/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Game_Calendar;
import age.of.civilizations2.jakowski.lukasz.Province_CoreType;
import com.badlogic.gdx.graphics.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class Province_Core
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected static final int NUMBER_OF_TURNS_REQUIRED_TO_GAIN_CORE = 40;
    protected static final int NUMBER_OF_TURNS_REQUIRED_TO_GAIN_CORE_EXTRA_PER_CORE = 10;
    protected static final int NUMBER_OF_TURNS_REQUIRED_TO_GAIN_CORE_WITHOUT_ANY_CORE = 15;
    private List<Integer> lCivs = new ArrayList<Integer>();
    private List<Province_CoreType> lCoreType = new ArrayList<Province_CoreType>();
    private List<Integer> lSinceTurnID = new ArrayList<Integer>();
    private int iCivsSize = 0;
    private int iCoreTypeSize = 0;
    private List<Integer> lOwnership_Civs = new ArrayList<Integer>();
    private List<Integer> lOwnership_NumberOfTurns = new ArrayList<Integer>();
    private int iOwnership_CivsSize = 0;

    protected Province_Core() {
    }

    protected static String getCoreTypeName(Province_CoreType coreType) {
        switch (coreType) {
            case CoreArea: {
                return CFG.langManager.get("CoreArea");
            }
            case Colony: {
                return CFG.langManager.get("ColonyArea");
            }
            case Occupy: {
                return CFG.langManager.get("OccupyArea");
            }
        }
        return "";
    }

    protected static Province_CoreType nextCoreType(Province_CoreType last) {
        switch (last) {
            case CoreArea: {
                return Province_CoreType.Colony;
            }
            case Colony: {
                return Province_CoreType.Occupy;
            }
            case Occupy: {
                return Province_CoreType.CoreArea;
            }
        }
        return Province_CoreType.CoreArea;
    }

    protected int getCivIndex(int nCivID) {
        return this.lCivs.indexOf(nCivID);
    }

    protected static Color getCoreTypeColor(Province_CoreType coreType) {
        switch (coreType) {
            case CoreArea: {
                return new Color(-1011838465);
            }
            case Colony: {
                return new Color(1506263807);
            }
            case Occupy: {
                return new Color(-528317697);
            }
        }
        return new Color(-1);
    }

    protected final void addNewCore(int nCivID, int nTurnID) {
        for (int i = 0; i < this.iCivsSize; ++i) {
            if (this.lCivs.get(i) != nCivID) continue;
            return;
        }
        this.lCivs.add(nCivID);
        this.lCoreType.add(Province_CoreType.CoreArea);
        this.lSinceTurnID.add(nTurnID);
        this.iCivsSize = this.lCivs.size();
        this.iCoreTypeSize = this.lCoreType.size();
    }

    protected final void addNewCore(int nCivID, int nTurnID, Province_CoreType type) {
        for (int i = 0; i < this.iCivsSize; ++i) {
            if (this.lCivs.get(i) != nCivID) continue;
            return;
        }
        this.lCivs.add(nCivID);
        this.lCoreType.add(type);
        this.lSinceTurnID.add(nTurnID);
        this.iCivsSize = this.lCivs.size();
        this.iCoreTypeSize = this.lCoreType.size();
    }

    protected final void removeCore(int nCivID) {
        int i;
        for (i = 0; i < this.iCivsSize; ++i) {
            if (this.lCivs.get(i) != nCivID) continue;
            this.lCivs.remove(i);
            this.lCoreType.remove(i);
            this.lSinceTurnID.remove(i);
            this.iCivsSize = this.lCivs.size();
            this.iCoreTypeSize = this.lCoreType.size();
            break;
        }
        for (i = 0; i < this.iOwnership_CivsSize; ++i) {
            if (this.lOwnership_Civs.get(i) != nCivID) continue;
            this.lOwnership_Civs.remove(i);
            this.lOwnership_NumberOfTurns.remove(i);
            this.iOwnership_CivsSize = this.lOwnership_Civs.size();
            break;
        }
    }

    protected final void increaseOwnership(int nCivID, int nProvinceID) {
        for (int i = 0; i < this.iOwnership_CivsSize; ++i) {
            if (this.lOwnership_Civs.get(i) != nCivID) continue;
            this.lOwnership_NumberOfTurns.set(i, this.lOwnership_NumberOfTurns.get(i) + 1);
            if (this.lOwnership_NumberOfTurns.get(i).intValue() == this.getNumOfTurnsOwnershipToGetACore()) {
                this.addNewCore(nCivID, Game_Calendar.TURN_ID, this.iCivsSize == 0 ? Province_CoreType.Colony : Province_CoreType.Occupy);
            }
            return;
        }
        if (!this.lOwnership_Civs.contains(nCivID)) {
            this.lOwnership_Civs.add(nCivID);
            this.lOwnership_NumberOfTurns.add(1);
            this.iOwnership_CivsSize = this.lOwnership_Civs.size();
        }
    }

    protected boolean isCoreArea(int CivID) {
        for (int i = 0; i < this.lCivs.size(); ++i) {
            if (this.lCivs.get(i) != CivID) continue;
            return this.lCoreType.get(i) == Province_CoreType.CoreArea;
        }
        return false;
    }

    protected final void clearData() {
        this.lCivs = new ArrayList<Integer>();
        this.lCoreType = new ArrayList<Province_CoreType>();
        this.lSinceTurnID = new ArrayList<Integer>();
        this.iCivsSize = 0;
        this.iCoreTypeSize = 0;
        this.lOwnership_Civs = new ArrayList<Integer>();
        this.lOwnership_NumberOfTurns = new ArrayList<Integer>();
        this.iOwnership_CivsSize = 0;
    }

    protected final boolean getHaveACore(int nCivID) {
        for (int i = 0; i < this.getCivsSize(); ++i) {
            if (nCivID != this.getCivID(i)) continue;
            return true;
        }
        return false;
    }

    protected final int getNumOfTurnsOwnershipToGetACore() {
        return this.iCivsSize == 0 ? 15 : 40 + 10 * this.getCivsSize();
    }

    protected final boolean getHaveOwnership(int nCivID) {
        for (int i = 0; i < this.getOwnership_CivsSize(); ++i) {
            if (nCivID != this.getOwnership_CivID(i)) continue;
            return true;
        }
        return false;
    }

    protected void setCoreType(int index, Province_CoreType coreType) {
        this.lCoreType.set(index, coreType);
    }

    protected final void resetOwnership(int nCivID) {
        for (int i = 0; i < this.getOwnership_CivsSize(); ++i) {
            if (nCivID != this.getOwnership_CivID(i)) continue;
            this.lOwnership_NumberOfTurns.set(i, 1);
            return;
        }
    }

    protected final int getNumOfOwnership(int nCivID) {
        for (int i = 0; i < this.getOwnership_CivsSize(); ++i) {
            if (nCivID != this.getOwnership_CivID(i)) continue;
            return this.getOwnership_NumOfTurns(i);
        }
        return 0;
    }

    private final boolean getIsLargestGroup(int nCivID, int nProvinceID) {
        int tempPop = CFG.game.getProvince(nProvinceID).getPopulationData().getPopulationOfCivID(nCivID);
        for (int i = 0; i < CFG.game.getProvince(nProvinceID).getPopulationData().getNationalitiesSize(); ++i) {
            if (CFG.game.getProvince(nProvinceID).getPopulationData().getPopulationID(i) <= tempPop) continue;
            return false;
        }
        return true;
    }

    protected final int getCivID(int i) {
        return this.lCivs.get(i);
    }

    protected final Province_CoreType getCoreType(int i) {
        try {
            return this.lCoreType.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            return Province_CoreType.CoreArea;
        }
    }

    protected final void setCivID_Editor(int i, int nCivID) {
        this.lCivs.set(i, nCivID);
    }

    protected final int getSinceTurnID(int i) {
        return this.lSinceTurnID.get(i);
    }

    protected final int getCivsSize() {
        return this.iCivsSize;
    }

    protected final int getCoreTypeSize() {
        return this.iCoreTypeSize;
    }

    protected final int getOwnership_CivID(int i) {
        return this.lOwnership_Civs.get(i);
    }

    protected final int getOwnership_NumOfTurns(int i) {
        return this.lOwnership_NumberOfTurns.get(i);
    }

    protected final int getOwnership_CivsSize() {
        return this.iOwnership_CivsSize;
    }
}

