/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Focus_Accomplish;
import age.of.civilizations2.jakowski.lukasz.Focus_Condition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Focus
implements Serializable {
    private static final long serialVersionUID = 0L;
    public String name = "";
    public List<String> present = new ArrayList<String>();
    public List<Focus_Condition> condition = new ArrayList<Focus_Condition>();
    public String describe = "";
    public String icon = "";
    public List<Focus_Accomplish> effect = new ArrayList<Focus_Accomplish>();
    public int FinishTurns = 25;
    protected static final int VERTICAL_SPACING = 100;
    protected static int HORIZONTAL_SPACING = 20;
    public int AI_Trend = 1;
    public transient List<String> postrequisites = new ArrayList<String>();
    public transient int x = -1;
    public transient int y = -1;
    public transient int depth = -1;
    public transient List<Focus> cachedParents;
    protected transient int iID = -1;
    public transient List<Focus> cachedChildren = new ArrayList<Focus>();
    protected transient boolean subtreeComputed = false;
    protected transient int subtreeWidth = 0;
    protected transient int subtreeHeight = 0;
    protected transient int maxChildDepth = 0;
    public boolean accomplish = false;
    protected static int NODE_MIN_WIDTH = 20;
    protected transient boolean layoutCalculated = false;

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public void initRelationships(List<Focus> allFocuses) {
        this.cachedParents = this.present.stream().map(p -> Focus.findFocus(p, allFocuses)).filter(Objects::nonNull).collect(Collectors.toList());
        this.postrequisites = allFocuses.stream().filter(g -> g.present.contains(this.name)).map(g -> g.name).collect(Collectors.toList());
        this.cachedChildren = this.postrequisites.stream().map(p -> Focus.findFocus(p, allFocuses)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    boolean isRootNode() {
        return this.cachedParents.isEmpty();
    }

    public void computeTreeDimensions() {
        if (this.subtreeComputed) {
            return;
        }
        int nodeWidth = this.getActualWidth();
        int nodeHeight = this.getActualHeight();
        if (this.cachedChildren.isEmpty()) {
            this.subtreeWidth = nodeWidth;
            this.subtreeHeight = nodeHeight;
            this.subtreeComputed = true;
            return;
        }
        this.cachedChildren.forEach(Focus::computeTreeDimensions);
        int childrenTotalWidth = this.cachedChildren.get((int)0).subtreeWidth;
        int maxChildHeight = this.cachedChildren.get((int)0).subtreeHeight;
        for (int i = 1; i < this.cachedChildren.size(); ++i) {
            childrenTotalWidth += HORIZONTAL_SPACING + this.cachedChildren.get((int)i).subtreeWidth;
            if (this.cachedChildren.get((int)i).subtreeHeight <= maxChildHeight) continue;
            maxChildHeight = this.cachedChildren.get((int)i).subtreeHeight;
        }
        this.subtreeWidth = Math.max(nodeWidth, childrenTotalWidth);
        this.subtreeHeight = nodeHeight + 100 + maxChildHeight;
        this.subtreeComputed = true;
    }

    public void positionTree(int baseX, int baseY) {
        this.x = baseX + (this.subtreeWidth - this.getActualWidth()) / 2;
        this.y = baseY;
        if (this.cachedChildren.isEmpty()) {
            return;
        }
        int childrenY = baseY + this.getActualHeight() + 100;
        int childrenTotalWidth = 0;
        for (Focus child : this.cachedChildren) {
            childrenTotalWidth += child.subtreeWidth;
        }
        int childrenSpacingTotal = (this.cachedChildren.size() - 1) * HORIZONTAL_SPACING;
        int currentX = baseX + (this.subtreeWidth - (childrenTotalWidth + childrenSpacingTotal)) / 2;
        for (Focus child : this.cachedChildren) {
            int childX = currentX + (child.subtreeWidth - child.getActualWidth()) / 2;
            child.positionTree(childX, childrenY);
            currentX += child.subtreeWidth + HORIZONTAL_SPACING;
        }
    }

    private void positionNode(Focus node, int baseX, int baseY) {
        int childrenStartX;
        node.x = baseX;
        node.y = baseY;
        if (node.cachedChildren.isEmpty()) {
            return;
        }
        int childrenY = baseY + node.getActualHeight() + 100;
        int currentX = childrenStartX = baseX + (node.subtreeWidth - this.getChildrenTotalWidth(node.cachedChildren)) / 2;
        for (Focus child : node.cachedChildren) {
            int childX = currentX + (child.subtreeWidth - child.getActualWidth()) / 2;
            this.positionNode(child, childX, childrenY);
            currentX += child.subtreeWidth + HORIZONTAL_SPACING;
        }
    }

    private int getChildrenTotalWidth(List<Focus> children) {
        int total = 0;
        for (int i = 0; i < children.size(); ++i) {
            total += children.get((int)i).subtreeWidth;
            if (i <= 0) continue;
            total += HORIZONTAL_SPACING;
        }
        return total;
    }

    public int getTreeWidth() {
        return this.subtreeWidth;
    }

    public int getTreeHeight() {
        return this.subtreeHeight;
    }

    public int getActualWidth() {
        return Math.max(this.calculateTextWidth() + 40, NODE_MIN_WIDTH);
    }

    public int getActualHeight() {
        CFG.glyphLayout.setText(CFG.fontMain, this.name);
        int textHeight = (int)CFG.glyphLayout.height;
        return textHeight + 40;
    }

    private int calculateTextWidth() {
        CFG.glyphLayout.setText(CFG.fontMain, this.name);
        return (int)CFG.glyphLayout.width;
    }

    private static Focus findFocus(String name, List<Focus> Focuses) {
        return Focuses.stream().filter(g -> g.name.equals(name)).findFirst().orElse(null);
    }

    public boolean canCarried(int iCivID) {
        boolean can = true;
        if (this.presentAccomplish(iCivID)) {
            for (int i = 0; i < this.condition.size(); ++i) {
                if (this.condition.get(i).Condition()) continue;
                can = false;
                break;
            }
        } else {
            can = false;
        }
        return can;
    }

    public boolean presentAccomplish(int iCivID) {
        boolean can = true;
        for (int i = 0; i < this.present.size(); ++i) {
            try {
                if (CFG.game.getCiv((int)iCivID).civFocus.list.getFocus((int)CFG.game.getCiv((int)iCivID).civFocus.list.Focus_listName.indexOf((Object)this.present.get((int)i))).accomplish) continue;
                can = false;
            }
            catch (IndexOutOfBoundsException e) {
                can = false;
            }
            break;
        }
        return can;
    }

    public boolean presentAccomplish(int iCivID, int index) {
        boolean can = true;
        try {
            can = CFG.game.getCiv((int)iCivID).civFocus.list.getFocus((int)CFG.game.getCiv((int)iCivID).civFocus.list.Focus_listName.indexOf((Object)this.present.get((int)index))).accomplish;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return can;
    }

    public void accomplish() {
        for (Focus_Accomplish slFocusAccomplish : this.effect) {
            slFocusAccomplish.run();
        }
        this.accomplish = true;
    }
}

