/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Image;
import age.of.civilizations2.jakowski.lukasz.ImageManager;
import age.of.civilizations2.jakowski.lukasz.Images;
import age.of.civilizations2.jakowski.lukasz.InterfaceManager;
import age.of.civilizations2.jakowski.lukasz.MenuElement_Hover_v2;
import age.of.civilizations2.jakowski.lukasz.MenuElement_Hover_v2_Element2;
import age.of.civilizations2.jakowski.lukasz.MenuElement_Hover_v2_Element_Type;
import age.of.civilizations2.jakowski.lukasz.MenuElement_Hover_v2_Element_Type_Text;
import age.of.civilizations2.jakowski.lukasz.Province_GameData2;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CFG_Zetvl {
    protected static List<Province_GameData2> provinceData = new ArrayList<Province_GameData2>();
    private static final Color DEFAULT_COLOR = Color.WHITE;
    private static final Pattern PATTERN = Pattern.compile("(#([A-Fa-f0-9]{6}([A-Fa-f0-9]{2})?))/|(%stop)");

    protected static final List<LineString> linesString(String str, int wrapWidth) {
        if (wrapWidth <= 0) {
            return Collections.singletonList(new LineString(CFG_Zetvl.parseText(str)));
        }
        ArrayList<LineString> finalResult = new ArrayList<LineString>();
        String[] logicalLines = str.split("\n");
        CFG.glyphLayout.setText(CFG.fontMain, "1");
        int oneWidth = (int)CFG.glyphLayout.width;
        for (String line : logicalLines) {
            List<TextSegment> segments = CFG_Zetvl.parseText(line);
            ArrayList<LineString> physicalLines = new ArrayList<LineString>();
            ArrayList<TextSegment> currentLine = new ArrayList<TextSegment>();
            int currentWidth = 0;
            int segIndex = 0;
            String remainingText = "";
            while (segIndex < segments.size() || !remainingText.isEmpty()) {
                String textToProcess;
                TextSegment currentSeg;
                if (segIndex < segments.size()) {
                    currentSeg = segments.get(segIndex);
                } else {
                    Color color = currentLine.isEmpty() ? Color.WHITE : ((TextSegment)currentLine.get((int)(currentLine.size() - 1))).color;
                    currentSeg = new TextSegment(remainingText, color);
                }
                String string = textToProcess = remainingText.isEmpty() ? currentSeg.text : remainingText;
                while (!textToProcess.isEmpty()) {
                    SplitResult splitResult = null;
                    CFG.glyphLayout.setText(CFG.fontMain, "1");
                    int oneWidth1 = (int)CFG.glyphLayout.width;
                    int bestIndex = 0;
                    int bestWidth = 0;
                    int lastSpaceIndex = -1;
                    int cumulativeWidth = 0;
                    for (int i = 0; i < textToProcess.length(); ++i) {
                        char c = textToProcess.charAt(i);
                        CFG.glyphLayout.setText(CFG.fontMain, c + "1");
                        int charWidth = (int)CFG.glyphLayout.width - oneWidth1;
                        cumulativeWidth += charWidth;
                        if (Character.isWhitespace(c)) {
                            lastSpaceIndex = i;
                        }
                        if (currentWidth + cumulativeWidth > wrapWidth) {
                            if (lastSpaceIndex > 0) {
                                String wordPart = textToProcess.substring(0, lastSpaceIndex + 1);
                                CFG.glyphLayout.setText(CFG.fontMain, wordPart + "1");
                                splitResult = new SplitResult(lastSpaceIndex + 1, (int)CFG.glyphLayout.width - oneWidth1);
                                break;
                            }
                            CFG.glyphLayout.setText(CFG.fontMain, textToProcess.charAt(0) + "1");
                            int char1Width = (int)CFG.glyphLayout.width - oneWidth1;
                            splitResult = new SplitResult(1, char1Width);
                            break;
                        }
                        bestIndex = i + 1;
                        bestWidth = cumulativeWidth;
                    }
                    if (splitResult == null) {
                        splitResult = new SplitResult(textToProcess.length(), bestWidth);
                    }
                    if (splitResult.splitIndex == 0) {
                        if (!currentLine.isEmpty()) {
                            physicalLines.add(new LineString(new ArrayList<TextSegment>(currentLine)));
                            currentLine.clear();
                            currentWidth = 0;
                        }
                        splitResult.splitIndex = 1;
                    }
                    String part = textToProcess.substring(0, splitResult.splitIndex);
                    TextSegment partialSeg = new TextSegment(part, currentSeg.color);
                    currentLine.add(partialSeg);
                    textToProcess = textToProcess.substring(splitResult.splitIndex);
                    if ((currentWidth += splitResult.splitWidth) < wrapWidth) continue;
                    if (!currentLine.isEmpty()) {
                        physicalLines.add(new LineString(new ArrayList<TextSegment>(currentLine)));
                        currentLine.clear();
                    }
                    currentWidth = 0;
                }
                if (remainingText.isEmpty()) {
                    ++segIndex;
                }
                remainingText = textToProcess;
            }
            if (!currentLine.isEmpty()) {
                physicalLines.add(new LineString(currentLine));
            }
            if (physicalLines.isEmpty()) {
                physicalLines.add(new LineString(Collections.singletonList(new TextSegment("", Color.WHITE))));
            }
            finalResult.addAll(physicalLines);
        }
        return finalResult;
    }

    protected static final List<LineString> linesString(String str, int wrapWidth, Color color2) {
        if (wrapWidth <= 0) {
            return Collections.singletonList(new LineString(CFG_Zetvl.parseText(str, color2)));
        }
        ArrayList<LineString> finalResult = new ArrayList<LineString>();
        String[] logicalLines = str.split("\n");
        CFG.glyphLayout.setText(CFG.fontMain, "1");
        int oneWidth = (int)CFG.glyphLayout.width;
        for (String line : logicalLines) {
            List<TextSegment> segments = CFG_Zetvl.parseText(line, color2);
            ArrayList<LineString> physicalLines = new ArrayList<LineString>();
            ArrayList<TextSegment> currentLine = new ArrayList<TextSegment>();
            int currentWidth = 0;
            int segIndex = 0;
            String remainingText = "";
            while (segIndex < segments.size() || !remainingText.isEmpty()) {
                String textToProcess;
                TextSegment currentSeg;
                if (segIndex < segments.size()) {
                    currentSeg = segments.get(segIndex);
                } else {
                    Color color = currentLine.isEmpty() ? color2 : ((TextSegment)currentLine.get((int)(currentLine.size() - 1))).color;
                    currentSeg = new TextSegment(remainingText, color);
                }
                String string = textToProcess = remainingText.isEmpty() ? currentSeg.text : remainingText;
                while (!textToProcess.isEmpty()) {
                    SplitResult splitResult = null;
                    CFG.glyphLayout.setText(CFG.fontMain, "1");
                    int oneWidth1 = (int)CFG.glyphLayout.width;
                    int bestIndex = 0;
                    int bestWidth = 0;
                    int lastSpaceIndex = -1;
                    int cumulativeWidth = 0;
                    for (int i = 0; i < textToProcess.length(); ++i) {
                        char c = textToProcess.charAt(i);
                        CFG.glyphLayout.setText(CFG.fontMain, c + "1");
                        int charWidth = (int)CFG.glyphLayout.width - oneWidth1;
                        cumulativeWidth += charWidth;
                        if (Character.isWhitespace(c)) {
                            lastSpaceIndex = i;
                        }
                        if (currentWidth + cumulativeWidth > wrapWidth) {
                            if (lastSpaceIndex > 0) {
                                String wordPart = textToProcess.substring(0, lastSpaceIndex + 1);
                                CFG.glyphLayout.setText(CFG.fontMain, wordPart + "1");
                                splitResult = new SplitResult(lastSpaceIndex + 1, (int)CFG.glyphLayout.width - oneWidth1);
                                break;
                            }
                            CFG.glyphLayout.setText(CFG.fontMain, textToProcess.charAt(0) + "1");
                            int char1Width = (int)CFG.glyphLayout.width - oneWidth1;
                            splitResult = new SplitResult(1, char1Width);
                            break;
                        }
                        bestIndex = i + 1;
                        bestWidth = cumulativeWidth;
                    }
                    if (splitResult == null) {
                        splitResult = new SplitResult(textToProcess.length(), bestWidth);
                    }
                    if (splitResult.splitIndex == 0) {
                        if (!currentLine.isEmpty()) {
                            physicalLines.add(new LineString(new ArrayList<TextSegment>(currentLine)));
                            currentLine.clear();
                            currentWidth = 0;
                        }
                        splitResult.splitIndex = 1;
                    }
                    String part = textToProcess.substring(0, splitResult.splitIndex);
                    TextSegment partialSeg = new TextSegment(part, currentSeg.color);
                    currentLine.add(partialSeg);
                    textToProcess = textToProcess.substring(splitResult.splitIndex);
                    if ((currentWidth += splitResult.splitWidth) < wrapWidth) continue;
                    if (!currentLine.isEmpty()) {
                        physicalLines.add(new LineString(new ArrayList<TextSegment>(currentLine)));
                        currentLine.clear();
                    }
                    currentWidth = 0;
                }
                if (remainingText.isEmpty()) {
                    ++segIndex;
                }
                remainingText = textToProcess;
            }
            if (!currentLine.isEmpty()) {
                physicalLines.add(new LineString(currentLine));
            }
            if (physicalLines.isEmpty()) {
                physicalLines.add(new LineString(Collections.singletonList(new TextSegment("", color2))));
            }
            finalResult.addAll(physicalLines);
        }
        return finalResult;
    }

    protected static final List<LineString> linesString(String str, int wrapWidth, String font) {
        if (wrapWidth <= 0) {
            return Collections.singletonList(new LineString(CFG_Zetvl.parseText(str), font));
        }
        ArrayList<LineString> finalResult = new ArrayList<LineString>();
        String[] logicalLines = str.split("\n");
        CFG.glyphLayout.setText(CFG.fontMain, "1");
        int oneWidth = (int)CFG.glyphLayout.width;
        for (String line : logicalLines) {
            List<TextSegment> segments = CFG_Zetvl.parseText(line);
            ArrayList<LineString> physicalLines = new ArrayList<LineString>();
            ArrayList<TextSegment> currentLine = new ArrayList<TextSegment>();
            int currentWidth = 0;
            int segIndex = 0;
            String remainingText = "";
            while (segIndex < segments.size() || !remainingText.isEmpty()) {
                String textToProcess;
                TextSegment currentSeg;
                if (segIndex < segments.size()) {
                    currentSeg = segments.get(segIndex);
                } else {
                    Color color = currentLine.isEmpty() ? Color.WHITE : ((TextSegment)currentLine.get((int)(currentLine.size() - 1))).color;
                    currentSeg = new TextSegment(remainingText, color);
                }
                String string = textToProcess = remainingText.isEmpty() ? currentSeg.text : remainingText;
                while (!textToProcess.isEmpty()) {
                    SplitResult splitResult = null;
                    CFG.glyphLayout.setText(CFG.fontMain, "1");
                    int oneWidth1 = (int)CFG.glyphLayout.width;
                    int bestIndex = 0;
                    int bestWidth = 0;
                    int lastSpaceIndex = -1;
                    int cumulativeWidth = 0;
                    for (int i = 0; i < textToProcess.length(); ++i) {
                        char c = textToProcess.charAt(i);
                        CFG.glyphLayout.setText(CFG.fontMain, c + "1");
                        int charWidth = (int)CFG.glyphLayout.width - oneWidth1;
                        cumulativeWidth += charWidth;
                        if (Character.isWhitespace(c)) {
                            lastSpaceIndex = i;
                        }
                        if (currentWidth + cumulativeWidth > wrapWidth) {
                            if (lastSpaceIndex > 0) {
                                String wordPart = textToProcess.substring(0, lastSpaceIndex + 1);
                                CFG.glyphLayout.setText(CFG.fontMain, wordPart + "1");
                                splitResult = new SplitResult(lastSpaceIndex + 1, (int)CFG.glyphLayout.width - oneWidth1);
                                break;
                            }
                            CFG.glyphLayout.setText(CFG.fontMain, textToProcess.charAt(0) + "1");
                            int char1Width = (int)CFG.glyphLayout.width - oneWidth1;
                            splitResult = new SplitResult(1, char1Width);
                            break;
                        }
                        bestIndex = i + 1;
                        bestWidth = cumulativeWidth;
                    }
                    if (splitResult == null) {
                        splitResult = new SplitResult(textToProcess.length(), bestWidth);
                    }
                    if (splitResult.splitIndex == 0) {
                        if (!currentLine.isEmpty()) {
                            physicalLines.add(new LineString(new ArrayList<TextSegment>(currentLine), font));
                            currentLine.clear();
                            currentWidth = 0;
                        }
                        splitResult.splitIndex = 1;
                    }
                    String part = textToProcess.substring(0, splitResult.splitIndex);
                    TextSegment partialSeg = new TextSegment(part, currentSeg.color);
                    currentLine.add(partialSeg);
                    textToProcess = textToProcess.substring(splitResult.splitIndex);
                    if ((currentWidth += splitResult.splitWidth) < wrapWidth) continue;
                    if (!currentLine.isEmpty()) {
                        physicalLines.add(new LineString(new ArrayList<TextSegment>(currentLine), font));
                        currentLine.clear();
                    }
                    currentWidth = 0;
                }
                if (remainingText.isEmpty()) {
                    ++segIndex;
                }
                remainingText = textToProcess;
            }
            if (!currentLine.isEmpty()) {
                physicalLines.add(new LineString(currentLine, font));
            }
            if (physicalLines.isEmpty()) {
                physicalLines.add(new LineString(Collections.singletonList(new TextSegment("", Color.WHITE)), font));
            }
            finalResult.addAll(physicalLines);
        }
        return finalResult;
    }

    protected static final int getLineStringHeight(List<LineString> lineStrings) {
        int o = 0;
        int w = (int)CFG.fontMain.getLineHeight();
        for (int i = 0; i < lineStrings.size(); ++i) {
            o += w + CFG.PADDING;
        }
        return o - CFG.PADDING;
    }

    protected static final int getLineStringHeight(List<LineString> lineStrings, String font) {
        int o = 0;
        int w = (int)InterfaceManager.getFont(font).getLineHeight();
        for (int i = 0; i < lineStrings.size(); ++i) {
            o += w + CFG.PADDING;
        }
        return o - CFG.PADDING;
    }

    protected static void drawColorfulText(SpriteBatch oSB, List<LineString> lineStrings, int nPosX, int nPosY) {
        int h = 0;
        for (int i = 0; i < lineStrings.size(); ++i) {
            lineStrings.get(i).draw(oSB, nPosX, nPosY + h);
            h += (int)(CFG.fontMain.getLineHeight() + (float)CFG.PADDING);
        }
    }

    protected static void drawColorfulText(SpriteBatch oSB, List<LineString> lineStrings, int nPosX, int nPosY, String font) {
        int h = 0;
        for (int i = 0; i < lineStrings.size(); ++i) {
            lineStrings.get(i).draw(oSB, nPosX, nPosY + h);
            h += (int)(InterfaceManager.getFont(font).getLineHeight() + (float)CFG.PADDING);
        }
    }

    protected static void writeProvincesGameData() {
        block4: {
            System.out.println(" ");
            try {
                for (int i = 0; i < provinceData.size(); ++i) {
                    if (provinceData.get(i) != null) {
                        FileHandle fileProvince = Gdx.files.local("map/" + CFG.map.getFile_ActiveMap_Path() + "data/provinces/" + i);
                        fileProvince.writeBytes(CFG.serialize(provinceData.get(i)), false);
                    }
                    System.out.print("\rwrite: " + i);
                }
            }
            catch (IOException var18) {
                if (!CFG.LOGS) break block4;
                CFG.exceptionStack(var18);
            }
        }
        Gdx.app.log("Zetvl", "Write Finish");
        provinceData.clear();
    }

    public static int toIntLimit(long var) {
        if (var > Integer.MAX_VALUE) {
            var = Integer.MAX_VALUE;
        }
        if (var < Integer.MIN_VALUE) {
            var = Integer.MIN_VALUE;
        }
        return (int)var;
    }

    public static List<TextSegment> parseText(String text) {
        ArrayList<TextSegment> segments = new ArrayList<TextSegment>();
        Matcher matcher = PATTERN.matcher(text);
        Color currentColor = DEFAULT_COLOR;
        StringBuilder currentText = new StringBuilder();
        int lastIndex = 0;
        while (matcher.find()) {
            int start = matcher.start();
            if (start > lastIndex) {
                String plainText = text.substring(lastIndex, start);
                currentText.append(plainText);
            }
            String colorHex = matcher.group(1);
            String stopFlag = matcher.group(4);
            if (colorHex != null) {
                if (currentText.length() > 0) {
                    segments.add(new TextSegment(currentText.toString(), currentColor));
                    currentText.setLength(0);
                }
                currentColor = CFG_Zetvl.parseColor(colorHex);
                lastIndex = matcher.end();
                continue;
            }
            if (stopFlag == null) continue;
            if (currentText.length() > 0) {
                segments.add(new TextSegment(currentText.toString(), currentColor));
                currentText.setLength(0);
            }
            currentColor = DEFAULT_COLOR;
            lastIndex = matcher.end();
        }
        if (lastIndex < text.length()) {
            String remainingText = text.substring(lastIndex);
            currentText.append(remainingText);
        }
        if (currentText.length() > 0) {
            segments.add(new TextSegment(currentText.toString(), currentColor));
        }
        return segments;
    }

    public static List<TextSegment> parseText(String text, Color DEFAULT_COLOR) {
        ArrayList<TextSegment> segments = new ArrayList<TextSegment>();
        Matcher matcher = PATTERN.matcher(text);
        Color currentColor = DEFAULT_COLOR;
        StringBuilder currentText = new StringBuilder();
        int lastIndex = 0;
        while (matcher.find()) {
            int start = matcher.start();
            if (start > lastIndex) {
                String plainText = text.substring(lastIndex, start);
                currentText.append(plainText);
            }
            String colorHex = matcher.group(1);
            String stopFlag = matcher.group(4);
            if (colorHex != null) {
                if (currentText.length() > 0) {
                    segments.add(new TextSegment(currentText.toString(), currentColor));
                    currentText.setLength(0);
                }
                currentColor = CFG_Zetvl.parseColor(colorHex);
                lastIndex = matcher.end();
                continue;
            }
            if (stopFlag == null) continue;
            if (currentText.length() > 0) {
                segments.add(new TextSegment(currentText.toString(), currentColor));
                currentText.setLength(0);
            }
            currentColor = DEFAULT_COLOR;
            lastIndex = matcher.end();
        }
        if (lastIndex < text.length()) {
            String remainingText = text.substring(lastIndex);
            currentText.append(remainingText);
        }
        if (currentText.length() > 0) {
            segments.add(new TextSegment(currentText.toString(), currentColor));
        }
        return segments;
    }

    private static Color parseColor(String hex) {
        try {
            hex = ((String)hex).toUpperCase();
            if (((String)hex).length() == 7) {
                hex = (String)hex + "FF";
            } else if (((String)hex).length() == 4) {
                hex = "#" + ((String)hex).charAt(1) + ((String)hex).charAt(1) + ((String)hex).charAt(2) + ((String)hex).charAt(2) + ((String)hex).charAt(3) + ((String)hex).charAt(3) + "FF";
            }
            return Color.valueOf((String)hex);
        }
        catch (Exception e) {
            return DEFAULT_COLOR;
        }
    }

    public static float getWidth(String str) {
        CFG.glyphLayout.setText(CFG.fontMain, str);
        return CFG.glyphLayout.width;
    }

    public static MenuElement_Hover_v2 wrapLineColorElementHover(String rawText, int wrapWidth) {
        ArrayList<MenuElement_Hover_v2_Element2> nElements = new ArrayList<MenuElement_Hover_v2_Element2>();
        if (rawText == null || rawText.isEmpty() || wrapWidth <= 0) {
            return new MenuElement_Hover_v2(nElements);
        }
        String[] logicalLines = rawText.split("\\n", -1);
        float SPACING = 1.0f;
        float SPACE_WIDTH = CFG_Zetvl.getWidth(" ");
        for (int i = 0; i < logicalLines.length; ++i) {
            String logicalLine = logicalLines[i];
            if (logicalLine.isEmpty()) {
                nElements.add(CFG_Zetvl.createElement2(new ArrayList<TextSegment>()));
                continue;
            }
            List<TextSegment> segments = CFG_Zetvl.parseText(logicalLine);
            ArrayList<TextSegment> currentLine = new ArrayList<TextSegment>();
            float currentLineWidth = 0.0f;
            Color previousColor = null;
            block1: for (int j = 0; j < segments.size(); ++j) {
                TextSegment segment = segments.get(j);
                StringBuilder remaining = new StringBuilder(segment.text);
                Color segmentColor = segment.color;
                if (previousColor != null && !previousColor.equals(segmentColor) && !segment.text.isEmpty()) {
                    if (currentLineWidth + SPACE_WIDTH <= (float)wrapWidth) {
                        currentLine.add(new TextSegment(" ", segmentColor));
                        currentLineWidth += SPACE_WIDTH;
                    } else {
                        nElements.add(CFG_Zetvl.createElement2(currentLine));
                        currentLine = new ArrayList();
                        currentLineWidth = 0.0f;
                        if (SPACE_WIDTH <= (float)wrapWidth) {
                            currentLine.add(new TextSegment(" ", segmentColor));
                            currentLineWidth = SPACE_WIDTH;
                        }
                    }
                }
                previousColor = segmentColor;
                while (!remaining.toString().isEmpty()) {
                    float availableWidth = (float)wrapWidth - currentLineWidth;
                    int charsToTake = 0;
                    float accumulatedWidth = 0.0f;
                    for (int k = 0; k < remaining.length(); ++k) {
                        float addWidth;
                        char c = remaining.charAt(k);
                        float charWidth = CFG_Zetvl.getWidth(String.valueOf(c));
                        float f = addWidth = currentLineWidth == 0.0f && k == 0 ? charWidth : SPACING + charWidth;
                        if (!(accumulatedWidth + addWidth <= availableWidth)) break;
                        accumulatedWidth += addWidth;
                        charsToTake = k + 1;
                    }
                    if (charsToTake == 0) {
                        char firstChar;
                        float charWidth;
                        if (!remaining.toString().isEmpty() && currentLineWidth == 0.0f && (charWidth = CFG_Zetvl.getWidth(String.valueOf(firstChar = remaining.charAt(0)))) <= availableWidth) {
                            charsToTake = 1;
                            accumulatedWidth = charWidth;
                        }
                        if (charsToTake == 0) {
                            if (currentLine.isEmpty()) continue block1;
                            nElements.add(CFG_Zetvl.createElement2(currentLine));
                            currentLine = new ArrayList();
                            currentLineWidth = 0.0f;
                            previousColor = null;
                            continue block1;
                        }
                    }
                    if (charsToTake > 0) {
                        String part = remaining.substring(0, charsToTake);
                        remaining.delete(0, charsToTake);
                        TextSegment partSegment = new TextSegment(part, segmentColor);
                        currentLine.add(partSegment);
                        currentLineWidth += accumulatedWidth;
                    }
                    if (remaining.toString().isEmpty()) continue;
                    nElements.add(CFG_Zetvl.createElement2(currentLine));
                    currentLine = new ArrayList();
                    currentLineWidth = 0.0f;
                    previousColor = null;
                }
            }
            if (currentLine.isEmpty()) continue;
            nElements.add(CFG_Zetvl.createElement2(currentLine));
        }
        return new MenuElement_Hover_v2(nElements);
    }

    public static ArrayList<MenuElement_Hover_v2_Element2> wrapLineColorElementHoverList(String rawText, int wrapWidth) {
        ArrayList<MenuElement_Hover_v2_Element2> nElements = new ArrayList<MenuElement_Hover_v2_Element2>();
        if (rawText == null || rawText.isEmpty() || wrapWidth <= 0) {
            return nElements;
        }
        String[] logicalLines = rawText.split("\\n", -1);
        float SPACING = 1.0f;
        float SPACE_WIDTH = CFG_Zetvl.getWidth(" ");
        for (int i = 0; i < logicalLines.length; ++i) {
            String logicalLine = logicalLines[i];
            if (logicalLine.isEmpty()) {
                nElements.add(CFG_Zetvl.createElement2(new ArrayList<TextSegment>()));
                continue;
            }
            List<TextSegment> segments = CFG_Zetvl.parseText(logicalLine);
            ArrayList<TextSegment> currentLine = new ArrayList<TextSegment>();
            float currentLineWidth = 0.0f;
            Color previousColor = null;
            block1: for (int j = 0; j < segments.size(); ++j) {
                TextSegment segment = segments.get(j);
                StringBuilder remaining = new StringBuilder(segment.text);
                Color segmentColor = segment.color;
                if (previousColor != null && !previousColor.equals(segmentColor) && !segment.text.isEmpty()) {
                    if (currentLineWidth + SPACE_WIDTH <= (float)wrapWidth) {
                        currentLine.add(new TextSegment(" ", segmentColor));
                        currentLineWidth += SPACE_WIDTH;
                    } else {
                        nElements.add(CFG_Zetvl.createElement2(currentLine));
                        currentLine = new ArrayList();
                        currentLineWidth = 0.0f;
                        if (SPACE_WIDTH <= (float)wrapWidth) {
                            currentLine.add(new TextSegment(" ", segmentColor));
                            currentLineWidth = SPACE_WIDTH;
                        }
                    }
                }
                previousColor = segmentColor;
                while (!remaining.toString().isEmpty()) {
                    float availableWidth = (float)wrapWidth - currentLineWidth;
                    int charsToTake = 0;
                    float accumulatedWidth = 0.0f;
                    for (int k = 0; k < remaining.length(); ++k) {
                        float addWidth;
                        char c = remaining.charAt(k);
                        float charWidth = CFG_Zetvl.getWidth(String.valueOf(c));
                        float f = addWidth = currentLineWidth == 0.0f && k == 0 ? charWidth : SPACING + charWidth;
                        if (!(accumulatedWidth + addWidth <= availableWidth)) break;
                        accumulatedWidth += addWidth;
                        charsToTake = k + 1;
                    }
                    if (charsToTake == 0) {
                        char firstChar;
                        float charWidth;
                        if (!remaining.toString().isEmpty() && currentLineWidth == 0.0f && (charWidth = CFG_Zetvl.getWidth(String.valueOf(firstChar = remaining.charAt(0)))) <= availableWidth) {
                            charsToTake = 1;
                            accumulatedWidth = charWidth;
                        }
                        if (charsToTake == 0) {
                            if (currentLine.isEmpty()) continue block1;
                            nElements.add(CFG_Zetvl.createElement2(currentLine));
                            currentLine = new ArrayList();
                            currentLineWidth = 0.0f;
                            previousColor = null;
                            continue block1;
                        }
                    }
                    if (charsToTake > 0) {
                        String part = remaining.substring(0, charsToTake);
                        remaining.delete(0, charsToTake);
                        TextSegment partSegment = new TextSegment(part, segmentColor);
                        currentLine.add(partSegment);
                        currentLineWidth += accumulatedWidth;
                    }
                    if (remaining.toString().isEmpty()) continue;
                    nElements.add(CFG_Zetvl.createElement2(currentLine));
                    currentLine = new ArrayList();
                    currentLineWidth = 0.0f;
                    previousColor = null;
                }
            }
            if (currentLine.isEmpty()) continue;
            nElements.add(CFG_Zetvl.createElement2(currentLine));
        }
        return nElements;
    }

    protected static String stopResistingText(String str, int CivA, int CivB) {
        return str.replace("%CivName%", CFG.game.getCiv(CivA).getCivName()).replace("%CivLeader%", CFG.game.getCiv((int)CivA).civGameData.leaderData != null ? CFG.game.getCiv((int)CivA).civGameData.leaderData.getName() : CFG.game.getCiv(CivA).getCivName()).replace("%Enemy%", CFG.game.getCiv(CivB).getCivName()).replace("%EnemyLeader%", CFG.game.getCiv((int)CivB).civGameData.leaderData != null ? CFG.game.getCiv((int)CivB).civGameData.leaderData.getName() : CFG.game.getCiv(CivB).getCivName()).replace("%CivAllianceName%", CFG.game.getCiv(CivA).getAllianceID() != 0 ? CFG.game.getAllianceName(CFG.game.getCiv(CivA).getAllianceID()) : CFG.game.getCiv(CivA).getCivName()).replace("%EnemyAllianceName%", CFG.game.getCiv(CivB).getAllianceID() != 0 ? CFG.game.getAllianceName(CFG.game.getCiv(CivB).getAllianceID()) : CFG.game.getCiv(CivB).getCivName());
    }

    protected static String changeLeaderText(String str, int Civ) {
        return str.replace("%CivName%", CFG.game.getCiv(Civ).getCivName()).replace("%CivLeader%", CFG.game.getCiv((int)Civ).civGameData.leaderData != null ? CFG.game.getCiv((int)Civ).civGameData.leaderData.getName() : CFG.game.getCiv(Civ).getCivName());
    }

    protected static String randomString(String str) {
        return str.split(";")[ThreadLocalRandom.current().nextInt(str.split(";").length)];
    }

    private static MenuElement_Hover_v2_Element2 createElement2(List<TextSegment> segments) {
        ArrayList<MenuElement_Hover_v2_Element_Type> nData = new ArrayList<MenuElement_Hover_v2_Element_Type>();
        for (TextSegment segment : segments) {
            nData.add(new MenuElement_Hover_v2_Element_Type_Text(segment.text, segment.color));
        }
        return new MenuElement_Hover_v2_Element2(nData);
    }

    private static float calculateLineWidth(List<TextSegment> segments) {
        float totalWidth = 0.0f;
        String lastText = null;
        Color lastColor = null;
        for (int i = 0; i < segments.size(); ++i) {
            TextSegment segment = segments.get(i);
            float segmentWidth = CFG_Zetvl.getWidth(segment.text);
            if (i > 0 && (lastColor != null && !lastColor.equals(segment.color) || !lastText.isEmpty())) {
                totalWidth += 1.0f;
            }
            totalWidth += segmentWidth;
            lastText = segment.text;
            lastColor = segment.color;
        }
        return totalWidth;
    }

    protected static void drawBG(SpriteBatch oSB, int ImageID) {
        int screen_lwr;
        int height;
        if (ImageID == -1) {
            return;
        }
        int width = ImageManager.getImage(ImageID).getWidth();
        int lwr = width / (height = ImageManager.getImage(ImageID).getHeight());
        if (lwr > (screen_lwr = CFG.GAME_WIDTH / CFG.GAME_HEIGHT)) {
            double scale = (double)CFG.GAME_HEIGHT / (double)height;
            height = (int)((double)height * scale);
            width = (int)((double)width * scale);
            ImageManager.getImage(ImageID).draw(oSB, CFG.GAME_WIDTH / 2 - width / 2, -ImageManager.getImage(ImageID).getHeight(), width, height);
        } else {
            double scale = (double)CFG.GAME_WIDTH / (double)width;
            height = (int)((double)height * scale);
            width = (int)((double)width * scale);
            ImageManager.getImage(ImageID).draw(oSB, 0, CFG.GAME_HEIGHT / 2 - height / 2 - ImageManager.getImage(ImageID).getHeight(), width, height);
        }
    }

    protected static void drawAdaptImage(SpriteBatch oSB, Image image, int nPosX, int nPosY, int nWidth, int nHeight) {
        int screen_lwr;
        int height;
        int width = image.getWidth();
        int lwr = width / (height = image.getHeight());
        if (lwr > (screen_lwr = nWidth / nHeight)) {
            double scale = (double)nHeight / (double)height;
            height = (int)((double)height * scale);
            width = (int)((double)width * scale);
            image.draw(oSB, nPosX + nWidth / 2 - width / 2, nPosY - image.getHeight(), width, height);
        } else {
            double scale = (double)nWidth / (double)width;
            height = (int)((double)height * scale);
            width = (int)((double)width * scale);
            image.draw(oSB, nPosX, nPosY + nHeight / 2 - height / 2 - image.getHeight(), width, height);
        }
    }

    protected static void BGDum() {
        if (Images.backgrounds.size() < 2) {
            return;
        }
        Thread backgroundChanger = new Thread(new Runnable(){
            private volatile boolean running = true;

            @Override
            public void run() {
                while (this.running) {
                    try {
                        TimeUnit.SECONDS.sleep(ThreadLocalRandom.current().nextInt(10, 16));
                        Images.backgroundLast = Images.background;
                        Images.background = ThreadLocalRandom.current().nextInt(0, Images.backgrounds.size() - 1);
                        for (float alpha = 0.0f; alpha < 1.0f; alpha += 0.01f) {
                            Images.backgroundAlpha = alpha;
                            TimeUnit.MILLISECONDS.sleep(25L);
                        }
                    }
                    catch (InterruptedException e) {
                        this.running = false;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        backgroundChanger.start();
    }

    protected static void loadBG() {
        FileHandle dir;
        if (Gdx.files.internal("UI/menumain.png").exists()) {
            Images.menu_main = ImageManager.addImage("UI/menumain.png");
        }
        if (!(dir = Gdx.files.internal("UI/bg/")).exists() || !dir.isDirectory()) {
            Gdx.app.error("Zetvl_BG", "The specified path does not exist or is not a directory: " + dir.path());
            return;
        }
        FileHandle[] files = dir.list();
        if (files == null) {
            Gdx.app.error("Zetvl_BG", "Read Dir Failed: " + dir.path());
            return;
        }
        for (FileHandle file : files) {
            int imageId;
            if (!file.isDirectory() && file.name().toLowerCase().endsWith(".png")) {
                try {
                    imageId = ImageManager.addImage(file.path());
                    Images.backgrounds.add(imageId);
                }
                catch (Exception e) {
                    Gdx.app.error("Zetvl_BG", "Load Image Failed: " + file.path(), e);
                }
            }
            if (file.isDirectory() || !file.name().toLowerCase().endsWith(".jpg")) continue;
            try {
                imageId = ImageManager.addImage(file.path());
                Images.backgrounds.add(imageId);
            }
            catch (Exception e) {
                Gdx.app.error("Zetvl_BG", "Load Image Failed: " + file.path(), e);
            }
        }
        if (!Images.backgrounds.isEmpty()) {
            Images.backgroundLast = Images.background = MathUtils.random(0, Images.backgrounds.size() - 1);
        } else {
            Images.backgrounds.add(-1);
            Gdx.app.log("Zetvl_BG", "Not Found Background");
        }
        Gdx.app.log("Zetvl_BG", String.valueOf(Images.backgrounds.size()));
        Images.backgroundLast = Images.background;
    }

    public static class LineString {
        public List<TextSegment> segments;
        public List<Integer> translate;
        public List<Integer> translate2;
        public String font = "";

        public LineString(List<TextSegment> segments) {
            this.segments = segments;
            this.translate = new ArrayList<Integer>();
            this.translate2 = new ArrayList<Integer>();
            Gdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    int tw;
                    int i;
                    int translate = 0;
                    CFG.glyphLayout.setText(CFG.fontMain, "1");
                    int one = (int)CFG.glyphLayout.width;
                    for (i = 0; i < segments.size(); ++i) {
                        translate.add(translate);
                        CFG.glyphLayout.setText(CFG.fontMain, segments.get((int)i).text + "1");
                        tw = (int)CFG.glyphLayout.width - one;
                        translate += tw;
                    }
                    translate = 0;
                    CFG.glyphLayout.setText(CFG.fontSpec, "1");
                    one = (int)CFG.glyphLayout.width;
                    for (i = 0; i < segments.size(); ++i) {
                        translate2.add(translate);
                        CFG.glyphLayout.setText(CFG.fontSpec, segments.get((int)i).text + "1");
                        tw = (int)CFG.glyphLayout.width - one;
                        translate += tw;
                    }
                }
            });
        }

        public LineString(List<TextSegment> segments, String font) {
            this.segments = segments;
            this.translate = new ArrayList<Integer>();
            this.translate2 = new ArrayList<Integer>();
            this.font = font;
            Gdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    int translate = 0;
                    CFG.glyphLayout.setText(InterfaceManager.getFont(font), "1");
                    int one = (int)CFG.glyphLayout.width;
                    for (int i = 0; i < segments.size(); ++i) {
                        translate.add(translate);
                        CFG.glyphLayout.setText(InterfaceManager.getFont(font), segments.get((int)i).text + "1");
                        int tw = (int)CFG.glyphLayout.width - one;
                        translate += tw;
                    }
                }
            });
        }

        public void draw3(SpriteBatch oSB, int nPosX, int nPosY) {
            if (this.font.isEmpty()) {
                this.draw(oSB, nPosX, nPosY);
            }
            if (this.translate.size() != this.segments.size()) {
                this.translate = new ArrayList<Integer>();
                int translate = 0;
                CFG.glyphLayout.setText(InterfaceManager.getFont(this.font), "1");
                int one = (int)CFG.glyphLayout.width;
                for (int i = 0; i < this.segments.size(); ++i) {
                    this.translate.add(translate);
                    CFG.glyphLayout.setText(InterfaceManager.getFont(this.font), this.segments.get((int)i).text + "1");
                    int tw = (int)CFG.glyphLayout.width - one;
                    translate += tw;
                }
            }
            for (int i = 0; i < this.segments.size(); ++i) {
                InterfaceManager.drawText(oSB, this.segments.get((int)i).text, nPosX + this.translate.get(i), nPosY, this.segments.get((int)i).color, this.font);
            }
        }

        public void draw(SpriteBatch oSB, int nPosX, int nPosY) {
            if (this.translate.size() != this.segments.size()) {
                this.translate = new ArrayList<Integer>();
                int translate = 0;
                CFG.glyphLayout.setText(CFG.fontMain, "1");
                int one = (int)CFG.glyphLayout.width;
                for (int i = 0; i < this.segments.size(); ++i) {
                    this.translate.add(translate);
                    CFG.glyphLayout.setText(CFG.fontMain, this.segments.get((int)i).text + "1");
                    int tw = (int)CFG.glyphLayout.width - one;
                    translate += tw;
                }
            }
            for (int i = 0; i < this.segments.size(); ++i) {
                CFG.drawText(oSB, this.segments.get((int)i).text, nPosX + this.translate.get(i), nPosY, this.segments.get((int)i).color);
            }
        }

        public void draw2(SpriteBatch oSB, int nPosX, int nPosY) {
            if (this.translate2.size() != this.segments.size()) {
                this.translate2 = new ArrayList<Integer>();
                int translate = 0;
                CFG.glyphLayout.setText(CFG.fontSpec, "1");
                int one = (int)CFG.glyphLayout.width;
                for (int i = 0; i < this.segments.size(); ++i) {
                    this.translate2.add(translate);
                    CFG.glyphLayout.setText(CFG.fontSpec, this.segments.get((int)i).text + "1");
                    int tw = (int)CFG.glyphLayout.width - one;
                    translate += tw;
                }
            }
            for (int i = 0; i < this.segments.size(); ++i) {
                CFG.drawText2(oSB, this.segments.get((int)i).text, nPosX + this.translate2.get(i), nPosY, this.segments.get((int)i).color);
            }
        }
    }

    public static class TextSegment {
        public String text;
        public Color color;

        public TextSegment(String text, Color color) {
            this.text = text;
            this.color = color;
        }
    }

    private static class SplitResult {
        int splitIndex;
        int splitWidth;

        SplitResult(int index, int width) {
            this.splitIndex = index;
            this.splitWidth = width;
        }
    }
}

