/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.AoCGame;
import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Focus_Test;
import age.of.civilizations2.jakowski.lukasz.GFX;
import age.of.civilizations2.jakowski.lukasz.LanguageManager;
import age.of.civilizations2.jakowski.lukasz.ZetvlLogger;
import age.of.civilizations2.jakowski.lukasz.Zetvl_Configuration;
import age.of.civilizations2.jakowski.lukasz.Zetvl_EntryColumn;
import age.of.civilizations2.jakowski.lukasz.Zetvl_Update;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Zetvl {
    public static Zetvl_Configuration Configuration;
    public static final List<String> LOGS;
    public static final List<LogLevel> LOGS_LEVEL;
    public static ZetvlLogger Logger;
    public static int LogTranslateY;
    public static int log_width;
    public static int log_height;
    public static int isDraggingLog;
    public static int logDragStartY;
    public static int logInitialTranslateY;
    public static String version;
    public static final int NuclearProduce = 2200;
    public static final List<Zetvl_EntryColumn> EntryColumn;
    public static int SELECT_ITEM;
    public static final float MAX_TECHNOLOGY_LEVEL = 2.0f;
    public static GFX gfx;
    private static final Map<Character, Float> charWidthCache;

    public static void init() {
        Zetvl.loadConfiguration();
        Zetvl.Zetvltest_focus();
    }

    protected static void LangEntryColumn() {
        EntryColumn.clear();
        EntryColumn.add(Zetvl_Update.current_update(LanguageManager.presentLanguage));
        EntryColumn.add(Zetvl_Update.update(LanguageManager.presentLanguage));
        Zetvl.loadEntryColumn();
    }

    public static void loadConfiguration() {
        Configuration = new Zetvl_Configuration();
        Configuration.ConfigLoad();
    }

    public static void Zetvltest_focus() {
        Focus_Test.init();
    }

    public static void log(String message) {
        LOGS.add(message);
        LOGS_LEVEL.add(LogLevel.INFO);
        if (LOGS.size() > 1000) {
            LOGS.remove(0);
            LOGS_LEVEL.remove(0);
        }
    }

    public static void debug(String message) {
        LOGS.add(message);
        LOGS_LEVEL.add(LogLevel.DEBUG);
        if (LOGS.size() > 1000) {
            LOGS.remove(0);
            LOGS_LEVEL.remove(0);
        }
    }

    public static void error(String message) {
        LOGS.add(message);
        LOGS_LEVEL.add(LogLevel.ERROR);
        if (LOGS.size() > 1000) {
            LOGS.remove(0);
            LOGS_LEVEL.remove(0);
        }
    }

    public static void outThrow(Throwable e) {
        if (CFG.LOGS) {
            CFG.exceptionStack(e);
        }
    }

    public static void log(String message, Throwable e) {
        Zetvl.addLogEntry(LogLevel.INFO, message, e);
    }

    public static void debug(String message, Throwable e) {
        Zetvl.addLogEntry(LogLevel.DEBUG, message, e);
    }

    public static void error(String message, Throwable e) {
        Zetvl.addLogEntry(LogLevel.ERROR, message, e);
    }

    private static void addLogEntry(LogLevel level, String message, Throwable e) {
        Zetvl.addSingleLine(level, message);
        if (e != null) {
            String stackTrace = Zetvl.getStackTrace(e);
            for (String line : stackTrace.split("\\r?\\n")) {
                Zetvl.addSingleLine(level, "  " + line.trim());
            }
        }
    }

    private static void addSingleLine(LogLevel level, String message) {
        LOGS.add(message);
        LOGS_LEVEL.add(level);
        Zetvl.trimLogs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void trimLogs() {
        List<String> list = LOGS;
        synchronized (list) {
            List<LogLevel> list2 = LOGS_LEVEL;
            synchronized (list2) {
                int change = 0;
                while (LOGS.size() > 1000 && !LOGS.isEmpty()) {
                    LOGS.remove(0);
                    if (!LOGS_LEVEL.isEmpty()) {
                        LOGS_LEVEL.remove(0);
                    }
                    ++change;
                }
                AoCGame.lastSyncedCount = LOGS.size() - change;
            }
        }
    }

    private static String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Color getLogLevel_Color(int index) {
        return switch (LOGS_LEVEL.get(index)) {
            default -> throw new IncompatibleClassChangeError();
            case LogLevel.INFO -> CFG.COLOR_TEXT_MODIFIER_NEUTRAL;
            case LogLevel.DEBUG -> CFG.COLOR_TEXT_ECONOMY;
            case LogLevel.ERROR -> CFG.COLOR_TEXT_MODIFIER_NEGATIVE;
        };
    }

    public static String getLogLevel_Tag(int index) {
        return switch (LOGS_LEVEL.get(index)) {
            default -> throw new IncompatibleClassChangeError();
            case LogLevel.INFO -> "[INFO]";
            case LogLevel.DEBUG -> "[DEBUG]";
            case LogLevel.ERROR -> "[ERROR]";
        };
    }

    public static String StorageSpaceFormat(long bytes) {
        boolean negative = false;
        if (bytes < 0L) {
            bytes = -bytes;
            negative = true;
        }
        Object storage = bytes >= 0x40000000L ? String.format(Locale.US, "%.1f GiB", (double)bytes / 1.073741824E9) : (bytes >= 0x100000L ? String.format(Locale.US, "%.1f MiB", (double)bytes / 1048576.0) : (bytes >= 1024L ? String.format(Locale.US, "%.1f KiB", (double)bytes / 1024.0) : bytes + " B"));
        if (negative) {
            storage = "- " + (String)storage;
        }
        return storage;
    }

    public static void drawCentreText(SpriteBatch oSB, String sText, int nPosX, int nPosY, Color color) {
        try {
            CFG.glyphLayout.setText(CFG.fontMain, sText);
            if (color != Color.WHITE) {
                CFG.fontMain.setColor(color);
            } else {
                CFG.fontMain.setColor(CFG.COLOR_TEXT_MODIFIER_NEUTRAL);
            }
            CFG.fontMain.draw((Batch)oSB, sText, (float)nPosX - CFG.glyphLayout.width / 2.0f, (float)(-nPosY));
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected static Array<String> wrapText(String sText, float wrapWidth) {
        Array<String> lines = new Array<String>();
        if (sText == null || sText.isEmpty() || wrapWidth <= 0.0f) {
            lines.add(sText);
            return lines;
        }
        StringBuilder currentLine = new StringBuilder();
        float currentWidth = 0.0f;
        for (int i = 0; i < sText.length(); ++i) {
            char c = sText.charAt(i);
            if (c == '\n') {
                lines.add(currentLine.toString());
                currentLine.setLength(0);
                currentWidth = 0.0f;
                continue;
            }
            float charWidth = Zetvl.getCharWidth(c);
            if (currentWidth + charWidth > wrapWidth) {
                if (currentLine.length() > 0) {
                    lines.add(currentLine.toString());
                    currentLine.setLength(0);
                    currentWidth = 0.0f;
                    --i;
                    continue;
                }
                currentLine.append(c);
                lines.add(currentLine.toString());
                currentLine.setLength(0);
                currentWidth = 0.0f;
                continue;
            }
            currentLine.append(c);
            currentWidth += charWidth;
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private static float getCharWidth(char c) {
        return charWidthCache.computeIfAbsent(Character.valueOf(c), k -> {
            CFG.glyphLayout.setText(CFG.fontMain, String.valueOf(c));
            return Float.valueOf(CFG.glyphLayout.width);
        }).floatValue();
    }

    public static Color lerpColor(Color start, Color end, float progress) {
        progress = Math.max(0.0f, Math.min(1.0f, progress));
        float r = start.r + (end.r - start.r) * progress;
        float g = start.g + (end.g - start.g) * progress;
        float b = start.b + (end.b - start.b) * progress;
        float a = start.a + (end.a - start.a) * progress;
        return new Color(r, g, b, a);
    }

    public static Color lerpColor(Color start, Color end, int progress) {
        return Zetvl.lerpColor(start, end, (float)progress / 100.0f);
    }

    public static void loadEntryColumn() {
        Json json = new Json(JsonWriter.OutputType.json);
        json.setTypeName(null);
        try {
            ArrayList<Zetvl_EntryColumn> zetvl_entryColumns = new ArrayList<Zetvl_EntryColumn>();
            FileHandle fileHandle = Gdx.files.internal("ZetvlUniverse/interface/Zetvl_EntryColumn.json");
            if (fileHandle.exists()) {
                zetvl_entryColumns = new ArrayList(json.fromJson(List.class, Zetvl_EntryColumn.class, fileHandle.readString("UTF-8")));
                EntryColumn.addAll(zetvl_entryColumns);
            } else if (!Gdx.files.local("ZetvlUniverse/interface/Zetvl_EntryColumn_Example.json").exists()) {
                ArrayList<List<String>> lists = new ArrayList<List<String>>();
                ArrayList<String> list = new ArrayList<String>();
                list.add("Test1");
                list.add("This is a sample template.");
                list.add("You can add your content according to your needs.");
                lists.add(new ArrayList(list));
                list.clear();
                list.add("Test2");
                list.add("For example, store your update log here.");
                list.add("It can also be used to store your introduction information.");
                lists.add(new ArrayList(list));
                list.clear();
                list.add("Test3");
                list.add("All in all, this is a developer-oriented function.");
                list.add("Go and try it");
                lists.add(new ArrayList(list));
                list.clear();
                zetvl_entryColumns.add(new Zetvl_EntryColumn("Test", lists));
                json.setUsePrototypes(false);
                Gdx.files.local("ZetvlUniverse/interface/Zetvl_EntryColumn_Example.json").writeString(json.prettyPrint(zetvl_entryColumns), false);
            }
        }
        catch (Throwable ex) {
            Gdx.app.error("Zetvl", "read entry column failed!", ex);
        }
    }

    static {
        LOGS = new ArrayList<String>();
        LOGS_LEVEL = new ArrayList<LogLevel>();
        Logger = new ZetvlLogger();
        LogTranslateY = 0;
        log_width = 0;
        log_height = 0;
        isDraggingLog = 0;
        logDragStartY = 0;
        logInitialTranslateY = 0;
        version = "1.0.7.0 (ZetvlX)";
        EntryColumn = new ArrayList<Zetvl_EntryColumn>();
        SELECT_ITEM = -1;
        charWidthCache = new HashMap<Character, Float>();
    }

    public static enum LogLevel {
        INFO,
        DEBUG,
        ERROR;

    }

    public static class ZetvlException
    extends RuntimeException {
        public ZetvlException(String message) {
            super(message);
        }

        public ZetvlException(String message, Exception e) {
            super(message, e);
        }
    }
}

