/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class CIMUtils {
    public static FileHandle createCIMFileHandle(final byte[] data) {
        return new FileHandle("in_memory.cim"){

            @Override
            public byte[] readBytes() {
                return data;
            }

            @Override
            public InputStream read() {
                return new ByteArrayInputStream(data);
            }

            @Override
            public long length() {
                return data.length;
            }

            @Override
            public boolean exists() {
                return data != null && data.length > 0;
            }
        };
    }

    public static byte[] pixmapToCIMBytes(Pixmap pixmap) {
        byte[] byArray;
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            FileHandle virtualFile = new FileHandle("temp.cim"){

                @Override
                public OutputStream write(boolean overwrite) {
                    return baos;
                }
            };
            PixmapIO.writeCIM(virtualFile, pixmap);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                CFG.exceptionStack(e);
                return null;
            }
        }
        baos.close();
        return byArray;
    }

    public static Pixmap cimBytesToPixmap(byte[] cimData) {
        try {
            return PixmapIO.readCIM(CIMUtils.createCIMFileHandle(cimData));
        }
        catch (Exception e) {
            CFG.exceptionStack(e);
            return null;
        }
    }
}

