/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Conditional;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.SentEvent;
import java.awt.SequencedEvent;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.CausedFocusEvent;
import sun.awt.SunToolkit;
import sun.awt.TimedWindowEvent;
import sun.util.logging.PlatformLogger;

public class DefaultKeyboardFocusManager
extends KeyboardFocusManager {
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("java.awt.focus.DefaultKeyboardFocusManager");
    private static final WeakReference<Window> NULL_WINDOW_WR = new WeakReference<Object>(null);
    private static final WeakReference<Component> NULL_COMPONENT_WR = new WeakReference<Object>(null);
    private WeakReference<Window> realOppositeWindowWR = NULL_WINDOW_WR;
    private WeakReference<Component> realOppositeComponentWR = NULL_COMPONENT_WR;
    private int inSendMessage;
    private LinkedList<KeyEvent> enqueuedKeyEvents = new LinkedList();
    private LinkedList<TypeAheadMarker> typeAheadMarkers = new LinkedList();
    private boolean consumeNextKeyTyped;
    private Component restoreFocusTo;

    private Window getOwningFrameDialog(Window window) {
        while (window != null && !(window instanceof Frame) && !(window instanceof Dialog)) {
            window = (Window)window.getParent();
        }
        return window;
    }

    private void restoreFocus(FocusEvent focusEvent, Window window) {
        Component component = (Component)this.realOppositeComponentWR.get();
        Component component2 = focusEvent.getComponent();
        if (!(window != null && this.restoreFocus(window, component2, false) || component != null && this.doRestoreFocus(component, component2, false) || focusEvent.getOppositeComponent() != null && this.doRestoreFocus(focusEvent.getOppositeComponent(), component2, false))) {
            this.clearGlobalFocusOwnerPriv();
        }
    }

    private void restoreFocus(WindowEvent windowEvent) {
        Window window = (Window)this.realOppositeWindowWR.get();
        if (!(window != null && this.restoreFocus(window, null, false) || windowEvent.getOppositeWindow() != null && this.restoreFocus(windowEvent.getOppositeWindow(), null, false))) {
            this.clearGlobalFocusOwnerPriv();
        }
    }

    private boolean restoreFocus(Window window, Component component, boolean bl) {
        this.restoreFocusTo = null;
        Component component2 = KeyboardFocusManager.getMostRecentFocusOwner(window);
        if (component2 != null && component2 != component) {
            if (DefaultKeyboardFocusManager.getHeavyweight(window) != this.getNativeFocusOwner()) {
                if (!component2.isShowing() || !component2.canBeFocusOwner()) {
                    component2 = component2.getNextFocusCandidate();
                }
                if (component2 != null && component2 != component) {
                    if (!component2.requestFocus(false, CausedFocusEvent.Cause.ROLLBACK)) {
                        this.restoreFocusTo = component2;
                    }
                    return true;
                }
            } else if (this.doRestoreFocus(component2, component, false)) {
                return true;
            }
        }
        if (bl) {
            this.clearGlobalFocusOwnerPriv();
            return true;
        }
        return false;
    }

    private boolean restoreFocus(Component component, boolean bl) {
        return this.doRestoreFocus(component, null, bl);
    }

    private boolean doRestoreFocus(Component component, Component component2, boolean bl) {
        boolean bl2 = true;
        if (component != component2 && component.isShowing() && component.canBeFocusOwner() && (bl2 = component.requestFocus(false, CausedFocusEvent.Cause.ROLLBACK))) {
            return true;
        }
        if (!bl2 && this.getGlobalFocusedWindow() != SunToolkit.getContainingWindow(component)) {
            this.restoreFocusTo = component;
            return true;
        }
        Component component3 = component.getNextFocusCandidate();
        if (component3 != null && component3 != component2 && component3.requestFocusInWindow(CausedFocusEvent.Cause.ROLLBACK)) {
            return true;
        }
        if (bl) {
            this.clearGlobalFocusOwnerPriv();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean sendMessage(Component component, AWTEvent aWTEvent) {
        aWTEvent.isPosted = true;
        AppContext appContext = AppContext.getAppContext();
        final AppContext appContext2 = component.appContext;
        final DefaultKeyboardFocusManagerSentEvent defaultKeyboardFocusManagerSentEvent = new DefaultKeyboardFocusManagerSentEvent(aWTEvent, appContext);
        if (appContext == appContext2) {
            ((SentEvent)defaultKeyboardFocusManagerSentEvent).dispatch();
        } else {
            if (appContext2.isDisposed()) {
                return false;
            }
            SunToolkit.postEvent(appContext2, defaultKeyboardFocusManagerSentEvent);
            if (EventQueue.isDispatchThread()) {
                EventDispatchThread eventDispatchThread = (EventDispatchThread)Thread.currentThread();
                eventDispatchThread.pumpEvents(1007, new Conditional(){

                    @Override
                    public boolean evaluate() {
                        return !defaultKeyboardFocusManagerSentEvent.dispatched && !appContext2.isDisposed();
                    }
                });
            } else {
                DefaultKeyboardFocusManagerSentEvent defaultKeyboardFocusManagerSentEvent2 = defaultKeyboardFocusManagerSentEvent;
                synchronized (defaultKeyboardFocusManagerSentEvent2) {
                    while (!defaultKeyboardFocusManagerSentEvent.dispatched && !appContext2.isDisposed()) {
                        try {
                            defaultKeyboardFocusManagerSentEvent.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }
        return defaultKeyboardFocusManagerSentEvent.dispatched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean repostIfFollowsKeyEvents(WindowEvent windowEvent) {
        if (!(windowEvent instanceof TimedWindowEvent)) {
            return false;
        }
        TimedWindowEvent timedWindowEvent = (TimedWindowEvent)windowEvent;
        long l = timedWindowEvent.getWhen();
        DefaultKeyboardFocusManager defaultKeyboardFocusManager = this;
        synchronized (defaultKeyboardFocusManager) {
            KeyEvent keyEvent;
            KeyEvent keyEvent2 = keyEvent = this.enqueuedKeyEvents.isEmpty() ? null : this.enqueuedKeyEvents.getFirst();
            if (keyEvent != null && l >= keyEvent.getWhen()) {
                Window window;
                TypeAheadMarker typeAheadMarker;
                TypeAheadMarker typeAheadMarker2 = typeAheadMarker = this.typeAheadMarkers.isEmpty() ? null : this.typeAheadMarkers.getFirst();
                if (typeAheadMarker != null && (window = typeAheadMarker.untilFocused.getContainingWindow()) != null && window.isFocused()) {
                    SunToolkit.postEvent(AppContext.getAppContext(), new SequencedEvent(windowEvent));
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchEvent(AWTEvent aWTEvent) {
        if (focusLog.isLoggable(PlatformLogger.Level.FINE) && (aWTEvent instanceof WindowEvent || aWTEvent instanceof FocusEvent)) {
            focusLog.fine("" + aWTEvent);
        }
        switch (aWTEvent.getID()) {
            case 207: {
                Component component;
                Window window;
                Window window2;
                boolean bl;
                if (this.repostIfFollowsKeyEvents((WindowEvent)aWTEvent)) {
                    return true;
                }
                WindowEvent windowEvent = (WindowEvent)aWTEvent;
                Window window3 = this.getGlobalFocusedWindow();
                Window window4 = windowEvent.getWindow();
                if (window4 == window3) {
                    return true;
                }
                if (!(window4.isFocusableWindow() && window4.isVisible() && window4.isDisplayable())) {
                    this.restoreFocus(windowEvent);
                    return true;
                }
                if (window3 != null && !(bl = DefaultKeyboardFocusManager.sendMessage(window3, new WindowEvent(window3, 208, window4)))) {
                    this.setGlobalFocusOwner(null);
                    this.setGlobalFocusedWindow(null);
                }
                if ((window2 = this.getOwningFrameDialog(window4)) != (window = this.getGlobalActiveWindow())) {
                    DefaultKeyboardFocusManager.sendMessage(window2, new WindowEvent(window2, 205, window));
                    if (window2 != this.getGlobalActiveWindow()) {
                        this.restoreFocus(windowEvent);
                        return true;
                    }
                }
                this.setGlobalFocusedWindow(window4);
                if (window4 != this.getGlobalFocusedWindow()) {
                    this.restoreFocus(windowEvent);
                    return true;
                }
                if (this.inSendMessage == 0) {
                    boolean bl2;
                    component = KeyboardFocusManager.getMostRecentFocusOwner(window4);
                    boolean bl3 = bl2 = this.restoreFocusTo != null && component == this.restoreFocusTo;
                    if (component == null && window4.isFocusableWindow()) {
                        component = window4.getFocusTraversalPolicy().getInitialComponent(window4);
                    }
                    Component component2 = null;
                    Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
                    // MONITORENTER : java.awt.KeyboardFocusManager.class
                    component2 = window4.setTemporaryLostComponent(null);
                    // MONITOREXIT : clazz
                    if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
                        focusLog.finer("tempLost {0}, toFocus {1}", component2, component);
                    }
                    if (component2 != null) {
                        component2.requestFocusInWindow(bl2 && component2 == component ? CausedFocusEvent.Cause.ROLLBACK : CausedFocusEvent.Cause.ACTIVATION);
                    }
                    if (component != null && component != component2) {
                        component.requestFocusInWindow(CausedFocusEvent.Cause.ACTIVATION);
                    }
                }
                this.restoreFocusTo = null;
                component = (Window)this.realOppositeWindowWR.get();
                if (component == windowEvent.getOppositeWindow()) return this.typeAheadAssertions(window4, windowEvent);
                windowEvent = new WindowEvent(window4, 207, (Window)component);
                return this.typeAheadAssertions(window4, windowEvent);
            }
            case 205: {
                WindowEvent windowEvent = (WindowEvent)aWTEvent;
                Window window = this.getGlobalActiveWindow();
                Window window5 = windowEvent.getWindow();
                if (window == window5) {
                    return true;
                }
                if (window != null) {
                    boolean bl = DefaultKeyboardFocusManager.sendMessage(window, new WindowEvent(window, 206, window5));
                    if (!bl) {
                        this.setGlobalActiveWindow(null);
                    }
                    if (this.getGlobalActiveWindow() != null) {
                        return true;
                    }
                }
                this.setGlobalActiveWindow(window5);
                if (window5 == this.getGlobalActiveWindow()) return this.typeAheadAssertions(window5, windowEvent);
                return true;
            }
            case 1004: {
                boolean bl;
                this.restoreFocusTo = null;
                FocusEvent focusEvent = (FocusEvent)aWTEvent;
                CausedFocusEvent.Cause cause = focusEvent instanceof CausedFocusEvent ? ((CausedFocusEvent)focusEvent).getCause() : CausedFocusEvent.Cause.UNKNOWN;
                Component component = this.getGlobalFocusOwner();
                Component component3 = focusEvent.getComponent();
                if (component == component3) {
                    if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                        focusLog.fine("Skipping {0} because focus owner is the same", aWTEvent);
                    }
                    this.dequeueKeyEvents(-1L, component3);
                    return true;
                }
                if (component != null && !(bl = DefaultKeyboardFocusManager.sendMessage(component, new CausedFocusEvent(component, 1005, focusEvent.isTemporary(), component3, cause)))) {
                    this.setGlobalFocusOwner(null);
                    if (!focusEvent.isTemporary()) {
                        this.setGlobalPermanentFocusOwner(null);
                    }
                }
                Window window = SunToolkit.getContainingWindow(component3);
                Window window6 = this.getGlobalFocusedWindow();
                if (window != null && window != window6) {
                    DefaultKeyboardFocusManager.sendMessage(window, new WindowEvent(window, 207, window6));
                    if (window != this.getGlobalFocusedWindow()) {
                        this.dequeueKeyEvents(-1L, component3);
                        return true;
                    }
                }
                if (!component3.isFocusable() || !component3.isShowing() || !component3.isEnabled() && !cause.equals((Object)CausedFocusEvent.Cause.UNKNOWN)) {
                    this.dequeueKeyEvents(-1L, component3);
                    if (!KeyboardFocusManager.isAutoFocusTransferEnabled()) return true;
                    if (window == null) {
                        this.restoreFocus(focusEvent, window6);
                    } else {
                        this.restoreFocus(focusEvent, window);
                    }
                    DefaultKeyboardFocusManager.setMostRecentFocusOwner(window, null);
                    return true;
                }
                this.setGlobalFocusOwner(component3);
                if (component3 != this.getGlobalFocusOwner()) {
                    this.dequeueKeyEvents(-1L, component3);
                    if (!KeyboardFocusManager.isAutoFocusTransferEnabled()) return true;
                    this.restoreFocus(focusEvent, window);
                    return true;
                }
                if (!focusEvent.isTemporary()) {
                    this.setGlobalPermanentFocusOwner(component3);
                    if (component3 != this.getGlobalPermanentFocusOwner()) {
                        this.dequeueKeyEvents(-1L, component3);
                        if (!KeyboardFocusManager.isAutoFocusTransferEnabled()) return true;
                        this.restoreFocus(focusEvent, window);
                        return true;
                    }
                }
                this.setNativeFocusOwner(DefaultKeyboardFocusManager.getHeavyweight(component3));
                Component component4 = (Component)this.realOppositeComponentWR.get();
                if (component4 == null) return this.typeAheadAssertions(component3, focusEvent);
                if (component4 == focusEvent.getOppositeComponent()) return this.typeAheadAssertions(component3, focusEvent);
                focusEvent = new CausedFocusEvent(component3, 1004, focusEvent.isTemporary(), component4, cause);
                focusEvent.isPosted = true;
                return this.typeAheadAssertions(component3, focusEvent);
            }
            case 1005: {
                FocusEvent focusEvent = (FocusEvent)aWTEvent;
                Component component = this.getGlobalFocusOwner();
                if (component == null) {
                    if (!focusLog.isLoggable(PlatformLogger.Level.FINE)) return true;
                    focusLog.fine("Skipping {0} because focus owner is null", aWTEvent);
                    return true;
                }
                if (component == focusEvent.getOppositeComponent()) {
                    if (!focusLog.isLoggable(PlatformLogger.Level.FINE)) return true;
                    focusLog.fine("Skipping {0} because current focus owner is equal to opposite", aWTEvent);
                    return true;
                }
                this.setGlobalFocusOwner(null);
                if (this.getGlobalFocusOwner() != null) {
                    this.restoreFocus(component, true);
                    return true;
                }
                if (!focusEvent.isTemporary()) {
                    this.setGlobalPermanentFocusOwner(null);
                    if (this.getGlobalPermanentFocusOwner() != null) {
                        this.restoreFocus(component, true);
                        return true;
                    }
                } else {
                    Window window = component.getContainingWindow();
                    if (window != null) {
                        window.setTemporaryLostComponent(component);
                    }
                }
                this.setNativeFocusOwner(null);
                focusEvent.setSource(component);
                this.realOppositeComponentWR = focusEvent.getOppositeComponent() != null ? new WeakReference<Component>(component) : NULL_COMPONENT_WR;
                return this.typeAheadAssertions(component, focusEvent);
            }
            case 206: {
                WindowEvent windowEvent = (WindowEvent)aWTEvent;
                Window window = this.getGlobalActiveWindow();
                if (window == null) {
                    return true;
                }
                if (window != aWTEvent.getSource()) {
                    return true;
                }
                this.setGlobalActiveWindow(null);
                if (this.getGlobalActiveWindow() != null) {
                    return true;
                }
                windowEvent.setSource(window);
                return this.typeAheadAssertions(window, windowEvent);
            }
            case 208: {
                if (this.repostIfFollowsKeyEvents((WindowEvent)aWTEvent)) {
                    return true;
                }
                WindowEvent windowEvent = (WindowEvent)aWTEvent;
                Window window = this.getGlobalFocusedWindow();
                Window window7 = windowEvent.getWindow();
                Window window8 = this.getGlobalActiveWindow();
                Window window9 = windowEvent.getOppositeWindow();
                if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                    focusLog.fine("Active {0}, Current focused {1}, losing focus {2} opposite {3}", window8, window, window7, window9);
                }
                if (window == null) {
                    return true;
                }
                if (this.inSendMessage == 0 && window7 == window8 && window9 == window) {
                    return true;
                }
                Component component = this.getGlobalFocusOwner();
                if (component != null) {
                    Component component5 = null;
                    if (window9 != null && (component5 = window9.getTemporaryLostComponent()) == null) {
                        component5 = window9.getMostRecentFocusOwner();
                    }
                    if (component5 == null) {
                        component5 = window9;
                    }
                    DefaultKeyboardFocusManager.sendMessage(component, new CausedFocusEvent(component, 1005, true, component5, CausedFocusEvent.Cause.ACTIVATION));
                }
                this.setGlobalFocusedWindow(null);
                if (this.getGlobalFocusedWindow() != null) {
                    this.restoreFocus(window, null, true);
                    return true;
                }
                windowEvent.setSource(window);
                this.realOppositeWindowWR = window9 != null ? new WeakReference<Window>(window) : NULL_WINDOW_WR;
                this.typeAheadAssertions(window, windowEvent);
                if (window9 != null) return true;
                DefaultKeyboardFocusManager.sendMessage(window8, new WindowEvent(window8, 206, null));
                if (this.getGlobalActiveWindow() == null) return true;
                this.restoreFocus(window, null, true);
                return true;
            }
            case 400: 
            case 401: 
            case 402: {
                return this.typeAheadAssertions(null, aWTEvent);
            }
        }
        return false;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        Container container;
        ComponentPeer componentPeer;
        Object object;
        Component component;
        Component component2;
        Component component3 = component2 = keyEvent.isPosted ? this.getFocusOwner() : keyEvent.getComponent();
        if (component2 != null && component2.isShowing() && component2.canBeFocusOwner() && !keyEvent.isConsumed() && (component = keyEvent.getComponent()) != null && component.isEnabled()) {
            this.redispatchEvent(component, keyEvent);
        }
        boolean bl = false;
        List<KeyEventPostProcessor> list = this.getKeyEventPostProcessors();
        if (list != null) {
            object = list.iterator();
            while (!bl && object.hasNext()) {
                bl = ((KeyEventPostProcessor)object.next()).postProcessKeyEvent(keyEvent);
            }
        }
        if (!bl) {
            this.postProcessKeyEvent(keyEvent);
        }
        if (((componentPeer = ((Component)(object = keyEvent.getComponent())).getPeer()) == null || componentPeer instanceof LightweightPeer) && (container = ((Component)object).getNativeContainer()) != null) {
            componentPeer = container.getPeer();
        }
        if (componentPeer != null) {
            componentPeer.handleEvent(keyEvent);
        }
        return true;
    }

    @Override
    public boolean postProcessKeyEvent(KeyEvent keyEvent) {
        Component component;
        Container container;
        if (!keyEvent.isConsumed() && (container = (Container)((component = keyEvent.getComponent()) instanceof Container ? component : component.getParent())) != null) {
            container.postProcessKeyEvent(keyEvent);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pumpApprovedKeyEvents() {
        KeyEvent keyEvent;
        do {
            keyEvent = null;
            DefaultKeyboardFocusManager defaultKeyboardFocusManager = this;
            synchronized (defaultKeyboardFocusManager) {
                if (this.enqueuedKeyEvents.size() != 0) {
                    keyEvent = this.enqueuedKeyEvents.getFirst();
                    if (this.typeAheadMarkers.size() != 0) {
                        TypeAheadMarker typeAheadMarker = this.typeAheadMarkers.getFirst();
                        if (keyEvent.getWhen() > typeAheadMarker.after) {
                            keyEvent = null;
                        }
                    }
                    if (keyEvent != null) {
                        if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
                            focusLog.finer("Pumping approved event {0}", keyEvent);
                        }
                        this.enqueuedKeyEvents.removeFirst();
                    }
                }
            }
            if (keyEvent == null) continue;
            this.preDispatchKeyEvent(keyEvent);
        } while (keyEvent != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpMarkers() {
        if (focusLog.isLoggable(PlatformLogger.Level.FINEST)) {
            focusLog.finest(">>> Markers dump, time: {0}", System.currentTimeMillis());
            DefaultKeyboardFocusManager defaultKeyboardFocusManager = this;
            synchronized (defaultKeyboardFocusManager) {
                if (this.typeAheadMarkers.size() != 0) {
                    for (TypeAheadMarker typeAheadMarker : this.typeAheadMarkers) {
                        focusLog.finest("    {0}", typeAheadMarker);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean typeAheadAssertions(Component var1_1, AWTEvent var2_2) {
        this.pumpApprovedKeyEvents();
        switch (var2_2.getID()) {
            case 400: 
            case 401: 
            case 402: {
                var3_3 = (KeyEvent)var2_2;
                var4_5 = this;
                synchronized (var4_5) {
                    if (var2_2.isPosted && this.typeAheadMarkers.size() != 0) {
                        var5_7 = this.typeAheadMarkers.getFirst();
                        if (var3_3.getWhen() > var5_7.after) {
                            if (DefaultKeyboardFocusManager.focusLog.isLoggable(PlatformLogger.Level.FINER)) {
                                DefaultKeyboardFocusManager.focusLog.finer("Storing event {0} because of marker {1}", new Object[]{var3_3, var5_7});
                            }
                            this.enqueuedKeyEvents.addLast(var3_3);
                            return true;
                        }
                    }
                }
                return this.preDispatchKeyEvent(var3_3);
            }
            case 1004: {
                if (DefaultKeyboardFocusManager.focusLog.isLoggable(PlatformLogger.Level.FINEST)) {
                    DefaultKeyboardFocusManager.focusLog.finest("Markers before FOCUS_GAINED on {0}", new Object[]{var1_1});
                }
                this.dumpMarkers();
                var3_4 = this;
                synchronized (var3_4) {
                    var4_6 = false;
                    if (!this.hasMarker(var1_1)) ** GOTO lbl38
                    var5_8 = this.typeAheadMarkers.iterator();
                    while (var5_8.hasNext()) {
                        if (((TypeAheadMarker)var5_8.next()).untilFocused != var1_1) ** GOTO lbl33
                        var4_6 = true;
                        ** GOTO lbl34
lbl33:
                        // 1 sources

                        if (var4_6) ** GOTO lbl43
lbl34:
                        // 2 sources

                        var5_8.remove();
                    }
                    ** GOTO lbl43
lbl38:
                    // 1 sources

                    if (DefaultKeyboardFocusManager.focusLog.isLoggable(PlatformLogger.Level.FINER)) {
                        DefaultKeyboardFocusManager.focusLog.finer("Event without marker {0}", new Object[]{var2_2});
                    }
                }
lbl43:
                // 3 sources

                DefaultKeyboardFocusManager.focusLog.finest("Markers after FOCUS_GAINED");
                this.dumpMarkers();
                this.redispatchEvent(var1_1, var2_2);
                this.pumpApprovedKeyEvents();
                return true;
            }
        }
        this.redispatchEvent(var1_1, var2_2);
        return true;
    }

    private boolean hasMarker(Component component) {
        Iterator iterator = this.typeAheadMarkers.iterator();
        while (iterator.hasNext()) {
            if (((TypeAheadMarker)iterator.next()).untilFocused != component) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void clearMarkers() {
        DefaultKeyboardFocusManager defaultKeyboardFocusManager = this;
        synchronized (defaultKeyboardFocusManager) {
            this.typeAheadMarkers.clear();
        }
    }

    private boolean preDispatchKeyEvent(KeyEvent keyEvent) {
        List<KeyEventDispatcher> list;
        if (keyEvent.isPosted) {
            list = this.getFocusOwner();
            keyEvent.setSource(list != null ? list : this.getFocusedWindow());
        }
        if (keyEvent.getSource() == null) {
            return true;
        }
        EventQueue.setCurrentEventAndMostRecentTime(keyEvent);
        if (KeyboardFocusManager.isProxyActive(keyEvent)) {
            ComponentPeer componentPeer;
            list = (Component)keyEvent.getSource();
            Container container = ((Component)((Object)list)).getNativeContainer();
            if (container != null && (componentPeer = container.getPeer()) != null) {
                componentPeer.handleEvent(keyEvent);
                keyEvent.consume();
            }
            return true;
        }
        list = this.getKeyEventDispatchers();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!((KeyEventDispatcher)iterator.next()).dispatchKeyEvent(keyEvent)) continue;
                return true;
            }
        }
        return this.dispatchKeyEvent(keyEvent);
    }

    private void consumeNextKeyTyped(KeyEvent keyEvent) {
        this.consumeNextKeyTyped = true;
    }

    private void consumeTraversalKey(KeyEvent keyEvent) {
        keyEvent.consume();
        this.consumeNextKeyTyped = keyEvent.getID() == 401 && !keyEvent.isActionKey();
    }

    private boolean consumeProcessedKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 400 && this.consumeNextKeyTyped) {
            keyEvent.consume();
            this.consumeNextKeyTyped = false;
            return true;
        }
        return false;
    }

    @Override
    public void processKeyEvent(Component component, KeyEvent keyEvent) {
        if (this.consumeProcessedKeyEvent(keyEvent)) {
            return;
        }
        if (keyEvent.getID() == 400) {
            return;
        }
        if (component.getFocusTraversalKeysEnabled() && !keyEvent.isConsumed()) {
            AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent);
            AWTKeyStroke aWTKeyStroke2 = AWTKeyStroke.getAWTKeyStroke(aWTKeyStroke.getKeyCode(), aWTKeyStroke.getModifiers(), !aWTKeyStroke.isOnKeyRelease());
            Set<AWTKeyStroke> set = component.getFocusTraversalKeys(0);
            boolean bl = set.contains(aWTKeyStroke);
            boolean bl2 = set.contains(aWTKeyStroke2);
            if (bl || bl2) {
                this.consumeTraversalKey(keyEvent);
                if (bl) {
                    this.focusNextComponent(component);
                }
                return;
            }
            if (keyEvent.getID() == 401) {
                this.consumeNextKeyTyped = false;
            }
            set = component.getFocusTraversalKeys(1);
            bl = set.contains(aWTKeyStroke);
            bl2 = set.contains(aWTKeyStroke2);
            if (bl || bl2) {
                this.consumeTraversalKey(keyEvent);
                if (bl) {
                    this.focusPreviousComponent(component);
                }
                return;
            }
            set = component.getFocusTraversalKeys(2);
            bl = set.contains(aWTKeyStroke);
            bl2 = set.contains(aWTKeyStroke2);
            if (bl || bl2) {
                this.consumeTraversalKey(keyEvent);
                if (bl) {
                    this.upFocusCycle(component);
                }
                return;
            }
            if (!(component instanceof Container) || !((Container)component).isFocusCycleRoot()) {
                return;
            }
            set = component.getFocusTraversalKeys(3);
            bl = set.contains(aWTKeyStroke);
            bl2 = set.contains(aWTKeyStroke2);
            if (bl || bl2) {
                this.consumeTraversalKey(keyEvent);
                if (bl) {
                    this.downFocusCycle((Container)component);
                }
            }
        }
    }

    @Override
    protected synchronized void enqueueKeyEvents(long l, Component component) {
        int n;
        if (component == null) {
            return;
        }
        if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
            focusLog.finer("Enqueue at {0} for {1}", l, component);
        }
        int n2 = 0;
        ListIterator<TypeAheadMarker> listIterator = this.typeAheadMarkers.listIterator(n);
        for (n = this.typeAheadMarkers.size(); n > 0; --n) {
            TypeAheadMarker typeAheadMarker = listIterator.previous();
            if (typeAheadMarker.after > l) continue;
            n2 = n;
            break;
        }
        this.typeAheadMarkers.add(n2, new TypeAheadMarker(l, component));
    }

    @Override
    protected synchronized void dequeueKeyEvents(long l, Component component) {
        if (component == null) {
            return;
        }
        if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
            focusLog.finer("Dequeue at {0} for {1}", l, component);
        }
        ListIterator<TypeAheadMarker> listIterator = this.typeAheadMarkers.listIterator(l >= 0L ? this.typeAheadMarkers.size() : 0);
        if (l < 0L) {
            while (listIterator.hasNext()) {
                TypeAheadMarker typeAheadMarker = listIterator.next();
                if (typeAheadMarker.untilFocused != component) continue;
                listIterator.remove();
                return;
            }
        } else {
            while (listIterator.hasPrevious()) {
                TypeAheadMarker typeAheadMarker = listIterator.previous();
                if (typeAheadMarker.untilFocused != component || typeAheadMarker.after != l) continue;
                listIterator.remove();
                return;
            }
        }
    }

    @Override
    protected synchronized void discardKeyEvents(Component component) {
        if (component == null) {
            return;
        }
        long l = -1L;
        Iterator iterator = this.typeAheadMarkers.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            TypeAheadMarker typeAheadMarker = (TypeAheadMarker)iterator.next();
            Component component2 = typeAheadMarker.untilFocused;
            boolean bl2 = bl = component2 == component;
            while (!bl && component2 != null && !(component2 instanceof Window)) {
                bl = (component2 = component2.getParent()) == component;
            }
            if (bl) {
                if (l < 0L) {
                    l = typeAheadMarker.after;
                }
                iterator.remove();
                continue;
            }
            if (l < 0L) continue;
            this.purgeStampedEvents(l, typeAheadMarker.after);
            l = -1L;
        }
        this.purgeStampedEvents(l, -1L);
    }

    private void purgeStampedEvents(long l, long l2) {
        if (l < 0L) {
            return;
        }
        Iterator iterator = this.enqueuedKeyEvents.iterator();
        while (iterator.hasNext()) {
            KeyEvent keyEvent = (KeyEvent)iterator.next();
            long l3 = keyEvent.getWhen();
            if (l < l3 && (l2 < 0L || l3 <= l2)) {
                iterator.remove();
            }
            if (l2 < 0L || l3 <= l2) continue;
            break;
        }
    }

    @Override
    public void focusPreviousComponent(Component component) {
        if (component != null) {
            component.transferFocusBackward();
        }
    }

    @Override
    public void focusNextComponent(Component component) {
        if (component != null) {
            component.transferFocus();
        }
    }

    @Override
    public void upFocusCycle(Component component) {
        if (component != null) {
            component.transferFocusUpCycle();
        }
    }

    @Override
    public void downFocusCycle(Container container) {
        if (container != null && container.isFocusCycleRoot()) {
            container.transferFocusDownCycle();
        }
    }

    static {
        AWTAccessor.setDefaultKeyboardFocusManagerAccessor(new AWTAccessor.DefaultKeyboardFocusManagerAccessor(){

            @Override
            public void consumeNextKeyTyped(DefaultKeyboardFocusManager defaultKeyboardFocusManager, KeyEvent keyEvent) {
                defaultKeyboardFocusManager.consumeNextKeyTyped(keyEvent);
            }
        });
    }

    private static class DefaultKeyboardFocusManagerSentEvent
    extends SentEvent {
        private static final long serialVersionUID = -2924743257508701758L;

        public DefaultKeyboardFocusManagerSentEvent(AWTEvent aWTEvent, AppContext appContext) {
            super(aWTEvent, appContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void dispatch() {
            DefaultKeyboardFocusManager defaultKeyboardFocusManager;
            DefaultKeyboardFocusManager defaultKeyboardFocusManager2;
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            DefaultKeyboardFocusManager defaultKeyboardFocusManager3 = defaultKeyboardFocusManager2 = keyboardFocusManager instanceof DefaultKeyboardFocusManager ? (DefaultKeyboardFocusManager)keyboardFocusManager : null;
            if (defaultKeyboardFocusManager2 != null) {
                defaultKeyboardFocusManager = defaultKeyboardFocusManager2;
                synchronized (defaultKeyboardFocusManager) {
                    defaultKeyboardFocusManager2.inSendMessage++;
                }
            }
            super.dispatch();
            if (defaultKeyboardFocusManager2 != null) {
                defaultKeyboardFocusManager = defaultKeyboardFocusManager2;
                synchronized (defaultKeyboardFocusManager) {
                    defaultKeyboardFocusManager2.inSendMessage--;
                }
            }
        }
    }

    private static class TypeAheadMarker {
        long after;
        Component untilFocused;

        TypeAheadMarker(long l, Component component) {
            this.after = l;
            this.untilFocused = component;
        }

        public String toString() {
            return ">>> Marker after " + this.after + " on " + this.untilFocused;
        }
    }
}

