/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.Buildings;
import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData_Armoury;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData_Farm;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData_Fort;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData_Library;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData_Supply;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData_Tower;
import age.of.civilizations2.jakowski.lukasz.Construction_GameData_Workshop;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Armoury;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Farm;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Fort;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Library;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Port;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Supply;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Tower;
import age.of.civilizations2.jakowski.lukasz.Message_Bulit_Workshop;
import age.of.civilizations2.jakowski.lukasz.Save_Civ_GameData;

class BuildingsManager {
    protected static Buildings ACTIVE_BUILDING = Buildings.FORT;
    private static final float[] ARMOURY_BUILD_COST;
    private static final int[] ARMOURY_BUILD_MOVEMENT_COST;
    private static final int[] ARMOURY_CONSTRUCTION;
    private static final String[] ARMOURY_NAMES;
    private static final float[] ARMOURY_TECH_LEVEL;
    protected static final int BONUS_CAPITAL_ATTACK_FROM_CAPITAL = 10;
    protected static final int BONUS_CAPITAL_DEFENSE = 15;
    protected static final int DESTROY_MOVEMENT_COST = 4;
    private static final float[] FARM_BUILD_COST;
    private static final int[] FARM_BUILD_MOVEMENT_COST;
    private static final int[] FARM_CONSTRUCTION;
    private static final float[] FARM_GROWTH_RATE_BONUS;
    private static final int[] FARM_MAINTENANCE_COST;
    private static final String[] FARM_NAMES;
    private static final float[] FARM_TECHNOLOGY_LEVEL;
    private static final float[] FORT_BUILD_COST;
    private static final int[] FORT_BUILD_MOVEMENT_COST;
    private static final int[] FORT_CONSTRUCTION;
    private static final int[] FORT_DEFENSE_BONUS;
    private static final int[] FORT_MAINTENANCE_COST;
    private static final String[] FORT_NAMES;
    private static final float[] FORT_TECH_LEVEL;
    private static final float[] LIBRARY_BUILD_COST;
    private static final int[] LIBRARY_BUILD_MOVEMENT_COST;
    private static final int[] LIBRARY_CONSTRUCTION;
    private static final String[] LIBRARY_NAMES;
    private static final int[] LIBRARY_RESEARCH_PER_POPULATION;
    private static final float[] LIBRARY_TECH_LEVEL;
    private static final float[] PORT_BUILD_COST;
    private static final int[] PORT_BUILD_MOVEMENT_COST;
    private static final int[] PORT_CONSTRUCTION;
    private static final float[] PORT_INCOME_PRODUCTION;
    private static final int[] PORT_MAINTENANCE_COST;
    private static final String[] PORT_NAMES;
    private static final float[] PORT_TECHNOLOGY_LEVEL;
    private static final float[] SUPPLY_BONUS;
    private static final float[] SUPPLY_BUILD_COST;
    private static final int[] SUPPLY_BUILD_MOVEMENT_COST;
    private static final int[] SUPPLY_CONSTRUCTION;
    private static final String[] SUPPLY_NAMES;
    private static final float[] SUPPLY_TECH_LEVEL;
    private static final float[] TOWER_BUILD_COST;
    private static final int[] TOWER_BUILD_MOVEMENT_COST;
    private static final int[] TOWER_CONSTRUCTION;
    private static final int[] TOWER_DEFENSE_BONUS;
    private static final int[] TOWER_MAINTENANCE_COST;
    private static final String[] TOWER_NAMES;
    private static final float[] TOWER_TECHNOLOGY_LEVEL;
    private static final float[] WORKSHOP_BUILD_COST;
    private static final int[] WORKSHOP_BUILD_MOVEMENT_COST;
    private static final int[] WORKSHOP_CONSTRUCTION;
    private static final float[] WORKSHOP_INCOME_PRODUCTION;
    private static final int[] WORKSHOP_MAINTENANCE_COST;
    private static final String[] WORKSHOP_NAMES;
    private static final float[] WORKSHOP_TECHNOLOGY_LEVEL;
    protected static int iBuildInProvinceID;

    static {
        iBuildInProvinceID = 0;
        FORT_NAMES = new String[]{"", "Castle", "Fortress"};
        FORT_BUILD_COST = new float[]{0.0f, 0.05f, 0.0865f};
        FORT_BUILD_MOVEMENT_COST = new int[]{0, 12, 14};
        FORT_DEFENSE_BONUS = new int[]{0, 10, 20};
        FORT_MAINTENANCE_COST = new int[]{0, 60, 125};
        FORT_TECH_LEVEL = new float[]{0.0f, 0.25f, 0.5f};
        FORT_CONSTRUCTION = new int[]{0, 2, 3};
        TOWER_NAMES = new String[]{"", "WatchTower"};
        TOWER_BUILD_COST = new float[]{0.0f, 0.0425f};
        TOWER_BUILD_MOVEMENT_COST = new int[]{0, 16};
        TOWER_DEFENSE_BONUS = new int[]{0, 4};
        TOWER_MAINTENANCE_COST = new int[]{0, 35};
        TOWER_TECHNOLOGY_LEVEL = new float[]{0.0f, 0.2f};
        TOWER_CONSTRUCTION = new int[]{0, 1};
        PORT_NAMES = new String[]{"", "Port"};
        PORT_BUILD_COST = new float[]{0.0f, 0.0685f};
        PORT_BUILD_MOVEMENT_COST = new int[]{0, 16};
        PORT_MAINTENANCE_COST = new int[]{0, 35};
        PORT_TECHNOLOGY_LEVEL = new float[]{0.0f, 0.25f};
        PORT_INCOME_PRODUCTION = new float[]{0.0f, 0.02f};
        PORT_CONSTRUCTION = new int[]{0, 1};
        FARM_NAMES = new String[]{"", "Farm", "Farm", "Farm", "Farm", "Farm"};
        FARM_BUILD_COST = new float[]{0.0f, 0.0625f, 0.0765f, 0.1115f, 0.165f, 0.215f};
        FARM_BUILD_MOVEMENT_COST = new int[]{0, 14, 16, 18, 24, 26};
        FARM_GROWTH_RATE_BONUS = new float[]{0.0f, 0.05f, 0.1f, 0.15f, 0.2f, 0.25f};
        FARM_MAINTENANCE_COST = new int[]{0, 35, 50, 55, 65, 75};
        FARM_TECHNOLOGY_LEVEL = new float[]{0.0f, 0.15f, 0.3f, 0.4f, 0.55f, 0.7f};
        FARM_CONSTRUCTION = new int[]{0, 1, 2, 3, 4, 5};
        LIBRARY_NAMES = new String[]{"", "Library", "University", "ResearchLab"};
        LIBRARY_BUILD_COST = new float[]{0.0f, 0.08f, 0.1425f, 0.2125f};
        LIBRARY_BUILD_MOVEMENT_COST = new int[]{0, 10, 16, 20};
        LIBRARY_RESEARCH_PER_POPULATION = new int[]{0, 725, 425, 225};
        LIBRARY_TECH_LEVEL = new float[]{0.0f, 0.25f, 0.5f, 0.85f};
        LIBRARY_CONSTRUCTION = new int[]{0, 2, 3, 4};
        ARMOURY_NAMES = new String[]{"", "Armoury"};
        ARMOURY_BUILD_COST = new float[]{0.0f, 0.095f};
        ARMOURY_BUILD_MOVEMENT_COST = new int[]{0, 28};
        ARMOURY_TECH_LEVEL = new float[]{0.0f, 0.4f};
        ARMOURY_CONSTRUCTION = new int[]{0, 4};
        WORKSHOP_NAMES = new String[]{"", "Workshop", "Workshop", "Workshop"};
        WORKSHOP_BUILD_COST = new float[]{0.0f, 0.06f, 0.1f, 0.15f};
        WORKSHOP_BUILD_MOVEMENT_COST = new int[]{0, 18, 24, 30};
        WORKSHOP_INCOME_PRODUCTION = new float[]{0.0f, 0.05f, 0.1f, 0.15f};
        WORKSHOP_MAINTENANCE_COST = new int[]{0, 35, 50, 70};
        WORKSHOP_TECHNOLOGY_LEVEL = new float[]{0.0f, 0.4f, 0.65f, 0.8f};
        WORKSHOP_CONSTRUCTION = new int[]{0, 2, 3, 3};
        SUPPLY_NAMES = new String[]{"", "SupplyCamp"};
        SUPPLY_BUILD_COST = new float[]{0.0f, 0.01675f};
        SUPPLY_BUILD_MOVEMENT_COST = new int[]{0, 14};
        SUPPLY_TECH_LEVEL = new float[]{0.0f, 0.3f};
        SUPPLY_CONSTRUCTION = new int[]{0, 3};
        SUPPLY_BONUS = new float[]{0.0f, 0.2f};
    }

    BuildingsManager() {
    }

    protected static final boolean buildArmoury(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfArmoury() < BuildingsManager.getArmoury_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfArmoury(CFG.game.getProvince(n).getLevelOfArmoury() + 1);
            Save_Civ_GameData save_Civ_GameData = CFG.game.getCiv((int)n2).civGameData;
            ++save_Civ_GameData.iNumOfBuildingsConstructed;
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Armoury(n2, n));
            return true;
        }
        return false;
    }

    protected static final boolean buildFarm(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfFarm() < BuildingsManager.getFarm_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfFarm(CFG.game.getProvince(n).getLevelOfFarm() + 1);
            Save_Civ_GameData save_Civ_GameData = CFG.game.getCiv((int)n2).civGameData;
            ++save_Civ_GameData.iNumOfBuildingsConstructed;
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Farm(n2, n));
            return true;
        }
        return false;
    }

    protected static final boolean buildFort(int n, int n2) {
        boolean bl = CFG.game.getProvince(n).getSeaProvince();
        if (!bl && CFG.game.getProvince(n).getLevelOfFort() < BuildingsManager.getFort_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfFort(CFG.game.getProvince(n).getLevelOfFort() + 1);
            Save_Civ_GameData save_Civ_GameData = CFG.game.getCiv((int)n2).civGameData;
            ++save_Civ_GameData.iNumOfBuildingsConstructed;
            for (int i = 0; i < CFG.game.getPlayersSize(); ++i) {
                if (CFG.game.getCiv(CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID()).getNumOfProvinces() <= 0) continue;
                CFG.game.getProvince(n).updateFogOfWar(i);
            }
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Fort(n2, n));
            return true;
        }
        return false;
    }

    protected static final boolean buildLibrary(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfLibrary() < BuildingsManager.getLibrary_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfLibrary(CFG.game.getProvince(n).getLevelOfLibrary() + 1);
            Save_Civ_GameData save_Civ_GameData = CFG.game.getCiv((int)n2).civGameData;
            ++save_Civ_GameData.iNumOfBuildingsConstructed;
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Library(n2, n));
            return true;
        }
        return false;
    }

    protected static final boolean buildPort(int n, int n2) {
        if (CFG.game.getProvince(n).getLevelOfPort() >= 0 && CFG.game.getProvince(n).getLevelOfPort() < BuildingsManager.getPort_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfPort(CFG.game.getProvince(n).getLevelOfPort() + 1);
            Save_Civ_GameData save_Civ_GameData = CFG.game.getCiv((int)n2).civGameData;
            ++save_Civ_GameData.iNumOfBuildingsConstructed;
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Port(n2, n));
            return true;
        }
        return false;
    }

    protected static final boolean buildSupply(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfSupply() < BuildingsManager.getSupply_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfSupply(CFG.game.getProvince(n).getLevelOfSupply() + 1);
            Save_Civ_GameData save_Civ_GameData = CFG.game.getCiv((int)n2).civGameData;
            ++save_Civ_GameData.iNumOfBuildingsConstructed;
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Supply(n2, n));
            return true;
        }
        return false;
    }

    protected static final boolean buildTower(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfWatchTower() < BuildingsManager.getTower_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfWatchTower(CFG.game.getProvince(n).getLevelOfWatchTower() + 1);
            Save_Civ_GameData save_Civ_GameData = CFG.game.getCiv((int)n2).civGameData;
            ++save_Civ_GameData.iNumOfBuildingsConstructed;
            for (int i = 0; i < CFG.game.getPlayersSize(); ++i) {
                if (CFG.game.getCiv(CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID()).getNumOfProvinces() <= 0) continue;
                for (int j = 0; j < CFG.game.getProvince(n).getNeighboringProvincesSize(); ++j) {
                    CFG.game.getProvince(CFG.game.getProvince(n).getNeighboringProvinces(j)).updateFogOfWar(i);
                }
            }
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Tower(n2, n));
            return true;
        }
        return false;
    }

    protected static final boolean buildWorkshop(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfWorkshop() < BuildingsManager.getWorkshop_MaxLevel()) {
            CFG.game.getProvince(n).setLevelOfWorkshop(CFG.game.getProvince(n).getLevelOfWorkshop() + 1);
            Save_Civ_GameData save_Civ_GameData = CFG.game.getCiv((int)n2).civGameData;
            ++save_Civ_GameData.iNumOfBuildingsConstructed;
            CFG.game.getCiv((int)n2).getCivilization_Diplomacy_GameData().messageBox.addMessage(new Message_Bulit_Workshop(n2, n));
            return true;
        }
        return false;
    }

    protected static final boolean canBuildArmoury(int n) {
        int n2 = CFG.game.getProvince(n).getLevelOfArmoury();
        int n3 = BuildingsManager.getArmoury_MaxLevel();
        boolean bl = true;
        if (n2 >= n3 || !(CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getArmoury_TechLevel(CFG.game.getProvince(n).getLevelOfArmoury() + 1)) || CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() < BuildingsManager.getArmoury_BuildMovementCost(CFG.game.getProvince(n).getLevelOfArmoury() + 1)) {
            bl = false;
        }
        return bl;
    }

    protected static final boolean canBuildFarm(int n) {
        int n2 = CFG.game.getProvince(n).getLevelOfFarm();
        int n3 = BuildingsManager.getFarm_MaxLevel();
        boolean bl = true;
        if (n2 >= n3 || !BuildingsManager.canBuildFarm_Terrain(n) || !(CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getFarm_TechLevel(CFG.game.getProvince(n).getLevelOfFarm() + 1)) || CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() < BuildingsManager.getFarm_BuildMovementCost(CFG.game.getProvince(n).getLevelOfFarm() + 1)) {
            bl = false;
        }
        return bl;
    }

    protected static final boolean canBuildFarm_Terrain(int n) {
        boolean bl = CFG.terrainTypesManager.getPopulationGrowth(CFG.game.getProvince(n).getTerrainTypeID()) >= 0.0f;
        return bl;
    }

    protected static final boolean canBuildFort(int n) {
        int n2 = CFG.game.getProvince(n).getLevelOfFort();
        int n3 = BuildingsManager.getFort_MaxLevel();
        boolean bl = true;
        if (n2 >= n3 || !(CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getFort_TechLevel(CFG.game.getProvince(n).getLevelOfFort() + 1)) || CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() < BuildingsManager.getFort_BuildMovementCost(CFG.game.getProvince(n).getLevelOfFort() + 1)) {
            bl = false;
        }
        return bl;
    }

    protected static final boolean canBuildLibrary(int n) {
        int n2 = CFG.game.getProvince(n).getLevelOfLibrary();
        int n3 = BuildingsManager.getLibrary_MaxLevel();
        boolean bl = true;
        if (n2 >= n3 || !(CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getLibrary_TechLevel(CFG.game.getProvince(n).getLevelOfLibrary() + 1)) || CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() < BuildingsManager.getLibrary_BuildMovementCost(CFG.game.getProvince(n).getLevelOfLibrary() + 1)) {
            bl = false;
        }
        return bl;
    }

    protected static final boolean canBuildPort(int n) {
        int n2 = CFG.game.getProvince(n).getLevelOfPort();
        int n3 = BuildingsManager.getPort_MaxLevel();
        boolean bl = true;
        if (n2 >= n3 || !(CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getPort_TechLevel(CFG.game.getProvince(n).getLevelOfPort() + 1)) || CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() < BuildingsManager.getPort_BuildMovementCost(CFG.game.getProvince(n).getLevelOfPort() + 1) || CFG.game.getProvince(n).getNeighboringSeaProvincesSize() <= 0) {
            bl = false;
        }
        return bl;
    }

    protected static final boolean canBuildSupply(int n) {
        int n2 = CFG.game.getProvince(n).getLevelOfSupply();
        int n3 = BuildingsManager.getSupply_MaxLevel();
        boolean bl = true;
        if (n2 >= n3 || !(CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getSupply_TechLevel(CFG.game.getProvince(n).getLevelOfSupply() + 1)) || CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() < BuildingsManager.getSupply_BuildMovementCost(CFG.game.getProvince(n).getLevelOfSupply() + 1)) {
            bl = false;
        }
        return bl;
    }

    protected static final boolean canBuildTower(int n) {
        int n2 = CFG.game.getProvince(n).getLevelOfWatchTower();
        int n3 = BuildingsManager.getTower_MaxLevel();
        boolean bl = true;
        if (n2 >= n3 || !(CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getTower_TechLevel(CFG.game.getProvince(n).getLevelOfWatchTower() + 1)) || CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() < BuildingsManager.getTower_BuildMovementCost(CFG.game.getProvince(n).getLevelOfWatchTower() + 1)) {
            bl = false;
        }
        return bl;
    }

    protected static final boolean canBuildWorkshop(int n) {
        int n2 = CFG.game.getProvince(n).getLevelOfWorkshop();
        int n3 = BuildingsManager.getWorkshop_MaxLevel();
        boolean bl = true;
        if (n2 >= n3 || !(CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getTechnologyLevel() >= BuildingsManager.getWorkshop_TechLevel(CFG.game.getProvince(n).getLevelOfWorkshop() + 1)) || CFG.game.getCiv(CFG.game.getProvince(n).getCivID()).getMovePoints() < BuildingsManager.getWorkshop_BuildMovementCost(CFG.game.getProvince(n).getLevelOfWorkshop() + 1)) {
            bl = false;
        }
        return bl;
    }

    protected static final boolean constructArmoury(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfArmoury() < BuildingsManager.getArmoury_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getArmoury_TechLevel(CFG.game.getProvince(n).getLevelOfArmoury() + 1) && CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getArmoury_BuildMovementCost(CFG.game.getProvince(n).getLevelOfArmoury() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getArmoury_BuildCost(CFG.game.getProvince(n).getLevelOfArmoury() + 1, n)) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getArmoury_BuildMovementCost(CFG.game.getProvince(n).getLevelOfArmoury() + 1));
            CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getArmoury_BuildCost(CFG.game.getProvince(n).getLevelOfArmoury() + 1, n));
            CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData_Armoury(n, BuildingsManager.getArmoury_Construction(CFG.game.getProvince(n).getLevelOfArmoury() + 1)));
            return true;
        }
        return false;
    }

    protected static final boolean constructFarm(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfFarm() < BuildingsManager.getFarm_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getFarm_TechLevel(CFG.game.getProvince(n).getLevelOfFarm() + 1) && CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getFarm_BuildMovementCost(CFG.game.getProvince(n).getLevelOfFarm() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getFarm_BuildCost(CFG.game.getProvince(n).getLevelOfFarm() + 1, n)) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getFarm_BuildMovementCost(CFG.game.getProvince(n).getLevelOfFarm() + 1));
            CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getFarm_BuildCost(CFG.game.getProvince(n).getLevelOfFarm() + 1, n));
            CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData_Farm(n, BuildingsManager.getFarm_Construction(CFG.game.getProvince(n).getLevelOfFarm() + 1)));
            return true;
        }
        return false;
    }

    protected static final boolean constructFort(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfFort() < BuildingsManager.getFort_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getFort_TechLevel(CFG.game.getProvince(n).getLevelOfFort() + 1) && CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getFort_BuildMovementCost(CFG.game.getProvince(n).getLevelOfFort() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getFort_BuildCost(CFG.game.getProvince(n).getLevelOfFort() + 1, n)) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getFort_BuildMovementCost(CFG.game.getProvince(n).getLevelOfFort() + 1));
            CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getFort_BuildCost(CFG.game.getProvince(n).getLevelOfFort() + 1, n));
            CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData_Fort(n, BuildingsManager.getFort_Construction(CFG.game.getProvince(n).getLevelOfFort() + 1)));
            return true;
        }
        return false;
    }

    protected static final boolean constructLibrary(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfLibrary() < BuildingsManager.getLibrary_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getLibrary_TechLevel(CFG.game.getProvince(n).getLevelOfLibrary() + 1) && CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getLibrary_BuildMovementCost(CFG.game.getProvince(n).getLevelOfLibrary() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getLibrary_BuildCost(CFG.game.getProvince(n).getLevelOfLibrary() + 1, n)) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getLibrary_BuildMovementCost(CFG.game.getProvince(n).getLevelOfLibrary() + 1));
            CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getLibrary_BuildCost(CFG.game.getProvince(n).getLevelOfLibrary() + 1, n));
            CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData_Library(n, BuildingsManager.getLibrary_Construction(CFG.game.getProvince(n).getLevelOfLibrary() + 1)));
            return true;
        }
        return false;
    }

    protected static final boolean constructPort(int n, int n2) {
        if (CFG.game.getProvince(n).getLevelOfPort() >= 0 && CFG.game.getProvince(n).getLevelOfPort() < BuildingsManager.getPort_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getPort_TechLevel(CFG.game.getProvince(n).getLevelOfPort() + 1) && CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getPort_BuildMovementCost(CFG.game.getProvince(n).getLevelOfPort() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getPort_BuildCost(CFG.game.getProvince(n).getLevelOfPort() + 1, n)) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getPort_BuildMovementCost(CFG.game.getProvince(n).getLevelOfPort() + 1));
            CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getPort_BuildCost(CFG.game.getProvince(n).getLevelOfPort() + 1, n));
            CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData(n, BuildingsManager.getPort_Construction(CFG.game.getProvince(n).getLevelOfPort() + 1)));
            return true;
        }
        return false;
    }

    protected static final boolean constructSupply(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfSupply() < BuildingsManager.getSupply_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getSupply_TechLevel(CFG.game.getProvince(n).getLevelOfSupply() + 1) && CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getSupply_BuildMovementCost(CFG.game.getProvince(n).getLevelOfSupply() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getSupply_BuildCost(CFG.game.getProvince(n).getLevelOfSupply() + 1, n)) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getSupply_BuildMovementCost(CFG.game.getProvince(n).getLevelOfSupply() + 1));
            CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getSupply_BuildCost(CFG.game.getProvince(n).getLevelOfSupply() + 1, n));
            CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData_Supply(n, BuildingsManager.getSupply_Construction(CFG.game.getProvince(n).getLevelOfSupply() + 1)));
            return true;
        }
        return false;
    }

    protected static final boolean constructTower(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfWatchTower() < BuildingsManager.getTower_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getTower_TechLevel(CFG.game.getProvince(n).getLevelOfWatchTower() + 1) && CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getTower_BuildMovementCost(CFG.game.getProvince(n).getLevelOfWatchTower() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getTower_BuildCost(CFG.game.getProvince(n).getLevelOfWatchTower() + 1, n)) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getTower_BuildMovementCost(CFG.game.getProvince(n).getLevelOfWatchTower() + 1));
            CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getTower_BuildCost(CFG.game.getProvince(n).getLevelOfWatchTower() + 1, n));
            CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData_Tower(n, BuildingsManager.getTower_Construction(CFG.game.getProvince(n).getLevelOfWatchTower() + 1)));
            return true;
        }
        return false;
    }

    protected static final boolean constructWorkshop(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfWorkshop() < BuildingsManager.getWorkshop_MaxLevel() && CFG.game.getCiv(n2).getTechnologyLevel() >= BuildingsManager.getWorkshop_TechLevel(CFG.game.getProvince(n).getLevelOfWorkshop() + 1) && CFG.game.getCiv(n2).getMovePoints() >= BuildingsManager.getWorkshop_BuildMovementCost(CFG.game.getProvince(n).getLevelOfWorkshop() + 1) && CFG.game.getCiv(n2).getMoney() >= (long)BuildingsManager.getWorkshop_BuildCost(CFG.game.getProvince(n).getLevelOfWorkshop() + 1, n)) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - BuildingsManager.getWorkshop_BuildMovementCost(CFG.game.getProvince(n).getLevelOfWorkshop() + 1));
            CFG.game.getCiv(n2).setMoney(CFG.game.getCiv(n2).getMoney() - (long)BuildingsManager.getWorkshop_BuildCost(CFG.game.getProvince(n).getLevelOfWorkshop() + 1, n));
            CFG.game.getCiv(n2).addNewConstruction(new Construction_GameData_Workshop(n, BuildingsManager.getWorkshop_Construction(CFG.game.getProvince(n).getLevelOfWorkshop() + 1)));
            return true;
        }
        return false;
    }

    protected static final boolean destroyArmoury(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfArmoury() > 0 && CFG.game.getCiv(n2).getMovePoints() >= 4) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
            CFG.game.getProvince(n).setLevelOfArmoury(0);
            return true;
        }
        return false;
    }

    protected static final boolean destroyFarm(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfFarm() > 0 && CFG.game.getCiv(n2).getMovePoints() >= 4) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
            CFG.game.getProvince(n).setLevelOfFarm(0);
            return true;
        }
        return false;
    }

    protected static final boolean destroyFort(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfFort() > 0 && CFG.game.getCiv(n2).getMovePoints() >= 4) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
            CFG.game.getProvince(n).setLevelOfFort(0);
            return true;
        }
        return false;
    }

    protected static final boolean destroyLibrary(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfLibrary() > 0 && CFG.game.getCiv(n2).getMovePoints() >= 4) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
            CFG.game.getProvince(n).setLevelOfLibrary(0);
            return true;
        }
        return false;
    }

    protected static final boolean destroyPort(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfPort() > 0 && CFG.game.getCiv(n2).getMovePoints() >= 4) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
            CFG.game.getProvince(n).setLevelOfPort(0);
            return true;
        }
        return false;
    }

    protected static final boolean destroySupply(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfSupply() > 0 && CFG.game.getCiv(n2).getMovePoints() >= 4) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
            CFG.game.getProvince(n).setLevelOfSupply(0);
            return true;
        }
        return false;
    }

    protected static final boolean destroyTower(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfWatchTower() > 0 && CFG.game.getCiv(n2).getMovePoints() >= 4) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
            CFG.game.getProvince(n).setLevelOfWatchTower(0);
            if (CFG.game.getCiv(n2).getControlledByPlayer()) {
                CFG.game.getProvince(n).updateFogOfWar(CFG.game.getPlayerID_ByCivID(n2));
            }
            return true;
        }
        return false;
    }

    protected static final boolean destroyWorkshop(int n, int n2) {
        if (!CFG.game.getProvince(n).getSeaProvince() && CFG.game.getProvince(n).getLevelOfWorkshop() > 0 && CFG.game.getCiv(n2).getMovePoints() >= 4) {
            CFG.game.getCiv(n2).setMovePoints(CFG.game.getCiv(n2).getMovePoints() - 4);
            CFG.game.getProvince(n).setLevelOfWorkshop(0);
            return true;
        }
        return false;
    }

    protected static final int getArmoury_BuildCost(int n, int n2) {
        float f;
        float f2;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n3 >= CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces()) break;
            int n5 = n4;
            if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(n3)).getLevelOfArmoury() > 0) {
                n5 = n4 + 1;
            }
            ++n3;
            n4 = n5;
            continue;
            break;
        }
        try {
            f2 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
            f = ARMOURY_BUILD_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
        float f3 = n4;
        float f4 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
        float f5 = CFG.game.getProvince(n2).getDevelopmentLevel();
        float f6 = CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID());
        return (int)((f2 * (f + f3 * 0.0235f) + f4 * ((1.0f - f5) * 0.3f)) * (f6 + 1.0f));
    }

    protected static final int getArmoury_BuildMovementCost(int n) {
        try {
            n = ARMOURY_BUILD_MOVEMENT_COST[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getArmoury_Construction(int n) {
        try {
            n = ARMOURY_CONSTRUCTION[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getArmoury_MaxLevel() {
        return ARMOURY_NAMES.length - 1;
    }

    protected static final String getArmoury_Name(int n) {
        try {
            String string2 = ARMOURY_NAMES[n];
            return string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            String[] stringArray = ARMOURY_NAMES;
            return stringArray[stringArray.length - 1];
        }
    }

    protected static final float getArmoury_TechLevel(int n) {
        try {
            float f = ARMOURY_TECH_LEVEL[n];
            return f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }

    protected static final int getFarm_BuildCost(int n, int n2) {
        float f;
        float f2;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n3 >= CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces()) break;
            int n5 = n4;
            if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(n3)).getLevelOfFarm() > 0) {
                n5 = n4 + CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(n3)).getLevelOfFarm();
            }
            ++n3;
            n4 = n5;
            continue;
            break;
        }
        try {
            f2 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
            f = FARM_BUILD_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
        float f3 = n4;
        float f4 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
        float f5 = CFG.game.getProvince(n2).getDevelopmentLevel();
        float f6 = CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID());
        return (int)((f2 * (f + f3 * 0.00215f) + f4 * ((1.0f - f5) * 0.015f)) * (f6 + 1.0f));
    }

    protected static final int getFarm_BuildMovementCost(int n) {
        try {
            n = FARM_BUILD_MOVEMENT_COST[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getFarm_Construction(int n) {
        try {
            n = FARM_CONSTRUCTION[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final float getFarm_GrowthRateBonus(int n) {
        try {
            float f = FARM_GROWTH_RATE_BONUS[n];
            return f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            float[] fArray = FARM_GROWTH_RATE_BONUS;
            return fArray[fArray.length - 1];
        }
    }

    protected static final int getFarm_MaitenanceCost(int n) {
        try {
            n = FARM_MAINTENANCE_COST[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getFarm_MaxLevel() {
        return FARM_NAMES.length - 1;
    }

    protected static final int getFarm_MaxLevel_CanBuild(int n) {
        float[] fArray;
        for (int i = 0; i < (fArray = FARM_TECHNOLOGY_LEVEL).length; ++i) {
            if (!(fArray[i] > CFG.game.getCiv(n).getTechnologyLevel())) continue;
            return i - 1;
        }
        return BuildingsManager.getFarm_MaxLevel();
    }

    protected static final String getFarm_Name(int n) {
        try {
            String string2 = FARM_NAMES[n];
            return string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            String[] stringArray = FARM_NAMES;
            return stringArray[stringArray.length - 1];
        }
    }

    protected static final float getFarm_TechLevel(int n) {
        try {
            float f = FARM_TECHNOLOGY_LEVEL[n];
            return f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }

    protected static final int getFort_BuildCost(int n, int n2) {
        float f;
        float f2;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n3 >= CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces()) break;
            int n5 = n4;
            if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(n3)).getLevelOfFort() > 0) {
                n5 = n4 + CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(n3)).getLevelOfFort();
            }
            ++n3;
            n4 = n5;
            continue;
            break;
        }
        try {
            f2 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
            f = FORT_BUILD_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
        float f3 = n4;
        float f4 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
        float f5 = CFG.game.getProvince(n2).getDevelopmentLevel();
        float f6 = CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID());
        return (int)((f2 * (f + f3 * 0.004721f) + f4 * ((1.0f - f5) * 0.0275f)) * (f6 + 1.0f));
    }

    protected static final int getFort_BuildMovementCost(int n) {
        try {
            n = FORT_BUILD_MOVEMENT_COST[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getFort_Construction(int n) {
        try {
            n = FORT_CONSTRUCTION[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getFort_DefenseBonus(int n) {
        try {
            n = FORT_DEFENSE_BONUS[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getFort_MaitenanceCost(int n) {
        try {
            n = FORT_MAINTENANCE_COST[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getFort_MaxLevel() {
        return FORT_NAMES.length - 1;
    }

    protected static final int getFort_MaxLevel_CanBuild(int n) {
        float[] fArray;
        for (int i = 0; i < (fArray = FORT_TECH_LEVEL).length; ++i) {
            if (!(fArray[i] > CFG.game.getCiv(n).getTechnologyLevel())) continue;
            return i - 1;
        }
        return BuildingsManager.getFort_MaxLevel();
    }

    protected static final String getFort_Name(int n) {
        try {
            String string2 = FORT_NAMES[n];
            return string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            String[] stringArray = FORT_NAMES;
            return stringArray[stringArray.length - 1];
        }
    }

    protected static final float getFort_TechLevel(int n) {
        try {
            float f = FORT_TECH_LEVEL[n];
            return f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }

    protected static final int getLibrary_BuildCost(int n, int n2) {
        float f;
        float f2;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n3 >= CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces()) break;
            int n5 = n4;
            if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(n3)).getLevelOfLibrary() > 0) {
                n5 = n4 + CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(n3)).getLevelOfLibrary();
            }
            ++n3;
            n4 = n5;
            continue;
            break;
        }
        try {
            f2 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
            f = LIBRARY_BUILD_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
        float f3 = n4;
        float f4 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
        float f5 = CFG.game.getProvince(n2).getDevelopmentLevel();
        float f6 = CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID());
        return (int)((f2 * (f + f3 * 0.00425f) + f4 * ((1.0f - f5) * 0.135f)) * (f6 + 1.0f));
    }

    protected static final int getLibrary_BuildMovementCost(int n) {
        try {
            n = LIBRARY_BUILD_MOVEMENT_COST[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getLibrary_Construction(int n) {
        try {
            n = LIBRARY_CONSTRUCTION[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getLibrary_MaxLevel() {
        return LIBRARY_NAMES.length - 1;
    }

    protected static final int getLibrary_MaxLevel_CanBuild(int n) {
        float[] fArray;
        for (int i = 0; i < (fArray = LIBRARY_TECH_LEVEL).length; ++i) {
            if (!(fArray[i] > CFG.game.getCiv(n).getTechnologyLevel())) continue;
            return i - 1;
        }
        return BuildingsManager.getLibrary_MaxLevel();
    }

    protected static final String getLibrary_Name(int n) {
        try {
            String string2 = LIBRARY_NAMES[n];
            return string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            String[] stringArray = LIBRARY_NAMES;
            return stringArray[stringArray.length - 1];
        }
    }

    protected static final int getLibrary_ResearchPerPopulation(int n) {
        try {
            n = LIBRARY_RESEARCH_PER_POPULATION[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final float getLibrary_TechLevel(int n) {
        try {
            float f = LIBRARY_TECH_LEVEL[n];
            return f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }

    protected static final int getPort_BuildCost(int n, int n2) {
        float f;
        float f2;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n3 >= CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces()) break;
            int n5 = n4;
            if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(n3)).getLevelOfPort() > 0) {
                n5 = n4 + 1;
            }
            ++n3;
            n4 = n5;
            continue;
            break;
        }
        try {
            f2 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
            f = PORT_BUILD_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
        float f3 = n4;
        float f4 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
        float f5 = CFG.game.getProvince(n2).getDevelopmentLevel();
        float f6 = CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID());
        return (int)((f2 * (f + f3 * 0.00325f) + f4 * ((1.0f - f5) * 0.015f)) * (f6 + 1.0f));
    }

    protected static final int getPort_BuildMovementCost(int n) {
        try {
            n = PORT_BUILD_MOVEMENT_COST[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getPort_Construction(int n) {
        try {
            n = PORT_CONSTRUCTION[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final float getPort_IncomeProduction(int n) {
        try {
            float f = PORT_INCOME_PRODUCTION[n];
            return f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return 0.0f;
        }
    }

    protected static final int getPort_MaitenanceCost(int n) {
        try {
            n = PORT_MAINTENANCE_COST[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getPort_MaxLevel() {
        return PORT_NAMES.length - 1;
    }

    protected static final String getPort_Name(int n) {
        try {
            String string2 = PORT_NAMES[n];
            return string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            String[] stringArray = PORT_NAMES;
            return stringArray[stringArray.length - 1];
        }
    }

    protected static final float getPort_TechLevel(int n) {
        try {
            float f = PORT_TECHNOLOGY_LEVEL[n];
            return f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }

    protected static final float getSupply_Bonus(int n) {
        try {
            float f = SUPPLY_BONUS[n];
            return f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            float[] fArray = SUPPLY_BONUS;
            return fArray[fArray.length - 1];
        }
    }

    protected static final int getSupply_BuildCost(int n, int n2) {
        float f;
        float f2;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n3 >= CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces()) break;
            int n5 = n4;
            if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(n3)).getLevelOfSupply() > 0) {
                n5 = n4 + 1;
            }
            ++n3;
            n4 = n5;
            continue;
            break;
        }
        try {
            f2 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
            f = SUPPLY_BUILD_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
        float f3 = n4;
        float f4 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
        float f5 = CFG.game.getProvince(n2).getDevelopmentLevel();
        float f6 = CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID());
        return (int)((f2 * (f + f3 * 0.0115f) + f4 * ((1.0f - f5) * 0.3f)) * (f6 + 1.0f));
    }

    protected static final int getSupply_BuildMovementCost(int n) {
        try {
            n = SUPPLY_BUILD_MOVEMENT_COST[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getSupply_Construction(int n) {
        try {
            n = SUPPLY_CONSTRUCTION[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getSupply_MaxLevel() {
        return SUPPLY_NAMES.length - 1;
    }

    protected static final String getSupply_Name(int n) {
        try {
            String string2 = SUPPLY_NAMES[n];
            return string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            String[] stringArray = SUPPLY_NAMES;
            return stringArray[stringArray.length - 1];
        }
    }

    protected static final float getSupply_TechLevel(int n) {
        try {
            float f = SUPPLY_TECH_LEVEL[n];
            return f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }

    protected static final int getTower_BuildCost(int n, int n2) {
        float f;
        float f2;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n3 >= CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces()) break;
            int n5 = n4;
            if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(n3)).getLevelOfWatchTower() > 0) {
                n5 = n4 + 1;
            }
            ++n3;
            n4 = n5;
            continue;
            break;
        }
        try {
            f2 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
            f = TOWER_BUILD_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
        float f3 = n4;
        float f4 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
        float f5 = CFG.game.getProvince(n2).getDevelopmentLevel();
        float f6 = CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID());
        return (int)((f2 * (f + f3 * 0.005314f) + f4 * ((1.0f - f5) * 0.01f)) * (f6 + 1.0f));
    }

    protected static final int getTower_BuildMovementCost(int n) {
        try {
            n = TOWER_BUILD_MOVEMENT_COST[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getTower_Construction(int n) {
        try {
            n = TOWER_CONSTRUCTION[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getTower_DefenseBonus(int n) {
        try {
            n = TOWER_DEFENSE_BONUS[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getTower_MaitenanceCost(int n) {
        try {
            n = TOWER_MAINTENANCE_COST[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getTower_MaxLevel() {
        return TOWER_NAMES.length - 1;
    }

    protected static final int getTower_MaxLevel_CanBuild(int n) {
        float[] fArray;
        for (int i = 0; i < (fArray = TOWER_TECHNOLOGY_LEVEL).length; ++i) {
            if (!(fArray[i] > CFG.game.getCiv(n).getTechnologyLevel())) continue;
            return i - 1;
        }
        return BuildingsManager.getTower_MaxLevel();
    }

    protected static final String getTower_Name(int n) {
        try {
            String string2 = TOWER_NAMES[n];
            return string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            String[] stringArray = TOWER_NAMES;
            return stringArray[stringArray.length - 1];
        }
    }

    protected static final float getTower_TechLevel(int n) {
        try {
            float f = TOWER_TECHNOLOGY_LEVEL[n];
            return f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }

    protected static final int getWorkshop_BuildCost(int n, int n2) {
        float f;
        float f2;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n3 >= CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getNumOfProvinces()) break;
            int n5 = n4;
            if (CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(n3)).getLevelOfWorkshop() > 0) {
                n5 = n4 + CFG.game.getProvince(CFG.game.getCiv(CFG.game.getProvince(n2).getCivID()).getProvinceID(n3)).getLevelOfWorkshop();
            }
            ++n3;
            n4 = n5;
            continue;
            break;
        }
        try {
            f2 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
            f = WORKSHOP_BUILD_COST[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
        float f3 = n4;
        float f4 = CFG.game.getGameScenarios().getScenario_StartingPopulation();
        float f5 = CFG.game.getProvince(n2).getDevelopmentLevel();
        float f6 = CFG.terrainTypesManager.getBuildCost(CFG.game.getProvince(n2).getTerrainTypeID());
        return (int)((f2 * (f + f3 * 0.002675f) + f4 * ((1.0f - f5) * 0.025f)) * (f6 + 1.0f));
    }

    protected static final int getWorkshop_BuildMovementCost(int n) {
        try {
            n = WORKSHOP_BUILD_MOVEMENT_COST[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getWorkshop_Construction(int n) {
        try {
            n = WORKSHOP_CONSTRUCTION[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final float getWorkshop_IncomeProduction(int n) {
        try {
            float f = WORKSHOP_INCOME_PRODUCTION[n];
            return f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            float[] fArray = WORKSHOP_INCOME_PRODUCTION;
            return fArray[fArray.length - 1];
        }
    }

    protected static final int getWorkshop_MaitenanceCost(int n) {
        try {
            n = WORKSHOP_MAINTENANCE_COST[n];
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0;
        }
    }

    protected static final int getWorkshop_MaxLevel() {
        return WORKSHOP_NAMES.length - 1;
    }

    protected static final int getWorkshop_MaxLevel_CanBuild(int n) {
        float[] fArray;
        for (int i = 0; i < (fArray = WORKSHOP_TECHNOLOGY_LEVEL).length; ++i) {
            if (!(fArray[i] > CFG.game.getCiv(n).getTechnologyLevel())) continue;
            return i - 1;
        }
        return BuildingsManager.getWorkshop_MaxLevel();
    }

    protected static final String getWorkshop_Name(int n) {
        try {
            String string2 = WORKSHOP_NAMES[n];
            return string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            String[] stringArray = WORKSHOP_NAMES;
            return stringArray[stringArray.length - 1];
        }
    }

    protected static final float getWorkshop_TechLevel(int n) {
        try {
            float f = WORKSHOP_TECHNOLOGY_LEVEL[n];
            return f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (CFG.LOGS) {
                CFG.exceptionStack(indexOutOfBoundsException);
            }
            return 0.0f;
        }
    }
}

