/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Ser;
import java.time.ZoneId;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesException;
import java.time.zone.ZoneRulesProvider;
import java.util.Objects;

final class ZoneRegion
extends ZoneId
implements Serializable {
    private static final long serialVersionUID = 8386373296231747096L;
    private final String id;
    private final transient ZoneRules rules;

    static ZoneRegion ofId(String string, boolean bl) {
        ZoneRules zoneRules;
        block2: {
            Objects.requireNonNull(string, "zoneId");
            ZoneRegion.checkName(string);
            zoneRules = null;
            try {
                zoneRules = ZoneRulesProvider.getRules(string, true);
            }
            catch (ZoneRulesException zoneRulesException) {
                if (!bl) break block2;
                throw zoneRulesException;
            }
        }
        return new ZoneRegion(string, zoneRules);
    }

    private static void checkName(String string) {
        int n = string.length();
        if (n < 2) {
            throw new DateTimeException("Invalid ID for region-based ZoneId, invalid format: " + string);
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '/' && i != 0 || c >= '0' && c <= '9' && i != 0 || c == '~' && i != 0 || c == '.' && i != 0 || c == '_' && i != 0 || c == '+' && i != 0 || c == '-' && i != 0) continue;
            throw new DateTimeException("Invalid ID for region-based ZoneId, invalid format: " + string);
        }
    }

    ZoneRegion(String string, ZoneRules zoneRules) {
        this.id = string;
        this.rules = zoneRules;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ZoneRules getRules() {
        return this.rules != null ? this.rules : ZoneRulesProvider.getRules(this.id, false);
    }

    private Object writeReplace() {
        return new Ser(7, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    @Override
    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(7);
        this.writeExternal(dataOutput);
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.id);
    }

    static ZoneId readExternal(DataInput dataInput) throws IOException {
        String string = dataInput.readUTF();
        return ZoneId.of(string, false);
    }
}

