/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;

public abstract class AbstractSelectableChannel
extends SelectableChannel {
    private final SelectorProvider provider;
    private SelectionKey[] keys = null;
    private int keyCount = 0;
    private final Object keyLock = new Object();
    private final Object regLock = new Object();
    boolean blocking = true;

    protected AbstractSelectableChannel(SelectorProvider selectorProvider) {
        this.provider = selectorProvider;
    }

    @Override
    public final SelectorProvider provider() {
        return this.provider;
    }

    private void addKey(SelectionKey selectionKey) {
        assert (Thread.holdsLock(this.keyLock));
        int n = 0;
        if (this.keys != null && this.keyCount < this.keys.length) {
            for (n = 0; n < this.keys.length && this.keys[n] != null; ++n) {
            }
        } else if (this.keys == null) {
            this.keys = new SelectionKey[3];
        } else {
            int n2 = this.keys.length * 2;
            SelectionKey[] selectionKeyArray = new SelectionKey[n2];
            for (n = 0; n < this.keys.length; ++n) {
                selectionKeyArray[n] = this.keys[n];
            }
            this.keys = selectionKeyArray;
            n = this.keyCount;
        }
        this.keys[n] = selectionKey;
        ++this.keyCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelectionKey findKey(Selector selector) {
        Object object = this.keyLock;
        synchronized (object) {
            if (this.keys == null) {
                return null;
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == null || this.keys[i].selector() != selector) continue;
                return this.keys[i];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeKey(SelectionKey selectionKey) {
        Object object = this.keyLock;
        synchronized (object) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] != selectionKey) continue;
                this.keys[i] = null;
                --this.keyCount;
            }
            ((AbstractSelectionKey)selectionKey).invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean haveValidKeys() {
        Object object = this.keyLock;
        synchronized (object) {
            if (this.keyCount == 0) {
                return false;
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == null || !this.keys[i].isValid()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isRegistered() {
        Object object = this.keyLock;
        synchronized (object) {
            return this.keyCount != 0;
        }
    }

    @Override
    public final SelectionKey keyFor(Selector selector) {
        return this.findKey(selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SelectionKey register(Selector selector, int n, Object object) throws ClosedChannelException {
        Object object2 = this.regLock;
        synchronized (object2) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if ((n & ~this.validOps()) != 0) {
                throw new IllegalArgumentException();
            }
            if (this.blocking) {
                throw new IllegalBlockingModeException();
            }
            SelectionKey selectionKey = this.findKey(selector);
            if (selectionKey != null) {
                selectionKey.interestOps(n);
                selectionKey.attach(object);
            }
            if (selectionKey == null) {
                Object object3 = this.keyLock;
                synchronized (object3) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    selectionKey = ((AbstractSelector)selector).register(this, n, object);
                    this.addKey(selectionKey);
                }
            }
            return selectionKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void implCloseChannel() throws IOException {
        this.implCloseSelectableChannel();
        Object object = this.keyLock;
        synchronized (object) {
            int n = this.keys == null ? 0 : this.keys.length;
            for (int i = 0; i < n; ++i) {
                SelectionKey selectionKey = this.keys[i];
                if (selectionKey == null) continue;
                selectionKey.cancel();
            }
        }
    }

    protected abstract void implCloseSelectableChannel() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isBlocking() {
        Object object = this.regLock;
        synchronized (object) {
            return this.blocking;
        }
    }

    @Override
    public final Object blockingLock() {
        return this.regLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SelectableChannel configureBlocking(boolean bl) throws IOException {
        Object object = this.regLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.blocking == bl) {
                return this;
            }
            if (bl && this.haveValidKeys()) {
                throw new IllegalBlockingModeException();
            }
            this.implConfigureBlocking(bl);
            this.blocking = bl;
        }
        return this;
    }

    protected abstract void implConfigureBlocking(boolean var1) throws IOException;
}

