/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Game_Calendar;
import age.of.civilizations2.jakowski.lukasz.HistoryLog;
import age.of.civilizations2.jakowski.lukasz.ImageManager;
import age.of.civilizations2.jakowski.lukasz.Images;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import java.util.ArrayList;
import java.util.List;

class HistoryManager {
    protected static int HISTORY_LIMIT;
    protected static List<String> lHistoryDates;
    protected static List<Integer> lHistoryDatesWidth;

    static {
        lHistoryDates = new ArrayList<String>();
        lHistoryDatesWidth = new ArrayList<Integer>();
        HISTORY_LIMIT = 200;
    }

    protected HistoryManager() {
        int n;
        CFG.timelapseManager.timelapseStatsGD.lHistory = new ArrayList<List<HistoryLog>>();
        this.addNewTurn();
        HistoryLog.ICON_WIDTH = (int)((float)ImageManager.getImage(Images.diplo_war).getWidth() * HistoryLog.getImageScale(Images.diplo_war));
        if (HistoryLog.ICON_WIDTH < (int)((float)ImageManager.getImage(Images.diplo_war).getWidth() * HistoryLog.getImageScale(Images.diplo_truce))) {
            HistoryLog.ICON_WIDTH = (int)((float)ImageManager.getImage(Images.diplo_war).getWidth() * HistoryLog.getImageScale(Images.diplo_truce));
        }
        if (HistoryLog.ICON_WIDTH < (int)((float)ImageManager.getImage(Images.diplo_war).getWidth() * HistoryLog.getImageScale(Images.diplo_alliance))) {
            HistoryLog.ICON_WIDTH = (int)((float)ImageManager.getImage(Images.diplo_war).getWidth() * HistoryLog.getImageScale(Images.diplo_alliance));
        }
        for (n = 0; n < CFG.ideologiesManager.getIdeologiesSize(); ++n) {
            if (HistoryLog.ICON_WIDTH >= (int)((float)CFG.ideologiesManager.getIdeology(n).getiCrownVassalImage().getWidth() * HistoryLog.getImageScale_CrownVassal(n))) continue;
            HistoryLog.ICON_WIDTH = (int)((float)CFG.ideologiesManager.getIdeology(n).getiCrownVassalImage().getWidth() * HistoryLog.getImageScale_CrownVassal(n));
        }
        HistoryLog.ICON_WIDTH += CFG.PADDING * 3;
        n = CFG.isDesktop() ? 200 : 50;
        HISTORY_LIMIT = n;
    }

    protected static final void buildHistoryDates() {
        int n;
        HistoryManager.clearHistoryDates();
        for (n = 1; n < Game_Calendar.TURN_ID; ++n) {
            lHistoryDates.add(Game_Calendar.getDate_ByTurnID(n));
        }
        lHistoryDates.add(Game_Calendar.getCurrentDate());
        int n2 = lHistoryDates.size();
        for (n = 0; n < n2; ++n) {
            GlyphLayout glyphLayout = CFG.glyphLayout;
            BitmapFont bitmapFont = CFG.fontMain;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(lHistoryDates.get(n));
            stringBuilder.append(": ");
            glyphLayout.setText(bitmapFont, stringBuilder.toString());
            lHistoryDatesWidth.add((int)(CFG.glyphLayout.width * 0.7f));
        }
    }

    protected static final void clearHistoryDates() {
        lHistoryDates.clear();
        lHistoryDatesWidth.clear();
    }

    protected final void addHistory(int n, HistoryLog historyLog) {
        CFG.timelapseManager.timelapseStatsGD.lHistory.get(n).add(historyLog);
    }

    protected final void addHistoryLog(HistoryLog historyLog) {
        block5: {
            try {
                CFG.timelapseManager.timelapseStatsGD.lHistory.get(CFG.timelapseManager.timelapseStatsGD.lHistory.size() - 1).add(historyLog);
                if (CFG.menuManager.getVisibleInGame_History()) {
                    CFG.menuManager.rebuildInGame_History();
                }
            }
            catch (NullPointerException nullPointerException) {
                if (CFG.LOGS) {
                    CFG.exceptionStack(nullPointerException);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!CFG.LOGS) break block5;
                CFG.exceptionStack(indexOutOfBoundsException);
            }
        }
    }

    protected final void addNewTurn() {
        ArrayList arrayList = new ArrayList();
        CFG.timelapseManager.timelapseStatsGD.lHistory.add(arrayList);
        if (CFG.timelapseManager.timelapseStatsGD.lHistory.size() > HISTORY_LIMIT) {
            CFG.timelapseManager.timelapseStatsGD.lHistory.remove(0);
        }
    }

    protected final void clearHistory() {
        CFG.timelapseManager.timelapseStatsGD.lHistory.clear();
    }

    protected final HistoryLog getHistory(int n, int n2) {
        return CFG.timelapseManager.timelapseStatsGD.lHistory.get(n).get(n2);
    }

    protected final int getHistorySize() {
        return CFG.timelapseManager.timelapseStatsGD.lHistory.size();
    }

    protected final int getHistoryTurnSize(int n) {
        return CFG.timelapseManager.timelapseStatsGD.lHistory.get(n).size();
    }

    protected final boolean haveHistory() {
        for (int i = 0; i < CFG.timelapseManager.timelapseStatsGD.lHistory.size(); ++i) {
            if (CFG.timelapseManager.timelapseStatsGD.lHistory.get(i).size() <= 0) continue;
            return true;
        }
        return false;
    }

    protected final void updateLanguage() {
        for (int i = 0; i < CFG.timelapseManager.timelapseStatsGD.lHistory.size(); ++i) {
            for (int j = 0; j < CFG.timelapseManager.timelapseStatsGD.lHistory.get(j).size(); ++j) {
                CFG.timelapseManager.timelapseStatsGD.lHistory.get(i).get(j).updateLanguage();
            }
        }
    }
}

