/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Game_Calendar;
import age.of.civilizations2.jakowski.lukasz.PeaceTreaty_Civs;
import age.of.civilizations2.jakowski.lukasz.WarCiv_GameData;
import age.of.civilizations2.jakowski.lukasz.War_Points;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class War_GameData
implements Serializable {
    protected static final float WAR_SCORE_MODIFIER = 0.7f;
    protected static final float WAR_SCORE_MODIFIER2 = 0.2f;
    private static final long serialVersionUID = 0L;
    protected String WAR_TAG;
    protected int iLastFight_InTunrs = 0;
    protected int iLastTurn_ConqueredProvince = 0;
    private int iWarTurnID = 1;
    private List<WarCiv_GameData> lAggressors = new ArrayList<WarCiv_GameData>();
    private List<WarCiv_GameData> lDefenders = new ArrayList<WarCiv_GameData>();
    protected boolean wasAnyAttack = false;

    protected War_GameData(int n, int n2) {
        this.addAggressor(n);
        this.addDefender(n2);
        this.iWarTurnID = Game_Calendar.TURN_ID;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CFG.game.getCiv(n).getCivTag());
        stringBuilder.append(CFG.game.getCiv(n2).getCivTag());
        stringBuilder.append(CFG.extraRandomTag());
        stringBuilder.append(this.iWarTurnID);
        this.WAR_TAG = stringBuilder.toString();
    }

    protected final void addAggressor(int n) {
        int n2;
        for (n2 = 0; n2 < this.getAggressorsSize(); ++n2) {
            if (this.lAggressors.get(n2).getCivID() != n) continue;
            return;
        }
        this.lAggressors.add(new WarCiv_GameData(n));
        for (n2 = 0; n2 < this.getDefendersSize(); ++n2) {
            if (CFG.game.getCivsAtWar(n, this.getDefenderID(n2).getCivID())) continue;
            CFG.game.setCivRelation_OfCivB(n, this.getDefenderID(n2).getCivID(), -100.0f);
            CFG.game.setCivRelation_OfCivB(this.getDefenderID(n2).getCivID(), n, -100.0f);
        }
        this.iLastFight_InTunrs = 0;
        this.iLastTurn_ConqueredProvince = Game_Calendar.TURN_ID;
    }

    protected final void addCasualties(int n, int n2) {
        int n3 = 0;
        this.iLastFight_InTunrs = 0;
        this.wasAnyAttack = true;
        int n4 = 0;
        while (true) {
            if (n4 >= this.getDefendersSize()) break;
            if (this.getDefenderID(n4).getCivID() == n) {
                this.getDefenderID(n4).addCasualties(n2);
                return;
            }
            ++n4;
        }
        for (int i = n3; i < this.getAggressorsSize(); ++i) {
            if (this.getAggressorID(i).getCivID() != n) continue;
            this.getAggressorID(i).addCasualties(n2);
            return;
        }
    }

    protected final void addCivilianEconomicLosses(int n, int n2, int n3) {
        int n4 = 0;
        this.iLastFight_InTunrs = 0;
        int n5 = 0;
        while (true) {
            if (n5 >= this.getDefendersSize()) break;
            if (this.getDefenderID(n5).getCivID() == n) {
                this.getDefenderID(n5).addCivilianDeaths(n2);
                this.getDefenderID(n5).addEconomicLosses(n3);
                return;
            }
            ++n5;
        }
        for (int i = n4; i < this.getAggressorsSize(); ++i) {
            if (this.getAggressorID(i).getCivID() != n) continue;
            this.getAggressorID(i).addCivilianDeaths(n2);
            this.getAggressorID(i).addEconomicLosses(n3);
            return;
        }
    }

    protected final void addConqueredProvinces(int n) {
        this.iLastTurn_ConqueredProvince = Game_Calendar.TURN_ID;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n3 >= this.getDefendersSize()) break;
            if (this.getDefenderID(n3).getCivID() == n) {
                this.getDefenderID(n3).addConqueredProvinces();
                return;
            }
            ++n3;
        }
        for (int i = n2; i < this.getAggressorsSize(); ++i) {
            if (this.getAggressorID(i).getCivID() != n) continue;
            this.getAggressorID(i).addConqueredProvinces();
            return;
        }
    }

    protected final void addDefender(int n) {
        int n2;
        for (n2 = 0; n2 < this.getDefendersSize(); ++n2) {
            if (this.lDefenders.get(n2).getCivID() != n) continue;
            return;
        }
        this.lDefenders.add(new WarCiv_GameData(n));
        for (n2 = 0; n2 < this.getAggressorsSize(); ++n2) {
            if (CFG.game.getCivsAtWar(n, this.getAggressorID(n2).getCivID())) continue;
            CFG.game.setCivRelation_OfCivB(n, this.getAggressorID(n2).getCivID(), -100.0f);
            CFG.game.setCivRelation_OfCivB(this.getAggressorID(n2).getCivID(), n, -100.0f);
        }
        this.iLastFight_InTunrs = 0;
        this.iLastTurn_ConqueredProvince = Game_Calendar.TURN_ID;
    }

    protected final WarCiv_GameData getAggressorID(int n) {
        return this.lAggressors.get(n);
    }

    protected final int getAggressorID_ByCivID(int n) {
        for (int i = 0; i < this.getAggressorsSize(); ++i) {
            if (this.getAggressorID(i).getCivID() != n) continue;
            return i;
        }
        return -1;
    }

    protected final int getAggressorsSize() {
        return this.lAggressors.size();
    }

    protected final PeaceTreaty_Civs getAggressors_ProvincesLost(int n, List<Boolean> list, List<Boolean> object) {
        object = new PeaceTreaty_Civs(this.getAggressorID(n).getCivID());
        for (int i = 0; i < this.getDefendersSize(); ++i) {
            if (!list.get(i).booleanValue()) continue;
            for (int j = 0; j < CFG.game.getCiv(this.getDefenderID(i).getCivID()).getNumOfProvinces(); ++j) {
                if (this.getDefenderID(i).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(i).getCivID()).getProvinceID(j)).getTrueOwnerOfProvince() || this.getAggressorID(n).getCivID() != CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(i).getCivID()).getProvinceID(j)).getTrueOwnerOfProvince()) continue;
                ((PeaceTreaty_Civs)object).lProvincesLost.add(CFG.game.getCiv(this.getDefenderID(i).getCivID()).getProvinceID(j));
            }
        }
        return object;
    }

    protected final int getCasualties_Aggressors() {
        int n = 0;
        for (int i = 0; i < this.getAggressorsSize(); ++i) {
            n = n + this.getAggressorID(i).getCasualties() + this.getAggressorID(i).getCivilianDeaths();
        }
        return n;
    }

    protected final int getCasualties_Defenders() {
        int n = 0;
        for (int i = 0; i < this.getDefendersSize(); ++i) {
            n = n + this.getDefenderID(i).getCasualties() + this.getDefenderID(i).getCivilianDeaths();
        }
        return n;
    }

    protected final WarCiv_GameData getDefenderID(int n) {
        return this.lDefenders.get(n);
    }

    protected final int getDefenderID_ByCivID(int n) {
        for (int i = 0; i < this.getDefendersSize(); ++i) {
            if (this.getDefenderID(i).getCivID() != n) continue;
            return i;
        }
        return -1;
    }

    protected final int getDefendersSize() {
        return this.lDefenders.size();
    }

    protected final PeaceTreaty_Civs getDefenders_ProvincesLost(int n, List<Boolean> object, List<Boolean> list) {
        object = new PeaceTreaty_Civs(this.getDefenderID(n).getCivID());
        for (int i = 0; i < this.getAggressorsSize(); ++i) {
            if (!list.get(i).booleanValue()) continue;
            for (int j = 0; j < CFG.game.getCiv(this.getAggressorID(i).getCivID()).getNumOfProvinces(); ++j) {
                if (this.getAggressorID(i).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(i).getCivID()).getProvinceID(j)).getTrueOwnerOfProvince() || this.getDefenderID(n).getCivID() != CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(i).getCivID()).getProvinceID(j)).getTrueOwnerOfProvince()) continue;
                ((PeaceTreaty_Civs)object).lProvincesLost.add(CFG.game.getCiv(this.getAggressorID(i).getCivID()).getProvinceID(j));
            }
        }
        return object;
    }

    protected final boolean getIsAggressor(int n) {
        for (int i = 0; i < this.getAggressorsSize(); ++i) {
            if (this.getAggressorID(i).getCivID() != n) continue;
            return true;
        }
        return false;
    }

    protected final boolean getIsDefender(int n) {
        for (int i = 0; i < this.getDefendersSize(); ++i) {
            if (this.getDefenderID(i).getCivID() != n) continue;
            return true;
        }
        return false;
    }

    protected final boolean getIsInAggressors(int n) {
        for (int i = 0; i < this.getAggressorsSize(); ++i) {
            if (this.getAggressorID(i).getCivID() != n) continue;
            return true;
        }
        return false;
    }

    protected final boolean getIsInDefenders(int n) {
        for (int i = 0; i < this.getDefendersSize(); ++i) {
            if (this.getDefenderID(i).getCivID() != n) continue;
            return true;
        }
        return false;
    }

    protected final int getParticipation_AggressorID(int n) {
        int n2 = 0;
        for (int i = 0; i < this.getAggressorsSize(); ++i) {
            n2 += this.getAggressorID(i).getCasualties();
        }
        if (n2 == 0) {
            return 100;
        }
        double d = n == 0 ? Math.ceil((float)this.getAggressorID(n).getCasualties() / (float)n2 * 100.0f) : Math.floor((float)this.getAggressorID(n).getCasualties() / (float)n2 * 100.0f);
        return (int)d;
    }

    protected final int getParticipation_DefenderID(int n) {
        int n2 = 0;
        for (int i = 0; i < this.getDefendersSize(); ++i) {
            n2 += this.getDefenderID(i).getCasualties();
        }
        if (n2 == 0) {
            return 100;
        }
        double d = n == 0 ? Math.ceil((float)this.getDefenderID(n).getCasualties() / (float)n2 * 100.0f) : Math.floor((float)this.getDefenderID(n).getCasualties() / (float)n2 * 100.0f);
        return (int)d;
    }

    protected final int getProvinces_Aggressor_Own(int n) {
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < CFG.game.getCiv(this.getAggressorID(n).getCivID()).getNumOfProvinces(); ++n3) {
            n2 = n4;
            if (this.getAggressorID(n).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(n).getCivID()).getProvinceID(n3)).getTrueOwnerOfProvince()) {
                n2 = n4 + 1;
            }
            n4 = n2;
        }
        for (n3 = 0; n3 < this.getDefendersSize(); ++n3) {
            for (int i = 0; i < CFG.game.getCiv(this.getDefenderID(n3).getCivID()).getNumOfProvinces(); ++i) {
                n2 = n4;
                if (this.getAggressorID(n).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(n3).getCivID()).getProvinceID(i)).getTrueOwnerOfProvince()) {
                    n2 = n4 + 1;
                }
                n4 = n2;
            }
        }
        return n4;
    }

    /*
     * Unable to fully structure code
     */
    protected final int getProvinces_Aggressor_OwnTotal(int var1_1) {
        var2_3 = 0;
        for (var3_2 = 0; var3_2 < CFG.game.getCiv(this.getAggressorID(var1_1).getCivID()).getNumOfProvinces(); ++var3_2) {
            if (this.getAggressorID(var1_1).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(var1_1).getCivID()).getProvinceID(var3_2)).getTrueOwnerOfProvince()) {
                while (true) {
                    var4_4 = var2_3 + 1;
                    break;
                }
            } else {
                var5_5 = 0;
                while (true) {
                    var4_4 = var2_3;
                    if (var5_5 >= this.getDefendersSize()) break;
                    if (this.getDefenderID(var5_5).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(var1_1).getCivID()).getProvinceID(var3_2)).getTrueOwnerOfProvince()) ** continue;
                    ++var5_5;
                }
            }
            var2_3 = var4_4;
        }
        return var2_3;
    }

    protected final int getProvinces_Defender_Own(int n) {
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < CFG.game.getCiv(this.getDefenderID(n).getCivID()).getNumOfProvinces(); ++n3) {
            n2 = n4;
            if (this.getDefenderID(n).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(n).getCivID()).getProvinceID(n3)).getTrueOwnerOfProvince()) {
                n2 = n4 + 1;
            }
            n4 = n2;
        }
        for (n2 = 0; n2 < this.getAggressorsSize(); ++n2) {
            for (n3 = 0; n3 < CFG.game.getCiv(this.getAggressorID(n2).getCivID()).getNumOfProvinces(); ++n3) {
                int n5 = n4;
                if (this.getDefenderID(n).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(n2).getCivID()).getProvinceID(n3)).getTrueOwnerOfProvince()) {
                    n5 = n4 + 1;
                }
                n4 = n5;
            }
        }
        return n4;
    }

    /*
     * Unable to fully structure code
     */
    protected final int getProvinces_Defender_OwnTotal(int var1_1) {
        var3_3 = 0;
        for (var2_2 = 0; var2_2 < CFG.game.getCiv(this.getDefenderID(var1_1).getCivID()).getNumOfProvinces(); ++var2_2) {
            if (this.getDefenderID(var1_1).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(var1_1).getCivID()).getProvinceID(var2_2)).getTrueOwnerOfProvince()) {
                while (true) {
                    var4_4 = var3_3 + 1;
                    break;
                }
            } else {
                var5_5 = 0;
                while (true) {
                    var4_4 = var3_3;
                    if (var5_5 >= this.getAggressorsSize()) break;
                    if (this.getAggressorID(var5_5).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(var1_1).getCivID()).getProvinceID(var2_2)).getTrueOwnerOfProvince()) ** continue;
                    ++var5_5;
                }
            }
            var3_3 = var4_4;
        }
        return var3_3;
    }

    protected final int getWarScore() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        for (n5 = 0; n5 < this.getAggressorsSize(); ++n5) {
            n4 = n7;
            n7 = n6;
            n3 = 0;
            n6 = n4;
            for (n4 = n3; n4 < CFG.game.getCiv(this.getAggressorID(n5).getCivID()).getNumOfProvinces(); ++n4) {
                if (this.getAggressorID(n5).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(n5).getCivID()).getProvinceID(n4)).getTrueOwnerOfProvince()) {
                    n3 = n7 + CFG.game.getProvinceValue(CFG.game.getCiv(this.getAggressorID(n5).getCivID()).getProvinceID(n4));
                    n2 = n6;
                } else {
                    n = 0;
                    while (true) {
                        n3 = n7;
                        n2 = n6;
                        if (n >= this.getDefendersSize()) break;
                        if (this.getDefenderID(n).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(n5).getCivID()).getProvinceID(n4)).getTrueOwnerOfProvince()) {
                            n2 = n6 + CFG.game.getProvinceValue(CFG.game.getCiv(this.getAggressorID(n5).getCivID()).getProvinceID(n4));
                            n3 = n7;
                            break;
                        }
                        ++n;
                    }
                }
                n7 = n3;
                n6 = n2;
            }
            n4 = n7;
            n7 = n6;
            n6 = n4;
        }
        n5 = 0;
        n4 = 0;
        for (n3 = 0; n3 < this.getDefendersSize(); ++n3) {
            n2 = n4;
            n4 = n5;
            n = 0;
            n5 = n2;
            for (n2 = n; n2 < CFG.game.getCiv(this.getDefenderID(n3).getCivID()).getNumOfProvinces(); ++n2) {
                int n8;
                if (this.getDefenderID(n3).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(n3).getCivID()).getProvinceID(n2)).getTrueOwnerOfProvince()) {
                    n = n4 + CFG.game.getProvinceValue(CFG.game.getCiv(this.getDefenderID(n3).getCivID()).getProvinceID(n2));
                    n8 = n5;
                } else {
                    int n9 = 0;
                    while (true) {
                        n = n4;
                        n8 = n5;
                        if (n9 >= this.getAggressorsSize()) break;
                        if (this.getAggressorID(n9).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(n3).getCivID()).getProvinceID(n2)).getTrueOwnerOfProvince()) {
                            n8 = n5 + CFG.game.getProvinceValue(CFG.game.getCiv(this.getDefenderID(n3).getCivID()).getProvinceID(n2));
                            n = n4;
                            break;
                        }
                        ++n9;
                    }
                }
                n4 = n;
                n5 = n8;
            }
            n2 = n5;
            n5 = n4;
            n4 = n2;
        }
        n5 = (int)((float)n7 / (float)(n5 + n4 + n7) * 100.0f);
        n6 = (int)((float)n4 / (float)(n6 + n7 + n4) * 100.0f);
        return -n5 + n6;
    }

    protected final int getWarScore_AggressorsInProvinceValue() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < this.getAggressorsSize(); ++n4) {
            for (n3 = 0; n3 < CFG.game.getCiv(this.getAggressorID(n4).getCivID()).getNumOfProvinces(); ++n3) {
                if (this.getAggressorID(n4).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(n4).getCivID()).getProvinceID(n3)).getTrueOwnerOfProvince()) {
                    n2 = n5;
                } else {
                    n = 0;
                    while (true) {
                        n2 = n5;
                        if (n >= this.getDefendersSize()) break;
                        if (this.getDefenderID(n).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(n4).getCivID()).getProvinceID(n3)).getTrueOwnerOfProvince()) {
                            n2 = n5 - CFG.game.getProvinceValue(CFG.game.getCiv(this.getAggressorID(n4).getCivID()).getProvinceID(n3));
                            break;
                        }
                        ++n;
                    }
                }
                n5 = n2;
            }
        }
        for (n4 = 0; n4 < this.getDefendersSize(); ++n4) {
            for (n3 = 0; n3 < CFG.game.getCiv(this.getDefenderID(n4).getCivID()).getNumOfProvinces(); ++n3) {
                if (this.getDefenderID(n4).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(n4).getCivID()).getProvinceID(n3)).getTrueOwnerOfProvince()) {
                    n2 = n5;
                } else {
                    n = 0;
                    while (true) {
                        n2 = n5;
                        if (n >= this.getAggressorsSize()) break;
                        if (this.getAggressorID(n).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(n4).getCivID()).getProvinceID(n3)).getTrueOwnerOfProvince()) {
                            n2 = n5 + CFG.game.getProvinceValue(CFG.game.getCiv(this.getDefenderID(n4).getCivID()).getProvinceID(n3));
                            break;
                        }
                        ++n;
                    }
                }
                n5 = n2;
            }
        }
        return n5;
    }

    protected final int getWarScore_AggressorsInProvinceValue(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < CFG.game.getCiv(this.getAggressorID(n).getCivID()).getNumOfProvinces(); ++n4) {
            if (this.getAggressorID(n).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(n).getCivID()).getProvinceID(n4)).getTrueOwnerOfProvince()) {
                n3 = n5;
            } else {
                n2 = 0;
                while (true) {
                    n3 = n5;
                    if (n2 >= this.getDefendersSize()) break;
                    if (this.getDefenderID(n2).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(n).getCivID()).getProvinceID(n4)).getTrueOwnerOfProvince()) {
                        n3 = n5 + CFG.game.getProvinceValue(CFG.game.getCiv(this.getAggressorID(n).getCivID()).getProvinceID(n4));
                        break;
                    }
                    ++n2;
                }
            }
            n5 = n3;
        }
        for (n4 = 0; n4 < this.getDefendersSize(); ++n4) {
            for (n3 = 0; n3 < CFG.game.getCiv(this.getDefenderID(n4).getCivID()).getNumOfProvinces(); ++n3) {
                if (this.getDefenderID(n4).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(n4).getCivID()).getProvinceID(n3)).getTrueOwnerOfProvince()) {
                    n2 = n5;
                } else {
                    n2 = n5;
                    if (this.getAggressorID(n).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(n4).getCivID()).getProvinceID(n3)).getTrueOwnerOfProvince()) {
                        n2 = n5 - CFG.game.getProvinceValue(CFG.game.getCiv(this.getDefenderID(n4).getCivID()).getProvinceID(n3));
                    }
                }
                n5 = n2;
            }
        }
        return n5;
    }

    protected final int getWarScore_AggressorsInProvinceValue_OnlyPositive(int n, List<Boolean> list, List<Boolean> list2) {
        int n2;
        int n3;
        int n4;
        int n5;
        list2 = new ArrayList<Boolean>();
        int n6 = 0;
        for (n5 = 0; n5 < this.getDefendersSize(); ++n5) {
            list2.add((Boolean)((Object)new War_Points(this.getDefenderID(n5).getCivID())));
        }
        n5 = 0;
        for (n4 = 0; n4 < CFG.game.getCiv(this.getAggressorID(n).getCivID()).getNumOfProvinces(); ++n4) {
            if (this.getAggressorID(n).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(n).getCivID()).getProvinceID(n4)).getTrueOwnerOfProvince()) {
                n3 = n5;
            } else {
                n2 = 0;
                while (true) {
                    n3 = n5;
                    if (n2 >= this.getDefendersSize()) break;
                    if (list.get(n2).booleanValue() && this.getDefenderID(n2).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(n).getCivID()).getProvinceID(n4)).getTrueOwnerOfProvince()) {
                        int n7 = CFG.game.getProvinceValue(CFG.game.getCiv(this.getAggressorID(n).getCivID()).getProvinceID(n4));
                        n3 = n5;
                        if (n7 > n5) {
                            n3 = n7;
                        }
                        ((War_Points)((Object)list2.get(n2))).addPoints(n7);
                        break;
                    }
                    ++n2;
                }
            }
            n5 = n3;
        }
        n3 = 0;
        for (n4 = 0; n4 < CFG.game.getCiv(this.getAggressorID(n).getCivID()).getNumOfProvinces(); ++n4) {
            n2 = n3;
            if (CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(n).getCivID()).getProvinceID(n4)).getTrueOwnerOfProvince() == this.getAggressorID(n).getCivID()) {
                n2 = n3 + 1;
            }
            n3 = n2;
        }
        n2 = n6;
        for (n4 = list2.size() - 1; n4 >= 0; --n4) {
            float f = n3;
            if (!(f >= (float)((War_Points)((Object)list2.get(n4))).getNumOfProvincesTotal() * 2.5f) && ((War_Points)((Object)list2.get(n4))).getNumOfProvincesTotal() > 2 && ((War_Points)((Object)list2.get((int)n4))).iNumOfLostProvinces > 2) {
                float f2;
                block17: {
                    block16: {
                        f2 = 0.7f;
                        if (((War_Points)((Object)list2.get(n4))).getNumOfProvincesTotal() != 3) break block16;
                        f2 = f = (1.0f - Math.min((float)this.getDefenderID(n4).getConqueredProvinces() / (float)Math.max(this.getAggressorID(n).getConqueredProvinces(), 1), 1.0f)) * 0.3f + 0.7f;
                    }
                    if (n3 >= ((War_Points)((Object)list2.get(n4))).getNumOfProvincesTotal()) break block17;
                    f2 = f = (float)(((War_Points)((Object)list2.get((int)n4))).iNumOfLostProvinces / ((War_Points)((Object)list2.get(n4))).getNumOfProvincesTotal()) * 0.1f + 0.2f + (1.0f - f / (float)((War_Points)((Object)list2.get(n4))).getNumOfProvincesTotal()) * 0.2f + (1.0f - Math.min((float)this.getDefenderID(n4).getConqueredProvinces() / (float)Math.max(this.getAggressorID(n).getConqueredProvinces(), 1), 1.0f)) * 0.35f;
                }
                try {
                    float f3 = ((War_Points)((Object)list2.get((int)n4))).iNumOfLostProvinces / ((War_Points)((Object)list2.get(n4))).getNumOfProvincesTotal();
                    f = Math.min((float)this.getDefenderID(n4).getConqueredProvinces() / (float)Math.max(this.getAggressorID(n).getConqueredProvinces(), 1), 1.0f);
                    f2 = f3 * 0.1f + 0.2f + (1.0f - f) * 0.35f;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    CFG.exceptionStack(illegalArgumentException);
                }
                n6 = (int)Math.max(Math.ceil((float)((War_Points)((Object)list2.get((int)n4))).iPoints * f2), (double)((War_Points)((Object)list2.get((int)n4))).iMinScore);
            } else {
                n6 = ((War_Points)((Object)list2.get((int)n4))).iPoints;
            }
            n2 += n6;
        }
        return Math.max(n2, n5);
    }

    protected final int getWarScore_DefendersInProvinceValue() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < this.getAggressorsSize(); ++n4) {
            for (n3 = 0; n3 < CFG.game.getCiv(this.getAggressorID(n4).getCivID()).getNumOfProvinces(); ++n3) {
                if (this.getAggressorID(n4).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(n4).getCivID()).getProvinceID(n3)).getTrueOwnerOfProvince()) {
                    n2 = n5;
                } else {
                    n = 0;
                    while (true) {
                        n2 = n5;
                        if (n >= this.getDefendersSize()) break;
                        if (this.getDefenderID(n).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(n4).getCivID()).getProvinceID(n3)).getTrueOwnerOfProvince()) {
                            n2 = n5 + CFG.game.getProvinceValue(CFG.game.getCiv(this.getAggressorID(n4).getCivID()).getProvinceID(n3));
                            break;
                        }
                        ++n;
                    }
                }
                n5 = n2;
            }
        }
        for (n4 = 0; n4 < this.getDefendersSize(); ++n4) {
            for (n3 = 0; n3 < CFG.game.getCiv(this.getDefenderID(n4).getCivID()).getNumOfProvinces(); ++n3) {
                if (this.getDefenderID(n4).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(n4).getCivID()).getProvinceID(n3)).getTrueOwnerOfProvince()) {
                    n2 = n5;
                } else {
                    n = 0;
                    while (true) {
                        n2 = n5;
                        if (n >= this.getAggressorsSize()) break;
                        if (this.getAggressorID(n).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(n4).getCivID()).getProvinceID(n3)).getTrueOwnerOfProvince()) {
                            n2 = n5 - CFG.game.getProvinceValue(CFG.game.getCiv(this.getDefenderID(n4).getCivID()).getProvinceID(n3));
                            break;
                        }
                        ++n;
                    }
                }
                n5 = n2;
            }
        }
        return n5;
    }

    protected final int getWarScore_DefendersInProvinceValue(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < this.getAggressorsSize(); ++n4) {
            for (n3 = 0; n3 < CFG.game.getCiv(this.getAggressorID(n4).getCivID()).getNumOfProvinces(); ++n3) {
                if (this.getAggressorID(n4).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(n4).getCivID()).getProvinceID(n3)).getTrueOwnerOfProvince()) {
                    n2 = n5;
                } else {
                    n2 = n5;
                    if (this.getDefenderID(n).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getAggressorID(n4).getCivID()).getProvinceID(n3)).getTrueOwnerOfProvince()) {
                        n2 = n5 - CFG.game.getProvinceValue(CFG.game.getCiv(this.getAggressorID(n4).getCivID()).getProvinceID(n3));
                    }
                }
                n5 = n2;
            }
        }
        for (n4 = 0; n4 < CFG.game.getCiv(this.getDefenderID(n).getCivID()).getNumOfProvinces(); ++n4) {
            if (this.getDefenderID(n).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(n).getCivID()).getProvinceID(n4)).getTrueOwnerOfProvince()) {
                n2 = n5;
            } else {
                n3 = 0;
                while (true) {
                    n2 = n5;
                    if (n3 >= this.getAggressorsSize()) break;
                    if (this.getAggressorID(n3).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(n).getCivID()).getProvinceID(n4)).getTrueOwnerOfProvince()) {
                        n2 = n5 + CFG.game.getProvinceValue(CFG.game.getCiv(this.getDefenderID(n).getCivID()).getProvinceID(n4));
                        break;
                    }
                    ++n3;
                }
            }
            n5 = n2;
        }
        return n5;
    }

    protected final int getWarScore_DefendersInProvinceValue_OnlyPositive(int n, List<Boolean> list, List<Boolean> list2) {
        int n2;
        int n3;
        int n4;
        int n5;
        list = new ArrayList<Boolean>();
        int n6 = 0;
        for (n5 = 0; n5 < this.getAggressorsSize(); ++n5) {
            list.add((Boolean)((Object)new War_Points(this.getAggressorID(n5).getCivID())));
        }
        n5 = 0;
        for (n4 = 0; n4 < CFG.game.getCiv(this.getDefenderID(n).getCivID()).getNumOfProvinces(); ++n4) {
            if (this.getDefenderID(n).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(n).getCivID()).getProvinceID(n4)).getTrueOwnerOfProvince()) {
                n3 = n5;
            } else {
                n2 = 0;
                while (true) {
                    n3 = n5;
                    if (n2 >= this.getAggressorsSize()) break;
                    if (list2.get(n2).booleanValue() && this.getAggressorID(n2).getCivID() == CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(n).getCivID()).getProvinceID(n4)).getTrueOwnerOfProvince()) {
                        int n7 = CFG.game.getProvinceValue(CFG.game.getCiv(this.getDefenderID(n).getCivID()).getProvinceID(n4));
                        n3 = n5;
                        if (n7 > n5) {
                            n3 = n7;
                        }
                        ((War_Points)((Object)list.get(n2))).addPoints(n7);
                        break;
                    }
                    ++n2;
                }
            }
            n5 = n3;
        }
        n3 = 0;
        for (n4 = 0; n4 < CFG.game.getCiv(this.getDefenderID(n).getCivID()).getNumOfProvinces(); ++n4) {
            n2 = n3;
            if (CFG.game.getProvince(CFG.game.getCiv(this.getDefenderID(n).getCivID()).getProvinceID(n4)).getTrueOwnerOfProvince() == this.getDefenderID(n).getCivID()) {
                n2 = n3 + 1;
            }
            n3 = n2;
        }
        n2 = n6;
        for (n4 = list.size() - 1; n4 >= 0; --n4) {
            float f = n3;
            if (!(f >= (float)((War_Points)((Object)list.get(n4))).getNumOfProvincesTotal() * 2.5f) && ((War_Points)((Object)list.get(n4))).getNumOfProvincesTotal() > 2 && ((War_Points)((Object)list.get((int)n4))).iNumOfLostProvinces > 2) {
                float f2;
                block17: {
                    block16: {
                        f2 = 0.7f;
                        if (((War_Points)((Object)list.get(n4))).getNumOfProvincesTotal() != 3) break block16;
                        f2 = f = (1.0f - Math.min((float)this.getAggressorID(n4).getConqueredProvinces() / (float)Math.max(this.getDefenderID(n).getConqueredProvinces(), 1), 1.0f)) * 0.3f + 0.7f;
                    }
                    if (n3 >= ((War_Points)((Object)list.get(n4))).getNumOfProvincesTotal()) break block17;
                    f2 = f = (float)(((War_Points)((Object)list.get((int)n4))).iNumOfLostProvinces / ((War_Points)((Object)list.get(n4))).getNumOfProvincesTotal()) * 0.1f + 0.2f + (1.0f - f / (float)((War_Points)((Object)list.get(n4))).getNumOfProvincesTotal()) * 0.2f + (1.0f - Math.min((float)this.getAggressorID(n4).getConqueredProvinces() / (float)Math.max(this.getDefenderID(n).getConqueredProvinces(), 1), 1.0f)) * 0.35f;
                }
                try {
                    f = ((War_Points)((Object)list.get((int)n4))).iNumOfLostProvinces / ((War_Points)((Object)list.get(n4))).getNumOfProvincesTotal();
                    float f3 = Math.min((float)this.getAggressorID(n4).getConqueredProvinces() / (float)Math.max(this.getDefenderID(n).getConqueredProvinces(), 1), 1.0f);
                    f2 = f * 0.1f + 0.2f + (1.0f - f3) * 0.35f;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    CFG.exceptionStack(illegalArgumentException);
                }
                n6 = (int)Math.max(Math.ceil((float)((War_Points)((Object)list.get((int)n4))).iPoints * f2), (double)((War_Points)((Object)list.get((int)n4))).iMinScore);
            } else {
                n6 = ((War_Points)((Object)list.get((int)n4))).iPoints;
            }
            n2 += n6;
        }
        return Math.max(n2, n5);
    }

    protected final int getWarScore_PeaceTreaty() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        for (n5 = 0; n5 < CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Aggressors.size(); ++n5) {
            n4 = n6;
            n3 = 0;
            n6 = n7;
            n7 = n4;
            for (n4 = n3; n4 < CFG.game.getCiv(CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Aggressors.get((int)n5).iCivID).getNumOfProvinces(); ++n4) {
                if (CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Aggressors.get((int)n5).iCivID == CFG.game.getProvince(CFG.game.getCiv(CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Aggressors.get((int)n5).iCivID).getProvinceID(n4)).getTrueOwnerOfProvince()) {
                    n3 = n7 + CFG.game.getProvinceValue(CFG.game.getCiv(CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Aggressors.get((int)n5).iCivID).getProvinceID(n4));
                    n2 = n6;
                } else {
                    n = 0;
                    while (true) {
                        n3 = n7;
                        n2 = n6;
                        if (n >= CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Defenders.size()) break;
                        if (CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Defenders.get((int)n).iCivID == CFG.game.getProvince(CFG.game.getCiv(CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Aggressors.get((int)n5).iCivID).getProvinceID(n4)).getTrueOwnerOfProvince()) {
                            n2 = n6 + CFG.game.getProvinceValue(CFG.game.getCiv(CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Aggressors.get((int)n5).iCivID).getProvinceID(n4));
                            n3 = n7;
                            break;
                        }
                        ++n;
                    }
                }
                n7 = n3;
                n6 = n2;
            }
            n4 = n6;
            n6 = n7;
            n7 = n4;
        }
        n5 = 0;
        n4 = 0;
        for (n3 = 0; n3 < CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Defenders.size(); ++n3) {
            n2 = n5;
            n = 0;
            n5 = n4;
            n4 = n2;
            for (n2 = n; n2 < CFG.game.getCiv(CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Defenders.get((int)n3).iCivID).getNumOfProvinces(); ++n2) {
                int n8;
                if (CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Defenders.get((int)n3).iCivID == CFG.game.getProvince(CFG.game.getCiv(CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Defenders.get((int)n3).iCivID).getProvinceID(n2)).getTrueOwnerOfProvince()) {
                    n = n4 + CFG.game.getProvinceValue(CFG.game.getCiv(CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Defenders.get((int)n3).iCivID).getProvinceID(n2));
                    n8 = n5;
                } else {
                    int n9 = 0;
                    while (true) {
                        n = n4;
                        n8 = n5;
                        if (n9 >= CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Aggressors.size()) break;
                        if (CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Aggressors.get((int)n9).iCivID == CFG.game.getProvince(CFG.game.getCiv(CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Defenders.get((int)n3).iCivID).getProvinceID(n2)).getTrueOwnerOfProvince()) {
                            n8 = n5 + CFG.game.getProvinceValue(CFG.game.getCiv(CFG.peaceTreatyData.peaceTreatyGameData.lCivsData_Defenders.get((int)n3).iCivID).getProvinceID(n2));
                            n = n4;
                            break;
                        }
                        ++n9;
                    }
                }
                n4 = n;
                n5 = n8;
            }
            n2 = n4;
            n4 = n5;
            n5 = n2;
        }
        n5 = (int)((float)n7 / (float)(n5 + n4 + n7) * 100.0f);
        n6 = (int)((float)n4 / (float)(n6 + n7 + n4) * 100.0f);
        return -n5 + n6;
    }

    protected final int getWarTurnID() {
        return this.iWarTurnID;
    }

    protected final void removeAggressor(int n) {
        for (int i = 0; i < this.getAggressorsSize(); ++i) {
            if (this.lAggressors.get(i).getCivID() != n) continue;
            this.lAggressors.remove(i);
            return;
        }
    }

    protected final void removeDefender(int n) {
        for (int i = 0; i < this.getDefendersSize(); ++i) {
            if (this.lDefenders.get(i).getCivID() != n) continue;
            this.lDefenders.remove(i);
            return;
        }
    }

    protected final void setWarTurnID(int n) {
        this.iWarTurnID = n;
    }

    protected final void updateAfterUnion(int n, int n2) {
        if (this.getIsAggressor(n) && this.getIsAggressor(n2)) {
            int n3 = this.getAggressorID_ByCivID(n);
            n = this.getAggressorID_ByCivID(n2);
            if (n3 >= 0 && n >= 0) {
                this.getAggressorID(n3).addCivilianDeaths(this.getAggressorID(n).getCivilianDeaths());
                this.getAggressorID(n3).addCasualties(this.getAggressorID(n).getCasualties());
                this.getAggressorID(n3).addEconomicLosses(this.getAggressorID(n).getEconomicLosses());
                this.removeAggressor(n2);
            }
        } else if (this.getIsDefender(n) && this.getIsDefender(n2)) {
            n = this.getDefenderID_ByCivID(n);
            int n4 = this.getDefenderID_ByCivID(n2);
            if (n >= 0 && n4 >= 0) {
                this.getDefenderID(n).addCivilianDeaths(this.getDefenderID(n4).getCivilianDeaths());
                this.getDefenderID(n).addCasualties(this.getDefenderID(n4).getCasualties());
                this.getDefenderID(n).addEconomicLosses(this.getDefenderID(n4).getEconomicLosses());
                this.removeDefender(n2);
            }
        } else if (this.getIsAggressor(n2) && !this.getIsDefender(n)) {
            if ((n2 = this.getAggressorID_ByCivID(n2)) >= 0) {
                this.getAggressorID(n2).setCivID(n);
            }
        } else if (this.getIsDefender(n2) && !this.getIsAggressor(n) && (n2 = this.getDefenderID_ByCivID(n2)) >= 0) {
            this.getDefenderID(n2).setCivID(n);
        }
    }
}

