/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.Age;
import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Game_Calendar;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import java.util.ArrayList;
import java.util.List;

class Game_Ages {
    private int iAgesSize;
    private List<Age> lAges;
    private String sBC;

    protected Game_Ages() {
        this.loadAges();
    }

    protected final Age getAge(int n) {
        return this.lAges.get(n);
    }

    protected final int getAgeOfYear(int n) {
        for (int i = 0; i < this.lAges.size() - 1; ++i) {
            if (this.lAges.get(i).getBeginningYear() > n || this.lAges.get(i).getEndYear() < n) continue;
            return i;
        }
        return this.lAges.size() - 1;
    }

    protected final float getAge_AdministrationCost_Distance(int n) {
        return this.lAges.get((int)n).EXPENSES_ADMINSTRATION_DISTANCE;
    }

    protected final float getAge_DevelopmentLevel_Increase(int n) {
        return this.lAges.get((int)n).DEVELOPMENT_LEVEL_INCREASE;
    }

    protected final float getAge_DiseaseChance(int n) {
        return this.lAges.get((int)n).DISEASE_CHANCE;
    }

    protected final float getAge_DistanceDiplomacy(int n) {
        return this.lAges.get((int)n).DIPLOMACY_ALLIANCE_PROPOSAL_NAGATIVE_DISTANCE;
    }

    protected final float getAge_Economy_GrowthRate(int n) {
        return this.lAges.get(n).getEconomyGrowthRate();
    }

    protected final float getAge_FogOfWarDiscovery_MetProvinces(int n) {
        return this.lAges.get((int)n).FOG_OF_WAR_DISCOVERY_MET_PROVINCES;
    }

    protected final float getAge_IncomeProduction_Base(int n) {
        return this.lAges.get((int)n).BASE_INCOME_PRODUCTION;
    }

    protected final float getAge_IncomeProduction_PerDevelopment(int n) {
        return this.lAges.get((int)n).INCOME_PRODUCTIONN_PER_DEVELOPMENT_MODIFIER;
    }

    protected final float getAge_IncomeTaxation_Base(int n) {
        return this.lAges.get((int)n).BASE_INCOME_TAXATION;
    }

    protected final float getAge_IncomeTaxation_PerTechnology(int n) {
        return this.lAges.get((int)n).INCOME_TAXATION_PER_TECHNOLOGY_MODIFIER;
    }

    protected final float getAge_MilitaryUpkeep(int n) {
        return this.lAges.get((int)n).BASE_MILITARY_UPKEEP;
    }

    protected final float getAge_MovementPointsModifier(int n) {
        return this.lAges.get((int)n).MOVEMENT_POINTS_MODIFIER;
    }

    protected final float getAge_Population_GrowthRate(int n) {
        return this.lAges.get(n).getPopulationGrowthRate();
    }

    protected final float getAge_RevolutionaryRiskModifier(int n) {
        return this.lAges.get((int)n).REVOLUTIONARY_RISK_MODIFIER;
    }

    protected final float getAge_StartingDevelopment(int n) {
        return this.lAges.get((int)n).GAME_STARTING_DEVELOPMENT;
    }

    protected final int getAge_StartingDiplomacyPoints(int n) {
        return this.lAges.get((int)n).BASE_DIPLOMACY_POINTS;
    }

    protected final int getAge_StartingMovementPoints(int n) {
        return this.lAges.get((int)n).BASE_MOVEMENT_POINTS;
    }

    protected final float getAge_TreasuryModifier(int n) {
        return this.lAges.get((int)n).INCOME_TAXATION_MODIFIER;
    }

    protected final float getAge_TreasuryModifier_Administration(int n) {
        return this.lAges.get((int)n).EXPENSES_ADMINSTRATION_MODIFIER;
    }

    protected final float getAge_TreasuryModifier_MilitaryUpkeep(int n) {
        return this.lAges.get((int)n).EXPENSES_MILITARY_UPKEEP_MODIFIER;
    }

    protected final float getAge_TreasuryModifier_Production(int n) {
        return this.lAges.get((int)n).INCOME_PRODUCTION_MODIFIER;
    }

    protected final int getAge_TurnDays(int n) {
        return (int)((float)this.lAges.get((int)n).GAME_DAYS_PER_TURN * Game_Calendar.GAME_SPEED);
    }

    protected final int getAgesSize() {
        return this.iAgesSize;
    }

    protected final String getBC() {
        return this.sBC;
    }

    protected final String getYear(int n) {
        StringBuilder stringBuilder;
        if (n < 0) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("");
            stringBuilder.append(-n);
            stringBuilder.append(" ");
            stringBuilder.append(this.getBC());
        } else {
            stringBuilder = new StringBuilder();
            stringBuilder.append("");
            stringBuilder.append(n);
        }
        return stringBuilder.toString();
    }

    protected final void loadAges() {
        this.lAges = new ArrayList<Age>();
        try {
            Object object = Gdx.files.internal("game/Ages.json").readString();
            Object object2 = new Json();
            ((Json)object2).setElementType(ConfigAgesData.class, "Age", Data_Ages.class);
            new ConfigAgesData();
            for (Data_Ages data_Ages : ((Json)object2).fromJson(ConfigAgesData.class, (String)object).Age) {
                List<Age> list = this.lAges;
                object = new Age(data_Ages.Name, data_Ages.AGE_BeginningYear, data_Ages.AGE_EndYear, data_Ages.POPULATION_GROWTH, data_Ages.ECONOMY_GROWTH, data_Ages.FOG_OF_WAR_DISCOVERY_MET_PROVINCES, data_Ages.DEVELOPMENT_LEVEL_INCREASE, data_Ages.INCOME_TAXATION_MODIFIER, data_Ages.INCOME_PRODUCTION_MODIFIER, data_Ages.EXPENSES_ADMINSTRATION_MODIFIER, data_Ages.EXPENSES_MILITARY_UPKEEP_MODIFIER, data_Ages.BASE_MOVEMENT_POINTS, data_Ages.MOVEMENT_POINTS_MODIFIER, data_Ages.BASE_DIPLOMACY_POINTS, data_Ages.EXPENSES_ADMINSTRATION_DISTANCE, data_Ages.DIPLOMACY_ALLIANCE_PROPOSAL_NAGATIVE_DISTANCE, data_Ages.BASE_INCOME_TAXATION, data_Ages.INCOME_TAXATION_PER_TECHNOLOGY_MODIFIER, data_Ages.BASE_MILITARY_UPKEEP, data_Ages.GAME_STARTING_DEVELOPMENT, data_Ages.GAME_DAYS_PER_TURN, data_Ages.BASE_INCOME_PRODUCTION, data_Ages.INCOME_PRODUCTIONN_PER_DEVELOPMENT_MODIFIER, data_Ages.REVOLUTIONARY_RISK_MODIFIER, data_Ages.DISEASE_CHANCE, data_Ages.COLONIZATION_COST, data_Ages.COLONIZE_COST_MOVEMENT_POINTS, data_Ages.COLONIZE_COST_DIPLOMACY_POINTS);
                list.add((Age)object);
            }
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            CFG.exceptionStack(gdxRuntimeException);
            this.lAges.add(new Age("AgeofCivilizations", -5000, -301, 0.3f, 0.2f));
            this.lAges.add(new Age("AgeofExpansion", -300, 499, 0.35f, 0.22f));
            this.lAges.add(new Age("AgeofDarkness", 500, 1065, 0.4f, 0.22f));
            this.lAges.add(new Age("AgeofFeudalism", 1066, 1491, 0.45f, 0.22f));
            this.lAges.add(new Age("AgeofDiscovery", 1492, 1749, 0.5f, 0.22f));
            this.lAges.add(new Age("AgeofRevolution", 1750, 1835, 0.55f, 0.22f));
            this.lAges.add(new Age("AgeofIndustrialisation", 1836, 1860, 0.6f, 0.22f));
            this.lAges.add(new Age("AgeofImperialism", 1861, 1918, 0.65f, 0.22f));
            this.lAges.add(new Age("AgeofConflict", 1919, 1946, 0.7f, 0.22f));
            this.lAges.add(new Age("AgeofBrinkmanship", 1947, 1990, 0.75f, 0.22f));
            this.lAges.add(new Age("AgeofInformation", 1991, 2049, 0.8f, 0.22f));
            this.lAges.add(new Age("AgeofTomorrow", 2050, 5000, 0.95f, 1.0f));
        }
        this.sBC = CFG.langManager.get("BeforeChrist");
        this.iAgesSize = this.lAges.size();
        for (int i = 0; i < this.iAgesSize; ++i) {
            this.lAges.get(i).setName(CFG.langManager.get(this.lAges.get(i).getName()));
        }
    }

    protected final void updateLanguage() {
        this.loadAges();
    }

    protected static class ConfigAgesData {
        protected ArrayList Age;
        protected String Age_of_Civilizations;

        protected ConfigAgesData() {
        }
    }

    protected static class Data_Ages {
        protected int AGE_BeginningYear;
        protected int AGE_EndYear;
        protected int BASE_DIPLOMACY_POINTS;
        protected float BASE_INCOME_PRODUCTION;
        protected float BASE_INCOME_TAXATION;
        protected float BASE_MILITARY_UPKEEP;
        protected int BASE_MOVEMENT_POINTS;
        protected float COLONIZATION_COST;
        protected int COLONIZE_COST_DIPLOMACY_POINTS;
        protected int COLONIZE_COST_MOVEMENT_POINTS;
        protected float DEVELOPMENT_LEVEL_INCREASE;
        protected int DIPLOMACY_ALLIANCE_PROPOSAL_NAGATIVE_DISTANCE;
        protected float DISEASE_CHANCE;
        protected float ECONOMY_GROWTH;
        protected float EXPENSES_ADMINSTRATION_DISTANCE;
        protected float EXPENSES_ADMINSTRATION_MODIFIER;
        protected float EXPENSES_MILITARY_UPKEEP_MODIFIER;
        protected float FOG_OF_WAR_DISCOVERY_MET_PROVINCES;
        protected int GAME_DAYS_PER_TURN;
        protected float GAME_STARTING_DEVELOPMENT;
        protected float INCOME_PRODUCTIONN_PER_DEVELOPMENT_MODIFIER;
        protected float INCOME_PRODUCTION_MODIFIER;
        protected float INCOME_TAXATION_MODIFIER;
        protected float INCOME_TAXATION_PER_TECHNOLOGY_MODIFIER;
        protected float MOVEMENT_POINTS_MODIFIER;
        protected String Name;
        protected float POPULATION_GROWTH;
        protected float REVOLUTIONARY_RISK_MODIFIER;

        protected Data_Ages() {
        }
    }
}

