/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.ImageManager;
import age.of.civilizations2.jakowski.lukasz.Images;
import age.of.civilizations2.jakowski.lukasz.MenuElement;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;

class Button
extends MenuElement {
    protected TypeOfButton typeOfButton;
    private Checkbox oCheckbox;
    protected String sText = null;
    protected int iTextWidth = -1;
    protected int iTextHeight;
    protected int iTextPositionX;
    protected TextPosition textPosition;
    protected boolean checkbox = false;
    private boolean checkboxState = false;

    Button() {
    }

    protected final void init(String sText, int iTextPositionX, int iPosX, int iPosY, int iWidth, int iHeight, boolean isClickable, boolean isVisible, boolean checkbox, boolean checkboxState) {
        this.init(sText, iTextPositionX, iPosX, iPosY, iWidth, iHeight, isClickable, isVisible, checkbox, checkboxState, null);
    }

    protected final void init(String sText, int nTextPositionX, int iPosX, int iPosY, int iWidth, int iHeight, boolean isClickable, boolean isVisible, boolean checkbox, boolean checkboxState, TypeOfButton typeOfButton) {
        this.typeOfElement = MenuElement.TypeOfElement.BUTTON;
        this.setPosX(iPosX);
        this.setPosY(iPosY);
        this.setWidth(iWidth);
        this.setHeight(iHeight);
        this.setText(sText);
        this.iTextPositionX = nTextPositionX;
        this.textPosition = nTextPositionX < 0 ? new TextPosition(){

            @Override
            public int getTextPosition() {
                return Button.this.getWidth() / 2 - Button.this.getTextWidth() / 2;
            }
        } : new TextPosition(){

            @Override
            public int getTextPosition() {
                return Button.this.iTextPositionX;
            }
        };
        this.checkbox = checkbox;
        this.checkboxState = checkboxState;
        this.oCheckbox = this.buildCheckbox();
        this.setClickable(isClickable);
        this.setVisible(isVisible);
        this.typeOfButton = typeOfButton;
    }

    @Override
    protected final void draw(SpriteBatch oSB, int iTranslateX, int iTranslateY, boolean isActive, boolean scrollableY) {
        if (this.getClickable()) {
            this.drawButtonBG(oSB, iTranslateX, iTranslateY, isActive);
        } else {
            oSB.setColor(1.0f, 1.0f, 1.0f, 0.45f);
            this.drawButtonBG(oSB, iTranslateX, iTranslateY, isActive);
            oSB.setColor(Color.WHITE);
        }
        this.oCheckbox.drawCheckBox(oSB, iTranslateX, iTranslateY, scrollableY);
        this.drawText(oSB, iTranslateX, iTranslateY, isActive);
    }

    protected Checkbox buildCheckbox() {
        if (this.checkbox) {
            return new Checkbox(){

                @Override
                public void drawCheckBox(SpriteBatch oSB, int iTranslateX, int iTranslateY, boolean scrollableY) {
                    if (Button.this.getCheckboxState()) {
                        oSB.setColor(new Color(0.55f, 0.8f, 0.0f, 0.25f));
                    } else {
                        oSB.setColor(new Color(0.8f, 0.137f, 0.0f, 0.25f));
                    }
                    ImageManager.getImage(Images.slider_gradient).draw(oSB, Button.this.getPosX() + iTranslateX, Button.this.getPosY() - ImageManager.getImage(Images.slider_gradient).getHeight() + 1 + iTranslateY, Button.this.getWidth() / 4, Button.this.getHeight() - 2, false, false);
                    oSB.setColor(new Color(0.0f, 0.0f, 0.0f, 0.3f));
                    ImageManager.getImage(Images.gradient).draw(oSB, Button.this.getPosX() + iTranslateX, Button.this.getPosY() - ImageManager.getImage(Images.gradient).getHeight() + 1 + iTranslateY, Button.this.getWidth(), Button.this.getHeight() / 4, false, false);
                    ImageManager.getImage(Images.gradient).draw(oSB, Button.this.getPosX() + iTranslateX, Button.this.getPosY() - ImageManager.getImage(Images.gradient).getHeight() + Button.this.getHeight() - 1 + iTranslateY - Button.this.getHeight() / 4, Button.this.getWidth(), Button.this.getHeight() / 4, false, true);
                    oSB.setColor(Color.WHITE);
                }
            };
        }
        return new Checkbox(){

            @Override
            public void drawCheckBox(SpriteBatch oSB, int iTranslateX, int iTranslateY, boolean scrollableY) {
            }
        };
    }

    protected void drawButtonBG(SpriteBatch oSB, int iTranslateX, int iTranslateY, boolean isActive) {
    }

    protected void drawText(SpriteBatch oSB, int iTranslateX, int iTranslateY, boolean isActive) {
        if (isActive) {
            CFG.drawText(oSB, this.getTextToDraw(), this.getPosX() + this.textPosition.getTextPosition() + iTranslateX, this.getPosY() + this.getHeight() / 2 - this.iTextHeight / 2 + iTranslateY, this.getColor(isActive));
        } else {
            CFG.drawTextWithShadow(oSB, this.getTextToDraw(), this.getPosX() + this.textPosition.getTextPosition() + iTranslateX, this.getPosY() + this.getHeight() / 2 - this.iTextHeight / 2 + iTranslateY, this.getColor(isActive));
        }
    }

    protected Color getColor(boolean isActive) {
        return isActive ? CFG.COLOR_BUTTON_GAME_TEXT_ACTIVE : (this.getClickable() ? new Color(0.38f, 0.38f, 0.38f, 1.0f) : new Color(0.49f, 0.49f, 0.49f, 0.5f));
    }

    @Override
    protected String getText() {
        return this.sText;
    }

    @Override
    protected String getTextToDraw() {
        return this.sText;
    }

    @Override
    public void setText(String sText) {
        block8: {
            this.sText = sText;
            try {
                if (sText != null) {
                    CFG.glyphLayout.setText(CFG.fontMain, this.getText());
                    this.iTextWidth = (int)CFG.glyphLayout.width;
                    this.iTextHeight = (int)CFG.glyphLayout.height;
                } else {
                    this.iTextHeight = 0;
                    this.iTextWidth = 0;
                }
            }
            catch (IndexOutOfBoundsException ex) {
                if (CFG.LOGS) {
                    CFG.exceptionStack(ex);
                }
            }
            catch (NullPointerException ex) {
                if (CFG.LOGS) {
                    CFG.exceptionStack(ex);
                }
            }
            catch (IllegalArgumentException ex) {
                if (!CFG.LOGS) break block8;
                CFG.exceptionStack(ex);
            }
        }
    }

    protected final void setCheckbox(boolean checkbox) {
        this.checkbox = checkbox;
    }

    @Override
    protected boolean getCheckboxState() {
        return this.checkboxState;
    }

    @Override
    protected final void setCheckboxState(boolean checkboxState) {
        this.checkboxState = checkboxState;
    }

    @Override
    protected void setTypeOfButton(TypeOfButton typeOfButton) {
        this.typeOfButton = typeOfButton;
    }

    @Override
    protected int getTextWidth() {
        return this.iTextWidth;
    }

    @Override
    protected int getTextPos() {
        return this.iTextPositionX;
    }

    @Override
    protected int getTextHeight() {
        return this.iTextHeight;
    }

    static interface TextPosition {
        public int getTextPosition();
    }

    static interface Checkbox {
        public void drawCheckBox(SpriteBatch var1, int var2, int var3, boolean var4);
    }

    protected static enum TypeOfButton {
        KEYBOARD,
        KEYBOARD_NUM,
        KEYBOARD_ACTIVE,
        KEYBOARD_SAVE,
        KEYBOARD_OPTIONS;

    }
}

