/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.AoCGame;
import age.of.civilizations2.jakowski.lukasz.CFG;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

class SoundsManager {
    private static final String CONSOLE_MUSIC_TITLE = AoCGame.exitsof("", "Console.mp3", "Scheming_Weasel.ogg");
    protected static boolean isPlayingConsoleMusic = false;
    private static final String START_MUSIC = AoCGame.exitsof("music/", "Start.mp3") ? "Start.mp3" : "Impact_Allegretto.ogg";
    private static final String DEFEAT_MUSIC = "Sudden_Defeat." + (CFG.isIOS() ? "mp3" : "ogg");
    private List<String> lTitles;
    private Music currentMusic = null;
    private float musicVolume = 0.4f;
    private int iCurrentMusicID = 0;
    private List<Sound> lSounds;
    private float soundsVolume = 0.55f;
    private float masterVolume = 1.0f;
    protected static int SOUND_CLICK;
    protected static int SOUND_CLICK2;
    protected static int SOUND_CLICK3;
    protected static int SOUND_PROVINCE;
    protected static int SOUND_ACTION_MOVE;
    protected static int SOUND_MOVE_ARMY;
    protected static int SOUND_MOVE_ARMY2;
    protected static int SOUND_MOVE_REGROUP;
    protected static int SOUND_INVADE;
    protected static int SOUND_RECRUIT;
    protected static int SOUND_GOLD;
    protected static int SOUND_DIPLOMACY;
    protected static int SOUND_TECHNOLOGY;
    protected static int SOUND_WAR;
    protected static int SOUND_WAR2;
    protected static int SOUND_BUILD;
    protected static int SOUND_PLUNDER;
    protected static int SOUND_CROW;
    protected static int SOUND_SEND;
    protected static int SOUND_SEND2;
    protected static int SOUND_SEND3;
    protected static int SOUND_SEND4;
    protected static int SOUND_ASSIMILATE;
    protected static int SOUND_WORKSHOP;
    protected static int SOUND_FARM;
    protected static int SOUND_PORT;
    protected static int SOUND_SUPPLY;
    protected static int SOUND_LIBRARY;
    protected static int SOUND_RANDOM;
    protected static int SOUND_START_FOCUS;
    protected static int SOUND_COMPLETE_FOCUS;
    protected static int SOUND_PLAY;
    protected static int SOUND_EVENT;
    protected static int SOUND_NEWS;
    protected static float PERC_VOLUME_SELECT_PROVINCE;
    protected static float PERC_VOLUME_KEYBOARD;
    protected static Array<Integer> SOUND_NUCLEAR_EXPLOSION;
    private final Random oR = new Random();
    private final ArrayList<String> oriTitle = new ArrayList();

    protected SoundsManager() {
        this.lTitles = new ArrayList<String>();
        this.lSounds = new ArrayList<Sound>();
        SOUND_CLICK = this.addSound("click." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_CLICK2 = this.addSound("click2." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_CLICK3 = this.addSound("click3." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_PROVINCE = SOUND_CLICK;
        try {
            FileHandle tempFileT = Gdx.files.internal("music/Age_of_Civilizations");
            String tempT = tempFileT.readString("UTF-8");
            String[] tagsSPLITED = tempT.split(";");
            this.lTitles.addAll(Arrays.asList(tagsSPLITED));
        }
        catch (GdxRuntimeException var8) {
            try {
                FileHandle tempFileT = Gdx.files.local("music/Age_of_Civilizations");
                String tempT = tempFileT.readString("UTF-8");
                String[] tagsSPLITED = tempT.split(";");
                this.lTitles.addAll(Arrays.asList(tagsSPLITED));
                this.oriTitle.addAll(this.lTitles);
            }
            catch (GdxRuntimeException gdxRuntimeException) {
                // empty catch block
            }
        }
        this.randomizePlayList();
        this.playStartMusic();
        SOUND_MOVE_ARMY = this.addSound("move_army." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_MOVE_ARMY2 = this.addSound("move_army2." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_MOVE_REGROUP = this.addSound("move_army_re." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_GOLD = this.addSound("gold2." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_DIPLOMACY = this.addSound("diplomacy." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_TECHNOLOGY = this.addSound("technology." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_ACTION_MOVE = this.addSound("action_move." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_RECRUIT = this.addSound("metal." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_WAR = this.addSound("war." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_WAR2 = this.addSound("war2." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_BUILD = this.addSound("build." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_SEND = this.addSound("send." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_SEND2 = this.addSound("send2." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_SEND3 = this.addSound("send3." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_SEND4 = this.addSound("send4." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_PLUNDER = this.addSound("plunder." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_CROW = this.addSound("crow." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_ASSIMILATE = this.addSound("assimilate." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_WORKSHOP = this.addSound("workshop." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_FARM = this.addSound("farm." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_PORT = this.addSound("port." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_SUPPLY = this.addSound("supply." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_LIBRARY = this.addSound("library." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_RANDOM = this.addSound("random." + (CFG.isIOS() ? "mp3" : "ogg"));
        SOUND_START_FOCUS = this.addSound("start_focus.wav");
        SOUND_COMPLETE_FOCUS = this.addSound("complete_focus.wav");
        SOUND_EVENT = this.addSound("event.wav");
        SOUND_NEWS = this.addSound("world_news.wav");
        int i = 0;
        while (Gdx.files.internal("sounds/nuclear_explosion" + ++i + ".ogg").exists()) {
            SOUND_NUCLEAR_EXPLOSION.add(this.addSound("nuclear_explosion" + i + ".ogg"));
        }
        SOUND_PLAY = this.addSound("Play." + (CFG.isIOS() ? "mp3" : "ogg"));
        this.masterVolume = CFG.settingsManager.VOLUME_MASTER;
        this.setSoundsVolume(CFG.settingsManager.VOLUME_SOUNDS);
        this.setMusicVolume(CFG.settingsManager.VOLUME_MUSIC);
    }

    protected final void randomizePlayList() {
        Random oR = new Random();
        ArrayList<String> tempList = new ArrayList<String>(this.lTitles);
        this.lTitles.clear();
        while (!tempList.isEmpty()) {
            int tempR = oR.nextInt(tempList.size());
            this.lTitles.add((String)tempList.get(tempR));
            tempList.remove(tempR);
        }
    }

    protected final int Positioning() {
        return this.oriTitle.indexOf(this.getCurrentMusicName());
    }

    protected final void loadNextMusic() {
        this.disposeCurrentMusic();
        ++this.iCurrentMusicID;
        if (this.iCurrentMusicID >= this.lTitles.size()) {
            this.iCurrentMusicID = 0;
            this.randomizePlayList();
        }
        try {
            this.currentMusic = Gdx.audio.newMusic(Gdx.files.internal("music/" + this.lTitles.get(this.iCurrentMusicID)));
            this.currentMusic.setLooping(false);
            this.currentMusic.play();
            this.currentMusic.setVolume(this.musicVolume * this.masterVolume);
            this.currentMusic.setOnCompletionListener(music -> this.loadNextMusic());
            isPlayingConsoleMusic = false;
            try {
                CFG.toast.setInView(this.getCurrentMusicTittle(), CFG.COLOR_TEXT_MODIFIER_NEUTRAL2);
                CFG.toast.setTimeInView(4500);
            }
            catch (NullPointerException nullPointerException) {}
        }
        catch (GdxRuntimeException var6) {
            try {
                this.currentMusic = Gdx.audio.newMusic(Gdx.files.local("music/" + this.lTitles.get(this.iCurrentMusicID)));
                this.currentMusic.setLooping(false);
                this.currentMusic.play();
                this.currentMusic.setVolume(this.musicVolume * this.masterVolume);
                this.currentMusic.setOnCompletionListener(music -> this.loadNextMusic());
                isPlayingConsoleMusic = false;
                try {
                    CFG.toast.setInView(this.getCurrentMusicTittle(), CFG.COLOR_TEXT_MODIFIER_NEUTRAL2);
                    CFG.toast.setTimeInView(4500);
                }
                catch (NullPointerException nullPointerException) {
                }
            }
            catch (GdxRuntimeException gdxRuntimeException) {}
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void playFallbackMusic(String filePath) {
        try {
            Music music = Gdx.audio.newMusic(Gdx.files.internal(filePath));
            music.setLooping(false);
            music.play();
            music.setVolume(this.musicVolume * this.masterVolume);
            music.setOnCompletionListener(new Music.OnCompletionListener(){

                @Override
                public void onCompletion(Music music) {
                    SoundsManager.this.loadNextMusic();
                }
            });
        }
        catch (GdxRuntimeException e) {
            try {
                Music music = Gdx.audio.newMusic(Gdx.files.local(filePath));
                music.setLooping(false);
                music.play();
                music.setVolume(this.musicVolume * this.masterVolume);
                music.setOnCompletionListener(new Music.OnCompletionListener(){

                    @Override
                    public void onCompletion(Music music) {
                        SoundsManager.this.loadNextMusic();
                    }
                });
            }
            catch (GdxRuntimeException e2) {
                Gdx.app.error("Audio", "Fallback failed: " + filePath, e2);
            }
        }
    }

    protected final void playSuperEventSound(String name) {
        try {
            this.disposeCurrentMusic();
            this.currentMusic = Gdx.audio.newMusic(Gdx.files.internal("sfx/super_events/" + name + ".ogg"));
            this.currentMusic.setLooping(false);
            this.currentMusic.play();
            this.currentMusic.setVolume(this.musicVolume * this.masterVolume);
            this.currentMusic.setOnCompletionListener(new Music.OnCompletionListener(){

                @Override
                public void onCompletion(Music music) {
                    SoundsManager.this.loadNextMusic();
                }
            });
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            // empty catch block
        }
    }

    protected final void playEventSound(String path) {
        try {
            this.disposeCurrentMusic();
            this.currentMusic = Gdx.audio.newMusic(Gdx.files.internal(path));
            this.currentMusic.setLooping(false);
            this.currentMusic.play();
            this.currentMusic.setVolume(this.musicVolume * this.masterVolume);
            this.currentMusic.setOnCompletionListener(new Music.OnCompletionListener(){

                @Override
                public void onCompletion(Music music) {
                    SoundsManager.this.loadNextMusic();
                }
            });
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            // empty catch block
        }
    }

    protected final void playConsoleMusic() {
        try {
            this.disposeCurrentMusic();
            this.currentMusic = Gdx.audio.newMusic(Gdx.files.internal("music/" + CONSOLE_MUSIC_TITLE));
            this.currentMusic.setLooping(false);
            this.currentMusic.play();
            this.currentMusic.setVolume(this.musicVolume * this.masterVolume);
            this.currentMusic.setOnCompletionListener(music -> this.loadNextMusic());
            isPlayingConsoleMusic = true;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            // empty catch block
        }
    }

    protected final void loadNextMusic(String name) {
        this.disposeCurrentMusic();
        try {
            this.iCurrentMusicID = Math.max(0, this.lTitles.indexOf(name));
            this.currentMusic = Gdx.audio.newMusic(Gdx.files.internal("music/" + name));
            this.currentMusic.setLooping(false);
            this.currentMusic.play();
            this.currentMusic.setVolume(this.musicVolume * this.masterVolume);
            this.currentMusic.setOnCompletionListener(music -> this.loadNextMusic());
            isPlayingConsoleMusic = false;
            try {
                CFG.toast.setInView(this.getCurrentMusicTitle(name), CFG.COLOR_TEXT_MODIFIER_NEUTRAL2);
                CFG.toast.setTimeInView(4500);
            }
            catch (NullPointerException nullPointerException) {}
        }
        catch (GdxRuntimeException var6) {
            try {
                this.iCurrentMusicID = Math.max(0, this.lTitles.indexOf(name));
                this.currentMusic = Gdx.audio.newMusic(Gdx.files.local("music/" + name));
                this.currentMusic.setLooping(false);
                this.currentMusic.play();
                this.currentMusic.setVolume(this.musicVolume * this.masterVolume);
                this.currentMusic.setOnCompletionListener(music -> this.loadNextMusic());
                isPlayingConsoleMusic = false;
                try {
                    CFG.toast.setInView(this.getCurrentMusicTitle(name), CFG.COLOR_TEXT_MODIFIER_NEUTRAL2);
                    CFG.toast.setTimeInView(4500);
                }
                catch (NullPointerException nullPointerException) {
                }
            }
            catch (GdxRuntimeException gdxRuntimeException) {}
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected final void playStartMusic() {
        try {
            this.disposeCurrentMusic();
            this.currentMusic = Gdx.audio.newMusic(Gdx.files.internal("music/" + START_MUSIC));
            this.currentMusic.setLooping(false);
            this.currentMusic.play();
            this.currentMusic.setVolume(this.musicVolume * this.masterVolume);
            this.currentMusic.setOnCompletionListener(music -> this.loadNextMusic());
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            // empty catch block
        }
    }

    protected final void disposeCurrentMusic() {
        if (this.currentMusic != null) {
            this.currentMusic.stop();
            this.currentMusic.dispose();
        }
    }

    protected final int addSound(String fileName) {
        try {
            this.lSounds.add(Gdx.audio.newSound(Gdx.files.internal("sounds/" + fileName)));
        }
        catch (GdxRuntimeException var5) {
            var5.printStackTrace();
            try {
                this.lSounds.add(Gdx.audio.newSound(Gdx.files.local("sounds/" + fileName)));
            }
            catch (GdxRuntimeException var4) {
                var5.printStackTrace();
                return -1;
            }
        }
        return this.lSounds.size() - 1;
    }

    protected final void playSound(int id) {
        this.playSound(id, 1.0f);
    }

    protected final void playSound(int id, float fPercOfVolume) {
        try {
            this.lSounds.get(id).stop();
            this.lSounds.get(id).play(this.soundsVolume * this.masterVolume * fPercOfVolume);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected final int playMoveArmy() {
        int tID = this.oR.nextInt(174) % 2;
        switch (tID) {
            case 1: {
                return SOUND_MOVE_ARMY2;
            }
        }
        return SOUND_MOVE_ARMY;
    }

    protected final String getCurrentMusicTittle() {
        return this.lTitles.get(this.iCurrentMusicID).replace(".ogg", "").replace(".mp3", "").replace("_", " ").trim();
    }

    protected final String getCurrentMusicName() {
        return this.lTitles.get(this.iCurrentMusicID);
    }

    protected final String getCurrentMusicTitle(String name) {
        return name.replace(".ogg", "").replace(".mp3", "").replace("_", " ").trim();
    }

    protected final void setMusicVolume(float nMusicVolume) {
        this.musicVolume = nMusicVolume;
        try {
            this.currentMusic.setVolume(this.musicVolume * this.masterVolume);
            if (this.musicVolume < 0.01f) {
                this.currentMusic.pause();
            } else if (!this.currentMusic.isPlaying()) {
                this.currentMusic.play();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected final float getMusicVolume() {
        return this.musicVolume;
    }

    protected final void setSoundsVolume(float soundsVolume) {
        this.soundsVolume = soundsVolume;
    }

    protected final float getSoundsVolume() {
        return this.soundsVolume;
    }

    protected final void setMasterVolume(float masterVolume) {
        this.masterVolume = masterVolume;
        this.setMusicVolume(this.getMusicVolume());
    }

    protected final float getMasterVolume() {
        return this.masterVolume;
    }

    protected final void dispose() {
        for (int i = 0; i < this.lSounds.size(); ++i) {
            this.lSounds.get(i).dispose();
        }
        this.currentMusic.dispose();
    }

    protected static final int getSend() {
        switch (CFG.oR.nextInt(4)) {
            case 0: {
                return SOUND_SEND;
            }
            case 1: {
                return SOUND_SEND2;
            }
            case 2: {
                return SOUND_SEND3;
            }
        }
        return SOUND_SEND4;
    }

    protected int getCurrentMusicID() {
        return this.iCurrentMusicID;
    }

    static {
        PERC_VOLUME_SELECT_PROVINCE = 0.95f;
        PERC_VOLUME_KEYBOARD = 0.9f;
        SOUND_NUCLEAR_EXPLOSION = new Array();
    }
}

