/*
 * Decompiled with CFR 0.152.
 */
package mapeditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import mapeditor.Button;

class GamePanel
extends JPanel
implements Runnable {
    private Thread gameThread;
    private volatile boolean bRunning = false;
    private Image baseImage;
    private Graphics baseGraphic;
    public static int GWIDTH = 1920;
    public static int GHEIGHT = 1020;
    private static Dimension gameThreadDim;
    private static String fileName;
    private static String fileNameJson;
    private static String sBackgroundImage;
    private static final boolean bRepeatBackground = true;
    private static final boolean export = false;
    protected static boolean MAXIMUM_SIZE;
    private boolean bDrawProvinces = true;
    protected static boolean bDrawProvincePoints;
    protected static boolean bDrawCities;
    protected static boolean bDrawCitiesNames;
    protected static boolean bDrawArmy;
    private boolean bChooseProvinceMode = false;
    private boolean bChangePointMode = false;
    private boolean bAddPointToProvinceMode = false;
    private boolean bRemovePointMode = false;
    private int iEndOfLandProvinces = -1;
    private static boolean CONVERT_AOH2_MAP_PROVINCES_DATA_TO_AOH3;
    private int iRemovedProvinceID = -1;
    private List<Image> mapEditorBackground = new ArrayList<Image>();
    private int iMapEditorBackgroundWidth;
    private int iMapEditorBackgroundHeight;
    private List<Image> mapEditorBackground2 = new ArrayList<Image>();
    private boolean drawBGMain = true;
    private int iHeightOfSingleBG = 1;
    private int gameMapSize = 0;
    private int iXMapPos = 0;
    private int iYMapPos = 0;
    private float fMapScale = 1.0f;
    private int iShiftXY = 15;
    private int iActiveProvinceID = -1;
    private boolean bSelectedPointsToChangePosition = false;
    private int iChangePositionX = 0;
    private int iChangePositionY = 0;
    private boolean drawBG = true;
    private boolean drawNeighboring = false;
    private List<Button> lButtons = new ArrayList<Button>();
    private Vector vProvinces;
    private GeneralPath currentProvince = null;
    private int currentProvincePoints = 0;
    private NeighboringProvincesThread _NeighboringProvincesThread = null;
    private boolean neighboringProvincesReadyToUse = false;
    private List<List<Integer>> lProvincesPointsX = new ArrayList<List<Integer>>();
    private List<List<Integer>> lProvincesPointsY = new ArrayList<List<Integer>>();
    public List<Boolean> haveCity = new ArrayList<Boolean>();
    private List<Integer> lProvincesCenterX = new ArrayList<Integer>();
    private List<Integer> lProvincesCenterY = new ArrayList<Integer>();
    private List<Integer> lProvincesMinX = new ArrayList<Integer>();
    private List<Integer> lProvincesMinY = new ArrayList<Integer>();
    private List<Integer> lProvincesMaxX = new ArrayList<Integer>();
    private List<Integer> lProvincesMaxY = new ArrayList<Integer>();
    private List<Integer> currentPointsX = new ArrayList<Integer>();
    private List<Integer> currentPointsY = new ArrayList<Integer>();
    private static List<String> citiesNames;
    private static List<Integer> citiesX;
    private static List<Integer> citiesY;
    private int iCurrentProvinceMinX;
    private int iCurrentProvinceMaxX;
    private int iCurrentProvinceMinY;
    private int iCurrentProvinceMaxY;
    private int iCurrentProvinceShiftArmyX = 0;
    private int iCurrentProvinceShiftArmyY = 0;
    private List<Integer> lContinent = new ArrayList<Integer>();
    private List<Integer> pathR = new ArrayList<Integer>();
    private List<Integer> pathG = new ArrayList<Integer>();
    private List<Integer> pathB = new ArrayList<Integer>();
    private List<List<Integer>> neighboring = new ArrayList<List<Integer>>();
    private int iLandProvinceAlpha = 120;
    private int iSeaProvinceAlpha = 80;
    private int iLastPressedPosX = 0;
    private int iLastPressedPosY = 0;
    private int iMousePosX = 0;
    private int iMousePosY = 0;
    private static final byte iPadding = 5;
    public String addCityName = "";
    private List<Boolean> isInView = new ArrayList<Boolean>();
    private String topText = "Lukasz Jakowski Games";
    private String downText = "Age of History 3";
    private String shortcuts = "O, C, V, Z, L, P, M";
    public static String mapName;
    public static int BackgroundSize_X;
    public static int BackgroundSize_Y;
    boolean foundFirst = false;
    boolean forward = false;

    private final void resetModes() {
        this.bChangePointMode = false;
        this.bAddPointToProvinceMode = false;
        this.bRemovePointMode = false;
        this.bChooseProvinceMode = false;
        this.bSelectedPointsToChangePosition = false;
    }

    public final void clearCurrentData() {
        int i;
        if (this.currentPointsX.size() <= 1) {
            return;
        }
        if (this.iRemovedProvinceID >= 0) {
            GeneralPath nPath = new GeneralPath();
            int nSize = this.currentPointsX.size();
            for (int i2 = 0; i2 < nSize; ++i2) {
                if (i2 == 0) {
                    nPath.moveTo(this.currentPointsX.get(i2).intValue(), this.currentPointsY.get(i2).intValue());
                    continue;
                }
                nPath.lineTo(this.currentPointsX.get(i2).intValue(), this.currentPointsY.get(i2).intValue());
            }
            this.vProvinces.set(this.iRemovedProvinceID, nPath);
            ArrayList<Integer> tempX = new ArrayList<Integer>();
            for (int i3 = 0; i3 < this.currentPointsX.size(); ++i3) {
                tempX.add(this.currentPointsX.get(i3));
            }
            ArrayList<Integer> tempY = new ArrayList<Integer>();
            for (int i4 = 0; i4 < this.currentPointsY.size(); ++i4) {
                tempY.add(this.currentPointsY.get(i4));
            }
            this.lProvincesPointsX.set(this.iRemovedProvinceID, tempX);
            this.lProvincesPointsY.set(this.iRemovedProvinceID, tempY);
            int tempMinX = this.iMapEditorBackgroundWidth;
            int tempMaxX = -this.iMapEditorBackgroundWidth;
            int tempMinY = this.iMapEditorBackgroundHeight;
            int tempMaxY = -this.iMapEditorBackgroundHeight;
            for (int j = 0; j < this.lProvincesPointsX.get(this.iRemovedProvinceID).size(); ++j) {
                if (this.lProvincesPointsX.get(this.iRemovedProvinceID).get(j) < tempMinX) {
                    tempMinX = this.lProvincesPointsX.get(this.iRemovedProvinceID).get(j);
                }
                if (this.lProvincesPointsX.get(this.iRemovedProvinceID).get(j) > tempMaxX) {
                    tempMaxX = this.lProvincesPointsX.get(this.iRemovedProvinceID).get(j);
                }
                if (this.lProvincesPointsY.get(this.iRemovedProvinceID).get(j) < tempMinY) {
                    tempMinY = this.lProvincesPointsY.get(this.iRemovedProvinceID).get(j);
                }
                if (this.lProvincesPointsY.get(this.iRemovedProvinceID).get(j) <= tempMaxY) continue;
                tempMaxY = this.lProvincesPointsY.get(this.iRemovedProvinceID).get(j);
            }
            this.lProvincesMaxX.set(this.iRemovedProvinceID, tempMaxX);
            this.lProvincesMaxY.set(this.iRemovedProvinceID, tempMaxY);
            this.lProvincesMinX.set(this.iRemovedProvinceID, tempMinX);
            this.lProvincesMinY.set(this.iRemovedProvinceID, tempMinY);
            this.lProvincesCenterX.set(this.iRemovedProvinceID, (tempMaxX + tempMinX) / 2);
            this.lProvincesCenterY.set(this.iRemovedProvinceID, (tempMaxY + tempMinY) / 2);
            this.iRemovedProvinceID = -1;
            this.currentPointsX.clear();
            this.currentPointsY.clear();
            this.iCurrentProvinceMinX = 0;
            this.iCurrentProvinceMaxX = 0;
            this.iCurrentProvinceMinY = 0;
            this.iCurrentProvinceMaxY = 0;
            this.iCurrentProvinceShiftArmyX = 0;
            this.iCurrentProvinceShiftArmyY = 0;
            this.currentProvincePoints = 0;
            this.currentProvince = null;
            return;
        }
        this.addColor();
        GeneralPath nPath = new GeneralPath();
        int nSize = this.currentPointsX.size();
        for (int i5 = 0; i5 < nSize; ++i5) {
            if (i5 == 0) {
                nPath.moveTo(this.currentPointsX.get(i5).intValue(), this.currentPointsY.get(i5).intValue());
                continue;
            }
            nPath.lineTo(this.currentPointsX.get(i5).intValue(), this.currentPointsY.get(i5).intValue());
        }
        this.vProvinces.add(nPath);
        ArrayList<Integer> tempX = new ArrayList<Integer>();
        for (int i6 = 0; i6 < this.currentPointsX.size(); ++i6) {
            tempX.add(this.currentPointsX.get(i6));
        }
        ArrayList<Integer> tempY = new ArrayList<Integer>();
        for (i = 0; i < this.currentPointsY.size(); ++i) {
            tempY.add(this.currentPointsY.get(i));
        }
        this.lProvincesPointsX.add(tempX);
        this.lProvincesPointsY.add(tempY);
        for (i = this.vProvinces.size() - 1; i < this.vProvinces.size(); ++i) {
            int tempMinX = this.iMapEditorBackgroundWidth;
            int tempMaxX = -this.iMapEditorBackgroundWidth;
            int tempMinY = this.iMapEditorBackgroundHeight;
            int tempMaxY = -this.iMapEditorBackgroundHeight;
            for (int j = 0; j < this.lProvincesPointsX.get(i).size(); ++j) {
                if (this.lProvincesPointsX.get(i).get(j) < tempMinX) {
                    tempMinX = this.lProvincesPointsX.get(i).get(j);
                }
                if (this.lProvincesPointsX.get(i).get(j) > tempMaxX) {
                    tempMaxX = this.lProvincesPointsX.get(i).get(j);
                }
                if (this.lProvincesPointsY.get(i).get(j) < tempMinY) {
                    tempMinY = this.lProvincesPointsY.get(i).get(j);
                }
                if (this.lProvincesPointsY.get(i).get(j) <= tempMaxY) continue;
                tempMaxY = this.lProvincesPointsY.get(i).get(j);
            }
            this.lProvincesMaxX.add(tempMaxX);
            this.lProvincesMaxY.add(tempMaxY);
            this.lProvincesMinX.add(tempMinX);
            this.lProvincesMinY.add(tempMinY);
            this.lProvincesCenterX.add((tempMaxX + tempMinX) / 2);
            this.lProvincesCenterY.add((tempMaxY + tempMinY) / 2);
        }
        this.currentPointsX.clear();
        this.currentPointsY.clear();
        this.iCurrentProvinceMinX = 0;
        this.iCurrentProvinceMaxX = 0;
        this.iCurrentProvinceMinY = 0;
        this.iCurrentProvinceMaxY = 0;
        this.iCurrentProvinceShiftArmyX = 0;
        this.iCurrentProvinceShiftArmyY = 0;
        this.currentProvincePoints = 0;
        this.currentProvince = null;
    }

    public final void buildHaveCity() {
        this.haveCity.clear();
        for (int i = 0; i < this.vProvinces.size(); ++i) {
            this.haveCity.add(false);
        }
        int jSize = citiesX.size();
        for (int j = 0; j < jSize; ++j) {
            for (int i = 0; i < this.vProvinces.size(); ++i) {
                if (!this.pathContains(citiesX.get(j), citiesY.get(j), i)) continue;
                this.haveCity.set(i, true);
            }
        }
    }

    protected GamePanel() {
        int i;
        int i2;
        int j;
        this.loadProvincesFromFile();
        this.addKeyListener();
        this.addWheelListener();
        this.addMotionListener();
        this.addMouseListener();
        gameThreadDim = new Dimension(GWIDTH, GHEIGHT);
        this.setPreferredSize(gameThreadDim);
        this.setBackground(Color.BLACK);
        this.setFocusable(true);
        for (j = 0; j < BackgroundSize_Y; ++j) {
            for (i2 = 0; i2 < BackgroundSize_X; ++i2) {
                this.mapEditorBackground.add(this.ImageReader(mapName + "/background/main/" + j + "_" + i2 + ".png"));
            }
        }
        this.gameMapSize = this.mapEditorBackground.size();
        this.iMapEditorBackgroundWidth = 0;
        for (i = 0; i < BackgroundSize_X; ++i) {
            this.iMapEditorBackgroundWidth += this.mapEditorBackground.get(i).getWidth(this);
        }
        this.iMapEditorBackgroundHeight = 0;
        for (i = 0; i < BackgroundSize_Y; ++i) {
            this.iMapEditorBackgroundHeight += this.mapEditorBackground.get(i * BackgroundSize_X).getHeight(this);
        }
        this.iHeightOfSingleBG = this.mapEditorBackground.get(0).getHeight(this);
        for (j = 0; j < BackgroundSize_Y; ++j) {
            for (i2 = 0; i2 < BackgroundSize_X; ++i2) {
                this.mapEditorBackground2.add(this.ImageReader(mapName + "/background/mapEditor/" + j + "_" + i2 + ".png"));
            }
        }
    }

    public void draw(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fillRect(0, 0, GWIDTH, GHEIGHT);
        g2d.scale(this.fMapScale, this.fMapScale);
        if (this.drawBG) {
            int i;
            int tempWidth;
            int j;
            int tempHeight;
            int currID;
            if (this.drawBGMain) {
                currID = this.gameMapSize - 1;
                tempHeight = this.iHeightOfSingleBG * (BackgroundSize_Y - 1);
                for (j = BackgroundSize_Y - 1; j >= 0; --j) {
                    tempWidth = this.iMapEditorBackgroundWidth - this.mapEditorBackground.get(0).getWidth(this);
                    for (i = BackgroundSize_X - 1; i >= 0; --i) {
                        g2d.drawImage(this.mapEditorBackground.get(currID), -this.iXMapPos + tempWidth, -this.iYMapPos + tempHeight, null);
                        tempWidth -= this.mapEditorBackground.get(currID).getWidth(this);
                        --currID;
                    }
                    tempHeight -= this.mapEditorBackground.get(0).getHeight(this);
                }
            } else {
                currID = this.gameMapSize - 1;
                tempHeight = this.iHeightOfSingleBG * (BackgroundSize_Y - 1);
                for (j = BackgroundSize_Y - 1; j >= 0; --j) {
                    tempWidth = this.iMapEditorBackgroundWidth - this.mapEditorBackground2.get(0).getWidth(this);
                    for (i = BackgroundSize_X - 1; i >= 0; --i) {
                        g2d.drawImage(this.mapEditorBackground2.get(currID), -this.iXMapPos + tempWidth, -this.iYMapPos + tempHeight, null);
                        tempWidth -= this.mapEditorBackground2.get(currID).getWidth(this);
                        --currID;
                    }
                    tempHeight -= this.mapEditorBackground2.get(0).getHeight(this);
                }
            }
        }
        try {
            this.updateInView();
            g2d.translate(-this.iXMapPos, -this.iYMapPos);
            if (!this.drawBGMain) {
                try {
                    for (int i = 0; i < this.vProvinces.size(); ++i) {
                        try {
                            if (!this.isInView.get(i).booleanValue() || this.haveCity.get(i).booleanValue()) continue;
                            try {
                                g2d.setColor(new Color(this.pathR.get(i), this.pathG.get(i), this.pathB.get(i), this.iLandProvinceAlpha));
                            }
                            catch (IndexOutOfBoundsException currID) {
                                // empty catch block
                            }
                            g2d.fill((GeneralPath)this.vProvinces.elementAt(i));
                            continue;
                        }
                        catch (Exception ex2) {
                            ex2.printStackTrace();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (this.bDrawProvinces) {
                this.drawProvinces(g2d);
                this.drawActiveProvince(g2d);
            }
            this.drawArmy(g2d);
            this.drawPoints(g2d);
            Graphics2D g2d2 = (Graphics2D)g.create();
            if (this.iXMapPos < 0) {
                g2d2.scale(this.fMapScale, this.fMapScale);
                g2d2.translate(-this.iMapEditorBackgroundWidth - this.iXMapPos, -this.iYMapPos);
                if (this.bDrawProvinces) {
                    this.drawProvinces(g2d2);
                    this.drawActiveProvince(g2d2);
                }
                this.drawArmy(g2d2);
                this.drawPoints(g2d2);
            }
        }
        catch (NullPointerException g2d2) {
        }
        catch (IndexOutOfBoundsException g2d2) {
            // empty catch block
        }
        if (this.currentPointsX.size() == 2) {
            g2d.drawRect(this.currentPointsX.get(0), this.currentPointsY.get(0), this.currentPointsX.get(1) - this.currentPointsX.get(0), this.currentPointsY.get(1) - this.currentPointsY.get(0));
        }
        if (this.drawNeighboring) {
            g2d.setColor(Color.red);
            this.drawNeighboring(g2d);
        }
        g2d.setColor(Color.red);
        g2d.draw3DRect((int)((float)this.iMousePosX / this.fMapScale) + this.iXMapPos, (int)((float)this.iMousePosY / this.fMapScale) + this.iYMapPos, 0, 0, false);
        for (int i = 0; i < this.lButtons.size(); ++i) {
            this.lButtons.get(i).draw(g);
        }
        if (this.bChangePointMode || this.bChooseProvinceMode || this.bAddPointToProvinceMode || this.bRemovePointMode || this.iRemovedProvinceID >= 0) {
            this.drawMode(g, g2d);
        }
        this.drawTextInfo(g, g2d);
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Clipboard clipboard = toolkit.getSystemClipboard();
            String copyFromClipboard = (String)clipboard.getData(DataFlavor.stringFlavor);
            if (copyFromClipboard != null) {
                this.addCityName = copyFromClipboard;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.drawTextInfo(g, g2d);
    }

    private final void updateInView() {
        for (int i = 0; i < this.vProvinces.size(); ++i) {
            this.isInView.set(i, ((float)this.iXMapPos + (float)GWIDTH / this.fMapScale >= (float)this.lProvincesMinX.get(i).intValue() && this.iXMapPos <= this.lProvincesMaxX.get(i) || (float)this.iXMapPos + (float)GWIDTH / this.fMapScale >= (float)(this.lProvincesMinX.get(i) + this.iMapEditorBackgroundWidth) && this.iXMapPos <= this.lProvincesMaxX.get(i) + this.iMapEditorBackgroundWidth || (float)this.iXMapPos + (float)GWIDTH / this.fMapScale >= (float)(this.lProvincesMinX.get(i) - this.iMapEditorBackgroundWidth) && this.iXMapPos <= this.lProvincesMaxX.get(i) - this.iMapEditorBackgroundWidth) && (float)this.iYMapPos + (float)GHEIGHT / this.fMapScale >= (float)this.lProvincesMinY.get(i).intValue() && this.iYMapPos <= this.lProvincesMaxY.get(i));
        }
    }

    private void drawProvinces(Graphics2D g2d) {
        try {
            for (int i = 0; i < this.vProvinces.size(); ++i) {
                if (!this.isInView.get(i).booleanValue()) continue;
                try {
                    if (i == this.iActiveProvinceID) {
                        g2d.setColor(new Color(255, 255, 255, 255));
                    } else {
                        g2d.setColor(new Color(this.pathR.get(i), this.pathG.get(i), this.pathB.get(i), this.iLandProvinceAlpha));
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                g2d.fill((GeneralPath)this.vProvinces.elementAt(i));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void drawActiveProvince(Graphics2D g2d) {
        if (this.iActiveProvinceID >= 0) {
            g2d.setColor(new Color(255, 255, 255, 255));
            g2d.fill((GeneralPath)this.vProvinces.elementAt(this.iActiveProvinceID));
        }
    }

    private void drawPoints(Graphics g2d) {
        try {
            if (bDrawProvincePoints) {
                for (int i = 0; i < this.vProvinces.size(); ++i) {
                    if (!this.isInView.get(i).booleanValue()) continue;
                    int jSize = this.lProvincesPointsX.get(i).size();
                    for (int j = 0; j < jSize; ++j) {
                        g2d.setColor(new Color(this.pathG.get(i), this.pathB.get(i), this.pathR.get(i), 255));
                        g2d.draw3DRect(this.lProvincesPointsX.get(i).get(j), this.lProvincesPointsY.get(i).get(j), 0, 0, false);
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException i) {
        }
        catch (NullPointerException i) {
            // empty catch block
        }
        try {
            if (bDrawCities) {
                Font font = new Font("Arial", 1, 3);
                g2d.setFont(font);
                AffineTransform affinetransform = new AffineTransform();
                FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
                for (int i = 0; i < citiesX.size(); ++i) {
                    try {
                        if (!((float)this.iXMapPos + (float)GWIDTH / this.fMapScale >= (float)citiesX.get(i).intValue() && this.iXMapPos <= citiesX.get(i) || (float)this.iXMapPos + (float)GWIDTH / this.fMapScale >= (float)(citiesX.get(i) + this.iMapEditorBackgroundWidth) && this.iXMapPos <= citiesX.get(i) + this.iMapEditorBackgroundWidth) && (!((float)this.iXMapPos + (float)GWIDTH / this.fMapScale >= (float)(citiesX.get(i) - this.iMapEditorBackgroundWidth)) || this.iXMapPos > citiesX.get(i) - this.iMapEditorBackgroundWidth) || !((float)this.iYMapPos + (float)GHEIGHT / this.fMapScale >= (float)citiesY.get(i).intValue()) || this.iYMapPos > citiesY.get(i)) continue;
                        g2d.setColor(Color.BLACK);
                        g2d.draw3DRect(citiesX.get(i) - 1, citiesY.get(i) - 1, 2, 2, false);
                        if (!bDrawCitiesNames) continue;
                        g2d.setColor(new Color(240, 240, 240, 255));
                        g2d.drawString(citiesNames.get(i), citiesX.get(i) - 1, citiesY.get(i) - 1);
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void drawArmy(Graphics g2d) {
        if (bDrawArmy) {
            for (int i = 0; i < this.vProvinces.size(); ++i) {
                if (!((float)this.iXMapPos + (float)GWIDTH / this.fMapScale >= (float)this.lProvincesMinX.get(i).intValue()) || this.iXMapPos > this.lProvincesMaxX.get(i) || !((float)this.iYMapPos + (float)GHEIGHT / this.fMapScale >= (float)this.lProvincesMinY.get(i).intValue()) || this.iYMapPos > this.lProvincesMaxY.get(i)) continue;
                Font font = new Font("SansSerif", 1, 14);
                g2d.setFont(font);
                AffineTransform affinetransform = new AffineTransform();
                FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
                g2d.setColor(new Color(10, 10, 10, 255));
                g2d.fillRect(this.lProvincesCenterX.get(i) - 2 - (int)font.getStringBounds("" + i, frc).getWidth() / 2, this.lProvincesCenterY.get(i) - 2 - (int)font.getStringBounds("2500", frc).getHeight() / 2 + 1, (int)font.getStringBounds("" + i, frc).getWidth() + 4, (int)font.getStringBounds("" + i, frc).getHeight() / 2 + 2);
                g2d.fillRect(this.lProvincesCenterX.get(i) - 2 - (int)font.getStringBounds("" + i, frc).getWidth() / 2 + 1, this.lProvincesCenterY.get(i) - 2 - (int)font.getStringBounds("2500", frc).getHeight() / 2, (int)font.getStringBounds("" + i, frc).getWidth() + 2, 1);
                g2d.fillRect(this.lProvincesCenterX.get(i) - 2 - (int)font.getStringBounds("" + i, frc).getWidth() / 2 + 1, this.lProvincesCenterY.get(i) - 2 - (int)font.getStringBounds("2500", frc).getHeight() / 2 + (int)font.getStringBounds("" + i, frc).getHeight() / 2 + 3, (int)font.getStringBounds("" + i, frc).getWidth() + 2, 1);
                g2d.setColor(new Color(255, 255, 45, 255));
                g2d.drawString("" + i, this.lProvincesCenterX.get(i) - (int)font.getStringBounds("" + i, frc).getWidth() / 2, this.lProvincesCenterY.get(i) + 1);
            }
        }
    }

    private void drawCurrentArmy(Graphics g2d) {
        if (bDrawArmy) {
            Font font = new Font("SansSerif", 1, 14);
            g2d.setFont(font);
            AffineTransform affinetransform = new AffineTransform();
            FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
            g2d.setColor(new Color(10, 10, 10, 255));
            g2d.fillRect((this.iCurrentProvinceMaxX + this.iCurrentProvinceMinX) / 2 - 2 - (int)font.getStringBounds("XY", frc).getWidth() / 2 + this.iCurrentProvinceShiftArmyX, (this.iCurrentProvinceMaxY + this.iCurrentProvinceMinY) / 2 - 1 - (int)font.getStringBounds("XY", frc).getHeight() / 2 + this.iCurrentProvinceShiftArmyY, (int)font.getStringBounds("XY", frc).getWidth() + 4, (int)font.getStringBounds("XY", frc).getHeight() / 2 + 2);
            g2d.fillRect((this.iCurrentProvinceMaxX + this.iCurrentProvinceMinX) / 2 - 1 - (int)font.getStringBounds("XY", frc).getWidth() / 2 + this.iCurrentProvinceShiftArmyX, (this.iCurrentProvinceMaxY + this.iCurrentProvinceMinY) / 2 - 2 - (int)font.getStringBounds("XY", frc).getHeight() / 2 + this.iCurrentProvinceShiftArmyY, (int)font.getStringBounds("XY", frc).getWidth() + 2, 1);
            g2d.fillRect((this.iCurrentProvinceMaxX + this.iCurrentProvinceMinX) / 2 - 1 - (int)font.getStringBounds("XY", frc).getWidth() / 2 + this.iCurrentProvinceShiftArmyX, (this.iCurrentProvinceMaxY + this.iCurrentProvinceMinY) / 2 - 2 - (int)font.getStringBounds("XY", frc).getHeight() / 2 + (int)font.getStringBounds("XY", frc).getHeight() / 2 + 3 + this.iCurrentProvinceShiftArmyY, (int)font.getStringBounds("XY", frc).getWidth() + 2, 1);
            if (this.iCurrentProvinceShiftArmyX != 0 || this.iCurrentProvinceShiftArmyY != 0) {
                g2d.setColor(new Color(178, 50, 35, 255));
            } else {
                g2d.setColor(new Color(255, 255, 45, 255));
            }
            g2d.drawString("XY", (this.iCurrentProvinceMaxX + this.iCurrentProvinceMinX) / 2 - (int)font.getStringBounds("XY", frc).getWidth() / 2 + this.iCurrentProvinceShiftArmyX, (this.iCurrentProvinceMaxY + this.iCurrentProvinceMinY) / 2 + 1 + this.iCurrentProvinceShiftArmyY);
        }
    }

    private void drawTextInfo(Graphics g, Graphics g2d) {
        g2d = (Graphics2D)g.create();
        g2d.setColor(Color.BLACK);
        Font font = new Font("SansSerif", 1, 18);
        g2d.setFont(font);
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
        int iMax = font.getStringBounds("X: " + this.iLastPressedPosX + " | Y: " + this.iLastPressedPosY, frc).getWidth() > font.getStringBounds("Scale: " + this.fMapScale + " | S: " + this.iShiftXY, frc).getWidth() ? (int)font.getStringBounds("X: " + this.iLastPressedPosX + " | Y: " + this.iLastPressedPosY, frc).getWidth() : (int)font.getStringBounds("Scale: " + this.fMapScale + " | S: " + this.iShiftXY, frc).getWidth();
        g2d.setColor(new Color(10, 10, 10, 200));
        g2d.fillRect(GWIDTH - iMax - 10, 0, iMax + 10, (5 + (int)font.getStringBounds("AOC", frc).getHeight()) * 2 + 5);
        g2d.setColor(new Color(64, 64, 64, 255));
        g2d.drawRect(GWIDTH - iMax - 10, -1, iMax + 10, (5 + (int)font.getStringBounds("AOC", frc).getHeight()) * 2 + 5);
        g2d.setColor(new Color(240, 240, 240, 255));
        g2d.drawString("Scale: " + this.fMapScale + " | S: " + this.iShiftXY, GWIDTH - iMax - 5, (int)font.getStringBounds("Scale: " + this.fMapScale, frc).getHeight());
        g2d.drawString("X: " + this.iLastPressedPosX + " | Y: " + this.iLastPressedPosY, GWIDTH - (int)font.getStringBounds("X: " + this.iLastPressedPosX + " | Y: " + this.iLastPressedPosY, frc).getWidth() - 5, (int)font.getStringBounds("X: " + this.iLastPressedPosX + " | Y: " + this.iLastPressedPosY, frc).getHeight() * 2);
        Font font2 = new Font("SansSerif", 1, 14);
        g2d.setFont(font2);
        AffineTransform affinetransform2 = new AffineTransform();
        FontRenderContext frc2 = new FontRenderContext(affinetransform2, true, true);
        g2d.setColor(new Color(240, 240, 240, 75));
        g2d.drawString(this.topText, 5, 5 + (int)font2.getStringBounds(this.topText, frc2).getHeight());
        g2d.drawString(this.downText, 5, 10 + (int)font2.getStringBounds(this.topText, frc2).getHeight() * 2);
        try {
            Font font3 = new Font("SansSerif", 1, 34);
            g2d.setFont(font3);
            g2d.setColor(new Color(240, 240, 240, 255));
            g2d.drawString("Name: " + this.addCityName, GWIDTH / 2 - (int)font.getStringBounds("Name: " + this.addCityName, frc).getWidth() / 2, (int)font.getStringBounds("ABC", frc).getHeight() + 25);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawMode(Graphics g, Graphics g2d) {
        String modeText;
        g2d = (Graphics2D)g.create();
        Font font = new Font("SansSerif", 1, 20);
        g2d.setFont(font);
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
        if (this.bChangePointMode && this.bSelectedPointsToChangePosition) {
            g2d.setColor(new Color(34, 168, 20, 200));
        } else if (this.bAddPointToProvinceMode) {
            g2d.setColor(new Color(46, 51, 96, 200));
        } else if (this.bRemovePointMode) {
            g2d.setColor(Color.RED);
        } else {
            g2d.setColor(new Color(10, 10, 10, 200));
        }
        g2d.fillRect(0, 0, GWIDTH, 5 + (int)font.getStringBounds("AOC", frc).getHeight() + 5);
        if (this.iRemovedProvinceID >= 0 && !this.bChooseProvinceMode) {
            g2d.setColor(Color.white);
            modeText = "Now create a new province, it will be added in place of removed province ID: " + this.iRemovedProvinceID;
        } else {
            g2d.setColor(new Color(250, 78, 20, 255));
            modeText = "Mode: " + (this.bChangePointMode ? "Change Points Position" : (this.bChooseProvinceMode ? "Remove a Province" : (this.bAddPointToProvinceMode ? "Add Point To Province" : (this.bRemovePointMode ? "Remove Point" : ""))));
        }
        g2d.drawString(modeText, GWIDTH / 2 - (int)(font.getStringBounds(modeText, frc).getWidth() / 2.0), (int)font.getStringBounds("MODE:", frc).getHeight());
    }

    private void drawNeighboring(Graphics2D g2d) {
        if (this.neighboringProvincesReadyToUse) {
            for (int i = 0; i < this.neighboring.size(); ++i) {
                for (int j = 0; j < this.neighboring.get(i).size(); ++j) {
                    g2d.setColor(Color.BLACK);
                    g2d.drawLine(this.lProvincesCenterX.get(i), this.lProvincesCenterY.get(i), this.lProvincesCenterX.get(this.neighboring.get(i).get(j)), this.lProvincesCenterY.get(this.neighboring.get(i).get(j)));
                }
            }
        }
    }

    public static void loadConfigFile() {
        FileReader fr = null;
        String sLine = "";
        try {
            fr = new FileReader("MapEditorSettings.txt");
            BufferedReader bfr = new BufferedReader(fr);
            while ((sLine = bfr.readLine()) != null) {
                String[] tempR = sLine.split("=");
                try {
                    if (tempR[0].equals("MAP_NAME")) {
                        mapName = tempR[1];
                        fileName = mapName + "/data/ProvincePoints/ProvincePoints.txt";
                        fileNameJson = mapName + "/data/ProvincePoints/ProvincePoints.json";
                        sBackgroundImage = mapName + "/background/0_0.png";
                        continue;
                    }
                    if (tempR[0].equals("WIDTH")) {
                        GWIDTH = Integer.parseInt(tempR[1]);
                        continue;
                    }
                    if (tempR[0].equals("HEIGHT")) {
                        GHEIGHT = Integer.parseInt(tempR[1]);
                        continue;
                    }
                    if (tempR[0].equals("MAXIMUM_SIZE")) {
                        MAXIMUM_SIZE = Boolean.parseBoolean(tempR[1]);
                        continue;
                    }
                    if (tempR[0].equals("DRAW_POINTS")) {
                        bDrawProvincePoints = Boolean.parseBoolean(tempR[1]);
                        continue;
                    }
                    if (tempR[0].equals("DRAW_PROVINCE_ID")) {
                        bDrawArmy = Boolean.parseBoolean(tempR[1]);
                        continue;
                    }
                    if (tempR[0].equals("CUT_FROM_PROVINCE_MODE")) {
                        if (!Boolean.parseBoolean(tempR[1])) continue;
                        fileName = mapName + "/data/ProvincePoints_Cut/ProvincePoints_Cut.txt";
                        fileNameJson = mapName + "/data/ProvincePoints_Cut/ProvincePoints_Cut.json";
                        continue;
                    }
                    if (!tempR[0].equals("CONVERT_AOH2_MAP_PROVINCES_DATA_TO_AOH3") || !Boolean.parseBoolean(tempR[1])) continue;
                    CONVERT_AOH2_MAP_PROVINCES_DATA_TO_AOH3 = true;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            fr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GamePanel.loadBackgroundData();
        GamePanel.loadCities();
    }

    public static void loadBackgroundData() {
        FileReader fr = null;
        String sLine = "";
        try {
            fr = new FileReader(mapName + "/config.json");
            BufferedReader bfr = new BufferedReader(fr);
            while ((sLine = bfr.readLine()) != null) {
                String[] tempR = sLine.split(":");
                try {
                    if (tempR[0].contains("BackgroundSize_X")) {
                        BackgroundSize_X = Integer.parseInt(tempR[1].replaceAll("[^0-9]", ""));
                        continue;
                    }
                    if (!tempR[0].contains("BackgroundSize_Y")) continue;
                    BackgroundSize_Y = Integer.parseInt(tempR[1].replaceAll("[^0-9]", ""));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            fr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void loadCities() {
        int i;
        int tY;
        int tX;
        Object tName;
        BufferedReader bfr2;
        FileReader fr = null;
        String sLine = "";
        try {
            fr = new FileReader(mapName + "/cities/cities.json");
            bfr2 = new BufferedReader(fr);
            tName = "";
            tX = 0;
            tY = 0;
            while ((sLine = bfr2.readLine()) != null) {
                try {
                    if (sLine.indexOf("Name") >= 0) {
                        tName = "";
                        boolean startAdd = false;
                        for (i = 0; i < sLine.length(); ++i) {
                            if (sLine.charAt(i) == ':') {
                                startAdd = true;
                            }
                            if (!startAdd) continue;
                            tName = (String)tName + sLine.charAt(i);
                        }
                        tName = ((String)tName).substring(((String)tName).indexOf(34) + 1, ((String)tName).lastIndexOf(34));
                        continue;
                    }
                    if (sLine.indexOf(120) >= 0) {
                        Object tNum = "";
                        for (i = 0; i < sLine.length(); ++i) {
                            if (sLine.charAt(i) < '0' || sLine.charAt(i) > '9') continue;
                            tNum = (String)tNum + sLine.charAt(i);
                        }
                        tX = Integer.parseInt((String)tNum);
                        continue;
                    }
                    if (sLine.indexOf("y") < 0) continue;
                    Object tNum = "";
                    for (i = 0; i < sLine.length(); ++i) {
                        if (sLine.charAt(i) < '0' || sLine.charAt(i) > '9') continue;
                        tNum = (String)tNum + sLine.charAt(i);
                    }
                    tY = Integer.parseInt((String)tNum);
                    citiesX.add(tX);
                    citiesY.add(tY);
                    citiesNames.add((String)tName);
                }
                catch (IndexOutOfBoundsException tNum) {
                }
                catch (IllegalArgumentException tNum) {}
            }
            fr.close();
        }
        catch (IOException bfr2) {
            // empty catch block
        }
        try {
            fr = new FileReader(mapName + "/cities/cities_1.json");
            bfr2 = new BufferedReader(fr);
            tName = "";
            tX = 0;
            tY = 0;
            while ((sLine = bfr2.readLine()) != null) {
                try {
                    if (sLine.indexOf("Name") >= 0) {
                        tName = "";
                        boolean startAdd = false;
                        for (i = 0; i < sLine.length(); ++i) {
                            if (sLine.charAt(i) == ':') {
                                startAdd = true;
                            }
                            if (!startAdd) continue;
                            tName = (String)tName + sLine.charAt(i);
                        }
                        tName = ((String)tName).substring(((String)tName).indexOf(34) + 1, ((String)tName).lastIndexOf(34));
                        continue;
                    }
                    if (sLine.indexOf(120) >= 0) {
                        Object tNum = "";
                        for (i = 0; i < sLine.length(); ++i) {
                            if (sLine.charAt(i) < '0' || sLine.charAt(i) > '9') continue;
                            tNum = (String)tNum + sLine.charAt(i);
                        }
                        tX = Integer.parseInt((String)tNum);
                        continue;
                    }
                    if (sLine.indexOf("y") < 0) continue;
                    Object tNum = "";
                    for (i = 0; i < sLine.length(); ++i) {
                        if (sLine.charAt(i) < '0' || sLine.charAt(i) > '9') continue;
                        tNum = (String)tNum + sLine.charAt(i);
                    }
                    tY = Integer.parseInt((String)tNum);
                    citiesX.add(tX);
                    citiesY.add(tY);
                    citiesNames.add((String)tName);
                }
                catch (IndexOutOfBoundsException tNum) {
                }
                catch (IllegalArgumentException tNum) {}
            }
            fr.close();
        }
        catch (IOException bfr3) {
            // empty catch block
        }
        try {
            fr = new FileReader(mapName + "/cities/cities_2.json");
            bfr2 = new BufferedReader(fr);
            tName = "";
            tX = 0;
            tY = 0;
            while ((sLine = bfr2.readLine()) != null) {
                try {
                    if (sLine.indexOf("Name") >= 0) {
                        tName = "";
                        boolean startAdd = false;
                        for (i = 0; i < sLine.length(); ++i) {
                            if (sLine.charAt(i) == ':') {
                                startAdd = true;
                            }
                            if (!startAdd) continue;
                            tName = (String)tName + sLine.charAt(i);
                        }
                        tName = ((String)tName).substring(((String)tName).indexOf(34) + 1, ((String)tName).lastIndexOf(34));
                        continue;
                    }
                    if (sLine.indexOf(120) >= 0) {
                        Object tNum = "";
                        for (i = 0; i < sLine.length(); ++i) {
                            if (sLine.charAt(i) < '0' || sLine.charAt(i) > '9') continue;
                            tNum = (String)tNum + sLine.charAt(i);
                        }
                        tX = Integer.parseInt((String)tNum);
                        continue;
                    }
                    if (sLine.indexOf("y") < 0) continue;
                    Object tNum = "";
                    for (i = 0; i < sLine.length(); ++i) {
                        if (sLine.charAt(i) < '0' || sLine.charAt(i) > '9') continue;
                        tNum = (String)tNum + sLine.charAt(i);
                    }
                    tY = Integer.parseInt((String)tNum);
                    citiesX.add(tX);
                    citiesY.add(tY);
                    citiesNames.add((String)tName);
                }
                catch (IndexOutOfBoundsException tNum) {
                }
                catch (IllegalArgumentException tNum) {}
            }
            fr.close();
        }
        catch (IOException bfr4) {
            // empty catch block
        }
        try {
            fr = new FileReader(mapName + "/cities/cities_3.json");
            bfr2 = new BufferedReader(fr);
            tName = "";
            tX = 0;
            tY = 0;
            while ((sLine = bfr2.readLine()) != null) {
                try {
                    if (sLine.indexOf("Name") >= 0) {
                        tName = "";
                        boolean startAdd = false;
                        for (i = 0; i < sLine.length(); ++i) {
                            if (sLine.charAt(i) == ':') {
                                startAdd = true;
                            }
                            if (!startAdd) continue;
                            tName = (String)tName + sLine.charAt(i);
                        }
                        tName = ((String)tName).substring(((String)tName).indexOf(34) + 1, ((String)tName).lastIndexOf(34));
                        continue;
                    }
                    if (sLine.indexOf(120) >= 0) {
                        Object tNum = "";
                        for (i = 0; i < sLine.length(); ++i) {
                            if (sLine.charAt(i) < '0' || sLine.charAt(i) > '9') continue;
                            tNum = (String)tNum + sLine.charAt(i);
                        }
                        tX = Integer.parseInt((String)tNum);
                        continue;
                    }
                    if (sLine.indexOf("y") < 0) continue;
                    Object tNum = "";
                    for (i = 0; i < sLine.length(); ++i) {
                        if (sLine.charAt(i) < '0' || sLine.charAt(i) > '9') continue;
                        tNum = (String)tNum + sLine.charAt(i);
                    }
                    tY = Integer.parseInt((String)tNum);
                    citiesX.add(tX);
                    citiesY.add(tY);
                    citiesNames.add((String)tName);
                }
                catch (IndexOutOfBoundsException tNum) {
                }
                catch (IllegalArgumentException tNum) {}
            }
            fr.close();
        }
        catch (IOException bfr5) {
            // empty catch block
        }
        try {
            fr = new FileReader(mapName + "/cities/cities_4.json");
            bfr2 = new BufferedReader(fr);
            tName = "";
            tX = 0;
            tY = 0;
            while ((sLine = bfr2.readLine()) != null) {
                try {
                    if (sLine.indexOf("Name") >= 0) {
                        tName = "";
                        boolean startAdd = false;
                        for (i = 0; i < sLine.length(); ++i) {
                            if (sLine.charAt(i) == ':') {
                                startAdd = true;
                            }
                            if (!startAdd) continue;
                            tName = (String)tName + sLine.charAt(i);
                        }
                        tName = ((String)tName).substring(((String)tName).indexOf(34) + 1, ((String)tName).lastIndexOf(34));
                        continue;
                    }
                    if (sLine.indexOf(120) >= 0) {
                        Object tNum = "";
                        for (i = 0; i < sLine.length(); ++i) {
                            if (sLine.charAt(i) < '0' || sLine.charAt(i) > '9') continue;
                            tNum = (String)tNum + sLine.charAt(i);
                        }
                        tX = Integer.parseInt((String)tNum);
                        continue;
                    }
                    if (sLine.indexOf("y") < 0) continue;
                    Object tNum = "";
                    for (i = 0; i < sLine.length(); ++i) {
                        if (sLine.charAt(i) < '0' || sLine.charAt(i) > '9') continue;
                        tNum = (String)tNum + sLine.charAt(i);
                    }
                    tY = Integer.parseInt((String)tNum);
                    citiesX.add(tX);
                    citiesY.add(tY);
                    citiesNames.add((String)tName);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            fr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void loadCities_AoH2() {
        int i;
        FileReader fr = null;
        String sLine = "";
        ArrayList<Object> citiesNames_AoH2 = new ArrayList<Object>();
        ArrayList<Integer> citiesX_AoH2 = new ArrayList<Integer>();
        ArrayList<Integer> citiesY_AoH2 = new ArrayList<Integer>();
        try {
            fr = new FileReader(mapName + "/cities/cities_AoH2.json");
            BufferedReader bfr = new BufferedReader(fr);
            Object tName = "";
            int tX = 0;
            int tY = 0;
            while ((sLine = bfr.readLine()) != null) {
                try {
                    int i2;
                    if (sLine.indexOf("Name") >= 0) {
                        tName = "";
                        boolean startAdd = false;
                        for (i2 = 0; i2 < sLine.length(); ++i2) {
                            if (sLine.charAt(i2) == ':') {
                                startAdd = true;
                            }
                            if (!startAdd) continue;
                            tName = (String)tName + sLine.charAt(i2);
                        }
                        tName = ((String)tName).substring(((String)tName).indexOf(34) + 1, ((String)tName).lastIndexOf(34));
                        continue;
                    }
                    if (sLine.indexOf(120) >= 0) {
                        Object tNum = "";
                        for (i2 = 0; i2 < sLine.length(); ++i2) {
                            if (sLine.charAt(i2) < '0' || sLine.charAt(i2) > '9') continue;
                            tNum = (String)tNum + sLine.charAt(i2);
                        }
                        tX = Integer.parseInt((String)tNum);
                        continue;
                    }
                    if (sLine.indexOf("y") < 0) continue;
                    Object tNum = "";
                    for (i2 = 0; i2 < sLine.length(); ++i2) {
                        if (sLine.charAt(i2) < '0' || sLine.charAt(i2) > '9') continue;
                        tNum = (String)tNum + sLine.charAt(i2);
                    }
                    tY = Integer.parseInt((String)tNum);
                    citiesX_AoH2.add(tX);
                    citiesY_AoH2.add(tY);
                    citiesNames_AoH2.add(tName);
                }
                catch (IndexOutOfBoundsException tNum) {
                }
                catch (IllegalArgumentException tNum) {}
            }
            fr.close();
        }
        catch (IOException bfr) {
            // empty catch block
        }
        ArrayList<String> citiesNames_Sorted = new ArrayList<String>();
        ArrayList<Integer> citiesX_Sorted = new ArrayList<Integer>();
        ArrayList<Integer> citiesY_Sorted = new ArrayList<Integer>();
        block9: for (i = 0; i < citiesNames.size(); ++i) {
            for (int a = 0; a < citiesNames_AoH2.size(); ++a) {
                if (!((String)citiesNames_AoH2.get(a)).equals(citiesNames.get(i))) continue;
                citiesNames_Sorted.add(citiesNames.get(i));
                citiesX_Sorted.add(citiesX.get(i));
                citiesY_Sorted.add(citiesY.get(i));
                citiesNames.remove(i);
                citiesX.remove(i);
                citiesY.remove(i);
                --i;
                continue block9;
            }
        }
        for (i = 0; i < citiesNames.size(); ++i) {
            citiesNames_Sorted.add(citiesNames.get(i));
            citiesX_Sorted.add(citiesX.get(i));
            citiesY_Sorted.add(citiesY.get(i));
        }
        citiesNames.clear();
        citiesX.clear();
        citiesY.clear();
        citiesNames = citiesNames_Sorted;
        citiesX = citiesX_Sorted;
        citiesY = citiesY_Sorted;
    }

    private String clearProvincePointsText(String sLine, String extra) {
        sLine = sLine.replace("\t", "");
        sLine = sLine.replace(" ", "");
        sLine = sLine.replace("[", "");
        sLine = sLine.replace("]", "");
        sLine = sLine.replace(extra, "");
        return sLine;
    }

    private void loadProvincesFromFile() {
        int i;
        this.vProvinces = new Vector();
        FileReader fr = null;
        String sLine = "";
        this.lProvincesPointsX.clear();
        this.lProvincesPointsY.clear();
        if (!CONVERT_AOH2_MAP_PROVINCES_DATA_TO_AOH3) {
            for (i = 0; i < 5000 && this.loadProvincesFromFile(i); ++i) {
            }
            this.buildProvinceColors();
        } else {
            try {
                fr = new FileReader("convertMapData.txt");
                BufferedReader bfr = new BufferedReader(fr);
                while ((sLine = bfr.readLine()) != null) {
                    int i2;
                    ArrayList<Integer> tempPointsX = new ArrayList<Integer>();
                    ArrayList<Integer> tempPointsY = new ArrayList<Integer>();
                    String[] sX = sLine.split(",");
                    int nSize = sX.length;
                    for (i2 = 0; i2 < nSize; ++i2) {
                        tempPointsX.add(Integer.parseInt(sX[i2]));
                    }
                    sLine = bfr.readLine();
                    sX = sLine.split(",");
                    nSize = sX.length;
                    for (i2 = 0; i2 < nSize; ++i2) {
                        tempPointsY.add(Integer.parseInt(sX[i2]));
                    }
                    GeneralPath nPath = new GeneralPath();
                    int nSize2 = sX.length;
                    for (int i3 = 0; i3 < nSize2; ++i3) {
                        if (i3 == 0) {
                            nPath.moveTo(((Integer)tempPointsX.get(i3)).intValue(), ((Integer)tempPointsY.get(i3)).intValue());
                            continue;
                        }
                        nPath.lineTo(((Integer)tempPointsX.get(i3)).intValue(), ((Integer)tempPointsY.get(i3)).intValue());
                    }
                    this.vProvinces.add(nPath);
                    this.lProvincesPointsX.add(tempPointsX);
                    this.lProvincesPointsY.add(tempPointsY);
                }
                this.buildProvinceColors();
                fr.close();
            }
            catch (IOException bfr) {
                // empty catch block
            }
        }
        for (i = 0; i < this.vProvinces.size(); ++i) {
            int tempMinX = 1000000000;
            int tempMaxX = -1000000000;
            int tempMinY = 1000000000;
            int tempMaxY = -1000000000;
            for (int j = 0; j < this.lProvincesPointsX.get(i).size(); ++j) {
                if (this.lProvincesPointsX.get(i).get(j) < tempMinX) {
                    tempMinX = this.lProvincesPointsX.get(i).get(j);
                }
                if (this.lProvincesPointsX.get(i).get(j) > tempMaxX) {
                    tempMaxX = this.lProvincesPointsX.get(i).get(j);
                }
                if (this.lProvincesPointsY.get(i).get(j) < tempMinY) {
                    tempMinY = this.lProvincesPointsY.get(i).get(j);
                }
                if (this.lProvincesPointsY.get(i).get(j) <= tempMaxY) continue;
                tempMaxY = this.lProvincesPointsY.get(i).get(j);
            }
            this.lProvincesMaxX.add(tempMaxX);
            this.lProvincesMaxY.add(tempMaxY);
            this.lProvincesMinX.add(tempMinX);
            this.lProvincesMinY.add(tempMinY);
            this.lProvincesCenterX.add((tempMaxX + tempMinX) / 2);
            this.lProvincesCenterY.add((tempMaxY + tempMinY) / 2);
        }
    }

    public final boolean loadProvincesFromFile(int id) {
        FileReader fr = null;
        String sLine = "";
        try {
            fr = new FileReader(fileNameJson.substring(0, fileNameJson.indexOf(".json")) + (String)(id > 0 ? "_" + id : "") + ".json");
            BufferedReader bfr = new BufferedReader(fr);
            while ((sLine = bfr.readLine()) != null) {
                int i;
                ArrayList<Integer> tempPointsX = new ArrayList<Integer>();
                ArrayList<Integer> tempPointsY = new ArrayList<Integer>();
                if (!sLine.contains("pX")) continue;
                sLine = this.clearProvincePointsText(sLine, "pX:");
                String[] sX = sLine.split(",");
                int nSize = sX.length;
                for (i = 0; i < nSize; ++i) {
                    tempPointsX.add(Integer.parseInt(sX[i]));
                }
                sLine = bfr.readLine();
                sLine = this.clearProvincePointsText(sLine, "pY:");
                sX = sLine.split(",");
                nSize = sX.length;
                for (i = 0; i < nSize; ++i) {
                    tempPointsY.add(Integer.parseInt(sX[i]));
                }
                GeneralPath nPath = new GeneralPath();
                int nSize2 = sX.length;
                for (int i2 = 0; i2 < nSize2; ++i2) {
                    if (i2 == 0) {
                        nPath.moveTo(((Integer)tempPointsX.get(i2)).intValue(), ((Integer)tempPointsY.get(i2)).intValue());
                        continue;
                    }
                    nPath.lineTo(((Integer)tempPointsX.get(i2)).intValue(), ((Integer)tempPointsY.get(i2)).intValue());
                }
                System.out.println("ADD PROVINCE ");
                this.vProvinces.add(nPath);
                this.lProvincesPointsX.add(tempPointsX);
                this.lProvincesPointsY.add(tempPointsY);
                System.out.println("ADD PROVINCE END");
            }
            fr.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void buildProvinceColors() {
        Random oR = new Random();
        this.pathR.clear();
        this.pathG.clear();
        this.pathB.clear();
        for (int i = 0; i < this.vProvinces.size(); ++i) {
            this.pathR.add(oR.nextInt(255));
            this.pathG.add(oR.nextInt(255));
            this.pathB.add(oR.nextInt(255));
            this.isInView.add(false);
        }
    }

    private void addColor() {
        Random oR = new Random();
        this.pathR.add(oR.nextInt(255));
        this.pathG.add(oR.nextInt(255));
        this.pathB.add(oR.nextInt(255));
        this.isInView.add(false);
    }

    private void addKeyListener() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 87: {
                        GamePanel.this.iYMapPos -= GamePanel.this.iShiftXY;
                        break;
                    }
                    case 83: {
                        GamePanel.this.iYMapPos += GamePanel.this.iShiftXY;
                        break;
                    }
                    case 65: {
                        GamePanel.this.iXMapPos -= GamePanel.this.iShiftXY;
                        break;
                    }
                    case 68: {
                        GamePanel.this.iXMapPos += GamePanel.this.iShiftXY;
                        break;
                    }
                    case 40: {
                        GamePanel.this.iYMapPos += GamePanel.this.iShiftXY;
                        break;
                    }
                    case 38: {
                        GamePanel.this.iYMapPos -= GamePanel.this.iShiftXY;
                        break;
                    }
                    case 37: {
                        GamePanel.this.iXMapPos -= GamePanel.this.iShiftXY;
                        break;
                    }
                    case 39: {
                        GamePanel.this.iXMapPos += GamePanel.this.iShiftXY;
                        break;
                    }
                    case 16: 
                    case 69: {
                        ++GamePanel.this.iShiftXY;
                        break;
                    }
                    case 27: 
                    case 81: {
                        --GamePanel.this.iShiftXY;
                        break;
                    }
                    case 32: {
                        GamePanel.this.bDrawProvinces = !GamePanel.this.bDrawProvinces;
                        break;
                    }
                    case 79: {
                        bDrawProvincePoints = !bDrawProvincePoints;
                        break;
                    }
                    case 67: {
                        bDrawCities = !bDrawCities;
                        break;
                    }
                    case 86: {
                        bDrawCitiesNames = !bDrawCitiesNames;
                        break;
                    }
                    case 90: {
                        GamePanel.this.drawBG = !GamePanel.this.drawBG;
                        break;
                    }
                    case 76: {
                        GamePanel.this.buildProvinceColors();
                        break;
                    }
                    case 89: {
                        GamePanel.this.autoPath();
                        break;
                    }
                    case 80: {
                        bDrawArmy = !bDrawArmy;
                        break;
                    }
                    case 73: {
                        GamePanel.this.drawNeighboring = !GamePanel.this.drawNeighboring;
                        break;
                    }
                    case 74: {
                        if (!GamePanel.this.bChooseProvinceMode) {
                            GamePanel.this.resetModes();
                        }
                        GamePanel.this.bChooseProvinceMode = !GamePanel.this.bChooseProvinceMode;
                        break;
                    }
                    case 88: {
                        GamePanel.this.drawBGMain = !GamePanel.this.drawBGMain;
                        break;
                    }
                    case 116: {
                        if (!GamePanel.this.drawBGMain) break;
                        GamePanel.this.buildHaveCity();
                        break;
                    }
                    case 75: {
                        GamePanel.this.iActiveProvinceID = -1;
                        break;
                    }
                    case 127: {
                        block31: for (int i = 0; i < GamePanel.this.vProvinces.size(); ++i) {
                            for (int j = 0; j < GamePanel.this.lProvincesPointsX.get(i).size(); ++j) {
                                if (GamePanel.this.lProvincesPointsX.get(i).get(j) != (int)((float)GamePanel.this.iMousePosX / GamePanel.this.fMapScale + (float)GamePanel.this.iXMapPos) || GamePanel.this.lProvincesPointsY.get(i).get(j) != (int)((float)GamePanel.this.iMousePosY / GamePanel.this.fMapScale + (float)GamePanel.this.iYMapPos)) continue;
                                GamePanel.this.lProvincesPointsX.get(i).remove(j);
                                GamePanel.this.lProvincesPointsY.get(i).remove(j);
                                GamePanel.this.rebuildPath(i);
                                continue block31;
                            }
                        }
                        break;
                    }
                    case 10: {
                        GamePanel.this.saveCitiesJson();
                        break;
                    }
                    case 77: {
                        if (!GamePanel.this.bChangePointMode) {
                            GamePanel.this.resetModes();
                        }
                        GamePanel.this.bChangePointMode = !GamePanel.this.bChangePointMode;
                        break;
                    }
                    case 78: {
                        if (!GamePanel.this.bAddPointToProvinceMode) {
                            GamePanel.this.resetModes();
                        }
                        GamePanel.this.bAddPointToProvinceMode = !GamePanel.this.bAddPointToProvinceMode;
                        break;
                    }
                    case 66: {
                        if (!GamePanel.this.bRemovePointMode) {
                            GamePanel.this.resetModes();
                        }
                        GamePanel.this.bRemovePointMode = !GamePanel.this.bRemovePointMode;
                        break;
                    }
                    case 8: {
                        if (GamePanel.this.currentPointsX.size() <= 0) break;
                        GamePanel.this.currentPointsX.remove(GamePanel.this.currentPointsX.size() - 1);
                        GamePanel.this.currentPointsY.remove(GamePanel.this.currentPointsY.size() - 1);
                        if (GamePanel.this.currentPointsX.size() > 0) {
                            GamePanel.this.iLastPressedPosX = GamePanel.this.currentPointsX.get(GamePanel.this.currentPointsX.size() - 1);
                            GamePanel.this.iLastPressedPosY = GamePanel.this.currentPointsY.get(GamePanel.this.currentPointsY.size() - 1);
                        }
                        --GamePanel.this.currentProvincePoints;
                        GamePanel.this.rebuildCurrentProvince();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    private void addWheelListener() {
        this.addMouseWheelListener(e -> {
            int steps = e.getWheelRotation();
            if (this.fMapScale > 1.0f) {
                this.fMapScale = (int)this.fMapScale;
                this.fMapScale -= (float)steps;
            } else if (this.fMapScale < 0.1f) {
                this.fMapScale = 0.1f;
            } else if (steps < 0) {
                this.fMapScale += 0.05f;
                if (this.fMapScale > 1.0f) {
                    this.fMapScale = 2.0f;
                }
            } else {
                this.fMapScale -= 0.05f;
                if (this.fMapScale < 0.1f) {
                    this.fMapScale = 0.1f;
                }
            }
        });
    }

    private void addMotionListener() {
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                GamePanel.this.iMousePosX = e.getX();
                GamePanel.this.iMousePosY = e.getY();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
    }

    private void addMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) == 16) {
                    GamePanel.this.iLastPressedPosX = (int)((float)GamePanel.this.iXMapPos + (float)GamePanel.this.iMousePosX / GamePanel.this.fMapScale);
                    GamePanel.this.iLastPressedPosY = (int)((float)GamePanel.this.iYMapPos + (float)GamePanel.this.iMousePosY / GamePanel.this.fMapScale);
                }
                if ((modifiers & 4) == 4) {
                    GamePanel.this.iXMapPos = (int)((float)GamePanel.this.iMousePosX / GamePanel.this.fMapScale + (float)GamePanel.this.iXMapPos);
                    GamePanel.this.iYMapPos = (int)((float)GamePanel.this.iMousePosY / GamePanel.this.fMapScale + (float)GamePanel.this.iYMapPos);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    private void addPointToCurrentProvince(int nX, int nY) {
        this.currentPointsX.add(nX);
        this.currentPointsY.add(nY);
        if (this.currentProvincePoints == 0) {
            this.currentProvince = new GeneralPath();
            this.currentProvince.moveTo((int)((float)this.iXMapPos + (float)this.iMousePosX / this.fMapScale), (int)((float)this.iYMapPos + (float)this.iMousePosY / this.fMapScale));
            this.iCurrentProvinceMaxX = this.iCurrentProvinceMinX = (int)((float)this.iXMapPos + (float)this.iMousePosX / this.fMapScale);
            this.iCurrentProvinceMaxY = this.iCurrentProvinceMinY = (int)((float)this.iYMapPos + (float)this.iMousePosY / this.fMapScale);
        } else {
            this.currentProvince.lineTo(nX, nY);
            if (this.iCurrentProvinceMaxX < this.currentPointsX.get(this.currentPointsX.size() - 1)) {
                this.iCurrentProvinceMaxX = this.currentPointsX.get(this.currentPointsX.size() - 1);
            }
            if (this.iCurrentProvinceMinX > this.currentPointsX.get(this.currentPointsX.size() - 1)) {
                this.iCurrentProvinceMinX = this.currentPointsX.get(this.currentPointsX.size() - 1);
            }
            if (this.iCurrentProvinceMaxY < this.currentPointsY.get(this.currentPointsY.size() - 1)) {
                this.iCurrentProvinceMaxY = this.currentPointsY.get(this.currentPointsY.size() - 1);
            }
            if (this.iCurrentProvinceMinY > this.currentPointsY.get(this.currentPointsY.size() - 1)) {
                this.iCurrentProvinceMinY = this.currentPointsY.get(this.currentPointsY.size() - 1);
            }
        }
        ++this.currentProvincePoints;
    }

    private void updateCurrentProvinceCenterPoint() {
        if (this.currentPointsX.size() > 0) {
            this.iCurrentProvinceMaxX = this.iCurrentProvinceMinX = this.currentPointsX.get(0).intValue();
            this.iCurrentProvinceMaxY = this.iCurrentProvinceMinY = this.currentPointsY.get(0).intValue();
            for (int i = 1; i < this.currentPointsX.size(); ++i) {
                if (this.iCurrentProvinceMaxX < this.currentPointsX.get(i)) {
                    this.iCurrentProvinceMaxX = this.currentPointsX.get(i);
                }
                if (this.iCurrentProvinceMinX > this.currentPointsX.get(i)) {
                    this.iCurrentProvinceMinX = this.currentPointsX.get(i);
                }
                if (this.iCurrentProvinceMaxY < this.currentPointsY.get(i)) {
                    this.iCurrentProvinceMaxY = this.currentPointsY.get(i);
                }
                if (this.iCurrentProvinceMinY <= this.currentPointsY.get(i)) continue;
                this.iCurrentProvinceMinY = this.currentPointsY.get(i);
            }
        }
    }

    private void rebuildCurrentProvince() {
        int iSize = this.currentPointsX.size();
        for (int i = 0; i < iSize; ++i) {
            if (i == 0) {
                this.currentProvince = new GeneralPath();
                this.currentProvince.moveTo(this.currentPointsX.get(i).intValue(), this.currentPointsY.get(i).intValue());
                continue;
            }
            this.currentProvince.lineTo(this.currentPointsX.get(i).intValue(), this.currentPointsY.get(i).intValue());
        }
        this.updateCurrentProvinceCenterPoint();
    }

    private void rebuildPath(int id) {
        GeneralPath oP = new GeneralPath();
        int iSize = this.lProvincesPointsX.get(id).size();
        for (int i = 0; i < iSize; ++i) {
            if (i == 0) {
                oP.moveTo(this.lProvincesPointsX.get(id).get(i).intValue(), this.lProvincesPointsY.get(id).get(i).intValue());
                continue;
            }
            oP.lineTo(this.lProvincesPointsX.get(id).get(i).intValue(), this.lProvincesPointsY.get(id).get(i).intValue());
        }
        this.vProvinces.set(id, oP);
    }

    private void removePoint() {
        for (int i = 0; i < this.vProvinces.size(); ++i) {
            for (int j = 0; j < this.lProvincesPointsX.get(i).size(); ++j) {
                if (this.lProvincesPointsX.get(i).get(j) != this.iLastPressedPosX || this.lProvincesPointsY.get(i).get(j) != this.iLastPressedPosY) continue;
                ArrayList<Integer> tempPointsX = new ArrayList<Integer>();
                ArrayList<Integer> tempPointsY = new ArrayList<Integer>();
                for (int a = 0; a < this.lProvincesPointsX.get(i).size(); ++a) {
                    if (a == j) continue;
                    tempPointsX.add(this.lProvincesPointsX.get(i).get(a));
                    tempPointsY.add(this.lProvincesPointsY.get(i).get(a));
                }
                this.lProvincesPointsX.set(i, tempPointsX);
                this.lProvincesPointsY.set(i, tempPointsY);
                this.rebuildPath(i);
            }
        }
    }

    private void addPointToProvince() {
        block0: for (int i = 0; i < this.vProvinces.size(); ++i) {
            for (int j = 0; j < this.lProvincesPointsX.get(i).size(); ++j) {
                if (this.lProvincesPointsX.get(i).get(j) != this.iLastPressedPosX || this.lProvincesPointsY.get(i).get(j) != this.iLastPressedPosY) continue;
                ArrayList<Integer> tempPointsX = new ArrayList<Integer>();
                ArrayList<Integer> tempPointsY = new ArrayList<Integer>();
                for (int a = 0; a < this.lProvincesPointsX.get(i).size(); ++a) {
                    tempPointsX.add(this.lProvincesPointsX.get(i).get(a));
                    tempPointsY.add(this.lProvincesPointsY.get(i).get(a));
                    if (a != j) continue;
                    tempPointsX.add(this.lProvincesPointsX.get(i).get(a) + 1);
                    tempPointsY.add(this.lProvincesPointsY.get(i).get(a));
                }
                this.lProvincesPointsX.set(i, tempPointsX);
                this.lProvincesPointsY.set(i, tempPointsY);
                this.rebuildPath(i);
                continue block0;
            }
        }
    }

    private void changePointPosition() {
        if (this.bSelectedPointsToChangePosition) {
            for (int i = 0; i < this.vProvinces.size(); ++i) {
                for (int j = 0; j < this.lProvincesPointsX.get(i).size(); ++j) {
                    if (this.lProvincesPointsX.get(i).get(j) != this.iChangePositionX || this.lProvincesPointsY.get(i).get(j) != this.iChangePositionY) continue;
                    this.lProvincesPointsX.get(i).set(j, this.iLastPressedPosX);
                    this.lProvincesPointsY.get(i).set(j, this.iLastPressedPosY);
                    this.rebuildPath(i);
                }
            }
            this.bSelectedPointsToChangePosition = false;
        } else {
            this.iChangePositionX = this.iLastPressedPosX;
            this.iChangePositionY = this.iLastPressedPosY;
            for (int i = 0; i < this.vProvinces.size(); ++i) {
                for (int j = 0; j < this.lProvincesPointsX.get(i).size(); ++j) {
                    if (this.lProvincesPointsX.get(i).get(j) != this.iChangePositionX || this.lProvincesPointsY.get(i).get(j) != this.iChangePositionY) continue;
                    this.bSelectedPointsToChangePosition = true;
                    return;
                }
            }
        }
    }

    private void setProvinceID() {
        for (int i = 0; i < this.vProvinces.size(); ++i) {
            if (!this.pathContains(this.iLastPressedPosX, this.iLastPressedPosY, i)) continue;
            this.iRemovedProvinceID = i;
            GeneralPath nPath = new GeneralPath();
            nPath.moveTo(0.0f, 0.0f);
            nPath.lineTo(1.0f, 0.0f);
            nPath.lineTo(1.0f, 1.0f);
            nPath.lineTo(0.0f, 1.0f);
            this.vProvinces.set(i, nPath);
            this.lProvincesPointsX.set(i, new ArrayList());
            this.lProvincesPointsY.set(i, new ArrayList());
            this.lProvincesCenterX.set(i, 0);
            this.lProvincesCenterY.set(i, 0);
            this.lProvincesMinX.set(i, 0);
            this.lProvincesMinY.set(i, 0);
            this.lProvincesMaxX.set(i, 0);
            this.lProvincesMaxY.set(i, 0);
            for (int k = 1; k < 10; ++k) {
                File myObj = new File(mapName + "/data/scales/" + k + "/" + this.iRemovedProvinceID);
                myObj.delete();
            }
            this.bChooseProvinceMode = false;
            return;
        }
    }

    private final void moveAllProvinces(int nX, int nY) {
        for (int i = this.vProvinces.size() - 1; i >= 0; --i) {
            for (int a = 0; a < this.lProvincesPointsX.get(i).size(); ++a) {
                this.lProvincesPointsX.get(i).set(a, this.lProvincesPointsX.get(i).get(a) + nX);
                this.lProvincesPointsY.get(i).set(a, this.lProvincesPointsY.get(i).get(a) + nY);
            }
        }
    }

    private final void removeAllProvincesOutsideTheBox(int nX, int nY, int nX2, int nY2) {
        for (int i = this.vProvinces.size() - 1; i >= 0; --i) {
            if (nX <= this.lProvincesMinX.get(i) && this.lProvincesMaxX.get(i) <= nX2 && nY <= this.lProvincesMinY.get(i) && this.lProvincesMaxY.get(i) <= nY2) {
                for (int a = 0; a < this.lProvincesPointsX.get(i).size(); ++a) {
                    this.lProvincesPointsX.get(i).set(a, this.lProvincesPointsX.get(i).get(a) * 2);
                    this.lProvincesPointsY.get(i).set(a, this.lProvincesPointsY.get(i).get(a) * 2);
                }
                continue;
            }
            this.vProvinces.remove(i);
            this.lProvincesPointsX.remove(i);
            this.lProvincesPointsY.remove(i);
            this.lProvincesCenterX.remove(i);
            this.lProvincesCenterY.remove(i);
            this.lProvincesMinX.remove(i);
            this.lProvincesMinY.remove(i);
            this.lProvincesMaxX.remove(i);
            this.lProvincesMaxY.remove(i);
        }
    }

    private boolean pathContains(int nX, int nY, int nProvinceID) {
        boolean output = false;
        int i = 0;
        int j = this.lProvincesPointsX.get(nProvinceID).size() - 1;
        int iSize = this.lProvincesPointsX.get(nProvinceID).size();
        while (i < iSize) {
            if (this.lProvincesPointsY.get(nProvinceID).get(i) > nY != this.lProvincesPointsY.get(nProvinceID).get(j) > nY && nX < (this.lProvincesPointsX.get(nProvinceID).get(j) - this.lProvincesPointsX.get(nProvinceID).get(i)) * (nY - this.lProvincesPointsY.get(nProvinceID).get(i)) / (this.lProvincesPointsY.get(nProvinceID).get(j) - this.lProvincesPointsY.get(nProvinceID).get(i)) + this.lProvincesPointsX.get(nProvinceID).get(j)) {
                output = !output;
            }
            j = i++;
        }
        return output;
    }

    private void saveProv() {
        FileWriter fw = null;
        try {
            int i;
            fw = new FileWriter("" + this.lProvincesPointsX.size());
            BufferedWriter bw = new BufferedWriter(fw);
            int nSize = this.currentPointsX.size();
            for (i = 0; i < nSize; ++i) {
                bw.write(String.valueOf(this.currentPointsX.get(i)) + (i != nSize - 1 ? "," : ""));
            }
            bw.write(";");
            nSize = this.currentPointsY.size();
            for (i = 0; i < nSize; ++i) {
                bw.write(String.valueOf(this.currentPointsY.get(i)) + (i != nSize - 1 ? "," : ""));
            }
            bw.close();
            fw.close();
        }
        catch (IOException ex) {
            System.out.println("AoCC");
        }
    }

    private void saveProvinces() {
        FileWriter fw = null;
        try {
            int i;
            fw = new FileWriter(fileName);
            BufferedWriter bw = new BufferedWriter(fw);
            int nSize = this.lProvincesPointsX.size();
            for (i = 0; i < nSize; ++i) {
                int j;
                int jSize = this.lProvincesPointsX.get(i).size();
                for (j = 0; j < jSize; ++j) {
                    bw.write(String.valueOf(this.lProvincesPointsX.get(i).get(j)) + (j != jSize - 1 ? "," : ""));
                }
                bw.newLine();
                jSize = this.lProvincesPointsY.get(i).size();
                for (j = 0; j < jSize; ++j) {
                    bw.write(String.valueOf(this.lProvincesPointsY.get(i).get(j)) + (j != jSize - 1 ? "," : ""));
                }
                if (i == nSize - 1) continue;
                bw.newLine();
            }
            if (this.currentProvincePoints > 1) {
                bw.newLine();
                nSize = this.currentPointsX.size();
                for (i = 0; i < nSize; ++i) {
                    bw.write(String.valueOf(this.currentPointsX.get(i)) + (i != nSize - 1 ? "," : ""));
                }
                bw.newLine();
                nSize = this.currentPointsY.size();
                for (i = 0; i < nSize; ++i) {
                    bw.write(String.valueOf(this.currentPointsY.get(i)) + (i != nSize - 1 ? "," : ""));
                }
            }
            bw.close();
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.clearCurrentData();
    }

    private void saveProvincesJson() {
        this.clearCurrentData();
        FileWriter fw = null;
        try {
            fw = new FileWriter(fileNameJson);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("{");
            bw.newLine();
            bw.write("\tAge_of_History: Data,");
            bw.newLine();
            bw.write("\t\tData: [");
            bw.newLine();
            int nProvinceID = 0;
            int nSize = this.lProvincesPointsX.size();
            for (int i = 0; i < nSize; ++i) {
                int j;
                if (this.lProvincesPointsX.get(i).size() == 0) continue;
                bw.write("\t\t{");
                bw.newLine();
                bw.write("\t\t\tiProvinceID: " + nProvinceID++ + ",");
                bw.newLine();
                bw.write("\t\t\tlPointsX: [");
                int jSize = this.lProvincesPointsX.get(i).size();
                for (j = 0; j < jSize; ++j) {
                    bw.write(String.valueOf(this.lProvincesPointsX.get(i).get(j)) + (j != jSize - 1 ? "," : ""));
                }
                bw.write("],");
                bw.newLine();
                bw.write("\t\t\tlPointsY: [");
                jSize = this.lProvincesPointsY.get(i).size();
                for (j = 0; j < jSize; ++j) {
                    bw.write(String.valueOf(this.lProvincesPointsY.get(i).get(j)) + (j != jSize - 1 ? "," : ""));
                }
                bw.write("]");
                bw.newLine();
                bw.write("\t\t},");
                bw.newLine();
            }
            bw.write("\t]");
            bw.newLine();
            bw.write("}");
            bw.close();
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveCitiesJson() {
        if (this.addCityName == null || this.addCityName.length() < 1) {
            return;
        }
        if (this.addCityName.charAt(this.addCityName.length() - 1) == ' ') {
            this.addCityName = this.addCityName.substring(0, this.addCityName.length() - 1);
        }
        boolean addCity = true;
        for (int i = 0; i < citiesX.size(); ++i) {
            if (citiesX.get(i) != this.iLastPressedPosX || citiesY.get(i) != this.iLastPressedPosY) continue;
            addCity = false;
            break;
        }
        if (!addCity) {
            return;
        }
        this.clearCurrentData();
        FileWriter fw = null;
        try {
            fw = new FileWriter(mapName + "/cities/cities.json");
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("{");
            bw.newLine();
            bw.write("\tcities:");
            bw.newLine();
            bw.write("\t[");
            bw.newLine();
            citiesNames.add(this.addCityName);
            citiesX.add(this.iLastPressedPosX);
            citiesY.add(this.iLastPressedPosY);
            for (int i = 0; i < citiesNames.size(); ++i) {
                bw.write("\t\t{");
                bw.newLine();
                bw.write("\t\t\tName: \"" + citiesNames.get(i) + "\",");
                bw.newLine();
                bw.write("\t\t\tx: " + String.valueOf(citiesX.get(i)) + ",");
                bw.newLine();
                bw.write("\t\t\ty: " + String.valueOf(citiesY.get(i)));
                bw.newLine();
                bw.write("\t\t},");
                bw.newLine();
            }
            bw.write("\t],");
            bw.newLine();
            bw.write("\tname: Earth");
            bw.newLine();
            bw.write("}");
            bw.close();
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void autoPath() {
        int startID = 0;
        int iSize = this.lProvincesPointsX.size();
        for (int i = 0; i < iSize; ++i) {
            boolean found = false;
            int kSize = this.lProvincesPointsX.get(i).size();
            for (int k = 0; k < kSize; ++k) {
                if (!Objects.equals(this.currentPointsX.get(this.currentPointsX.size() - 1), this.lProvincesPointsX.get(i).get(k)) || !Objects.equals(this.currentPointsY.get(this.currentPointsY.size() - 1), this.lProvincesPointsY.get(i).get(k))) continue;
                if (k != 0 && Objects.equals(this.currentPointsX.get(this.currentPointsX.size() - 2), this.lProvincesPointsX.get(i).get(k - 1)) && Objects.equals(this.currentPointsY.get(this.currentPointsY.size() - 2), this.lProvincesPointsY.get(i).get(k - 1))) {
                    found = true;
                    this.forward = true;
                    startID = k + 1;
                    break;
                }
                if (k + 1 >= kSize || !Objects.equals(this.currentPointsX.get(this.currentPointsX.size() - 2), this.lProvincesPointsX.get(i).get(k + 1)) || !Objects.equals(this.currentPointsY.get(this.currentPointsY.size() - 2), this.lProvincesPointsY.get(i).get(k + 1))) break;
                this.forward = false;
                found = true;
                startID = k - 1;
                break;
            }
            if (!found) continue;
            if (this.forward) {
                int kSize2 = this.lProvincesPointsX.get(i).size();
                while (startID < kSize2) {
                    int n;
                    int nSize = this.lProvincesPointsX.size();
                    for (n = 0; n < nSize; ++n) {
                        if (i == n) continue;
                        int oSize = this.lProvincesPointsX.get(n).size();
                        for (int o = 0; o < oSize; ++o) {
                            if (!Objects.equals(this.lProvincesPointsX.get(n).get(o), this.lProvincesPointsX.get(i).get(startID)) || !Objects.equals(this.lProvincesPointsY.get(n).get(o), this.lProvincesPointsY.get(i).get(startID))) continue;
                            return;
                        }
                    }
                    nSize = this.currentPointsX.size();
                    for (n = 0; n < nSize; ++n) {
                        if (!Objects.equals(this.currentPointsX.get(n), this.lProvincesPointsX.get(i).get(startID)) || !Objects.equals(this.currentPointsY.get(n), this.lProvincesPointsY.get(i).get(startID))) continue;
                        return;
                    }
                    this.addPointToCurrentProvince(this.lProvincesPointsX.get(i).get(startID), this.lProvincesPointsY.get(i).get(startID));
                    ++startID;
                }
            } else {
                while (startID > 0) {
                    int n;
                    int nSize = this.lProvincesPointsX.size();
                    for (n = 0; n < nSize; ++n) {
                        if (i == n) continue;
                        int oSize = this.lProvincesPointsX.get(n).size();
                        for (int o = 0; o < oSize; ++o) {
                            if (!Objects.equals(this.lProvincesPointsX.get(n).get(o), this.lProvincesPointsX.get(i).get(startID)) || !Objects.equals(this.lProvincesPointsY.get(n).get(o), this.lProvincesPointsY.get(i).get(startID))) continue;
                            return;
                        }
                    }
                    nSize = this.currentPointsX.size();
                    for (n = 0; n < nSize; ++n) {
                        if (!Objects.equals(this.currentPointsX.get(n), this.lProvincesPointsX.get(i).get(startID)) || !Objects.equals(this.currentPointsY.get(n), this.lProvincesPointsY.get(i).get(startID))) continue;
                        return;
                    }
                    this.addPointToCurrentProvince(this.lProvincesPointsX.get(i).get(startID), this.lProvincesPointsY.get(i).get(startID));
                    --startID;
                }
            }
            break;
        }
        this.rebuildCurrentProvince();
    }

    private void exportData() {
        int i;
        int iSize = this.lProvincesPointsX.size();
        for (i = 0; i < iSize; ++i) {
            System.out.println("nProvinces.add(get" + i + "());");
        }
        iSize = this.lProvincesPointsX.size();
        for (i = 0; i < iSize; ++i) {
            System.out.println("\tprivate final Province get" + i + "() {");
            System.out.println("\t\treturn new Province(" + i + ", " + (i > this.iEndOfLandProvinces ? -2 : (this.seaAcces(i) ? 0 : -1)) + ", get" + i + "X(), get" + i + "Y(), getPB" + i + "(), new short[]{" + this.getNeighboring(i) + "}, new short[]{" + this.getNeighSea(i) + "});");
            System.out.println("\t}\n");
        }
        System.out.println("\t// -------------------------------------------------\n");
        iSize = this.lProvincesPointsX.size();
        for (i = 0; i < iSize; ++i) {
            System.out.println("\tprivate final Province_Border[] getPB" + i + "() {");
            boolean retNull = true;
            for (int j = i + 1; j < this.lProvincesPointsX.size(); ++j) {
                int a;
                int n;
                int nSize;
                boolean end;
                int n2;
                int nSize2;
                int o;
                boolean f1;
                int o2;
                boolean found = false;
                int nSize3 = this.lProvincesPointsX.get(i).size();
                for (int n3 = 0; n3 < nSize3; ++n3) {
                    int oSize = this.lProvincesPointsX.get(j).size();
                    for (int o3 = 0; o3 < oSize; ++o3) {
                        if (!this.lProvincesPointsX.get(i).get(n3).equals(this.lProvincesPointsX.get(j).get(o3)) || !this.lProvincesPointsY.get(i).get(n3).equals(this.lProvincesPointsY.get(j).get(o3))) continue;
                        found = true;
                        if (retNull) {
                            System.out.print("\t\treturn new Province_Border[]{");
                        }
                        retNull = false;
                        break;
                    }
                    if (found) break;
                }
                if (!found) continue;
                ArrayList<Integer> pX = new ArrayList<Integer>();
                ArrayList<Integer> pY = new ArrayList<Integer>();
                boolean l1 = false;
                int oSize = this.lProvincesPointsX.get(j).size();
                for (o2 = 0; o2 < oSize; ++o2) {
                    if (!this.lProvincesPointsX.get(i).get(this.lProvincesPointsX.get(i).size() - 1).equals(this.lProvincesPointsX.get(j).get(o2)) || !this.lProvincesPointsY.get(i).get(this.lProvincesPointsY.get(i).size() - 1).equals(this.lProvincesPointsY.get(j).get(o2))) continue;
                    l1 = true;
                }
                if (l1) {
                    l1 = false;
                    oSize = this.lProvincesPointsX.get(i).size();
                    for (o2 = 0; o2 < oSize; ++o2) {
                        if (!this.lProvincesPointsX.get(j).get(this.lProvincesPointsX.get(j).size() - 1).equals(this.lProvincesPointsX.get(i).get(o2)) || !this.lProvincesPointsY.get(j).get(this.lProvincesPointsY.get(j).size() - 1).equals(this.lProvincesPointsY.get(i).get(o2))) continue;
                        l1 = true;
                    }
                    if (!l1) {
                        f1 = false;
                        block8: for (o = this.lProvincesPointsX.get(j).size() - 1; o >= 0; --o) {
                            if (!f1) {
                                nSize2 = this.lProvincesPointsX.get(i).size();
                                for (n2 = 0; n2 < nSize2; ++n2) {
                                    if (!this.lProvincesPointsX.get(j).get(o).equals(this.lProvincesPointsX.get(i).get(n2)) || !this.lProvincesPointsY.get(j).get(o).equals(this.lProvincesPointsY.get(i).get(n2))) continue;
                                    f1 = true;
                                    pX.add(this.lProvincesPointsX.get(j).get(o));
                                    pY.add(this.lProvincesPointsY.get(j).get(o));
                                    continue block8;
                                }
                                continue;
                            }
                            end = true;
                            nSize = this.lProvincesPointsX.get(i).size();
                            for (n = 0; n < nSize; ++n) {
                                if (!this.lProvincesPointsX.get(j).get(o).equals(this.lProvincesPointsX.get(i).get(n)) || !this.lProvincesPointsY.get(j).get(o).equals(this.lProvincesPointsY.get(i).get(n))) continue;
                                end = false;
                                pX.add(this.lProvincesPointsX.get(j).get(o));
                                pY.add(this.lProvincesPointsY.get(j).get(o));
                                break;
                            }
                            if (!end) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        boolean startID = false;
                        boolean t1 = false;
                        for (int o4 = this.lProvincesPointsX.get(i).size() - 1; o4 >= 0; --o4) {
                            t1 = false;
                            nSize = this.lProvincesPointsX.get(j).size();
                            for (n = 0; n < nSize; ++n) {
                                if (!this.lProvincesPointsX.get(i).get(o4).equals(this.lProvincesPointsX.get(j).get(n)) || !this.lProvincesPointsY.get(i).get(o4).equals(this.lProvincesPointsY.get(j).get(n))) continue;
                                t1 = true;
                                break;
                            }
                            if (t1) continue;
                            while (o4 < this.lProvincesPointsX.get(i).size() - 1) {
                                pX.add(this.lProvincesPointsX.get(i).get(o4));
                                pY.add(this.lProvincesPointsY.get(i).get(o4));
                                ++o4;
                            }
                            break;
                        }
                        for (int h = 0; h < this.lProvincesPointsX.get(i).size(); ++h) {
                            boolean addT = false;
                            for (int n4 = 0; n4 < this.lProvincesPointsX.get(j).size(); ++n4) {
                                if (!this.lProvincesPointsX.get(i).get(h).equals(this.lProvincesPointsX.get(j).get(n4)) || !this.lProvincesPointsY.get(i).get(h).equals(this.lProvincesPointsY.get(j).get(n4))) continue;
                                addT = true;
                                break;
                            }
                            if (addT) {
                                pX.add(this.lProvincesPointsX.get(i).get(h));
                                pY.add(this.lProvincesPointsY.get(i).get(h));
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    f1 = false;
                    block16: for (o = this.lProvincesPointsX.get(i).size() - 1; o >= 0; --o) {
                        if (!f1) {
                            nSize2 = this.lProvincesPointsX.get(j).size();
                            for (n2 = 0; n2 < nSize2; ++n2) {
                                if (!this.lProvincesPointsX.get(i).get(o).equals(this.lProvincesPointsX.get(j).get(n2)) || !this.lProvincesPointsY.get(i).get(o).equals(this.lProvincesPointsY.get(j).get(n2))) continue;
                                f1 = true;
                                pX.add(this.lProvincesPointsX.get(i).get(o));
                                pY.add(this.lProvincesPointsY.get(i).get(o));
                                continue block16;
                            }
                            continue;
                        }
                        end = true;
                        nSize = this.lProvincesPointsX.get(j).size();
                        for (n = 0; n < nSize; ++n) {
                            if (!this.lProvincesPointsX.get(i).get(o).equals(this.lProvincesPointsX.get(j).get(n)) || !this.lProvincesPointsY.get(i).get(o).equals(this.lProvincesPointsY.get(j).get(n))) continue;
                            end = false;
                            pX.add(this.lProvincesPointsX.get(i).get(o));
                            pY.add(this.lProvincesPointsY.get(i).get(o));
                            break;
                        }
                        if (!end) {
                            continue;
                        }
                        break;
                    }
                }
                System.out.print("\n\t\t\t\tnew Province_Border(" + j + ", ");
                System.out.print("new short[] {");
                int aSize = pX.size();
                for (a = 0; a < aSize; ++a) {
                    System.out.print(String.valueOf(pX.get(a)) + ",");
                }
                System.out.print("},");
                System.out.print("new short[] {");
                aSize = pY.size();
                for (a = 0; a < aSize; ++a) {
                    System.out.print(String.valueOf(pY.get(a)) + ",");
                }
                System.out.print("}");
                System.out.print("),");
            }
            if (retNull) {
                System.out.print("\t\treturn null;");
            } else {
                System.out.print("};");
            }
            System.out.println("\n\t}");
        }
        System.out.println("\t// -------------------------------------------------\n");
        iSize = this.lProvincesPointsX.size();
        for (i = 0; i < iSize; ++i) {
            int j;
            System.out.println("\tprivate final short[] get" + i + "X() {");
            System.out.print("\t\treturn new short[]{");
            int jSize = this.lProvincesPointsX.get(i).size();
            for (j = 0; j < jSize; ++j) {
                System.out.print(String.valueOf(this.lProvincesPointsX.get(i).get(j)) + ",");
            }
            System.out.println("};");
            System.out.println("\t}");
            System.out.println("\tprivate final short[] get" + i + "Y() {");
            System.out.print("\t\treturn new short[]{");
            jSize = this.lProvincesPointsY.get(i).size();
            for (j = 0; j < jSize; ++j) {
                System.out.print(String.valueOf(this.lProvincesPointsY.get(i).get(j)) + ",");
            }
            System.out.println("};");
            System.out.println("\t}");
        }
    }

    String getNeighboring(int i) {
        Object output = "";
        for (int j = 0; j < this.neighboring.get(i).size(); ++j) {
            boolean add = true;
            for (int k = j + 1; k < this.neighboring.get(i).size(); ++k) {
                int c;
                int a = this.neighboring.get(i).get(k);
                if (a != (c = this.neighboring.get(i).get(j).intValue())) continue;
                add = false;
            }
            int c = this.neighboring.get(i).get(j);
            if (c > this.iEndOfLandProvinces && i < this.iEndOfLandProvinces + 1) {
                add = false;
            }
            if (!add) continue;
            output = (String)output + String.valueOf(this.neighboring.get(i).get(j)) + ", ";
        }
        return output;
    }

    private String getNeighSea(int i) {
        Object outp = "";
        if (i > this.iEndOfLandProvinces) {
            return "";
        }
        for (int j = 0; j < this.neighboring.get(i).size(); ++j) {
            boolean add = true;
            for (int k = j + 1; k < this.neighboring.get(i).size(); ++k) {
                int c;
                int a = this.neighboring.get(i).get(k);
                if (a == (c = this.neighboring.get(i).get(j).intValue())) {
                    add = false;
                }
                if (c >= this.iEndOfLandProvinces + 1) continue;
                add = false;
            }
            if (this.neighboring.get(i).get(j) < this.iEndOfLandProvinces + 1) {
                add = false;
            }
            if (!add) continue;
            outp = (String)outp + String.valueOf(this.neighboring.get(i).get(j)) + ", ";
        }
        return outp;
    }

    boolean seaAcces(int i) {
        for (int j = 0; j < this.neighboring.get(i).size(); ++j) {
            for (int k = 0; k < j; ++k) {
                if (this.neighboring.get(i).get(j) <= this.iEndOfLandProvinces) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void run() {
        while (this.bRunning) {
            this.gameThreadRender();
            this.paintScreen();
        }
    }

    private void paintScreen() {
        try {
            Graphics g = this.getGraphics();
            if (this.baseImage != null && g != null) {
                g.drawImage(this.baseImage, 0, 0, null);
            }
            Toolkit.getDefaultToolkit().sync();
            g.dispose();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.requestFocusInWindow();
    }

    private void StartGame() {
        if (this.gameThread == null || !this.bRunning) {
            this.gameThread = new Thread(this);
            this.gameThread.start();
            this.bRunning = true;
        }
    }

    private void gameThreadRender() {
        if (this.baseImage == null || GWIDTH != this.getWidth() || GHEIGHT != this.getHeight()) {
            if (this.getWidth() > 0 && this.getHeight() > 0) {
                GWIDTH = this.getWidth();
                GHEIGHT = this.getHeight();
            }
            this.baseImage = this.createImage(GWIDTH, GHEIGHT);
            if (this.baseImage == null) {
                return;
            }
            this.baseGraphic = this.baseImage.getGraphics();
        }
        this.baseGraphic.setColor(Color.WHITE);
        this.baseGraphic.fillRect(0, 0, GWIDTH, GHEIGHT);
        this.draw(this.baseGraphic);
    }

    public void StopGame() {
        if (this.bRunning) {
            this.bRunning = false;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.StartGame();
    }

    public BufferedImage ImageReader(String nFile) {
        try {
            File imageFile = new File(nFile);
            return ImageIO.read(imageFile);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static {
        MAXIMUM_SIZE = true;
        bDrawProvincePoints = true;
        bDrawCities = true;
        bDrawCitiesNames = true;
        bDrawArmy = false;
        CONVERT_AOH2_MAP_PROVINCES_DATA_TO_AOH3 = false;
        citiesNames = new ArrayList<String>();
        citiesX = new ArrayList<Integer>();
        citiesY = new ArrayList<Integer>();
        BackgroundSize_X = 1;
        BackgroundSize_Y = 1;
    }

    private class NeighboringProvincesThread
    extends Thread {
        private NeighboringProvincesThread() {
        }

        @Override
        public void run() {
            try {
                int iSize = GamePanel.this.lProvincesPointsX.size();
                for (int i = 0; i < iSize; ++i) {
                    ArrayList<Integer> oC = new ArrayList<Integer>();
                    int jSize = GamePanel.this.lProvincesPointsX.get(i).size();
                    for (int j = 0; j < jSize; ++j) {
                        int kSize = GamePanel.this.lProvincesPointsX.size();
                        block4: for (int k = 0; k < kSize; ++k) {
                            if (k == i) continue;
                            int uSize = GamePanel.this.lProvincesPointsX.get(k).size();
                            for (int u = 0; u < uSize; ++u) {
                                int h;
                                int e;
                                int c;
                                int a = GamePanel.this.lProvincesPointsX.get(i).get(j);
                                if (a != (c = GamePanel.this.lProvincesPointsX.get(k).get(u).intValue()) && a + GamePanel.this.iMapEditorBackgroundWidth != c && a != c + GamePanel.this.iMapEditorBackgroundWidth || (e = GamePanel.this.lProvincesPointsY.get(i).get(j).intValue()) != (h = GamePanel.this.lProvincesPointsY.get(k).get(u).intValue())) continue;
                                oC.add(k);
                                k = kSize;
                                continue block4;
                            }
                        }
                    }
                    GamePanel.this.neighboring.add(oC);
                }
                GamePanel.this.neighboringProvincesReadyToUse = true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }
}

