@echo off
setlocal ENABLEDELAYEDEXPANSION

echo ===========================================
echo   Node.js Auto Setup + App Launcher
echo ===========================================
echo.

set "SCRIPT_DIR=%~dp0"
cd /d "%SCRIPT_DIR%"

echo [1/3] Checking Node.js installation...

where node >nul 2>nul
if not errorlevel 1 goto HASNODE

echo Node.js not found on PATH. Downloading and installing...

set "NODE_VERSION=v22.11.0"
set "NODE_MSI_URL=https://nodejs.org/dist/%NODE_VERSION%/node-%NODE_VERSION%-x64.msi"
set "NODE_MSI=%TEMP%\node_installer_%NODE_VERSION%.msi"

if exist "%NODE_MSI%" goto HAVE_MSI

powershell -NoProfile -Command "Invoke-WebRequest -Uri '%NODE_MSI_URL%' -OutFile '%NODE_MSI%'"
if errorlevel 1 goto END

:HAVE_MSI
msiexec /i "%NODE_MSI%" /qn /norestart
if errorlevel 1 goto END

:HASNODE
where node >nul 2>nul
if errorlevel 1 goto END

echo Node version:
for /f "delims=" %%v in ('node -v') do echo   %%v
echo.

echo [2/3] Checking npm dependencies...

if not exist "%SCRIPT_DIR%package.json" goto RUN_APP

if exist "%SCRIPT_DIR%node_modules" goto HAVE_MODULES

call npm install
if errorlevel 1 goto END

:HAVE_MODULES

:RUN_APP
echo.
echo [3/3] Launching the tracker.

if not exist "%SCRIPT_DIR%index.js" goto END

node "%SCRIPT_DIR%index.js"
echo.
echo App exited with code %ERRORLEVEL%.

:END
echo.
echo Press any key to close...
pause >nul
endlocal
