/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.util.Arrays;
import sun.security.ssl.ProtocolVersion;

class Authenticator {
    private final byte[] block;
    private static final int BLOCK_SIZE_SSL = 11;
    private static final int BLOCK_SIZE_TLS = 13;

    Authenticator() {
        this.block = new byte[0];
    }

    Authenticator(ProtocolVersion protocolVersion) {
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            this.block = new byte[13];
            this.block[9] = protocolVersion.major;
            this.block[10] = protocolVersion.minor;
        } else {
            this.block = new byte[11];
        }
    }

    final boolean seqNumOverflow() {
        return this.block.length != 0 && this.block[0] == -1 && this.block[1] == -1 && this.block[2] == -1 && this.block[3] == -1 && this.block[4] == -1 && this.block[5] == -1 && this.block[6] == -1;
    }

    final boolean seqNumIsHuge() {
        return this.block.length != 0 && this.block[0] == -1 && this.block[1] == -1;
    }

    final byte[] sequenceNumber() {
        return Arrays.copyOf(this.block, 8);
    }

    final byte[] acquireAuthenticationBytes(byte by, int n) {
        byte[] byArray = (byte[])this.block.clone();
        if (this.block.length != 0) {
            byArray[8] = by;
            byArray[byArray.length - 2] = (byte)(n >> 8);
            byArray[byArray.length - 1] = (byte)n;
            int n2 = 7;
            while (n2 >= 0) {
                int n3 = n2--;
                this.block[n3] = (byte)(this.block[n3] + 1);
                if (this.block[n3] == 0) continue;
            }
        }
        return byArray;
    }
}

