/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.nativesandbox;

import com.sun.deploy.nativesandbox.NativeSandboxBrokerImpl;
import com.sun.deploy.util.ArgumentParsingUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public final class IntegrityProcess
extends Process {
    public static final int INTEGRITY_LEVEL_UNKNOWN = 0;
    public static final int INTEGRITY_LEVEL_LOW = 1;
    public static final int INTEGRITY_LEVEL_MEDIUM = 2;
    public static final int INTEGRITY_LEVEL_APP_CONTAINER = 3;
    private static int integrityLevel = 0;
    private long processHandle = 0L;
    private Thread brokerThread = null;
    private static ClassLoader loader = null;

    public static void setClassLoader(ClassLoader classLoader) {
        loader = classLoader;
    }

    public static Process getIntegrityProcess(List list) throws IOException {
        if (list.isEmpty()) {
            return null;
        }
        IntegrityProcess integrityProcess = new IntegrityProcess();
        integrityProcess.start(list);
        return integrityProcess;
    }

    public static int getIntegrityLevel() {
        if (integrityLevel == 0) {
            integrityLevel = IntegrityProcess.getCurrentIntegrityLevel();
        }
        return integrityLevel;
    }

    private static native int getCurrentIntegrityLevel();

    private static native long launchProcess(String var0, String var1);

    private static native void waitForProcess(long var0);

    private static native void destroyProcess(long var0);

    private IntegrityProcess() {
    }

    public OutputStream getOutputStream() {
        return null;
    }

    public InputStream getInputStream() {
        return null;
    }

    public InputStream getErrorStream() {
        return null;
    }

    public int waitFor() throws InterruptedException {
        if (this.processHandle != 0L) {
            IntegrityProcess.waitForProcess(this.processHandle);
        }
        return 0;
    }

    public int exitValue() {
        return 0;
    }

    public synchronized void destroy() {
        if (this.processHandle != 0L) {
            IntegrityProcess.destroyProcess(this.processHandle);
            this.processHandle = 0L;
        }
    }

    private void initializeNativeSandboxBroker(List list) throws IOException {
        final long[] lArray = NativeSandboxBrokerImpl.getNativeSandboxPipeHandles();
        if (lArray == null) {
            throw new IOException("Cannot create native pipes.");
        }
        final long[] lArray2 = NativeSandboxBrokerImpl.getNativeSandboxPipeHandles();
        if (lArray2 == null) {
            throw new IOException("Cannot create native pipes.");
        }
        String string = null;
        int n = -1;
        for (int i = 1; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            if (!string2.equals("-ta")) continue;
            if (i + 1 >= list.size()) break;
            n = i + 1;
            string = (String)list.get(n);
            break;
        }
        if (string == null && n == -1) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("-DNSBWP=" + lArray[1]);
            arrayList.add("-DNSBRP=" + lArray2[0]);
            string = ArgumentParsingUtil.encodeArgumentList(arrayList);
            list.add("-ta");
            list.add(string);
        } else {
            List list2 = ArgumentParsingUtil.decodeArgumentList(string);
            list2.add("-DNSBWP=" + lArray[1]);
            list2.add("-DNSBRP=" + lArray2[0]);
            string = ArgumentParsingUtil.encodeArgumentList(list2);
            list.remove(n);
            list.add(n, string);
        }
        this.brokerThread = new Thread(){

            public void run() {
                if (loader != null) {
                    Thread.currentThread().setContextClassLoader(loader);
                }
                NativeSandboxBrokerImpl nativeSandboxBrokerImpl = new NativeSandboxBrokerImpl(lArray[0], lArray2[1]);
                nativeSandboxBrokerImpl.runNativeSandboxBroker();
            }
        };
        this.brokerThread.setDaemon(false);
        this.brokerThread.start();
    }

    private void start(List list) throws IOException {
        String string = "";
        String string2 = "";
        this.initializeNativeSandboxBroker(list);
        string = (String)list.get(0);
        for (int i = 0; i < list.size(); ++i) {
            String string3 = (String)list.get(i);
            if (string3.contains(" ")) {
                string2 = string2 + "\"";
                string2 = string2 + string3;
                string2 = string2 + "\"";
            } else {
                string2 = string2 + string3;
            }
            if (i >= list.size() - 1) continue;
            string2 = string2 + " ";
        }
        this.processHandle = IntegrityProcess.launchProcess(string, string2);
    }
}

