/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;

public class Menu_Configuration {
    public static Configuration configuration;

    public static void load() {
        Json json = new Json();
        json.setTypeName(null);
        json.setIgnoreUnknownFields(true);
        json.setUsePrototypes(false);
        json.setOutputType(JsonWriter.OutputType.json);
        FileHandle file = Gdx.files.internal("UI/MenuConfig.json");
        try {
            configuration = json.fromJson(Configuration.class, file);
        }
        catch (Throwable ex) {
            configuration = new Configuration();
            configuration.init();
            Menu_Configuration.saveConfiguration(json);
        }
    }

    private static void saveConfiguration(Json json) {
        try {
            FileHandle file = Gdx.files.local("UI/MenuConfig.json");
            String jsonOutput = json.prettyPrint(configuration);
            file.writeString(jsonOutput, false);
            Gdx.app.log("Menu_Configuration", "Save Configuration");
        }
        catch (Throwable writeEx) {
            Gdx.app.error("Menu_Configuration", "Save Configuration Failed", writeEx);
        }
    }

    public static void save() {
        Json json = new Json();
        json.setOutputType(JsonWriter.OutputType.json);
        Menu_Configuration.saveConfiguration(json);
    }

    public static class Configuration {
        public Load_Configuration load_configuration;
        public Main_Configuration main_configuration;
        public Event_Configuration event_configuration;

        protected void init() {
            if (this.load_configuration == null) {
                this.load_configuration = new Load_Configuration();
            }
            if (this.main_configuration == null) {
                this.main_configuration = new Main_Configuration();
            }
            if (this.event_configuration == null) {
                this.event_configuration = new Event_Configuration();
            }
        }
    }

    public static enum OriginCoordinate {
        UP_LEFT,
        UP_RIGHT,
        DOWN_LEFT,
        DOWN_RIGHT;

    }

    public static enum Event_Configuration_Type {
        Default,
        Enhance;

    }

    public static class Event_Configuration {
        public boolean Enable = false;
        public Event_Configuration_Type Type = Event_Configuration_Type.Default;
        public boolean title_font_enable = false;
        public String title_font = "Main";
        public Color title_color = Color.WHITE;
        public boolean column_font_enable = false;
        public String column_font = "Main";
        public Color column_color = Color.WHITE;
        public OriginCoordinate origin_coordinate = OriginCoordinate.UP_LEFT;
    }

    public static class Main_Configuration {
        public boolean Enable = false;
        public String Type = "Default";
        public boolean Logo = true;
        public int Logo_Animation = 0;
    }

    public static class Load_Configuration {
        public boolean Enable = false;
        public String Type = "Default";
        public int Text_Color_R = 255;
        public int Text_Color_G = 255;
        public int Text_Color_B = 255;
        public int Bottom_Offset = 0;
    }
}

