/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class HolyRomanEmpire_GameData
implements Serializable {
    private static final long serialVersionUID = 0L;
    private int iElectorsSize = 0;
    private int iEmperorAuthority = 0;
    private int iEmperorID = -1;
    private int iNextElectionsIn = 30;
    private int iPrincesSize = 0;
    private int iProvincesSize = 0;
    private List<Integer> lElectors;
    private List<Integer> lPrinces;
    private List<Integer> lProvinces = new ArrayList<Integer>();
    protected List<Integer> lVotesFor;

    public HolyRomanEmpire_GameData() {
        this.lElectors = new ArrayList<Integer>();
        this.lPrinces = new ArrayList<Integer>();
        this.lVotesFor = new ArrayList<Integer>();
    }

    protected final void addElector(int n) {
        if (this.getElectorsSize() < 7) {
            for (int i = 0; i < this.getPrincesSize(); ++i) {
                if (this.getPrince(i) != n) continue;
                this.lElectors.add(i);
                this.iElectorsSize = this.lElectors.size();
                this.buildVotesFor();
                return;
            }
        }
    }

    protected final void addPrince(int n) {
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            if (this.getPrince(i) != n) continue;
            return;
        }
        this.lPrinces.add(n);
        this.iPrincesSize = this.lPrinces.size();
        CFG.game.getCiv(n).setIsPartOfHolyRomanEmpire(true);
    }

    protected final boolean addProvince(int n) {
        for (int i = 0; i < this.getProvincesSize(); ++i) {
            if (this.getProvinces(i) != n) continue;
            return false;
        }
        this.lProvinces.add(n);
        this.iProvincesSize = this.lProvinces.size();
        CFG.game.getProvince(n).setIsPartOfHolyRomanEmpire(true);
        return true;
    }

    protected final void addStrongestPrinceAsElector() {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        for (n = 0; n < this.getPrincesSize(); ++n) {
            if (CFG.game.getCiv(this.getPrince(n)).getNumOfProvinces() <= 0 || this.getIsElector(this.getPrince(n)) || this.getIsEmperor(this.getPrince(n))) continue;
            arrayList.add(this.getPrince(n));
        }
        if (arrayList.size() > 0) {
            int n3 = 0;
            for (n = n2; n < arrayList.size(); ++n) {
                n2 = n3;
                if (CFG.game.getCiv((Integer)arrayList.get(n)).countPopulation() > CFG.game.getCiv((Integer)arrayList.get(n3)).countPopulation()) {
                    n2 = n;
                }
                n3 = n2;
            }
            this.addElector((Integer)arrayList.get(n3));
        }
    }

    protected final void buildVotesFor() {
        int n;
        if (this.lVotesFor == null) {
            this.lVotesFor = new ArrayList<Integer>();
        }
        int n2 = this.lVotesFor.size();
        int n3 = 0;
        if (n2 == 0) {
            for (n = 0; n < this.getElectorsSize(); ++n) {
                this.lVotesFor.add(this.getPrince(this.getElector(n)));
            }
        } else {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = 0; n < this.lVotesFor.size(); ++n) {
                arrayList.add(this.lVotesFor.get(n));
            }
            this.lVotesFor.clear();
            for (n = n3; n < this.getElectorsSize(); ++n) {
                if (CFG.game.getCiv(this.getPrince(this.getElector(n))).getControlledByPlayer()) {
                    try {
                        this.lVotesFor.add((Integer)arrayList.get(n));
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.lVotesFor.add(this.getPrince(this.getElector(n)));
                    }
                    continue;
                }
                this.lVotesFor.add(this.getPrince(this.getElector(n)));
            }
        }
    }

    protected final int getElector(int n) {
        return this.lElectors.get(n);
    }

    protected final int getElectorsSize() {
        return this.iElectorsSize;
    }

    protected final int getEmperor() {
        return this.lPrinces.get(this.iEmperorID);
    }

    protected final int getEmperorAuthority() {
        return this.iEmperorAuthority;
    }

    protected final boolean getIsElector(int n) {
        for (int i = 0; i < this.getElectorsSize(); ++i) {
            if (this.getPrince(this.getElector(i)) != n) continue;
            return true;
        }
        return false;
    }

    protected boolean getIsEmperor(int n) {
        boolean bl;
        int n2 = this.iEmperorID;
        boolean bl2 = bl = false;
        if (n2 >= 0) {
            bl2 = bl;
            if (this.getPrince(n2) == n) {
                bl2 = true;
            }
        }
        return bl2;
    }

    protected final boolean getIsImperialProvince(int n) {
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            if (this.getProvinces(i) != n) continue;
            return true;
        }
        return false;
    }

    protected final boolean getIsPrince(int n) {
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            if (this.getPrince(i) != n) continue;
            return true;
        }
        return false;
    }

    protected final int getNextElectionsIn() {
        return this.iNextElectionsIn;
    }

    protected final int getPrince(int n) {
        return this.lPrinces.get(n);
    }

    protected final int getPrincesSize() {
        return this.iPrincesSize;
    }

    protected final int getPrincesSize_True() {
        int n = 0;
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            int n2 = n;
            if (CFG.game.getCiv(this.getPrince(i)).getNumOfProvinces() > 0) {
                n2 = n + 1;
            }
            n = n2;
        }
        return n;
    }

    protected final int getProvinces(int n) {
        return this.lProvinces.get(n);
    }

    protected final int getProvincesSize() {
        return this.iProvincesSize;
    }

    protected final void randomNextElections() {
        this.iNextElectionsIn = CFG.oR.nextInt(60) + 32;
    }

    protected final void removeElector(int n) {
        for (int i = 0; i < this.getElectorsSize(); ++i) {
            if (this.getPrince(this.lElectors.get(i)) != n) continue;
            this.lElectors.remove(i);
            this.iElectorsSize = this.lElectors.size();
            this.buildVotesFor();
            return;
        }
    }

    protected final void removePrince(int n) {
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            if (this.getPrince(i) != n) continue;
            CFG.game.getCiv(n).setIsPartOfHolyRomanEmpire(false);
            this.removeElector(n);
            this.lPrinces.remove(i);
            this.iPrincesSize = this.lPrinces.size();
            for (n = 0; n < this.getElectorsSize(); ++n) {
                if (this.lElectors.get(n) <= i) continue;
                List<Integer> list = this.lElectors;
                list.set(n, list.get(n) - 1);
            }
            n = this.iEmperorID;
            if (n == i) {
                this.iEmperorID = this.getElectorsSize() > 0 ? this.getElector(0) : -1;
            } else if (n > i) {
                this.iEmperorID = n - 1;
            }
            return;
        }
    }

    protected final void removePrinceID(int n) {
        this.removePrince(this.getPrince(n));
    }

    protected final boolean removeProvince(int n) {
        for (int i = 0; i < this.getProvincesSize(); ++i) {
            if (this.getProvinces(i) != n) continue;
            CFG.game.getProvince(n).setIsPartOfHolyRomanEmpire(false);
            this.lProvinces.remove(i);
            this.iProvincesSize = this.lProvinces.size();
            return true;
        }
        return false;
    }

    protected final void setElectorID(int n) {
        if (n < this.getPrincesSize()) {
            if (this.getIsElector(this.getPrince(n))) {
                this.removeElector(this.getPrince(n));
            } else {
                this.addElector(this.getPrince(n));
            }
        }
    }

    protected final void setEmperor(int n) {
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            if (this.getPrince(i) != n) continue;
            this.iEmperorID = i;
            this.removeElector(n);
            return;
        }
    }

    protected final void setEmperorAuthority(int n) {
        this.iEmperorAuthority = n;
    }

    protected final void setEmperorID(int n) {
        this.iEmperorID = this.iEmperorID != n && n < this.getPrincesSize() ? n : -1;
    }

    protected final void setNextElectionsIn(int n) {
        this.iNextElectionsIn = n;
    }

    protected final void updateHRE_AfterRemoveCivilization(int n) {
        int n2 = 0;
        while (n2 < this.getPrincesSize()) {
            int n3;
            if (this.getPrince(n2) == n) {
                this.removePrince(n);
                n3 = n2 - 1;
            } else {
                n3 = n2;
                if (this.getPrince(n2) > n) {
                    List<Integer> list = this.lPrinces;
                    list.set(n2, list.get(n2) - 1);
                    n3 = n2;
                }
            }
            n2 = n3 + 1;
        }
    }
}

