/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import java.util.HashMap;
import java.util.Map;

public class Zetvl_Configuration {
    private final Map<String, String> properties = new HashMap<String, String>();
    public float CAPITULATION_POINT;
    public int RECRUIT_FORCE;
    public boolean GOAL;
    public boolean ORIGINAL_LEADER_RENDER;
    public boolean TURNS_RECRUIT;
    public boolean LOGS;
    public boolean CHANGE_CONSOLE_MUSIC;
    public boolean TEN_THOUSAND;
    public boolean DEBUG;
    public boolean NEW_PROVINCE_RENDER;
    public String BATTLE_SYSTEM_SELECT;
    public boolean GLOBAL_NUCLEAR_ATTACK;
    public boolean NEW_EVENT_UI;

    public void ConfigLoad() {
        this.load();
        this.parseValues();
        Gdx.app.log("Zetvl", "Loader");
    }

    private void load() {
        String[] lines;
        FileHandle file = Gdx.files.internal("ZetvlUniverse/Zetvl_Configuration.properties");
        if (!file.exists()) {
            Gdx.app.error("Zetvl", "Config is not found");
            Gdx.app.log("Zetvl", "=== LOAD-DEFAULT ===");
            this.setDefaults();
            return;
        }
        for (String line : lines = file.readString("UTF-8").split("\r\n")) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            String[] parts = line.split("=", 2);
            if (parts.length == 2) {
                String key = parts[0].trim();
                String value = parts[1].trim();
                this.properties.put(key, value);
                continue;
            }
            Gdx.app.error("Zetvl", "Invalid config line: " + line);
        }
    }

    private void parseValues() {
        try {
            this.CAPITULATION_POINT = Float.parseFloat(this.properties.getOrDefault("CAPITULATION_POINT", "70"));
            this.RECRUIT_FORCE = Integer.parseInt(this.properties.getOrDefault("RECRUIT_FORCE", "4000"));
            this.GOAL = Boolean.parseBoolean(this.properties.getOrDefault("GOAL", "false"));
            this.ORIGINAL_LEADER_RENDER = Boolean.parseBoolean(this.properties.getOrDefault("ORIGINAL_LEADER_RENDER", "false"));
            this.TURNS_RECRUIT = Boolean.parseBoolean(this.properties.getOrDefault("TURNS_RECRUIT", "false"));
            this.LOGS = Boolean.parseBoolean(this.properties.getOrDefault("LOGS", "false"));
            this.CHANGE_CONSOLE_MUSIC = Boolean.parseBoolean(this.properties.getOrDefault("CHANGE_CONSOLE_MUSIC", "true"));
            this.TEN_THOUSAND = Boolean.parseBoolean(this.properties.getOrDefault("TEN_THOUSAND", "false"));
            this.DEBUG = Boolean.parseBoolean(this.properties.getOrDefault("DEBUG", "false"));
            this.NEW_PROVINCE_RENDER = Boolean.parseBoolean(this.properties.getOrDefault("NEW_PROVINCE_RENDER", "false"));
            this.BATTLE_SYSTEM_SELECT = this.properties.getOrDefault("BATTLE_SYSTEM_SELECT", "DEFAULT");
            this.GLOBAL_NUCLEAR_ATTACK = Boolean.parseBoolean(this.properties.getOrDefault("GLOBAL_NUCLEAR_ATTACK", "false"));
            this.NEW_EVENT_UI = Boolean.parseBoolean(this.properties.getOrDefault("NEW_EVENT_UI", "false"));
        }
        catch (NumberFormatException e) {
            Gdx.app.error("Zetvl", "No Effective, Do not load", e);
            this.setDefaults();
        }
    }

    private void setDefaults() {
        this.CAPITULATION_POINT = 70.0f;
        this.RECRUIT_FORCE = 4000;
        this.GOAL = false;
        this.ORIGINAL_LEADER_RENDER = false;
        this.TURNS_RECRUIT = false;
        this.LOGS = false;
        this.CHANGE_CONSOLE_MUSIC = true;
        this.TEN_THOUSAND = false;
        this.DEBUG = false;
        this.NEW_PROVINCE_RENDER = false;
        this.BATTLE_SYSTEM_SELECT = "DEFAULT";
        this.GLOBAL_NUCLEAR_ATTACK = false;
        this.NEW_EVENT_UI = false;
    }

    public float getCapitulationPoint() {
        return this.CAPITULATION_POINT;
    }

    public int getRecruitForce() {
        return this.RECRUIT_FORCE;
    }

    public boolean isGOAL() {
        return this.GOAL;
    }
}

