/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.MenuElement;
import age.of.civilizations2.jakowski.lukasz.Text;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;

class Text_Scrollable
extends Text {
    private Color textColor;
    private int iScrollPosX = 0;
    private boolean scrollRight = true;
    private long lTime;
    private float fTextScale = 1.0f;
    private boolean center = false;
    private DrawText drawText;

    protected Text_Scrollable(String sText, int iPosX, int iPosY, int iWidth, Color textColor) {
        this.init(sText, iPosX, iPosY, iWidth, 0, textColor, 1.0f, 0);
    }

    protected Text_Scrollable(String sText, int iPosX, int iPosY, int iWidth, Color textColor, float nTextScale) {
        this.init(sText, iPosX, iPosY, iWidth, 0, textColor, nTextScale, 0);
    }

    protected Text_Scrollable(String sText, int iPosX, int iPosY, int iWidth, int iHeight, Color textColor, float nTextScale) {
        this.init(sText, iPosX, iPosY, iWidth, iHeight, textColor, nTextScale, 0);
    }

    protected Text_Scrollable(String sText, int iPosX, int iPosY, int iWidth, int iHeight, Color textColor, float nTextScale, int iTextPos) {
        this.init(sText, iPosX, iPosY, iWidth, iHeight, textColor, nTextScale, iTextPos);
    }

    private final void init(String sText, int iPosX, int iPosY, int iWidth, int iHeight, Color textColor, float nTextScale, int iTextPos) {
        this.typeOfElement = MenuElement.TypeOfElement.TEXT;
        this.iScrollPosX = iTextPos;
        this.fTextScale = nTextScale;
        this.center = iTextPos < 0;
        this.setPosX(iPosX);
        this.setPosY(iPosY);
        this.setWidth(iWidth);
        if (iHeight > 0) {
            this.setHeight(iHeight);
        }
        this.setText(sText);
        this.textColor = textColor;
        this.updateTextPosition();
        this.drawText = this.fTextScale != 1.0f ? (oSB, iTranslateX, iTranslateY, isActive, scrollableY) -> {
            CFG.fontSpec.getData().setScale(this.fTextScale);
            CFG.drawTextWithShadow2(oSB, this.getText(), this.getPosX() + (isActive && !this.center ? this.iScrollPosX : this.textPosition.getTextPosition()) + iTranslateX, this.getPosY() + this.getHeight() / 2 - this.iTextHeight / 2 + iTranslateY, this.getColor(isActive));
            CFG.fontSpec.getData().setScale(1.0f);
        } : (oSB, iTranslateX, iTranslateY, isActive, scrollableY) -> CFG.drawTextWithShadow2(oSB, this.getText(), this.getPosX() + (isActive && !this.center ? this.iScrollPosX : this.textPosition.getTextPosition()) + iTranslateX, this.getPosY() + this.getHeight() / 2 - this.iTextHeight / 2 + iTranslateY, this.getColor(isActive));
    }

    protected void draw_StartClip(SpriteBatch oSB, int iTranslateX, int iTranslateY, boolean isActive, boolean scrollableY) {
        Rectangle clipBounds = new Rectangle(this.getPosX() + iTranslateX, CFG.GAME_HEIGHT - this.getPosY() - iTranslateY + CFG.PADDING, this.getWidth(), (float)(-this.getHeight()) * 1.8f);
        oSB.flush();
        ScissorStack.pushScissors(clipBounds);
    }

    protected void draw_Element(SpriteBatch oSB, int iTranslateX, int iTranslateY, boolean isActive, boolean scrollableY) {
        this.drawText.draw_Element(oSB, iTranslateX, iTranslateY, isActive, scrollableY);
    }

    protected void draw_EndClip(SpriteBatch oSB, int iTranslateX, int iTranslateY, boolean isActive, boolean scrollableY) {
        try {
            oSB.flush();
            ScissorStack.popScissors();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    protected void draw(SpriteBatch oSB, int iTranslateX, int iTranslateY, boolean isActive, boolean scrollableY) {
        this.draw_StartClip(oSB, iTranslateX, iTranslateY, isActive, scrollableY);
        this.draw_Element(oSB, iTranslateX, iTranslateY, isActive, scrollableY);
        this.draw_EndClip(oSB, iTranslateX, iTranslateY, isActive, scrollableY);
    }

    @Override
    protected Color getColor(boolean isActive) {
        return isActive ? CFG.COLOR_BUTTON_GAME_TEXT_ACTIVE : (this.getIsHovered() ? CFG.COLOR_BUTTON_GAME_TEXT_HOVERED : (this.getClickable() ? this.textColor : new Color(0.78f, 0.78f, 0.78f, 0.7f)));
    }

    @Override
    public void setText(String sText) {
        this.sText = sText;
        try {
            CFG.fontSpec.getData().setScale(this.fTextScale);
            CFG.glyphLayout.setText(CFG.fontSpec, sText);
            this.iTextWidth = (int)CFG.glyphLayout.width;
            this.iTextHeight = (int)CFG.glyphLayout.height;
            CFG.fontSpec.getData().setScale(1.0f);
            if (this.getHeight() < this.iTextHeight) {
                this.setHeight(this.iTextHeight);
            }
            this.updateTextPosition();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    protected final void updateTextPosition() {
        this.textPosition = this.getTextWidth() > this.getWidth() + CFG.PADDING ? () -> {
            if (this.lTime + 35L <= System.currentTimeMillis()) {
                if (this.scrollRight) {
                    --this.iScrollPosX;
                    if (this.getWidth() - this.iScrollPosX >= this.getTextWidth() + CFG.PADDING) {
                        this.scrollRight = !this.scrollRight;
                    }
                } else {
                    ++this.iScrollPosX;
                    if (this.iScrollPosX == CFG.PADDING) {
                        this.scrollRight = true;
                    }
                }
                this.lTime = System.currentTimeMillis();
                CFG.setRender_3(true);
            }
            return this.iScrollPosX;
        } : (this.center ? () -> this.getWidth() / 2 - this.getTextWidth() / 2 : () -> 0);
        this.iScrollPosX = 0;
        this.scrollRight = true;
    }

    @Override
    protected int getCurrent() {
        return this.iScrollPosX;
    }

    private static interface DrawText {
        public void draw_Element(SpriteBatch var1, int var2, int var3, boolean var4, boolean var5);
    }
}

