/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz.desktop;

import age.of.civilizations2.jakowski.lukasz.LinkHandler;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.lwjgl.opengl.Display;

public class DesktopLinkHandler
implements LinkHandler {
    @Override
    public void openPage(String AppURI, String WebURL) {
        Gdx.net.openURI(WebURL);
    }

    @Override
    public void LogOutI(String var1, String var2) {
        System.out.println("[" + var1 + "] " + var2);
    }

    @Override
    public void LogOutI(String var1, String var2, Throwable var3) {
        System.out.println("[" + var1 + "] " + var2);
        var3.printStackTrace();
    }

    @Override
    public void LogOutD(String var1, String var2) {
        System.out.println("[" + var1 + "] " + var2);
    }

    @Override
    public void LogOutD(String var1, String var2, Throwable var3) {
        System.out.println("[" + var1 + "] " + var2);
        var3.printStackTrace();
    }

    @Override
    public void LogOutE(String var1, String var2) {
        System.err.println("[" + var1 + "] " + var2);
    }

    @Override
    public void LogOutE(String var1, String var2, Throwable var3) {
        System.err.println("[" + var1 + "] " + var2);
        var3.printStackTrace();
    }

    @Override
    public void toast(String message) {
        SwingUtilities.invokeLater(() -> {
            try {
                if (!SystemTray.isSupported()) {
                    throw new UnsupportedOperationException("System tray not supported");
                }
                Image awtIcon = this.getLWJGL2WindowIcon();
                awtIcon.getScaledInstance(16, 16, 1);
                TrayIcon trayIcon = new TrayIcon(awtIcon);
                SystemTray tray = SystemTray.getSystemTray();
                tray.add(trayIcon);
                trayIcon.displayMessage("Zetvl", message, TrayIcon.MessageType.INFO);
                new Timer(3000, e -> tray.remove(trayIcon)).start();
            }
            catch (Throwable e2) {
                e2.printStackTrace();
                JOptionPane.showMessageDialog(null, message, "Zetvl", 1);
            }
        });
    }

    private Image convertAndScaleIcon(ByteBuffer buffer, int targetSize) {
        try {
            buffer.rewind();
            int originalSize = (int)Math.sqrt(buffer.capacity() / 4);
            BufferedImage originalImage = new BufferedImage(originalSize, originalSize, 2);
            for (int y = 0; y < originalSize; ++y) {
                for (int x = 0; x < originalSize; ++x) {
                    int r = buffer.get() & 0xFF;
                    int g = buffer.get() & 0xFF;
                    int b = buffer.get() & 0xFF;
                    int a = buffer.get() & 0xFF;
                    int pixel = a << 24 | r << 16 | g << 8 | b;
                    originalImage.setRGB(x, y, pixel);
                }
            }
            if (originalSize != targetSize) {
                BufferedImage scaledImage = new BufferedImage(targetSize, targetSize, 2);
                Graphics2D g = scaledImage.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.drawImage(originalImage, 0, 0, targetSize, targetSize, 0, 0, originalSize, originalSize, null);
                g.dispose();
                return scaledImage;
            }
            return originalImage;
        }
        catch (Exception e) {
            return DesktopLinkHandler.createDefaultIcon();
        }
    }

    private Image getLWJGL2WindowIcon() {
        try {
            Field iconsField = Display.class.getDeclaredField("cached_icons");
            iconsField.setAccessible(true);
            ByteBuffer[] cachedWindowIcons = (ByteBuffer[])iconsField.get(null);
            if (cachedWindowIcons == null || cachedWindowIcons.length == 0) {
                return DesktopLinkHandler.createDefaultIcon();
            }
            ByteBuffer bestBuffer = null;
            int targetSize = 16;
            int minDiff = Integer.MAX_VALUE;
            for (ByteBuffer buf : cachedWindowIcons) {
                int size = (int)Math.sqrt((double)buf.capacity() / 4.0);
                int diff = Math.abs(size - targetSize);
                if (size == targetSize) {
                    bestBuffer = buf;
                    break;
                }
                if (diff >= minDiff) continue;
                minDiff = diff;
                bestBuffer = buf;
            }
            if (bestBuffer == null) {
                bestBuffer = cachedWindowIcons[0];
            }
            return this.convertAndScaleIcon(bestBuffer, targetSize);
        }
        catch (Throwable e) {
            return DesktopLinkHandler.createDefaultIcon();
        }
    }

    private static Image createDefaultIcon() {
        BufferedImage image = new BufferedImage(32, 32, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(new Color(30, 144, 255));
        g.fillOval(0, 0, 32, 32);
        g.dispose();
        return image;
    }

    @Override
    public void saveFileToDirectory(FileHandle sourceFile, Runnable successCallback, Runnable errorCallback) {
        new Thread(() -> {
            FileDialog fileDialog = new FileDialog((Frame)null, "\u9009\u62e9\u4fdd\u5b58\u4f4d\u7f6e", 1);
            fileDialog.setMode(1);
            fileDialog.setFile(sourceFile.name());
            fileDialog.setVisible(true);
            String selectedDir = fileDialog.getDirectory();
            String selectedFile = fileDialog.getFile();
            if (selectedDir != null && selectedFile != null) {
                FileHandle destination = Gdx.files.absolute(selectedDir).child(selectedFile);
                try {
                    sourceFile.copyTo(destination);
                    Gdx.app.postRunnable(successCallback);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Gdx.app.postRunnable(errorCallback);
                }
            } else {
                Gdx.app.postRunnable(errorCallback);
            }
        }).start();
    }

    @Override
    public void keyboard(boolean show) {
    }
}

