/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.TextTask;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.utils.Pool;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TextUpdateEngine {
    private static final int MAX_TASKS_PER_FRAME = 1000;
    private static final long TASK_TIMEOUT = 2000L;
    private static final float FRAME_TIME_TARGET = 15.0f;
    private static final ConcurrentHashMap<String, TextTask> taskMap = new ConcurrentHashMap();
    private static final ConcurrentLinkedQueue<TextTask> taskQueue = new ConcurrentLinkedQueue();
    private static final Pool<TextTask> taskPool = new Pool<TextTask>(5000){

        @Override
        protected TextTask newObject() {
            return new TextTask();
        }
    };
    private static long lastFrameDuration = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void submitTask(BitmapFont font, CharSequence text, GlyphLayout layout) {
        String key = TextUpdateEngine.buildKey(font, text, layout);
        ConcurrentHashMap<String, TextTask> concurrentHashMap = taskMap;
        synchronized (concurrentHashMap) {
            if (!taskMap.containsKey(key)) {
                TextTask task = taskPool.obtain();
                task.set(font, text, layout);
                taskMap.put(key, task);
                taskQueue.add(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processTasks() {
        TextTask task;
        long startTime = System.nanoTime();
        int processed = 0;
        int maxTasks = TextUpdateEngine.calculateDynamicLimit();
        while (processed < maxTasks && !taskQueue.isEmpty() && (task = taskQueue.poll()) != null) {
            try {
                task.layout.setText(task.font, task.text);
            }
            catch (Exception e) {
                Gdx.app.error("TextUpdate", "Task failed: " + e.getMessage());
            }
            finally {
                taskMap.remove(TextUpdateEngine.buildKey(task.font, task.text, task.layout));
                taskPool.free(task);
                ++processed;
            }
        }
        TextUpdateEngine.cleanExpiredTasks();
        lastFrameDuration = System.nanoTime() - startTime;
    }

    private static int calculateDynamicLimit() {
        float frameTimeMs = (float)lastFrameDuration / 1000000.0f;
        float ratio = 15.0f / (frameTimeMs + 1.0f);
        return Math.min(1000, (int)(1000.0f * ratio));
    }

    private static void cleanExpiredTasks() {
        long now = System.currentTimeMillis();
        taskQueue.removeIf(task -> {
            if (now - task.createTime > 2000L) {
                taskPool.free((TextTask)task);
                return true;
            }
            return false;
        });
    }

    private static String buildKey(BitmapFont font, CharSequence text, GlyphLayout layout) {
        return font.hashCode() + "|" + text.hashCode() + "|" + System.identityHashCode(layout);
    }

    public static int getPendingTasks() {
        return taskQueue.size();
    }
}

