/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;

public class SafeGlyphLayout
extends GlyphLayout {
    private static volatile Thread glThread;

    @Override
    public void setText(BitmapFont font, CharSequence str) {
        if (this.isGLThread()) {
            super.setText(font, str);
        } else {
            this.syncToGLThread(() -> super.setText(font, str));
        }
    }

    private boolean isGLThread() {
        return Thread.currentThread() == glThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncToGLThread(Runnable task) {
        Object lock = new Object();
        boolean[] isDone = new boolean[]{false};
        Gdx.app.postRunnable(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                this.width = 0.0f;
                this.height = 0.0f;
            }
            finally {
                Object object = lock;
                synchronized (object) {
                    isDone[0] = true;
                    lock.notifyAll();
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            try {
                if (!isDone[0]) {
                    lock.wait(1000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        Gdx.app.postRunnable(() -> {
            glThread = Thread.currentThread();
        });
    }
}

