/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.MenuElement_Hover_v2_Element_Type;
import age.of.civilizations2.jakowski.lukasz.MenuElement_Hover_v2_Element_Type_Text;
import age.of.civilizations2.jakowski.lukasz.Zetvl;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.I18NBundle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.TreeSet;

class LanguageManager {
    protected static boolean translationsKeysMode = false;
    protected static String presentLanguage;
    private FileHandle fileHandle;
    private Locale locale;
    private I18NBundle bundle;
    private FileHandle fileHandleCivs;
    private Locale localeCivs;
    private I18NBundle bundleCivs;
    private FileHandle fileHandleLoading;
    private Locale localeLoading;
    private I18NBundle bundleLoading;
    private FileHandle fileHandleFocus;
    private Locale localeFocus;
    private I18NBundle bundleFocus;
    protected int iLoading_NumOfTexts = 0;
    private KeyOutput keyOutput;
    private List<String> cache = new ArrayList<String>();
    private List<String> cachekey = new ArrayList<String>();

    protected final void updateKeyOutput() {
        this.keyOutput = translationsKeysMode ? new KeyOutput(){

            @Override
            public String get(String key) {
                return "[" + key + "]";
            }

            @Override
            public String get(String key, int iValue) {
                return "[" + key + "]";
            }

            @Override
            public String get(String key, String sValue) {
                return "[" + key + "]";
            }

            @Override
            public String get(String key, String sValue, String sValue2) {
                return "[" + key + "]";
            }
        } : new KeyOutput(){

            @Override
            public String get(String key) {
                try {
                    return LanguageManager.this.bundle.get(key);
                }
                catch (MissingResourceException var3) {
                    Gdx.app.log("AoC", "MissingResourceException: " + key);
                    return key;
                }
            }

            @Override
            public String get(String key, int iValue) {
                try {
                    return LanguageManager.this.bundle.format(key, iValue);
                }
                catch (MissingResourceException var4) {
                    Gdx.app.log("AoC", "MissingResourceException: " + key);
                    return key;
                }
            }

            @Override
            public String get(String key, String sValue) {
                try {
                    return LanguageManager.this.bundle.format(key, sValue);
                }
                catch (MissingResourceException var4) {
                    Gdx.app.log("AoC", "MissingResourceException: " + key);
                    return key;
                }
            }

            @Override
            public String get(String key, String sValue, String sValue2) {
                try {
                    return LanguageManager.this.bundle.format(key, sValue, sValue2);
                }
                catch (MissingResourceException var5) {
                    Gdx.app.log("AoC", "MissingResourceException: " + key);
                    return key;
                }
            }
        };
    }

    protected LanguageManager(String nTag) {
        presentLanguage = !Objects.equals(nTag, "") ? "_" + nTag : nTag;
        this.fileHandle = Gdx.files.internal("game/languages/Bundle");
        this.locale = new Locale(nTag);
        this.bundle = I18NBundle.createBundle(this.fileHandle, this.locale);
        this.initCivsBundle(nTag);
        this.initFocusBundle(nTag);
        this.initLoadingBundle(nTag);
        this.updateKeyOutput();
        Zetvl.LangEntryColumn();
    }

    protected String getCurrent() {
        return presentLanguage;
    }

    protected final void initCivsBundle(String nTag) {
        this.fileHandleCivs = Gdx.files.internal("game/languages/civilizations/Bundle");
        this.localeCivs = new Locale(nTag);
        this.bundleCivs = I18NBundle.createBundle(this.fileHandleCivs, this.localeCivs);
    }

    protected final void initFocusBundle(String nTag) {
        this.fileHandleFocus = Gdx.files.internal("game/languages/focus/Bundle");
        this.localeFocus = new Locale(nTag);
        this.bundleFocus = I18NBundle.createBundle(this.fileHandleFocus, this.localeFocus);
    }

    protected final void initLoadingBundle(String nTag) {
        this.fileHandleLoading = Gdx.files.internal("game/languages/loading/Bundle");
        this.localeLoading = new Locale(nTag);
        this.bundleLoading = I18NBundle.createBundle(this.fileHandleLoading, this.localeLoading);
        Gdx.app.log("", "num: " + this.getLoading("NumOfTexts"));
        try {
            this.iLoading_NumOfTexts = Integer.parseInt(this.getLoading("NumOfTexts"));
        }
        catch (IllegalArgumentException var3) {
            this.iLoading_NumOfTexts = 0;
        }
    }

    protected final void dispose() {
        this.fileHandle = null;
        this.locale = null;
        this.bundle = null;
        this.fileHandleCivs = null;
        this.localeCivs = null;
        this.bundleCivs = null;
        this.fileHandleFocus = null;
        this.localeFocus = null;
        this.bundleFocus = null;
        this.fileHandleLoading = null;
        this.localeLoading = null;
        this.bundleLoading = null;
    }

    protected String get(String key) {
        if (this.cache.contains(key)) {
            int i = this.cache.indexOf(key);
            return this.cachekey.get(i);
        }
        this.cachekey.add(this.keyOutput.get(key));
        this.cache.add(key);
        int i = this.cache.size() - 1;
        return this.cachekey.get(i);
    }

    protected final void clearCache() {
        try {
            this.cachekey.clear();
            this.cache.clear();
        }
        catch (NullPointerException e) {
            this.cache = new ArrayList<String>();
            this.cachekey = new ArrayList<String>();
        }
    }

    protected String get(String key, int nValue) {
        return this.keyOutput.get(key, nValue);
    }

    protected String get(String key, String nValue) {
        return this.keyOutput.get(key, nValue);
    }

    protected String get(String key, String nValue, String nValue2) {
        return this.keyOutput.get(key, nValue, nValue2);
    }

    protected String getMerge() {
        try {
            FileHandle languageFile = this.getLanguageFile("game/languages/Bundle");
            FileHandle languageCivFile = this.getLanguageFile("game/languages/civilizations/Bundle");
            FileHandle languageLoadingFile = this.getLanguageFile("game/languages/loading/Bundle");
            String rawContent = languageFile.readString("UTF-8") + languageCivFile.readString("UTF-8") + languageLoadingFile.readString("UTF-8");
            TreeSet<Character> charset = new TreeSet<Character>(Comparator.comparingInt(c -> c.charValue() == ' ' ? 0 : 1).thenComparingInt(Character::charValue));
            for (char c2 : rawContent.toCharArray()) {
                if (Character.isISOControl(c2)) continue;
                charset.add(Character.valueOf(c2));
            }
            StringBuilder sb = new StringBuilder();
            for (Character c3 : charset) {
                sb.append(c3);
            }
            for (char c4 = ' '; c4 <= '~'; c4 = (char)(c4 + '\u0001')) {
                if (charset.contains(Character.valueOf(c4))) continue;
                sb.append(c4);
            }
            return sb.toString();
        }
        catch (Exception e) {
            Gdx.app.error("FontGen", "\u5b57\u7b26\u96c6\u751f\u6210\u5931\u8d25", e);
            return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!@#$%^&*()-_=+[]{}|;:'\",.<>/? ";
        }
    }

    private FileHandle getLanguageFile(String basePath) {
        FileHandle specific = Gdx.files.internal(basePath + presentLanguage + ".properties");
        return specific.exists() ? specific : Gdx.files.internal(basePath + ".properties");
    }

    protected String getCiv(String key) {
        try {
            return this.bundleCivs.get(key);
        }
        catch (MissingResourceException var8) {
            if (key.indexOf(95) > 0) {
                try {
                    return this.bundleCivs.get(key.substring(0, key.indexOf(95)));
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            try {
                if (CFG.isAndroid()) {
                    try {
                        FileHandle file = Gdx.files.local("game/civilizations_editor/" + CFG.ideologiesManager.getRealTag(key) + "/" + CFG.ideologiesManager.getRealTag(key) + "_NM");
                        return file.readString("UTF-8");
                    }
                    catch (GdxRuntimeException var5) {
                        FileHandle filex = Gdx.files.internal("game/civilizations_editor/" + CFG.ideologiesManager.getRealTag(key) + "/" + CFG.ideologiesManager.getRealTag(key) + "_NM");
                        return filex.readString("UTF-8");
                    }
                }
                FileHandle file = Gdx.files.internal("game/civilizations_editor/" + CFG.ideologiesManager.getRealTag(key) + "/" + CFG.ideologiesManager.getRealTag(key) + "_NM");
                return file.readString("UTF-8");
            }
            catch (GdxRuntimeException var6) {
                Gdx.app.log("AoC", "CivMissingResourceException: " + key);
                return key;
            }
        }
    }

    protected String getFocus(String key) {
        try {
            return this.bundleFocus.get(key);
        }
        catch (MissingResourceException var8) {
            if (key.indexOf(95) > 0) {
                try {
                    return this.bundleFocus.get(key.substring(0, key.indexOf(95)));
                }
                catch (MissingResourceException var7) {
                    return this.get("Focus_" + key);
                }
            }
            String sText = this.get("Focus_" + key);
            if (sText.equals("Focus_" + key)) {
                sText = key;
            }
            return sText;
        }
    }

    protected String getHolder(String key, String holder, String replace) {
        return this.get(key).replace("$" + holder + "$", replace);
    }

    protected List<MenuElement_Hover_v2_Element_Type> getHighLight(String key, String holder, String replace) {
        holder = "$" + (String)holder + "$";
        key = this.get(key);
        ArrayList<MenuElement_Hover_v2_Element_Type> elements = new ArrayList<MenuElement_Hover_v2_Element_Type>();
        int startIndex = 0;
        while (startIndex < key.length()) {
            int holderStart = key.indexOf((String)holder, startIndex);
            if (holderStart == -1) {
                this.addTextElement(elements, key.substring(startIndex), false);
                break;
            }
            if (holderStart > startIndex) {
                this.addTextElement(elements, key.substring(startIndex, holderStart), false);
            }
            this.addTextElement(elements, replace, true);
            startIndex = holderStart + ((String)holder).length();
        }
        return elements;
    }

    private void addTextElement(List<MenuElement_Hover_v2_Element_Type> list, String text, boolean highlight) {
        if (!text.isEmpty()) {
            Color color = highlight ? CFG.COLOR_TEXT_MODIFIER_NEUTRAL2 : CFG.COLOR_TEXT_MODIFIER_NEUTRAL;
            list.add(new MenuElement_Hover_v2_Element_Type_Text(text, color, 2));
        }
    }

    protected String getLoading(String key) {
        try {
            return this.bundleLoading.get(key);
        }
        catch (MissingResourceException var3) {
            return "";
        }
        catch (NullPointerException var4) {
            CFG.loadingTime = 0L;
            return "";
        }
    }

    static interface KeyOutput {
        public String get(String var1);

        public String get(String var1, int var2);

        public String get(String var1, String var2);

        public String get(String var1, String var2, String var3);
    }
}

