/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.G;
import age.of.civilizations2.jakowski.lukasz.Image;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import java.util.HashMap;
import java.util.Map;

public class GFX {
    protected final Map<G, Image> image;
    protected final Image missing = new Image(GFX.createMinecraftMissingTexture(32), Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);

    protected GFX() {
        this.image = new HashMap<G, Image>();
    }

    protected void ADD(String path, G gfx) {
        try {
            this.image.put(gfx, new Image(new Texture(Gdx.files.internal(path))));
        }
        catch (Throwable ignore) {
            Gdx.app.error("Zetvl", "Gfx Mission: " + path);
        }
    }

    protected void ADD(String path, G gfx, Texture.TextureFilter filter, Texture.TextureWrap wrap) {
        try {
            this.image.put(gfx, new Image(new Texture(Gdx.files.internal(path), Pixmap.Format.RGBA8888, false), filter, wrap));
        }
        catch (Throwable ignore) {
            Gdx.app.error("Zetvl", "Gfx Mission: " + path);
        }
    }

    protected Image GET(G Texture2) {
        return this.image.getOrDefault((Object)Texture2, this.missing);
    }

    public static Texture createMinecraftMissingTexture(int size) {
        Pixmap pixmap = new Pixmap(size, size, Pixmap.Format.RGBA8888);
        Color purple = new Color(0.75f, 0.25f, 0.75f, 1.0f);
        Color black = new Color(0.15f, 0.15f, 0.15f, 1.0f);
        int tileSize = size / 4;
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x < size; ++x) {
                boolean isPurple = (x / tileSize + y / tileSize) % 2 == 0;
                pixmap.setColor(isPurple ? purple : black);
                pixmap.drawPixel(x, y);
            }
        }
        Texture texture = new Texture(pixmap);
        pixmap.dispose();
        return texture;
    }
}

