/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Mountain;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import java.util.ArrayList;
import java.util.List;

class Game_Mountains {
    Game_Mountains() {
    }

    protected final List<Mountain> loadMountains() {
        ArrayList<Mountain> nMountains = new ArrayList<Mountain>();
        Config mountainsData = new Config();
        try {
            mountainsData = this.readMountains("mountains.json");
            for (Object e : mountainsData.mountains) {
                GameCity oMountainData = (GameCity)e;
                nMountains.add(new Mountain(oMountainData.Name, oMountainData.Elevation, oMountainData.x, oMountainData.y));
            }
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            // empty catch block
        }
        return nMountains;
    }

    private final Config readMountains(String nFileName) {
        FileHandle handle = Gdx.files.internal("map/" + CFG.map.getFile_ActiveMap_Path() + "cities/" + nFileName);
        String fileContent = handle.readString();
        Json json = new Json();
        json.setElementType(Config.class, "mountains", GameCity.class);
        return json.fromJson(Config.class, fileContent);
    }

    protected static class GameCity {
        protected String Name;
        protected int Elevation;
        protected int x;
        protected int y;

        protected GameCity() {
        }
    }

    protected static class Config {
        private ArrayList mountains;
        private String name;

        protected Config() {
        }
    }
}

