/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression.rangecoder;

import java.io.IOException;
import java.io.InputStream;

public class Decoder {
    static final int kBitModelTotal = 2048;
    static final int kNumBitModelTotalBits = 11;
    static final int kNumMoveBits = 5;
    static final int kTopMask = -16777216;
    int Code;
    int Range;
    InputStream Stream;

    public static void InitBitModels(short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)1024;
        }
    }

    public int DecodeBit(short[] sArray, int n) throws IOException {
        int n2 = this.Code;
        int n3 = this.Range;
        short s = sArray[n];
        int n4 = (n3 >>> 11) * s;
        if ((n2 ^ Integer.MIN_VALUE) < (Integer.MIN_VALUE ^ n4)) {
            this.Range = n4;
            sArray[n] = (short)(s + (2048 - s >>> 5));
            if ((this.Range & 0xFF000000) == 0) {
                this.Code = n2 << 8 | this.Stream.read();
                this.Range <<= 8;
            }
            return 0;
        }
        this.Range = n3 - n4;
        this.Code = n2 - n4;
        sArray[n] = (short)(s - (s >>> 5));
        if ((this.Range & 0xFF000000) == 0) {
            this.Code = this.Code << 8 | this.Stream.read();
            this.Range <<= 8;
        }
        return 1;
    }

    public final int DecodeDirectBits(int n) throws IOException {
        int n2 = 0;
        while (n != 0) {
            this.Range >>>= 1;
            int n3 = this.Code;
            int n4 = this.Range;
            int n5 = n3 - n4 >>> 31;
            this.Code = n3 - (n5 - 1 & n4);
            n2 = n2 << 1 | 1 - n5;
            if ((0xFF000000 & n4) == 0) {
                this.Code = this.Code << 8 | this.Stream.read();
                this.Range <<= 8;
            }
            --n;
        }
        return n2;
    }

    public final void Init() throws IOException {
        this.Code = 0;
        this.Range = -1;
        for (int i = 0; i < 5; ++i) {
            this.Code = this.Code << 8 | this.Stream.read();
        }
    }

    public final void ReleaseStream() {
        this.Stream = null;
    }

    public final void SetStream(InputStream inputStream) {
        this.Stream = inputStream;
    }
}

