/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression;

public class CRC {
    public static int[] Table = new int[256];
    int _value = -1;

    static {
        for (int i = 0; i < 256; ++i) {
            int n = i;
            for (int j = 0; j < 8; ++j) {
                if ((n & 1) != 0) {
                    n = n >>> 1 ^ 0xEDB88320;
                    continue;
                }
                n >>>= 1;
            }
            CRC.Table[i] = n;
        }
    }

    public int GetDigest() {
        return ~this._value;
    }

    public void Init() {
        this._value = -1;
    }

    public void Update(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int[] nArray = Table;
            int n2 = this._value;
            this._value = nArray[(byArray[i] ^ n2) & 0xFF] ^ n2 >>> 8;
        }
    }

    public void Update(byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int[] nArray = Table;
            int n3 = this._value;
            this._value = nArray[(byArray[n + i] ^ n3) & 0xFF] ^ n3 >>> 8;
        }
    }

    public void UpdateByte(int n) {
        int[] nArray = Table;
        int n2 = this._value;
        this._value = nArray[(n ^ n2) & 0xFF] ^ n2 >>> 8;
    }
}

