/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.PerformanceCounter;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.TimeUtils;

public class PerformanceCounters {
    private static final float nano2seconds = 1.0E-9f;
    public final Array<PerformanceCounter> counters = new Array();
    private long lastTick = 0L;

    public PerformanceCounter add(String object) {
        object = new PerformanceCounter((String)object);
        this.counters.add((PerformanceCounter)object);
        return object;
    }

    public PerformanceCounter add(String object, int n) {
        object = new PerformanceCounter((String)object, n);
        this.counters.add((PerformanceCounter)object);
        return object;
    }

    public void tick() {
        long l = TimeUtils.nanoTime();
        long l2 = this.lastTick;
        if (l2 > 0L) {
            this.tick((float)(l - l2) * 1.0E-9f);
        }
        this.lastTick = l;
    }

    public void tick(float f) {
        for (int i = 0; i < this.counters.size; ++i) {
            this.counters.get(i).tick(f);
        }
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        for (int i = 0; i < this.counters.size; ++i) {
            if (i != 0) {
                stringBuilder.append("; ");
            }
            this.counters.get(i).toString(stringBuilder);
        }
        return stringBuilder;
    }
}

