/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.NoSuchElementException;

public class OrderedMap<K, V>
extends ObjectMap<K, V> {
    final Array<K> keys;

    public OrderedMap() {
        this.keys = new Array();
    }

    public OrderedMap(int n) {
        super(n);
        this.keys = new Array(this.capacity);
    }

    public OrderedMap(int n, float f) {
        super(n, f);
        this.keys = new Array(this.capacity);
    }

    public OrderedMap(OrderedMap<? extends K, ? extends V> orderedMap) {
        super(orderedMap);
        this.keys = new Array<K>(orderedMap.keys);
    }

    @Override
    public void clear() {
        this.keys.clear();
        super.clear();
    }

    @Override
    public void clear(int n) {
        this.keys.clear();
        super.clear(n);
    }

    @Override
    public ObjectMap.Entries<K, V> entries() {
        if (Collections.allocateIterators) {
            return new ObjectMap.Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new OrderedMapEntries(this);
            this.entries2 = new OrderedMapEntries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    @Override
    public ObjectMap.Entries<K, V> iterator() {
        return this.entries();
    }

    @Override
    public ObjectMap.Keys<K> keys() {
        if (Collections.allocateIterators) {
            return new ObjectMap.Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new OrderedMapKeys(this);
            this.keys2 = new OrderedMapKeys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    public Array<K> orderedKeys() {
        return this.keys;
    }

    @Override
    public V put(K k, V v) {
        if (!this.containsKey(k)) {
            this.keys.add(k);
        }
        return super.put(k, v);
    }

    @Override
    public V remove(K k) {
        this.keys.removeValue(k, false);
        return super.remove(k);
    }

    public V removeIndex(int n) {
        return super.remove(this.keys.removeIndex(n));
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        Array<K> array = this.keys;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            K k = array.get(i);
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(this.get(k));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public ObjectMap.Values<V> values() {
        if (Collections.allocateIterators) {
            return new ObjectMap.Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new OrderedMapValues(this);
            this.values2 = new OrderedMapValues(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public static class OrderedMapEntries<K, V>
    extends ObjectMap.Entries<K, V> {
        private Array<K> keys;

        public OrderedMapEntries(OrderedMap<K, V> orderedMap) {
            super(orderedMap);
            this.keys = orderedMap.keys;
        }

        @Override
        public ObjectMap.Entry next() {
            if (this.hasNext) {
                if (this.valid) {
                    this.entry.key = this.keys.get(this.nextIndex);
                    this.entry.value = this.map.get(this.entry.key);
                    int n = this.nextIndex;
                    boolean bl = true;
                    this.nextIndex = n + 1;
                    if (this.nextIndex >= this.map.size) {
                        bl = false;
                    }
                    this.hasNext = bl;
                    return this.entry;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.currentIndex >= 0) {
                this.map.remove(this.entry.key);
                --this.nextIndex;
                return;
            }
            throw new IllegalStateException("next must be called before remove.");
        }

        @Override
        public void reset() {
            boolean bl = false;
            this.nextIndex = 0;
            if (this.map.size > 0) {
                bl = true;
            }
            this.hasNext = bl;
        }
    }

    public static class OrderedMapKeys<K>
    extends ObjectMap.Keys<K> {
        private Array<K> keys;

        public OrderedMapKeys(OrderedMap<K, ?> orderedMap) {
            super(orderedMap);
            this.keys = orderedMap.keys;
        }

        @Override
        public K next() {
            if (this.hasNext) {
                if (this.valid) {
                    K k = this.keys.get(this.nextIndex);
                    this.currentIndex = this.nextIndex;
                    int n = this.nextIndex;
                    boolean bl = true;
                    this.nextIndex = n + 1;
                    if (this.nextIndex >= this.map.size) {
                        bl = false;
                    }
                    this.hasNext = bl;
                    return k;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.currentIndex >= 0) {
                ((OrderedMap)this.map).removeIndex(this.nextIndex - 1);
                this.nextIndex = this.currentIndex;
                this.currentIndex = -1;
                return;
            }
            throw new IllegalStateException("next must be called before remove.");
        }

        @Override
        public void reset() {
            boolean bl = false;
            this.nextIndex = 0;
            if (this.map.size > 0) {
                bl = true;
            }
            this.hasNext = bl;
        }
    }

    public static class OrderedMapValues<V>
    extends ObjectMap.Values<V> {
        private Array keys;

        public OrderedMapValues(OrderedMap<?, V> orderedMap) {
            super(orderedMap);
            this.keys = orderedMap.keys;
        }

        @Override
        public V next() {
            if (this.hasNext) {
                if (this.valid) {
                    Object v = this.map.get(this.keys.get(this.nextIndex));
                    this.currentIndex = this.nextIndex;
                    int n = this.nextIndex;
                    boolean bl = true;
                    this.nextIndex = n + 1;
                    if (this.nextIndex >= this.map.size) {
                        bl = false;
                    }
                    this.hasNext = bl;
                    return v;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.currentIndex >= 0) {
                ((OrderedMap)this.map).removeIndex(this.currentIndex);
                this.nextIndex = this.currentIndex;
                this.currentIndex = -1;
                return;
            }
            throw new IllegalStateException("next must be called before remove.");
        }

        @Override
        public void reset() {
            boolean bl = false;
            this.nextIndex = 0;
            if (this.map.size > 0) {
                bl = true;
            }
            this.hasNext = bl;
        }
    }
}

