/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntMap<V>
implements Iterable<Entry<V>> {
    private static final int EMPTY = 0;
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    int capacity;
    private Entries entries1;
    private Entries entries2;
    boolean hasZeroValue;
    private int hashShift;
    int[] keyTable;
    private Keys keys1;
    private Keys keys2;
    private float loadFactor;
    private int mask;
    private int pushIterations;
    public int size;
    private int stashCapacity;
    int stashSize;
    private int threshold;
    V[] valueTable;
    private Values values1;
    private Values values2;
    V zeroValue;

    public IntMap() {
        this(51, 0.8f);
    }

    public IntMap(int n) {
        this(n, 0.8f);
    }

    public IntMap(int n, float f) {
        if (n >= 0) {
            if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) <= 0x40000000) {
                this.capacity = n;
                if (!(f <= 0.0f)) {
                    this.loadFactor = f;
                    n = this.capacity;
                    this.threshold = (int)((float)n * f);
                    this.mask = n - 1;
                    this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
                    this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
                    this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
                    this.keyTable = new int[this.capacity + this.stashCapacity];
                    this.valueTable = new Object[this.keyTable.length];
                    return;
                }
                java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                stringBuilder.append("loadFactor must be > 0: ");
                stringBuilder.append(f);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("initialCapacity is too large: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("initialCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public IntMap(IntMap<? extends V> intMap) {
        this((int)Math.floor((float)intMap.capacity * intMap.loadFactor), intMap.loadFactor);
        this.stashSize = intMap.stashSize;
        Object[] objectArray = intMap.keyTable;
        System.arraycopy(objectArray, 0, this.keyTable, 0, objectArray.length);
        objectArray = intMap.valueTable;
        System.arraycopy(objectArray, 0, this.valueTable, 0, objectArray.length);
        this.size = intMap.size;
        this.zeroValue = intMap.zeroValue;
        this.hasZeroValue = intMap.hasZeroValue;
    }

    private boolean containsKeyStash(int n) {
        int[] nArray = this.keyTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        for (int i = n2; i < n3 + n2; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private V getStash(int n, V v) {
        int[] nArray = this.keyTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        for (int i = n2; i < n3 + n2; ++i) {
            if (nArray[i] != n) continue;
            return this.valueTable[i];
        }
        return v;
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    private void push(int n, V v, int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n8 = this.mask;
        int n9 = this.pushIterations;
        int n10 = 0;
        int n11 = n6;
        n6 = n2;
        V v2 = v;
        int n12 = n;
        n2 = n10;
        do {
            if ((n = MathUtils.random(2)) != 0) {
                if (n != 1) {
                    v = VArray[n11];
                    nArray[n11] = n12;
                    VArray[n11] = v2;
                    n = n7;
                } else {
                    v = VArray[n4];
                    nArray[n4] = n12;
                    VArray[n4] = v2;
                    n = n5;
                }
            } else {
                v = VArray[n6];
                nArray[n6] = n12;
                VArray[n6] = v2;
                n = n3;
            }
            n6 = n & n8;
            n3 = nArray[n6];
            if (n3 == 0) {
                nArray[n6] = n;
                VArray[n6] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n4 = this.hash2(n);
            n5 = nArray[n4];
            if (n5 == 0) {
                nArray[n4] = n;
                VArray[n4] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n11 = this.hash3(n);
            n7 = nArray[n11];
            if (n7 == 0) {
                nArray[n11] = n;
                VArray[n11] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n2 = n10 = n2 + 1;
            n12 = n;
            v2 = v;
        } while (n10 != n9);
        this.putStash(n, v);
    }

    private void putResize(int n, V v) {
        if (n == 0) {
            this.zeroValue = v;
            this.hasZeroValue = true;
            return;
        }
        int[] nArray = this.keyTable;
        int n2 = n & this.mask;
        int n3 = nArray[n2];
        if (n3 == 0) {
            nArray[n2] = n;
            this.valueTable[n2] = v;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        nArray = this.keyTable;
        int n4 = this.hash2(n);
        int n5 = nArray[n4];
        if (n5 == 0) {
            nArray[n4] = n;
            this.valueTable[n4] = v;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        nArray = this.keyTable;
        int n6 = this.hash3(n);
        int n7 = nArray[n6];
        if (n7 == 0) {
            nArray[n6] = n;
            this.valueTable[n6] = v;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n, v, n2, n3, n4, n5, n6, n7);
    }

    private void putStash(int n, V v) {
        int n2 = this.stashSize;
        if (n2 == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.putResize(n, v);
            return;
        }
        int n3 = this.capacity + n2;
        this.keyTable[n3] = n;
        this.valueTable[n3] = v;
        this.stashSize = n2 + 1;
        ++this.size;
    }

    private void resize(int n) {
        int n2 = this.capacity;
        int n3 = this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        double d = n;
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(d)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(d) / 8);
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n4 = this.stashCapacity;
        this.keyTable = new int[n + n4];
        this.valueTable = new Object[n + n4];
        n4 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (n = 0; n < n2 + n3; ++n) {
                n4 = nArray[n];
                if (n4 == 0) continue;
                this.putResize(n4, VArray[n]);
            }
        }
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        while (true) {
            int n2 = n - 1;
            if (n <= 0) break;
            nArray[n2] = 0;
            VArray[n2] = null;
            n = n2;
        }
        this.size = 0;
        this.stashSize = 0;
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.zeroValue = null;
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(n);
    }

    public boolean containsKey(int n) {
        if (n == 0) {
            return this.hasZeroValue;
        }
        int n2 = this.mask;
        if (this.keyTable[n2 & n] != n && this.keyTable[n2 = this.hash2(n)] != n && this.keyTable[n2 = this.hash3(n)] != n) {
            return this.containsKeyStash(n);
        }
        return true;
    }

    public boolean containsValue(Object object, boolean bl) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return true;
            }
            object = this.keyTable;
            int n = this.capacity + this.stashSize;
            while (true) {
                int n2 = n - 1;
                if (n > 0) {
                    if (object[n2] != false && VArray[n2] == null) {
                        return true;
                    }
                    n = n2;
                    continue;
                }
                break;
            }
        } else if (bl) {
            if (object == this.zeroValue) {
                return true;
            }
            int n = this.capacity + this.stashSize;
            while (true) {
                int n3 = n - 1;
                if (n > 0) {
                    if (VArray[n3] == object) {
                        return true;
                    }
                    n = n3;
                    continue;
                }
                break;
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return true;
            }
            int n = this.capacity + this.stashSize;
            while (true) {
                int n4 = n - 1;
                if (n <= 0) break;
                if (object.equals(VArray[n4])) {
                    return true;
                }
                n = n4;
            }
        }
        return false;
    }

    public void ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) >= this.threshold) {
                this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / this.loadFactor)));
            }
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public Entries<V> entries() {
        if (Collections.allocateIterators) {
            return new Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            Entries entries = this.entries1;
            entries.valid = true;
            this.entries2.valid = false;
            return entries;
        }
        this.entries2.reset();
        Entries entries = this.entries2;
        entries.valid = true;
        this.entries1.valid = false;
        return entries;
    }

    public boolean equals(Object object) {
        V v;
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntMap)) {
            return false;
        }
        object = (IntMap)object;
        if (((IntMap)object).size != this.size) {
            return false;
        }
        boolean bl = ((IntMap)object).hasZeroValue;
        boolean bl2 = this.hasZeroValue;
        if (bl != bl2) {
            return false;
        }
        if (bl2 && ((v = ((IntMap)object).zeroValue) == null ? this.zeroValue != null : !v.equals(this.zeroValue))) {
            return false;
        }
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            int n3 = nArray[i];
            if (n3 == 0 || !((v = VArray[i]) == null ? ((IntMap)object).get(n3, ObjectMap.dummy) != null : !v.equals(((IntMap)object).get(n3)))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntMap)) {
            return false;
        }
        IntMap intMap = (IntMap)object;
        if (intMap.size != this.size) {
            return false;
        }
        boolean bl = intMap.hasZeroValue;
        boolean bl2 = this.hasZeroValue;
        if (bl != bl2) {
            return false;
        }
        if (bl2 && this.zeroValue != intMap.zeroValue) {
            return false;
        }
        object = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            Object object2 = object[i];
            if (object2 == false || VArray[i] == intMap.get((int)object2, ObjectMap.dummy)) continue;
            return false;
        }
        return true;
    }

    public int findKey(Object object, boolean bl, int n) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return 0;
            }
            object = this.keyTable;
            int n2 = this.capacity + this.stashSize;
            while (true) {
                int n3 = n2 - 1;
                if (n2 > 0) {
                    if (object[n3] != false && VArray[n3] == null) {
                        return (int)object[n3];
                    }
                    n2 = n3;
                    continue;
                }
                break;
            }
        } else if (bl) {
            if (object == this.zeroValue) {
                return 0;
            }
            int n4 = this.capacity + this.stashSize;
            while (true) {
                int n5 = n4 - 1;
                if (n4 > 0) {
                    if (VArray[n5] == object) {
                        return this.keyTable[n5];
                    }
                    n4 = n5;
                    continue;
                }
                break;
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return 0;
            }
            int n6 = this.capacity + this.stashSize;
            while (true) {
                int n7 = n6 - 1;
                if (n6 <= 0) break;
                if (object.equals(VArray[n7])) {
                    return this.keyTable[n7];
                }
                n6 = n7;
            }
        }
        return n;
    }

    public V get(int n) {
        int n2;
        if (n == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            return this.zeroValue;
        }
        int n3 = n2 = this.mask & n;
        if (this.keyTable[n2] != n) {
            n3 = n2 = this.hash2(n);
            if (this.keyTable[n2] != n) {
                n3 = n2 = this.hash3(n);
                if (this.keyTable[n2] != n) {
                    return this.getStash(n, null);
                }
            }
        }
        return this.valueTable[n3];
    }

    public V get(int n, V v) {
        int n2;
        if (n == 0) {
            if (!this.hasZeroValue) {
                return v;
            }
            return this.zeroValue;
        }
        int n3 = n2 = this.mask & n;
        if (this.keyTable[n2] != n) {
            n3 = n2 = this.hash2(n);
            if (this.keyTable[n2] != n) {
                n3 = n2 = this.hash3(n);
                if (this.keyTable[n2] != n) {
                    return this.getStash(n, v);
                }
            }
        }
        return this.valueTable[n3];
    }

    public int hashCode() {
        Object object;
        boolean bl = this.hasZeroValue;
        int n = bl && (object = this.zeroValue) != null ? object.hashCode() + 0 : 0;
        object = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        int n4 = n;
        for (int i = 0; i < n2 + n3; ++i) {
            Object object2 = object[i];
            n = n4;
            if (object2 != false) {
                V v = VArray[i];
                n = n4 += object2 * 31;
                if (v != null) {
                    n = n4 + v.hashCode();
                }
            }
            n4 = n;
        }
        return n4;
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    @Override
    public Iterator<Entry<V>> iterator() {
        return this.entries();
    }

    public Keys keys() {
        if (Collections.allocateIterators) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            Keys keys = this.keys1;
            keys.valid = true;
            this.keys2.valid = false;
            return keys;
        }
        this.keys2.reset();
        Keys keys = this.keys2;
        keys.valid = true;
        this.keys1.valid = false;
        return keys;
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public V put(int n, V v) {
        if (n == 0) {
            V v2 = this.zeroValue;
            this.zeroValue = v;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return v2;
        }
        Object object = this.keyTable;
        int n2 = n & this.mask;
        int n3 = object[n2];
        if (n3 == n) {
            object = this.valueTable;
            int n4 = object[n2];
            object[n2] = (int)v;
            return n4;
        }
        int n5 = this.hash2(n);
        int n6 = object[n5];
        if (n6 == n) {
            object = this.valueTable;
            int n7 = object[n5];
            object[n5] = (int)v;
            return n7;
        }
        int n8 = this.hash3(n);
        int n9 = object[n8];
        if (n9 == n) {
            V[] VArray = this.valueTable;
            object = VArray[n8];
            VArray[n8] = v;
            return (V)object;
        }
        int n10 = this.capacity;
        int n11 = this.stashSize;
        for (int i = n10; i < n11 + n10; ++i) {
            if (object[i] != n) continue;
            V[] VArray = this.valueTable;
            object = VArray[i];
            VArray[i] = v;
            return (V)object;
        }
        if (n3 == 0) {
            object[n2] = n;
            this.valueTable[n2] = v;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (n6 == 0) {
            object[n5] = n;
            this.valueTable[n5] = v;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (n9 == 0) {
            object[n8] = n;
            this.valueTable[n8] = v;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        this.push(n, v, n2, n3, n5, n6, n8, n9);
        return null;
    }

    public void putAll(IntMap<? extends V> object2) {
        for (Entry<V> entry : ((IntMap)object2).entries()) {
            this.put(entry.key, entry.value);
        }
    }

    public V remove(int n) {
        if (n == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            V v = this.zeroValue;
            this.zeroValue = null;
            this.hasZeroValue = false;
            --this.size;
            return v;
        }
        Object object = this.keyTable;
        int n2 = this.mask & n;
        if (object[n2] == n) {
            object[n2] = 0;
            V[] VArray = this.valueTable;
            object = VArray[n2];
            VArray[n2] = null;
            --this.size;
            return (V)object;
        }
        object = this.keyTable;
        n2 = this.hash2(n);
        if (object[n2] == n) {
            object[n2] = 0;
            V[] VArray = this.valueTable;
            object = VArray[n2];
            VArray[n2] = null;
            --this.size;
            return (V)object;
        }
        object = this.keyTable;
        n2 = this.hash3(n);
        if (object[n2] == n) {
            object[n2] = 0;
            object = this.valueTable;
            int n3 = object[n2];
            object[n2] = (int)null;
            --this.size;
            return n3;
        }
        return this.removeStash(n);
    }

    V removeStash(int n) {
        Object object = this.keyTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        for (int i = n2; i < n3 + n2; ++i) {
            if (object[i] != n) continue;
            object = this.valueTable[i];
            this.removeStashIndex(i);
            --this.size;
            return (V)object;
        }
        return null;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            Object[] objectArray = this.keyTable;
            objectArray[n] = objectArray[n2];
            objectArray = this.valueTable;
            objectArray[n] = objectArray[n2];
            objectArray[n2] = (int)null;
        } else {
            this.valueTable[n] = null;
        }
    }

    public void shrink(int n) {
        if (n >= 0) {
            int n2 = this.size;
            int n3 = n;
            if (n2 > n) {
                n3 = n2;
            }
            if (this.capacity <= n3) {
                return;
            }
            this.resize(MathUtils.nextPowerOfTwo(n3));
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("maximumCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public String toString() {
        int n;
        int n2;
        V[] VArray;
        int[] nArray;
        StringBuilder stringBuilder;
        block6: {
            if (this.size == 0) {
                return "[]";
            }
            stringBuilder = new StringBuilder(32);
            stringBuilder.append('[');
            nArray = this.keyTable;
            VArray = this.valueTable;
            n = n2 = nArray.length;
            if (this.hasZeroValue) {
                stringBuilder.append("0=");
                stringBuilder.append(this.zeroValue);
            } else {
                int n3;
                while (true) {
                    n2 = n3 = n - 1;
                    if (n <= 0) break block6;
                    n2 = nArray[n3];
                    if (n2 != 0) break;
                    n = n3;
                }
                stringBuilder.append(n2);
                stringBuilder.append('=');
                stringBuilder.append(VArray[n3]);
                n2 = n3;
            }
        }
        while (true) {
            n = n2 - 1;
            if (n2 <= 0) break;
            n2 = nArray[n];
            if (n2 == 0) {
                n2 = n;
                continue;
            }
            stringBuilder.append(", ");
            stringBuilder.append(n2);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n]);
            n2 = n;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Values<V> values() {
        if (Collections.allocateIterators) {
            return new Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            Values values = this.values1;
            values.valid = true;
            this.values2.valid = false;
            return values;
        }
        this.values2.reset();
        Values values = this.values2;
        values.valid = true;
        this.values1.valid = false;
        return values;
    }

    public static class Entries<V>
    extends MapIterator<V>
    implements Iterable<Entry<V>>,
    Iterator<Entry<V>> {
        private Entry<V> entry = new Entry();

        public Entries(IntMap intMap) {
            super(intMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return this;
        }

        @Override
        public Entry<V> next() {
            if (this.hasNext) {
                if (this.valid) {
                    Object object = this.map.keyTable;
                    if (this.nextIndex == -1) {
                        object = this.entry;
                        object.key = 0;
                        object.value = this.map.zeroValue;
                    } else {
                        this.entry.key = object[this.nextIndex];
                        this.entry.value = this.map.valueTable[this.nextIndex];
                    }
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return this.entry;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    public static class Entry<V> {
        public int key;
        public V value;

        public String toString() {
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append(this.key);
            stringBuilder.append("=");
            stringBuilder.append(this.value);
            return stringBuilder.toString();
        }
    }

    public static class Keys
    extends MapIterator {
        public Keys(IntMap intMap) {
            super(intMap);
        }

        public int next() {
            if (this.hasNext) {
                if (this.valid) {
                    int n = this.nextIndex == -1 ? 0 : this.map.keyTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return n;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.map.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }

    private static class MapIterator<V> {
        static final int INDEX_ILLEGAL = -2;
        static final int INDEX_ZERO = -1;
        int currentIndex;
        public boolean hasNext;
        final IntMap<V> map;
        int nextIndex;
        boolean valid = true;

        public MapIterator(IntMap<V> intMap) {
            this.map = intMap;
            this.reset();
        }

        void findNextIndex() {
            block1: {
                this.hasNext = false;
                int[] nArray = this.map.keyTable;
                int n = this.map.capacity;
                int n2 = this.map.stashSize;
                do {
                    int n3;
                    this.nextIndex = n3 = this.nextIndex + 1;
                    if (n3 >= n + n2) break block1;
                } while (nArray[this.nextIndex] == 0);
                this.hasNext = true;
            }
        }

        public void remove() {
            block7: {
                IntMap<V> intMap;
                block6: {
                    block5: {
                        if (this.currentIndex != -1 || !this.map.hasZeroValue) break block5;
                        intMap = this.map;
                        intMap.zeroValue = null;
                        intMap.hasZeroValue = false;
                        break block6;
                    }
                    int n = this.currentIndex;
                    if (n < 0) break block7;
                    if (n >= this.map.capacity) {
                        this.map.removeStashIndex(this.currentIndex);
                        this.nextIndex = this.currentIndex - 1;
                        this.findNextIndex();
                    } else {
                        this.map.keyTable[this.currentIndex] = 0;
                        this.map.valueTable[this.currentIndex] = null;
                    }
                }
                this.currentIndex = -2;
                intMap = this.map;
                --intMap.size;
                return;
            }
            throw new IllegalStateException("next must be called before remove.");
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }
    }

    public static class Values<V>
    extends MapIterator<V>
    implements Iterable<V>,
    Iterator<V> {
        public Values(IntMap<V> intMap) {
            super(intMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        @Override
        public V next() {
            if (this.hasNext) {
                if (this.valid) {
                    Object v = this.nextIndex == -1 ? this.map.zeroValue : this.map.valueTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return v;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            super.remove();
        }

        public Array<V> toArray() {
            Array<V> array = new Array<V>(true, this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }
    }
}

