/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.OrderedSet;
import com.badlogic.gdx.utils.Pools;
import java.util.Iterator;

public class Selection<T>
implements Disableable,
Iterable<T> {
    private Actor actor;
    boolean isDisabled;
    T lastSelected;
    boolean multiple;
    private final OrderedSet<T> old;
    private boolean programmaticChangeEvents = true;
    boolean required;
    final OrderedSet<T> selected = new OrderedSet();
    private boolean toggle;

    public Selection() {
        this.old = new OrderedSet();
    }

    public void add(T t) {
        if (t != null) {
            if (!this.selected.add(t)) {
                return;
            }
            if (this.programmaticChangeEvents && this.fireChangeEvent()) {
                this.selected.remove(t);
            } else {
                this.lastSelected = t;
                this.changed();
            }
            return;
        }
        throw new IllegalArgumentException("item cannot be null.");
    }

    public void addAll(Array<T> array) {
        this.snapshot();
        int n = array.size;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            T t = array.get(i);
            if (t != null) {
                if (!this.selected.add(t)) continue;
                bl = true;
                continue;
            }
            throw new IllegalArgumentException("item cannot be null.");
        }
        if (bl) {
            if (this.programmaticChangeEvents && this.fireChangeEvent()) {
                this.revert();
            } else {
                this.lastSelected = array.peek();
                this.changed();
            }
        }
        this.cleanup();
    }

    protected void changed() {
    }

    /*
     * Unable to fully structure code
     */
    public void choose(T var1_1) {
        block16: {
            block15: {
                block14: {
                    block13: {
                        if (var1_1 == null) break block16;
                        if (this.isDisabled) {
                            return;
                        }
                        this.snapshot();
                        if ((!this.toggle || this.required || this.selected.size != 1) && !UIUtils.ctrl() || !this.selected.contains(var1_1)) ** GOTO lbl18
                        if (!this.required || (var2_3 = this.selected.size) != 1) break block13;
                        this.cleanup();
                        return;
                    }
                    this.selected.remove(var1_1);
                    this.lastSelected = null;
                    ** GOTO lbl44
lbl18:
                    // 1 sources

                    var3_5 = this.multiple;
                    var4_6 = false;
                    var5_7 = false;
                    if (!var3_5) ** GOTO lbl28
                    var2_4 = var4_6;
                    if (this.toggle) ** GOTO lbl38
                    var2_4 = var4_6;
                    if (UIUtils.ctrl()) ** GOTO lbl38
lbl28:
                    // 2 sources

                    if (this.selected.size == 1 && (var3_5 = this.selected.contains(var1_1))) {
                        this.cleanup();
                        return;
                    }
                    var2_4 = var5_7;
                    if (this.selected.size <= 0) break block14;
                    var2_4 = true;
                }
                this.selected.clear(8);
lbl38:
                // 3 sources

                if ((var3_5 = this.selected.add(var1_1)) || var2_4) break block15;
                this.cleanup();
                return;
            }
            try {
                this.lastSelected = var1_1;
lbl44:
                // 2 sources

                if (this.fireChangeEvent()) {
                    this.revert();
                } else {
                    this.changed();
                }
                return;
            }
            finally {
                this.cleanup();
            }
        }
        throw new IllegalArgumentException("item cannot be null.");
    }

    void cleanup() {
        this.old.clear(32);
    }

    public void clear() {
        if (this.selected.size == 0) {
            return;
        }
        this.snapshot();
        this.selected.clear(8);
        if (this.programmaticChangeEvents && this.fireChangeEvent()) {
            this.revert();
        } else {
            this.lastSelected = null;
            this.changed();
        }
        this.cleanup();
    }

    public boolean contains(T t) {
        if (t == null) {
            return false;
        }
        return this.selected.contains(t);
    }

    public boolean fireChangeEvent() {
        if (this.actor == null) {
            return false;
        }
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        try {
            boolean bl = this.actor.fire(changeEvent);
            return bl;
        }
        finally {
            Pools.free(changeEvent);
        }
    }

    public T first() {
        T t = this.selected.size == 0 ? null : (T)this.selected.first();
        return t;
    }

    public T getLastSelected() {
        T t = this.lastSelected;
        if (t != null) {
            return t;
        }
        if (this.selected.size > 0) {
            return this.selected.first();
        }
        return null;
    }

    public boolean getMultiple() {
        return this.multiple;
    }

    public boolean getRequired() {
        return this.required;
    }

    public boolean getToggle() {
        return this.toggle;
    }

    @Deprecated
    public boolean hasItems() {
        boolean bl = this.selected.size > 0;
        return bl;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }

    public boolean isEmpty() {
        boolean bl = this.selected.size == 0;
        return bl;
    }

    public OrderedSet<T> items() {
        return this.selected;
    }

    @Override
    public Iterator<T> iterator() {
        return this.selected.iterator();
    }

    public boolean notEmpty() {
        boolean bl = this.selected.size > 0;
        return bl;
    }

    public void remove(T t) {
        if (t != null) {
            if (!this.selected.remove(t)) {
                return;
            }
            if (this.programmaticChangeEvents && this.fireChangeEvent()) {
                this.selected.add(t);
            } else {
                this.lastSelected = null;
                this.changed();
            }
            return;
        }
        throw new IllegalArgumentException("item cannot be null.");
    }

    public void removeAll(Array<T> array) {
        this.snapshot();
        int n = array.size;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            T t = array.get(i);
            if (t != null) {
                if (!this.selected.remove(t)) continue;
                bl = true;
                continue;
            }
            throw new IllegalArgumentException("item cannot be null.");
        }
        if (bl) {
            if (this.programmaticChangeEvents && this.fireChangeEvent()) {
                this.revert();
            } else {
                this.lastSelected = null;
                this.changed();
            }
        }
        this.cleanup();
    }

    void revert() {
        this.selected.clear(this.old.size);
        this.selected.addAll(this.old);
    }

    public void set(T t) {
        if (t != null) {
            if (this.selected.size == 1 && this.selected.first() == t) {
                return;
            }
            this.snapshot();
            this.selected.clear(8);
            this.selected.add(t);
            if (this.programmaticChangeEvents && this.fireChangeEvent()) {
                this.revert();
            } else {
                this.lastSelected = t;
                this.changed();
            }
            this.cleanup();
            return;
        }
        throw new IllegalArgumentException("item cannot be null.");
    }

    public void setActor(Actor actor) {
        this.actor = actor;
    }

    public void setAll(Array<T> array) {
        this.snapshot();
        this.lastSelected = null;
        this.selected.clear(array.size);
        int n = array.size;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            T t = array.get(i);
            if (t != null) {
                if (!this.selected.add(t)) continue;
                bl = true;
                continue;
            }
            throw new IllegalArgumentException("item cannot be null.");
        }
        if (bl) {
            if (this.programmaticChangeEvents && this.fireChangeEvent()) {
                this.revert();
            } else if (array.size > 0) {
                this.lastSelected = array.peek();
                this.changed();
            }
        }
        this.cleanup();
    }

    @Override
    public void setDisabled(boolean bl) {
        this.isDisabled = bl;
    }

    public void setMultiple(boolean bl) {
        this.multiple = bl;
    }

    public void setProgrammaticChangeEvents(boolean bl) {
        this.programmaticChangeEvents = bl;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setToggle(boolean bl) {
        this.toggle = bl;
    }

    public int size() {
        return this.selected.size;
    }

    void snapshot() {
        this.old.clear(this.selected.size);
        this.old.addAll(this.selected);
    }

    public Array<T> toArray() {
        return this.selected.iterator().toArray();
    }

    public Array<T> toArray(Array<T> array) {
        return this.selected.iterator().toArray(array);
    }

    public String toString() {
        return this.selected.toString();
    }
}

