/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.utils.TimeUtils;

public class ClickListener
extends InputListener {
    public static float visualPressedDuration = 0.1f;
    private int button;
    private boolean cancelled;
    private long lastTapTime;
    private boolean over;
    private boolean pressed;
    private int pressedButton = -1;
    private int pressedPointer = -1;
    private int tapCount;
    private long tapCountInterval = 400000000L;
    private float tapSquareSize = 14.0f;
    private float touchDownX = -1.0f;
    private float touchDownY = -1.0f;
    private long visualPressedTime;

    public ClickListener() {
    }

    public ClickListener(int n) {
        this.button = n;
    }

    public void cancel() {
        if (this.pressedPointer == -1) {
            return;
        }
        this.cancelled = true;
        this.pressed = false;
    }

    public void clicked(InputEvent inputEvent, float f, float f2) {
    }

    @Override
    public void enter(InputEvent inputEvent, float f, float f2, int n, Actor actor) {
        if (n == -1 && !this.cancelled) {
            this.over = true;
        }
    }

    @Override
    public void exit(InputEvent inputEvent, float f, float f2, int n, Actor actor) {
        if (n == -1 && !this.cancelled) {
            this.over = false;
        }
    }

    public int getButton() {
        return this.button;
    }

    public int getPressedButton() {
        return this.pressedButton;
    }

    public int getPressedPointer() {
        return this.pressedPointer;
    }

    public int getTapCount() {
        return this.tapCount;
    }

    public float getTapSquareSize() {
        return this.tapSquareSize;
    }

    public float getTouchDownX() {
        return this.touchDownX;
    }

    public float getTouchDownY() {
        return this.touchDownY;
    }

    public boolean inTapSquare() {
        boolean bl = this.touchDownX != -1.0f;
        return bl;
    }

    public boolean inTapSquare(float f, float f2) {
        float f3 = this.touchDownX;
        boolean bl = false;
        if (f3 == -1.0f && this.touchDownY == -1.0f) {
            return false;
        }
        boolean bl2 = bl;
        if (Math.abs(f - this.touchDownX) < this.tapSquareSize) {
            bl2 = bl;
            if (Math.abs(f2 - this.touchDownY) < this.tapSquareSize) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public void invalidateTapSquare() {
        this.touchDownX = -1.0f;
        this.touchDownY = -1.0f;
    }

    public boolean isOver() {
        boolean bl = this.over || this.pressed;
        return bl;
    }

    public boolean isOver(Actor actor, float f, float f2) {
        Actor actor2 = actor.hit(f, f2, true);
        if (actor2 != null && actor2.isDescendantOf(actor)) {
            return true;
        }
        return this.inTapSquare(f, f2);
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public boolean isVisualPressed() {
        if (this.pressed) {
            return true;
        }
        long l = this.visualPressedTime;
        if (l <= 0L) {
            return false;
        }
        if (l > TimeUtils.millis()) {
            return true;
        }
        this.visualPressedTime = 0L;
        return false;
    }

    public void setButton(int n) {
        this.button = n;
    }

    public void setTapCount(int n) {
        this.tapCount = n;
    }

    public void setTapCountInterval(float f) {
        this.tapCountInterval = (long)(f * 1.0E9f);
    }

    public void setTapSquareSize(float f) {
        this.tapSquareSize = f;
    }

    public void setVisualPressed(boolean bl) {
        this.visualPressedTime = bl ? TimeUtils.millis() + (long)(visualPressedDuration * 1000.0f) : 0L;
    }

    @Override
    public boolean touchDown(InputEvent inputEvent, float f, float f2, int n, int n2) {
        int n3;
        if (this.pressed) {
            return false;
        }
        if (n == 0 && (n3 = this.button) != -1 && n2 != n3) {
            return false;
        }
        this.pressed = true;
        this.pressedPointer = n;
        this.pressedButton = n2;
        this.touchDownX = f;
        this.touchDownY = f2;
        this.setVisualPressed(true);
        return true;
    }

    @Override
    public void touchDragged(InputEvent inputEvent, float f, float f2, int n) {
        if (n == this.pressedPointer && !this.cancelled) {
            this.pressed = this.isOver(inputEvent.getListenerActor(), f, f2);
            if (!this.pressed) {
                this.invalidateTapSquare();
            }
        }
    }

    @Override
    public void touchUp(InputEvent inputEvent, float f, float f2, int n, int n2) {
        if (n == this.pressedPointer) {
            if (!this.cancelled) {
                boolean bl;
                boolean bl2 = bl = this.isOver(inputEvent.getListenerActor(), f, f2);
                if (bl) {
                    bl2 = bl;
                    if (n == 0) {
                        n = this.button;
                        bl2 = bl;
                        if (n != -1) {
                            bl2 = bl;
                            if (n2 != n) {
                                bl2 = false;
                            }
                        }
                    }
                }
                if (bl2) {
                    long l = TimeUtils.nanoTime();
                    if (l - this.lastTapTime > this.tapCountInterval) {
                        this.tapCount = 0;
                    }
                    ++this.tapCount;
                    this.lastTapTime = l;
                    this.clicked(inputEvent, f, f2);
                }
            }
            this.pressed = false;
            this.pressedPointer = -1;
            this.pressedButton = -1;
            this.cancelled = false;
        }
    }
}

