/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TransformDrawable;
import com.badlogic.gdx.utils.Scaling;

public class Image
extends Widget {
    private int align = 1;
    private Drawable drawable;
    private float imageHeight;
    private float imageWidth;
    private float imageX;
    private float imageY;
    private Scaling scaling;

    public Image() {
        this((Drawable)null);
    }

    public Image(Texture texture) {
        this(new TextureRegionDrawable(new TextureRegion(texture)));
    }

    public Image(NinePatch ninePatch) {
        this(new NinePatchDrawable(ninePatch), Scaling.stretch, 1);
    }

    public Image(TextureRegion textureRegion) {
        this(new TextureRegionDrawable(textureRegion), Scaling.stretch, 1);
    }

    public Image(Skin skin, String string2) {
        this(skin.getDrawable(string2), Scaling.stretch, 1);
    }

    public Image(Drawable drawable2) {
        this(drawable2, Scaling.stretch, 1);
    }

    public Image(Drawable drawable2, Scaling scaling) {
        this(drawable2, scaling, 1);
    }

    public Image(Drawable drawable2, Scaling scaling, int n) {
        this.setDrawable(drawable2);
        this.scaling = scaling;
        this.align = n;
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    @Override
    public void draw(Batch batch, float f) {
        this.validate();
        Object object = this.getColor();
        batch.setColor(((Color)object).r, ((Color)object).g, ((Color)object).b, ((Color)object).a * f);
        f = this.getX();
        float f2 = this.getY();
        float f3 = this.getScaleX();
        float f4 = this.getScaleY();
        if (this.drawable instanceof TransformDrawable) {
            float f5 = this.getRotation();
            if (f3 != 1.0f || f4 != 1.0f || f5 != 0.0f) {
                ((TransformDrawable)this.drawable).draw(batch, f + this.imageX, f2 + this.imageY, this.getOriginX() - this.imageX, this.getOriginY() - this.imageY, this.imageWidth, this.imageHeight, f3, f4, f5);
                return;
            }
        }
        if ((object = this.drawable) != null) {
            object.draw(batch, f + this.imageX, f2 + this.imageY, this.imageWidth * f3, this.imageHeight * f4);
        }
    }

    public Drawable getDrawable() {
        return this.drawable;
    }

    public float getImageHeight() {
        return this.imageHeight;
    }

    public float getImageWidth() {
        return this.imageWidth;
    }

    public float getImageX() {
        return this.imageX;
    }

    public float getImageY() {
        return this.imageY;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getPrefHeight() {
        Drawable drawable2 = this.drawable;
        if (drawable2 != null) {
            return drawable2.getMinHeight();
        }
        return 0.0f;
    }

    @Override
    public float getPrefWidth() {
        Drawable drawable2 = this.drawable;
        if (drawable2 != null) {
            return drawable2.getMinWidth();
        }
        return 0.0f;
    }

    @Override
    public void layout() {
        Object object = this.drawable;
        if (object == null) {
            return;
        }
        float f = object.getMinWidth();
        float f2 = this.drawable.getMinHeight();
        float f3 = this.getWidth();
        float f4 = this.getHeight();
        object = this.scaling.apply(f, f2, f3, f4);
        this.imageWidth = ((Vector2)object).x;
        this.imageHeight = ((Vector2)object).y;
        int n = this.align;
        this.imageX = (n & 8) != 0 ? 0.0f : ((n & 0x10) != 0 ? (float)((int)(f3 - this.imageWidth)) : (float)((int)(f3 / 2.0f - this.imageWidth / 2.0f)));
        n = this.align;
        this.imageY = (n & 2) != 0 ? (float)((int)(f4 - this.imageHeight)) : ((n & 4) != 0 ? 0.0f : (float)((int)(f4 / 2.0f - this.imageHeight / 2.0f)));
    }

    public void setAlign(int n) {
        this.align = n;
        this.invalidate();
    }

    public void setDrawable(Skin skin, String string2) {
        this.setDrawable(skin.getDrawable(string2));
    }

    public void setDrawable(Drawable drawable2) {
        if (this.drawable == drawable2) {
            return;
        }
        if (drawable2 != null) {
            if (this.getPrefWidth() != drawable2.getMinWidth() || this.getPrefHeight() != drawable2.getMinHeight()) {
                this.invalidateHierarchy();
            }
        } else {
            this.invalidateHierarchy();
        }
        this.drawable = drawable2;
    }

    public void setScaling(Scaling scaling) {
        if (scaling != null) {
            this.scaling = scaling;
            this.invalidate();
            return;
        }
        throw new IllegalArgumentException("scaling cannot be null.");
    }

    @Override
    public String toString() {
        String string2 = this.getName();
        if (string2 != null) {
            return string2;
        }
        String string3 = this.getClass().getName();
        int n = string3.lastIndexOf(46);
        string2 = string3;
        if (n != -1) {
            string2 = string3.substring(n + 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        string3 = string2.indexOf(36) != -1 ? "Image " : "";
        stringBuilder.append(string3);
        stringBuilder.append(string2);
        stringBuilder.append(": ");
        stringBuilder.append(this.drawable);
        return stringBuilder.toString();
    }
}

