/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.AddAction;
import com.badlogic.gdx.scenes.scene2d.actions.AddListenerAction;
import com.badlogic.gdx.scenes.scene2d.actions.AfterAction;
import com.badlogic.gdx.scenes.scene2d.actions.AlphaAction;
import com.badlogic.gdx.scenes.scene2d.actions.ColorAction;
import com.badlogic.gdx.scenes.scene2d.actions.DelayAction;
import com.badlogic.gdx.scenes.scene2d.actions.LayoutAction;
import com.badlogic.gdx.scenes.scene2d.actions.MoveByAction;
import com.badlogic.gdx.scenes.scene2d.actions.MoveToAction;
import com.badlogic.gdx.scenes.scene2d.actions.ParallelAction;
import com.badlogic.gdx.scenes.scene2d.actions.RemoveAction;
import com.badlogic.gdx.scenes.scene2d.actions.RemoveActorAction;
import com.badlogic.gdx.scenes.scene2d.actions.RemoveListenerAction;
import com.badlogic.gdx.scenes.scene2d.actions.RepeatAction;
import com.badlogic.gdx.scenes.scene2d.actions.RotateByAction;
import com.badlogic.gdx.scenes.scene2d.actions.RotateToAction;
import com.badlogic.gdx.scenes.scene2d.actions.RunnableAction;
import com.badlogic.gdx.scenes.scene2d.actions.ScaleByAction;
import com.badlogic.gdx.scenes.scene2d.actions.ScaleToAction;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.actions.SizeByAction;
import com.badlogic.gdx.scenes.scene2d.actions.SizeToAction;
import com.badlogic.gdx.scenes.scene2d.actions.TimeScaleAction;
import com.badlogic.gdx.scenes.scene2d.actions.TouchableAction;
import com.badlogic.gdx.scenes.scene2d.actions.VisibleAction;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

public class Actions {
    public static <T extends Action> T action(Class<T> object) {
        object = Pools.get(object);
        Action action = (Action)((Pool)object).obtain();
        action.setPool((Pool)object);
        return (T)action;
    }

    public static AddAction addAction(Action action) {
        AddAction addAction = Actions.action(AddAction.class);
        addAction.setAction(action);
        return addAction;
    }

    public static AddAction addAction(Action action, Actor actor) {
        AddAction addAction = Actions.action(AddAction.class);
        addAction.setTarget(actor);
        addAction.setAction(action);
        return addAction;
    }

    public static AddListenerAction addListener(EventListener eventListener, boolean bl) {
        AddListenerAction addListenerAction = Actions.action(AddListenerAction.class);
        addListenerAction.setListener(eventListener);
        addListenerAction.setCapture(bl);
        return addListenerAction;
    }

    public static AddListenerAction addListener(EventListener eventListener, boolean bl, Actor actor) {
        AddListenerAction addListenerAction = Actions.action(AddListenerAction.class);
        addListenerAction.setTarget(actor);
        addListenerAction.setListener(eventListener);
        addListenerAction.setCapture(bl);
        return addListenerAction;
    }

    public static AfterAction after(Action action) {
        AfterAction afterAction = Actions.action(AfterAction.class);
        afterAction.setAction(action);
        return afterAction;
    }

    public static AlphaAction alpha(float f) {
        return Actions.alpha(f, 0.0f, null);
    }

    public static AlphaAction alpha(float f, float f2) {
        return Actions.alpha(f, f2, null);
    }

    public static AlphaAction alpha(float f, float f2, Interpolation interpolation) {
        AlphaAction alphaAction = Actions.action(AlphaAction.class);
        alphaAction.setAlpha(f);
        alphaAction.setDuration(f2);
        alphaAction.setInterpolation(interpolation);
        return alphaAction;
    }

    public static ColorAction color(Color color2) {
        return Actions.color(color2, 0.0f, null);
    }

    public static ColorAction color(Color color2, float f) {
        return Actions.color(color2, f, null);
    }

    public static ColorAction color(Color color2, float f, Interpolation interpolation) {
        ColorAction colorAction = Actions.action(ColorAction.class);
        colorAction.setEndColor(color2);
        colorAction.setDuration(f);
        colorAction.setInterpolation(interpolation);
        return colorAction;
    }

    public static DelayAction delay(float f) {
        DelayAction delayAction = Actions.action(DelayAction.class);
        delayAction.setDuration(f);
        return delayAction;
    }

    public static DelayAction delay(float f, Action action) {
        DelayAction delayAction = Actions.action(DelayAction.class);
        delayAction.setDuration(f);
        delayAction.setAction(action);
        return delayAction;
    }

    public static AlphaAction fadeIn(float f) {
        return Actions.alpha(1.0f, f, null);
    }

    public static AlphaAction fadeIn(float f, Interpolation interpolation) {
        AlphaAction alphaAction = Actions.action(AlphaAction.class);
        alphaAction.setAlpha(1.0f);
        alphaAction.setDuration(f);
        alphaAction.setInterpolation(interpolation);
        return alphaAction;
    }

    public static AlphaAction fadeOut(float f) {
        return Actions.alpha(0.0f, f, null);
    }

    public static AlphaAction fadeOut(float f, Interpolation interpolation) {
        AlphaAction alphaAction = Actions.action(AlphaAction.class);
        alphaAction.setAlpha(0.0f);
        alphaAction.setDuration(f);
        alphaAction.setInterpolation(interpolation);
        return alphaAction;
    }

    public static RepeatAction forever(Action action) {
        RepeatAction repeatAction = Actions.action(RepeatAction.class);
        repeatAction.setCount(-1);
        repeatAction.setAction(action);
        return repeatAction;
    }

    public static VisibleAction hide() {
        return Actions.visible(false);
    }

    public static LayoutAction layout(boolean bl) {
        LayoutAction layoutAction = Actions.action(LayoutAction.class);
        layoutAction.setLayoutEnabled(bl);
        return layoutAction;
    }

    public static MoveByAction moveBy(float f, float f2) {
        return Actions.moveBy(f, f2, 0.0f, null);
    }

    public static MoveByAction moveBy(float f, float f2, float f3) {
        return Actions.moveBy(f, f2, f3, null);
    }

    public static MoveByAction moveBy(float f, float f2, float f3, Interpolation interpolation) {
        MoveByAction moveByAction = Actions.action(MoveByAction.class);
        moveByAction.setAmount(f, f2);
        moveByAction.setDuration(f3);
        moveByAction.setInterpolation(interpolation);
        return moveByAction;
    }

    public static MoveToAction moveTo(float f, float f2) {
        return Actions.moveTo(f, f2, 0.0f, null);
    }

    public static MoveToAction moveTo(float f, float f2, float f3) {
        return Actions.moveTo(f, f2, f3, null);
    }

    public static MoveToAction moveTo(float f, float f2, float f3, Interpolation interpolation) {
        MoveToAction moveToAction = Actions.action(MoveToAction.class);
        moveToAction.setPosition(f, f2);
        moveToAction.setDuration(f3);
        moveToAction.setInterpolation(interpolation);
        return moveToAction;
    }

    public static MoveToAction moveToAligned(float f, float f2, int n) {
        return Actions.moveToAligned(f, f2, n, 0.0f, null);
    }

    public static MoveToAction moveToAligned(float f, float f2, int n, float f3) {
        return Actions.moveToAligned(f, f2, n, f3, null);
    }

    public static MoveToAction moveToAligned(float f, float f2, int n, float f3, Interpolation interpolation) {
        MoveToAction moveToAction = Actions.action(MoveToAction.class);
        moveToAction.setPosition(f, f2, n);
        moveToAction.setDuration(f3);
        moveToAction.setInterpolation(interpolation);
        return moveToAction;
    }

    public static ParallelAction parallel() {
        return Actions.action(ParallelAction.class);
    }

    public static ParallelAction parallel(Action action) {
        ParallelAction parallelAction = Actions.action(ParallelAction.class);
        parallelAction.addAction(action);
        return parallelAction;
    }

    public static ParallelAction parallel(Action action, Action action2) {
        ParallelAction parallelAction = Actions.action(ParallelAction.class);
        parallelAction.addAction(action);
        parallelAction.addAction(action2);
        return parallelAction;
    }

    public static ParallelAction parallel(Action action, Action action2, Action action3) {
        ParallelAction parallelAction = Actions.action(ParallelAction.class);
        parallelAction.addAction(action);
        parallelAction.addAction(action2);
        parallelAction.addAction(action3);
        return parallelAction;
    }

    public static ParallelAction parallel(Action action, Action action2, Action action3, Action action4) {
        ParallelAction parallelAction = Actions.action(ParallelAction.class);
        parallelAction.addAction(action);
        parallelAction.addAction(action2);
        parallelAction.addAction(action3);
        parallelAction.addAction(action4);
        return parallelAction;
    }

    public static ParallelAction parallel(Action action, Action action2, Action action3, Action action4, Action action5) {
        ParallelAction parallelAction = Actions.action(ParallelAction.class);
        parallelAction.addAction(action);
        parallelAction.addAction(action2);
        parallelAction.addAction(action3);
        parallelAction.addAction(action4);
        parallelAction.addAction(action5);
        return parallelAction;
    }

    public static ParallelAction parallel(Action ... actionArray) {
        ParallelAction parallelAction = Actions.action(ParallelAction.class);
        int n = actionArray.length;
        for (int i = 0; i < n; ++i) {
            parallelAction.addAction(actionArray[i]);
        }
        return parallelAction;
    }

    public static RemoveAction removeAction(Action action) {
        RemoveAction removeAction = Actions.action(RemoveAction.class);
        removeAction.setAction(action);
        return removeAction;
    }

    public static RemoveAction removeAction(Action action, Actor actor) {
        RemoveAction removeAction = Actions.action(RemoveAction.class);
        removeAction.setTarget(actor);
        removeAction.setAction(action);
        return removeAction;
    }

    public static RemoveActorAction removeActor() {
        return Actions.action(RemoveActorAction.class);
    }

    public static RemoveActorAction removeActor(Actor actor) {
        RemoveActorAction removeActorAction = Actions.action(RemoveActorAction.class);
        removeActorAction.setTarget(actor);
        return removeActorAction;
    }

    public static RemoveListenerAction removeListener(EventListener eventListener, boolean bl) {
        RemoveListenerAction removeListenerAction = Actions.action(RemoveListenerAction.class);
        removeListenerAction.setListener(eventListener);
        removeListenerAction.setCapture(bl);
        return removeListenerAction;
    }

    public static RemoveListenerAction removeListener(EventListener eventListener, boolean bl, Actor actor) {
        RemoveListenerAction removeListenerAction = Actions.action(RemoveListenerAction.class);
        removeListenerAction.setTarget(actor);
        removeListenerAction.setListener(eventListener);
        removeListenerAction.setCapture(bl);
        return removeListenerAction;
    }

    public static RepeatAction repeat(int n, Action action) {
        RepeatAction repeatAction = Actions.action(RepeatAction.class);
        repeatAction.setCount(n);
        repeatAction.setAction(action);
        return repeatAction;
    }

    public static RotateByAction rotateBy(float f) {
        return Actions.rotateBy(f, 0.0f, null);
    }

    public static RotateByAction rotateBy(float f, float f2) {
        return Actions.rotateBy(f, f2, null);
    }

    public static RotateByAction rotateBy(float f, float f2, Interpolation interpolation) {
        RotateByAction rotateByAction = Actions.action(RotateByAction.class);
        rotateByAction.setAmount(f);
        rotateByAction.setDuration(f2);
        rotateByAction.setInterpolation(interpolation);
        return rotateByAction;
    }

    public static RotateToAction rotateTo(float f) {
        return Actions.rotateTo(f, 0.0f, null);
    }

    public static RotateToAction rotateTo(float f, float f2) {
        return Actions.rotateTo(f, f2, null);
    }

    public static RotateToAction rotateTo(float f, float f2, Interpolation interpolation) {
        RotateToAction rotateToAction = Actions.action(RotateToAction.class);
        rotateToAction.setRotation(f);
        rotateToAction.setDuration(f2);
        rotateToAction.setInterpolation(interpolation);
        return rotateToAction;
    }

    public static RunnableAction run(Runnable runnable) {
        RunnableAction runnableAction = Actions.action(RunnableAction.class);
        runnableAction.setRunnable(runnable);
        return runnableAction;
    }

    public static ScaleByAction scaleBy(float f, float f2) {
        return Actions.scaleBy(f, f2, 0.0f, null);
    }

    public static ScaleByAction scaleBy(float f, float f2, float f3) {
        return Actions.scaleBy(f, f2, f3, null);
    }

    public static ScaleByAction scaleBy(float f, float f2, float f3, Interpolation interpolation) {
        ScaleByAction scaleByAction = Actions.action(ScaleByAction.class);
        scaleByAction.setAmount(f, f2);
        scaleByAction.setDuration(f3);
        scaleByAction.setInterpolation(interpolation);
        return scaleByAction;
    }

    public static ScaleToAction scaleTo(float f, float f2) {
        return Actions.scaleTo(f, f2, 0.0f, null);
    }

    public static ScaleToAction scaleTo(float f, float f2, float f3) {
        return Actions.scaleTo(f, f2, f3, null);
    }

    public static ScaleToAction scaleTo(float f, float f2, float f3, Interpolation interpolation) {
        ScaleToAction scaleToAction = Actions.action(ScaleToAction.class);
        scaleToAction.setScale(f, f2);
        scaleToAction.setDuration(f3);
        scaleToAction.setInterpolation(interpolation);
        return scaleToAction;
    }

    public static SequenceAction sequence() {
        return Actions.action(SequenceAction.class);
    }

    public static SequenceAction sequence(Action action) {
        SequenceAction sequenceAction = Actions.action(SequenceAction.class);
        sequenceAction.addAction(action);
        return sequenceAction;
    }

    public static SequenceAction sequence(Action action, Action action2) {
        SequenceAction sequenceAction = Actions.action(SequenceAction.class);
        sequenceAction.addAction(action);
        sequenceAction.addAction(action2);
        return sequenceAction;
    }

    public static SequenceAction sequence(Action action, Action action2, Action action3) {
        SequenceAction sequenceAction = Actions.action(SequenceAction.class);
        sequenceAction.addAction(action);
        sequenceAction.addAction(action2);
        sequenceAction.addAction(action3);
        return sequenceAction;
    }

    public static SequenceAction sequence(Action action, Action action2, Action action3, Action action4) {
        SequenceAction sequenceAction = Actions.action(SequenceAction.class);
        sequenceAction.addAction(action);
        sequenceAction.addAction(action2);
        sequenceAction.addAction(action3);
        sequenceAction.addAction(action4);
        return sequenceAction;
    }

    public static SequenceAction sequence(Action action, Action action2, Action action3, Action action4, Action action5) {
        SequenceAction sequenceAction = Actions.action(SequenceAction.class);
        sequenceAction.addAction(action);
        sequenceAction.addAction(action2);
        sequenceAction.addAction(action3);
        sequenceAction.addAction(action4);
        sequenceAction.addAction(action5);
        return sequenceAction;
    }

    public static SequenceAction sequence(Action ... actionArray) {
        SequenceAction sequenceAction = Actions.action(SequenceAction.class);
        int n = actionArray.length;
        for (int i = 0; i < n; ++i) {
            sequenceAction.addAction(actionArray[i]);
        }
        return sequenceAction;
    }

    public static VisibleAction show() {
        return Actions.visible(true);
    }

    public static SizeByAction sizeBy(float f, float f2) {
        return Actions.sizeBy(f, f2, 0.0f, null);
    }

    public static SizeByAction sizeBy(float f, float f2, float f3) {
        return Actions.sizeBy(f, f2, f3, null);
    }

    public static SizeByAction sizeBy(float f, float f2, float f3, Interpolation interpolation) {
        SizeByAction sizeByAction = Actions.action(SizeByAction.class);
        sizeByAction.setAmount(f, f2);
        sizeByAction.setDuration(f3);
        sizeByAction.setInterpolation(interpolation);
        return sizeByAction;
    }

    public static SizeToAction sizeTo(float f, float f2) {
        return Actions.sizeTo(f, f2, 0.0f, null);
    }

    public static SizeToAction sizeTo(float f, float f2, float f3) {
        return Actions.sizeTo(f, f2, f3, null);
    }

    public static SizeToAction sizeTo(float f, float f2, float f3, Interpolation interpolation) {
        SizeToAction sizeToAction = Actions.action(SizeToAction.class);
        sizeToAction.setSize(f, f2);
        sizeToAction.setDuration(f3);
        sizeToAction.setInterpolation(interpolation);
        return sizeToAction;
    }

    public static TimeScaleAction timeScale(float f, Action action) {
        TimeScaleAction timeScaleAction = Actions.action(TimeScaleAction.class);
        timeScaleAction.setScale(f);
        timeScaleAction.setAction(action);
        return timeScaleAction;
    }

    public static TouchableAction touchable(Touchable touchable) {
        TouchableAction touchableAction = Actions.action(TouchableAction.class);
        touchableAction.setTouchable(touchable);
        return touchableAction;
    }

    public static VisibleAction visible(boolean bl) {
        VisibleAction visibleAction = Actions.action(VisibleAction.class);
        visibleAction.setVisible(bl);
        return visibleAction;
    }
}

