/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;

public class InputEvent
extends Event {
    private int button;
    private char character;
    private int keyCode;
    private int pointer;
    private Actor relatedActor;
    private int scrollAmount;
    private float stageX;
    private float stageY;
    private Type type;

    public int getButton() {
        return this.button;
    }

    public char getCharacter() {
        return this.character;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getPointer() {
        return this.pointer;
    }

    public Actor getRelatedActor() {
        return this.relatedActor;
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    public float getStageX() {
        return this.stageX;
    }

    public float getStageY() {
        return this.stageY;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isTouchFocusCancel() {
        boolean bl = this.stageX == -2.1474836E9f || this.stageY == -2.1474836E9f;
        return bl;
    }

    @Override
    public void reset() {
        super.reset();
        this.relatedActor = null;
        this.button = -1;
    }

    public void setButton(int n) {
        this.button = n;
    }

    public void setCharacter(char c) {
        this.character = c;
    }

    public void setKeyCode(int n) {
        this.keyCode = n;
    }

    public void setPointer(int n) {
        this.pointer = n;
    }

    public void setRelatedActor(Actor actor) {
        this.relatedActor = actor;
    }

    public void setScrollAmount(int n) {
        this.scrollAmount = n;
    }

    public void setStageX(float f) {
        this.stageX = f;
    }

    public void setStageY(float f) {
        this.stageY = f;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Vector2 toCoordinates(Actor actor, Vector2 vector2) {
        vector2.set(this.stageX, this.stageY);
        actor.stageToLocalCoordinates(vector2);
        return vector2;
    }

    public String toString() {
        return this.type.toString();
    }

    public static enum Type {
        touchDown,
        touchUp,
        touchDragged,
        mouseMoved,
        enter,
        exit,
        scrolled,
        keyDown,
        keyUp,
        keyTyped;

    }
}

