/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.net;

import com.badlogic.gdx.Net;
import com.badlogic.gdx.net.NetJavaSocketImpl;
import com.badlogic.gdx.net.ServerSocket;
import com.badlogic.gdx.net.ServerSocketHints;
import com.badlogic.gdx.net.Socket;
import com.badlogic.gdx.net.SocketHints;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class NetJavaServerSocketImpl
implements ServerSocket {
    private Net.Protocol protocol;
    private java.net.ServerSocket server;

    public NetJavaServerSocketImpl(Net.Protocol protocol, int n, ServerSocketHints serverSocketHints) {
        this(protocol, null, n, serverSocketHints);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NetJavaServerSocketImpl(Net.Protocol object, String string2, int n, ServerSocketHints serverSocketHints) {
        this.protocol = object;
        try {
            this.server = object = new java.net.ServerSocket();
            if (serverSocketHints != null) {
                this.server.setPerformancePreferences(serverSocketHints.performancePrefConnectionTime, serverSocketHints.performancePrefLatency, serverSocketHints.performancePrefBandwidth);
                this.server.setReuseAddress(serverSocketHints.reuseAddress);
                this.server.setSoTimeout(serverSocketHints.acceptTimeout);
                this.server.setReceiveBufferSize(serverSocketHints.receiveBufferSize);
            }
            object = string2 != null ? new InetSocketAddress(string2, n) : new InetSocketAddress(n);
            if (serverSocketHints != null) {
                this.server.bind((SocketAddress)object, serverSocketHints.backlog);
                return;
            }
            this.server.bind((SocketAddress)object);
            return;
        }
        catch (Exception exception) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Cannot create a server socket at port ");
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append(".");
            throw new GdxRuntimeException(((StringBuilder)object).toString(), exception);
        }
    }

    @Override
    public Socket accept(SocketHints object) {
        try {
            object = new NetJavaSocketImpl(this.server.accept(), (SocketHints)object);
            return object;
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Error accepting socket.", exception);
        }
    }

    @Override
    public void dispose() {
        java.net.ServerSocket serverSocket = this.server;
        if (serverSocket != null) {
            try {
                serverSocket.close();
                this.server = null;
            }
            catch (Exception exception) {
                throw new GdxRuntimeException("Error closing server.", exception);
            }
        }
    }

    @Override
    public Net.Protocol getProtocol() {
        return this.protocol;
    }
}

