/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math.collision;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import java.io.Serializable;

public class Ray
implements Serializable {
    private static final long serialVersionUID = -620692054835390878L;
    static Vector3 tmp = new Vector3();
    public final Vector3 direction;
    public final Vector3 origin = new Vector3();

    public Ray() {
        this.direction = new Vector3();
    }

    public Ray(Vector3 vector3, Vector3 vector32) {
        this.direction = new Vector3();
        this.origin.set(vector3);
        this.direction.set(vector32).nor();
    }

    public Ray cpy() {
        return new Ray(this.origin, this.direction);
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            object = (Ray)object;
            if (!this.direction.equals(((Ray)object).direction) || !this.origin.equals(((Ray)object).origin)) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public Vector3 getEndPoint(Vector3 vector3, float f) {
        return vector3.set(this.direction).scl(f).add(this.origin);
    }

    public int hashCode() {
        return (this.direction.hashCode() + 73) * 73 + this.origin.hashCode();
    }

    public Ray mul(Matrix4 matrix4) {
        tmp.set(this.origin).add(this.direction);
        tmp.mul(matrix4);
        this.origin.mul(matrix4);
        this.direction.set(tmp.sub(this.origin));
        return this;
    }

    public Ray set(float f, float f2, float f3, float f4, float f5, float f6) {
        this.origin.set(f, f2, f3);
        this.direction.set(f4, f5, f6);
        return this;
    }

    public Ray set(Vector3 vector3, Vector3 vector32) {
        this.origin.set(vector3);
        this.direction.set(vector32);
        return this;
    }

    public Ray set(Ray ray) {
        this.origin.set(ray.origin);
        this.direction.set(ray.direction);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ray [");
        stringBuilder.append(this.origin);
        stringBuilder.append(":");
        stringBuilder.append(this.direction);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

