/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.WindowedMean;

public class FloatCounter {
    public float average;
    public int count;
    public float latest;
    public float max;
    public final WindowedMean mean;
    public float min;
    public float total;
    public float value;

    public FloatCounter(int n) {
        WindowedMean windowedMean = n > 1 ? new WindowedMean(n) : null;
        this.mean = windowedMean;
        this.reset();
    }

    public void put(float f) {
        this.latest = f;
        this.total += f;
        ++this.count;
        this.average = this.total / (float)this.count;
        WindowedMean windowedMean = this.mean;
        if (windowedMean != null) {
            windowedMean.addValue(f);
            this.value = this.mean.getMean();
        } else {
            this.value = this.latest;
        }
        windowedMean = this.mean;
        if (windowedMean == null || windowedMean.hasEnoughData()) {
            f = this.value;
            if (f < this.min) {
                this.min = f;
            }
            if ((f = this.value) > this.max) {
                this.max = f;
            }
        }
    }

    public void reset() {
        this.count = 0;
        this.total = 0.0f;
        this.min = Float.MAX_VALUE;
        this.max = -3.4028235E38f;
        this.average = 0.0f;
        this.latest = 0.0f;
        this.value = 0.0f;
        WindowedMean windowedMean = this.mean;
        if (windowedMean != null) {
            windowedMean.clear();
        }
    }
}

