/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.BaseTmxMapLoader;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.XmlReader;
import java.util.Iterator;

public class AtlasTmxMapLoader
extends BaseTmxMapLoader<AtlasTiledMapLoaderParameters> {
    protected AtlasResolver atlasResolver;
    protected Array<Texture> trackedTextures = new Array();

    public AtlasTmxMapLoader() {
        super(new InternalFileHandleResolver());
    }

    public AtlasTmxMapLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    /*
     * WARNING - void declaration
     */
    private FileHandle getAtlasFileHandle(FileHandle object) {
        void var2_7;
        XmlReader.Element object22 = this.root.getChildByName("properties");
        if (object22 != null) {
            for (XmlReader.Element element : object22.getChildrenByName("property")) {
                if (!element.getAttribute("name").startsWith("atlas")) continue;
                String string2 = element.getAttribute("value");
                break;
            }
        } else {
            Object var2_6 = null;
        }
        if (var2_7 != null) {
            if (((FileHandle)(object = AtlasTmxMapLoader.getRelativeFileHandle((FileHandle)object, (String)var2_7))).exists()) {
                return object;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("The 'atlas' file could not be found: '");
            ((StringBuilder)object).append((String)var2_7);
            ((StringBuilder)object).append("'");
            throw new GdxRuntimeException(((StringBuilder)object).toString());
        }
        object = new GdxRuntimeException("The map is missing the 'atlas' property");
        throw object;
    }

    private void setTextureFilters(Texture.TextureFilter textureFilter, Texture.TextureFilter textureFilter2) {
        Iterator<Texture> iterator = this.trackedTextures.iterator();
        while (iterator.hasNext()) {
            iterator.next().setFilter(textureFilter, textureFilter2);
        }
        this.trackedTextures.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addStaticTiles(FileHandle object, ImageResolver object22, TiledMapTileSet tiledMapTileSet, XmlReader.Element object3, Array<XmlReader.Element> object4, String string2, int n, int n2, int n3, int n4, int n5, String string3, int n6, int n7, String string4, int n8, int n9, FileHandle fileHandle) {
        TextureAtlas.AtlasRegion atlasRegion;
        void var14_20;
        void var13_19;
        void var7_13;
        void var10_16;
        void var11_17;
        void var9_15;
        void var8_14;
        void var17_23;
        void var16_22;
        void var15_21;
        void var3_9;
        object = this.atlasResolver.getAtlas();
        for (Texture texture : ((TextureAtlas)object).getTextures()) {
            this.trackedTextures.add(texture);
        }
        MapProperties mapProperties = var3_9.getProperties();
        mapProperties.put("imagesource", var15_21);
        mapProperties.put("imagewidth", (int)var16_22);
        mapProperties.put("imageheight", (int)var17_23);
        mapProperties.put("tilewidth", (int)var8_14);
        mapProperties.put("tileheight", (int)var9_15);
        mapProperties.put("margin", (int)var11_17);
        mapProperties.put("spacing", (int)var10_16);
        if (var15_21 != null && var15_21.length() > 0) {
            void var6_12;
            var8_14 = var16_22 / var8_14;
            var10_16 = var17_23 / var9_15;
            for (TextureAtlas.AtlasRegion atlasRegion2 : ((TextureAtlas)object).findRegions((String)var6_12)) {
                if (atlasRegion2 == null || (var9_15 = var7_13 + atlasRegion2.index) < var7_13 || var9_15 > var8_14 * var10_16 + var7_13 - true) continue;
                this.addStaticTiledMapTile((TiledMapTileSet)var3_9, atlasRegion2, (int)var9_15, (float)var13_19, (float)var14_20);
            }
        }
        Iterator iterator = ((Array)((Object)atlasRegion)).iterator();
        while (iterator.hasNext()) {
            Object object2 = (XmlReader.Element)iterator.next();
            var8_14 = var7_13 + ((XmlReader.Element)object2).getIntAttribute("id", 0);
            if (var3_9.getTile((int)var8_14) != null || (object2 = ((XmlReader.Element)object2).getChildByName("image")) == null) continue;
            object2 = ((XmlReader.Element)object2).getAttribute("source");
            atlasRegion = ((TextureAtlas)object).findRegion((String)(object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(46))));
            if (atlasRegion != null) {
                this.addStaticTiledMapTile((TiledMapTileSet)var3_9, atlasRegion, (int)var8_14, (float)var13_19, (float)var14_20);
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Tileset atlasRegion not found: ");
            ((StringBuilder)object).append((String)object2);
            throw new GdxRuntimeException(((StringBuilder)object).toString());
        }
    }

    @Override
    protected Array<AssetDescriptor> getDependencyAssetDescriptors(FileHandle fileHandle, TextureLoader.TextureParameter object) {
        object = new Array();
        if ((fileHandle = this.getAtlasFileHandle(fileHandle)) != null) {
            ((Array)object).add(new AssetDescriptor<TextureAtlas>(fileHandle, TextureAtlas.class));
        }
        return object;
    }

    public TiledMap load(String string2) {
        return this.load(string2, new AtlasTiledMapLoaderParameters());
    }

    public TiledMap load(String object, AtlasTiledMapLoaderParameters atlasTiledMapLoaderParameters) {
        Object object2 = this.resolve((String)object);
        this.root = this.xml.parse((FileHandle)object2);
        object = new TextureAtlas(this.getAtlasFileHandle((FileHandle)object2));
        this.atlasResolver = new AtlasResolver.DirectAtlasResolver((TextureAtlas)object);
        object2 = this.loadTiledMap((FileHandle)object2, atlasTiledMapLoaderParameters, this.atlasResolver);
        ((TiledMap)object2).setOwnedResources(new Array<TextureAtlas>(new TextureAtlas[]{object}));
        this.setTextureFilters(atlasTiledMapLoaderParameters.textureMinFilter, atlasTiledMapLoaderParameters.textureMagFilter);
        return object2;
    }

    @Override
    public void loadAsync(AssetManager assetManager, String string2, FileHandle fileHandle, AtlasTiledMapLoaderParameters atlasTiledMapLoaderParameters) {
        this.atlasResolver = new AtlasResolver.AssetManagerAtlasResolver(assetManager, this.getAtlasFileHandle(fileHandle).path());
        this.map = this.loadTiledMap(fileHandle, atlasTiledMapLoaderParameters, this.atlasResolver);
    }

    @Override
    public TiledMap loadSync(AssetManager assetManager, String string2, FileHandle fileHandle, AtlasTiledMapLoaderParameters atlasTiledMapLoaderParameters) {
        if (atlasTiledMapLoaderParameters != null) {
            this.setTextureFilters(atlasTiledMapLoaderParameters.textureMinFilter, atlasTiledMapLoaderParameters.textureMagFilter);
        }
        return this.map;
    }

    private static interface AtlasResolver
    extends ImageResolver {
        public TextureAtlas getAtlas();

        public static class AssetManagerAtlasResolver
        implements AtlasResolver {
            private final AssetManager assetManager;
            private final String atlasName;

            public AssetManagerAtlasResolver(AssetManager assetManager, String string2) {
                this.assetManager = assetManager;
                this.atlasName = string2;
            }

            @Override
            public TextureAtlas getAtlas() {
                return this.assetManager.get(this.atlasName, TextureAtlas.class);
            }

            @Override
            public TextureRegion getImage(String string2) {
                return this.getAtlas().findRegion(string2);
            }
        }

        public static class DirectAtlasResolver
        implements AtlasResolver {
            private final TextureAtlas atlas;

            public DirectAtlasResolver(TextureAtlas textureAtlas) {
                this.atlas = textureAtlas;
            }

            @Override
            public TextureAtlas getAtlas() {
                return this.atlas;
            }

            @Override
            public TextureRegion getImage(String string2) {
                return this.atlas.findRegion(string2);
            }
        }
    }

    public static class AtlasTiledMapLoaderParameters
    extends BaseTmxMapLoader.Parameters {
        public boolean forceTextureFilters = false;
    }
}

