/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.CubemapData;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.ETC1;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.zip.GZIPInputStream;

public class KTXTextureData
implements CubemapData,
TextureData {
    private static final int GL_TEXTURE_1D = 4660;
    private static final int GL_TEXTURE_1D_ARRAY_EXT = 4660;
    private static final int GL_TEXTURE_2D_ARRAY_EXT = 4660;
    private static final int GL_TEXTURE_3D = 4660;
    private ByteBuffer compressedData;
    private FileHandle file;
    private int glBaseInternalFormat;
    private int glFormat;
    private int glInternalFormat;
    private int glType;
    private int glTypeSize;
    private int imagePos;
    private int numberOfArrayElements;
    private int numberOfFaces;
    private int numberOfMipmapLevels;
    private int pixelDepth = -1;
    private int pixelHeight = -1;
    private int pixelWidth = -1;
    private boolean useMipMaps;

    public KTXTextureData(FileHandle fileHandle, boolean bl) {
        this.file = fileHandle;
        this.useMipMaps = bl;
    }

    @Override
    public void consumeCubemapData() {
        this.consumeCustomData(34067);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void consumeCustomData(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.compressedData == null) {
            GdxRuntimeException gdxRuntimeException = new GdxRuntimeException("Call prepare() before calling consumeCompressedData()");
            throw gdxRuntimeException;
        }
        Object object = BufferUtils.newIntBuffer(16);
        if (this.glType != 0 && this.glFormat != 0) {
            n5 = 0;
        } else {
            if (this.glType + this.glFormat != 0) throw new GdxRuntimeException("either both or none of glType, glFormat must be zero");
            n5 = 1;
        }
        if (this.pixelHeight > 0) {
            n4 = 2;
            n3 = 3553;
        } else {
            n4 = 1;
            n3 = 4660;
        }
        if (this.pixelDepth > 0) {
            n4 = 3;
            n3 = 4660;
        }
        if ((n2 = this.numberOfFaces) == 6) {
            if (n4 != 2) throw new GdxRuntimeException("cube map needs 2D faces");
            n3 = 34067;
        } else if (n2 != 1) throw new GdxRuntimeException("numberOfFaces must be either 1 or 6");
        n2 = n4;
        int n6 = n3;
        if (this.numberOfArrayElements > 0) {
            if (n3 != 4660) {
                if (n3 != 3553) throw new GdxRuntimeException("No API for 3D and cube arrays yet");
            }
            n2 = n4 + 1;
            n6 = 4660;
        }
        if (n6 == 4660) throw new GdxRuntimeException("Unsupported texture format (only 2D texture are supported in LibGdx for the time being)");
        n4 = this.numberOfFaces;
        int n7 = 34069;
        if (n4 == 6 && n != 34067) {
            if (34069 > n) throw new GdxRuntimeException("You must specify either GL_TEXTURE_CUBE_MAP to bind all 6 faces of the cube or the requested face GL_TEXTURE_CUBE_MAP_POSITIVE_X and followings.");
            if (n > 34074) throw new GdxRuntimeException("You must specify either GL_TEXTURE_CUBE_MAP to bind all 6 faces of the cube or the requested face GL_TEXTURE_CUBE_MAP_POSITIVE_X and followings.");
            n4 = n - 34069;
        } else {
            if (this.numberOfFaces == 6 && n == 34067) {
                n = n7;
            } else if (n != n6 && (34069 > n || n > 34074 || n != 3553)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Invalid target requested : 0x");
                ((StringBuilder)object).append(Integer.toHexString(n));
                ((StringBuilder)object).append(", expecting : 0x");
                ((StringBuilder)object).append(Integer.toHexString(n6));
                throw new GdxRuntimeException(((StringBuilder)object).toString());
            }
            n4 = -1;
            n7 = n;
        }
        Gdx.gl.glGetIntegerv(3317, (IntBuffer)object);
        int n8 = ((IntBuffer)object).get(0);
        if (n8 != 4) {
            Gdx.gl.glPixelStorei(3317, 4);
        }
        int n9 = this.glInternalFormat;
        int n10 = this.glFormat;
        n3 = this.imagePos;
        n6 = 0;
        n = n5;
        n5 = n4;
        while (true) {
            int n11;
            int n12;
            int n13;
            if (n6 < this.numberOfMipmapLevels) {
                n13 = Math.max(1, this.pixelWidth >> n6);
                n4 = Math.max(1, this.pixelHeight >> n6);
                Math.max(1, this.pixelDepth >> n6);
                this.compressedData.position(n3);
                n12 = this.compressedData.getInt();
                n11 = n12 + 3 & 0xFFFFFFFC;
                n3 += 4;
            } else {
                if (n8 != 4) {
                    Gdx.gl.glPixelStorei(3317, n8);
                }
                if (this.useMipMaps()) {
                    Gdx.gl.glGenerateMipmap(n7);
                }
                this.disposePreparedData();
                return;
            }
            for (int i = 0; i < this.numberOfFaces; ++i) {
                int n14;
                block31: {
                    block32: {
                        block28: {
                            block33: {
                                block30: {
                                    block29: {
                                        this.compressedData.position(n3);
                                        n3 += n11;
                                        if (n5 != -1 && n5 != i) break block29;
                                        object = this.compressedData.slice();
                                        ((ByteBuffer)object).limit(n11);
                                        if (n2 != 1) break block30;
                                    }
                                    n14 = n4;
                                    break block31;
                                }
                                if (n2 != 2) break block32;
                                n14 = this.numberOfArrayElements;
                                if (n14 > 0) {
                                    n4 = n14;
                                }
                                if (n == 0) break block33;
                                if (n9 == ETC1.ETC1_RGB8_OES) {
                                    if (!Gdx.graphics.supportsExtension("GL_OES_compressed_ETC1_RGB8_texture")) {
                                        object = ETC1.decodeImage(new ETC1.ETC1Data(n13, n4, (ByteBuffer)object, 0), Pixmap.Format.RGB888);
                                        Gdx.gl.glTexImage2D(n7 + i, n6, ((Pixmap)object).getGLInternalFormat(), ((Pixmap)object).getWidth(), ((Pixmap)object).getHeight(), 0, ((Pixmap)object).getGLFormat(), ((Pixmap)object).getGLType(), ((Pixmap)object).getPixels());
                                        ((Pixmap)object).dispose();
                                        break block28;
                                    } else {
                                        Gdx.gl.glCompressedTexImage2D(n7 + i, n6, n9, n13, n4, 0, n12, (Buffer)object);
                                    }
                                    break block28;
                                } else {
                                    Gdx.gl.glCompressedTexImage2D(n7 + i, n6, n9, n13, n4, 0, n12, (Buffer)object);
                                }
                                break block28;
                            }
                            Gdx.gl.glTexImage2D(n7 + i, n6, n9, n13, n4, 0, n10, this.glType, (Buffer)object);
                        }
                        n14 = n4;
                        break block31;
                    }
                    n14 = n4;
                    if (n2 == 3) {
                        n14 = this.numberOfArrayElements;
                        n14 = n4;
                    }
                }
                n4 = n14;
            }
            ++n6;
        }
    }

    @Override
    public Pixmap consumePixmap() {
        throw new GdxRuntimeException("This TextureData implementation does not return a Pixmap");
    }

    @Override
    public boolean disposePixmap() {
        throw new GdxRuntimeException("This TextureData implementation does not return a Pixmap");
    }

    public void disposePreparedData() {
        ByteBuffer byteBuffer = this.compressedData;
        if (byteBuffer != null) {
            BufferUtils.disposeUnsafeByteBuffer(byteBuffer);
        }
        this.compressedData = null;
    }

    public ByteBuffer getData(int n, int n2) {
        int n3 = this.imagePos;
        for (int i = 0; i < this.numberOfMipmapLevels; ++i) {
            int n4 = this.compressedData.getInt(n3) + 3 & 0xFFFFFFFC;
            n3 += 4;
            if (i == n) {
                for (int j = 0; j < this.numberOfFaces; ++j) {
                    if (j == n2) {
                        this.compressedData.position(n3);
                        ByteBuffer byteBuffer = this.compressedData.slice();
                        byteBuffer.limit(n4);
                        return byteBuffer;
                    }
                    n3 += n4;
                }
                continue;
            }
            n3 += n4 * this.numberOfFaces;
        }
        return null;
    }

    @Override
    public Pixmap.Format getFormat() {
        throw new GdxRuntimeException("This TextureData implementation directly handles texture formats.");
    }

    public int getGlInternalFormat() {
        return this.glInternalFormat;
    }

    @Override
    public int getHeight() {
        return this.pixelHeight;
    }

    public int getNumberOfFaces() {
        return this.numberOfFaces;
    }

    public int getNumberOfMipMapLevels() {
        return this.numberOfMipmapLevels;
    }

    @Override
    public TextureData.TextureDataType getType() {
        return TextureData.TextureDataType.Custom;
    }

    @Override
    public int getWidth() {
        return this.pixelWidth;
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public boolean isPrepared() {
        boolean bl = this.compressedData != null;
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void prepare() {
        int n;
        Object object;
        Object object2;
        block17: {
            block16: {
                block14: {
                    GdxRuntimeException gdxRuntimeException;
                    Object object3;
                    block15: {
                        if (this.compressedData != null) {
                            GdxRuntimeException gdxRuntimeException2 = new GdxRuntimeException("Already prepared");
                            throw gdxRuntimeException2;
                        }
                        object2 = this.file;
                        if (object2 == null) throw new GdxRuntimeException("Need a file to load from");
                        if (!((FileHandle)object2).name().endsWith(".zktx")) break block16;
                        object3 = new byte[10240];
                        gdxRuntimeException = null;
                        DataInputStream dataInputStream = null;
                        object2 = dataInputStream;
                        try {
                            object2 = dataInputStream;
                            object2 = dataInputStream;
                            object2 = dataInputStream;
                            GZIPInputStream gZIPInputStream = new GZIPInputStream(this.file.read());
                            object2 = dataInputStream;
                            BufferedInputStream bufferedInputStream = new BufferedInputStream(gZIPInputStream);
                            object2 = dataInputStream;
                            object = new DataInputStream(bufferedInputStream);
                        }
                        catch (Throwable throwable) {
                            break block14;
                        }
                        catch (Exception exception) {
                            object = gdxRuntimeException;
                            break block15;
                        }
                        try {
                            this.compressedData = BufferUtils.newUnsafeByteBuffer(((DataInputStream)object).readInt());
                            while ((n = ((DataInputStream)object).read((byte[])object3)) != -1) {
                                this.compressedData.put((byte[])object3, 0, n);
                            }
                            this.compressedData.position(0);
                            this.compressedData.limit(this.compressedData.capacity());
                        }
                        catch (Throwable throwable) {
                            dataInputStream = object;
                            object = throwable;
                            object2 = dataInputStream;
                            break block14;
                        }
                        catch (Exception exception) {
                            break block15;
                        }
                        StreamUtils.closeQuietly((Closeable)object);
                        break block17;
                    }
                    object2 = object;
                    {
                        void var4_9;
                        object2 = object;
                        object3 = new StringBuilder;
                        object2 = object;
                        ((StringBuilder)object3)();
                        object2 = object;
                        ((StringBuilder)object3).append("Couldn't load zktx file '");
                        object2 = object;
                        ((StringBuilder)object3).append(this.file);
                        object2 = object;
                        ((StringBuilder)object3).append("'");
                        object2 = object;
                        gdxRuntimeException = new GdxRuntimeException(((StringBuilder)object3).toString(), (Throwable)var4_9);
                        object2 = object;
                        throw gdxRuntimeException;
                    }
                }
                StreamUtils.closeQuietly((Closeable)object2);
                throw object;
            }
            this.compressedData = ByteBuffer.wrap(this.file.readBytes());
        }
        if (this.compressedData.get() != -85) throw new GdxRuntimeException("Invalid KTX Header");
        if (this.compressedData.get() != 75) throw new GdxRuntimeException("Invalid KTX Header");
        if (this.compressedData.get() != 84) throw new GdxRuntimeException("Invalid KTX Header");
        if (this.compressedData.get() != 88) throw new GdxRuntimeException("Invalid KTX Header");
        if (this.compressedData.get() != 32) throw new GdxRuntimeException("Invalid KTX Header");
        if (this.compressedData.get() != 49) throw new GdxRuntimeException("Invalid KTX Header");
        if (this.compressedData.get() != 49) throw new GdxRuntimeException("Invalid KTX Header");
        if (this.compressedData.get() != -69) throw new GdxRuntimeException("Invalid KTX Header");
        if (this.compressedData.get() != 13) throw new GdxRuntimeException("Invalid KTX Header");
        if (this.compressedData.get() != 10) throw new GdxRuntimeException("Invalid KTX Header");
        if (this.compressedData.get() != 26) throw new GdxRuntimeException("Invalid KTX Header");
        if (this.compressedData.get() != 10) throw new GdxRuntimeException("Invalid KTX Header");
        n = this.compressedData.getInt();
        if (n != 67305985) {
            if (n != 16909060) throw new GdxRuntimeException("Invalid KTX Header");
        }
        if (n != 67305985) {
            object = this.compressedData;
            object2 = ((ByteBuffer)object).order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            ((ByteBuffer)object).order((ByteOrder)object2);
        }
        this.glType = this.compressedData.getInt();
        this.glTypeSize = this.compressedData.getInt();
        this.glFormat = this.compressedData.getInt();
        this.glInternalFormat = this.compressedData.getInt();
        this.glBaseInternalFormat = this.compressedData.getInt();
        this.pixelWidth = this.compressedData.getInt();
        this.pixelHeight = this.compressedData.getInt();
        this.pixelDepth = this.compressedData.getInt();
        this.numberOfArrayElements = this.compressedData.getInt();
        this.numberOfFaces = this.compressedData.getInt();
        this.numberOfMipmapLevels = this.compressedData.getInt();
        if (this.numberOfMipmapLevels == 0) {
            this.numberOfMipmapLevels = 1;
            this.useMipMaps = true;
        }
        n = this.compressedData.getInt();
        this.imagePos = this.compressedData.position() + n;
        if (this.compressedData.isDirect()) return;
        n = this.imagePos;
        int n2 = 0;
        while (true) {
            if (n2 >= this.numberOfMipmapLevels) {
                this.compressedData.limit(n);
                this.compressedData.position(0);
                object2 = BufferUtils.newUnsafeByteBuffer(n);
                ((ByteBuffer)object2).order(this.compressedData.order());
                ((ByteBuffer)object2).put(this.compressedData);
                this.compressedData = object2;
                return;
            }
            n += (this.compressedData.getInt(n) + 3 & 0xFFFFFFFC) * this.numberOfFaces + 4;
            ++n2;
        }
    }

    @Override
    public boolean useMipMaps() {
        return this.useMipMaps;
    }
}

