/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.FloatBuffer;

public class FloatTextureData
implements TextureData {
    FloatBuffer buffer;
    int format;
    int height = 0;
    int internalFormat;
    boolean isGpuOnly;
    boolean isPrepared = false;
    int type;
    int width = 0;

    public FloatTextureData(int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.width = n;
        this.height = n2;
        this.internalFormat = n3;
        this.format = n4;
        this.type = n5;
        this.isGpuOnly = bl;
    }

    @Override
    public void consumeCustomData(int n) {
        block6: {
            block5: {
                block4: {
                    if (Gdx.app.getType() == Application.ApplicationType.Android || Gdx.app.getType() == Application.ApplicationType.iOS || Gdx.app.getType() == Application.ApplicationType.WebGL) break block4;
                    if (!Gdx.graphics.isGL30Available() && !Gdx.graphics.supportsExtension("GL_ARB_texture_float")) {
                        throw new GdxRuntimeException("Extension GL_ARB_texture_float not supported!");
                    }
                    Gdx.gl.glTexImage2D(n, 0, this.internalFormat, this.width, this.height, 0, this.format, 5126, this.buffer);
                    break block5;
                }
                if (!Gdx.graphics.supportsExtension("OES_texture_float")) break block6;
                Gdx.gl.glTexImage2D(n, 0, 6408, this.width, this.height, 0, 6408, 5126, this.buffer);
            }
            return;
        }
        throw new GdxRuntimeException("Extension OES_texture_float not supported!");
    }

    @Override
    public Pixmap consumePixmap() {
        throw new GdxRuntimeException("This TextureData implementation does not return a Pixmap");
    }

    @Override
    public boolean disposePixmap() {
        throw new GdxRuntimeException("This TextureData implementation does not return a Pixmap");
    }

    public FloatBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public Pixmap.Format getFormat() {
        return Pixmap.Format.RGBA8888;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public TextureData.TextureDataType getType() {
        return TextureData.TextureDataType.Custom;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared;
    }

    @Override
    public void prepare() {
        if (!this.isPrepared) {
            if (!this.isGpuOnly) {
                boolean bl = Gdx.graphics.getGLVersion().getType().equals((Object)GLVersion.Type.OpenGL);
                int n = 4;
                if (bl) {
                    int n2;
                    if (this.internalFormat != 34842) {
                        // empty if block
                    }
                    if ((n2 = this.internalFormat) == 34843 || n2 == 34837) {
                        n = 3;
                    }
                    if ((n2 = this.internalFormat) == 33327 || n2 == 33328) {
                        n = 2;
                    }
                    if ((n2 = this.internalFormat) == 33325 || n2 == 33326) {
                        n = 1;
                    }
                } else {
                    n = 4;
                }
                this.buffer = BufferUtils.newFloatBuffer(this.width * this.height * n);
            }
            this.isPrepared = true;
            return;
        }
        throw new GdxRuntimeException("Already prepared");
    }

    @Override
    public boolean useMipMaps() {
        return false;
    }
}

