/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.IntIntMap;

public class FirstPersonCameraController
extends InputAdapter {
    private int BACKWARD = 47;
    private int DOWN = 33;
    private int FORWARD = 51;
    private int STRAFE_LEFT = 29;
    private int STRAFE_RIGHT = 32;
    private int UP = 45;
    private final Camera camera;
    private float degreesPerPixel = 0.5f;
    private final IntIntMap keys = new IntIntMap();
    private final Vector3 tmp = new Vector3();
    private float velocity = 5.0f;

    public FirstPersonCameraController(Camera camera) {
        this.camera = camera;
    }

    @Override
    public boolean keyDown(int n) {
        this.keys.put(n, n);
        return true;
    }

    @Override
    public boolean keyUp(int n) {
        this.keys.remove(n, 0);
        return true;
    }

    public void setDegreesPerPixel(float f) {
        this.degreesPerPixel = f;
    }

    public void setVelocity(float f) {
        this.velocity = f;
    }

    @Override
    public boolean touchDragged(int n, int n2, int n3) {
        float f = -Gdx.input.getDeltaX();
        float f2 = this.degreesPerPixel;
        float f3 = -Gdx.input.getDeltaY();
        float f4 = this.degreesPerPixel;
        this.camera.direction.rotate(this.camera.up, f * f2);
        this.tmp.set(this.camera.direction).crs(this.camera.up).nor();
        this.camera.direction.rotate(this.tmp, f3 * f4);
        return true;
    }

    public void update() {
        this.update(Gdx.graphics.getDeltaTime());
    }

    public void update(float f) {
        if (this.keys.containsKey(this.FORWARD)) {
            this.tmp.set(this.camera.direction).nor().scl(this.velocity * f);
            this.camera.position.add(this.tmp);
        }
        if (this.keys.containsKey(this.BACKWARD)) {
            this.tmp.set(this.camera.direction).nor().scl(-f * this.velocity);
            this.camera.position.add(this.tmp);
        }
        if (this.keys.containsKey(this.STRAFE_LEFT)) {
            this.tmp.set(this.camera.direction).crs(this.camera.up).nor().scl(-f * this.velocity);
            this.camera.position.add(this.tmp);
        }
        if (this.keys.containsKey(this.STRAFE_RIGHT)) {
            this.tmp.set(this.camera.direction).crs(this.camera.up).nor().scl(this.velocity * f);
            this.camera.position.add(this.tmp);
        }
        if (this.keys.containsKey(this.UP)) {
            this.tmp.set(this.camera.up).nor().scl(this.velocity * f);
            this.camera.position.add(this.tmp);
        }
        if (this.keys.containsKey(this.DOWN)) {
            this.tmp.set(this.camera.up).nor().scl(-f * this.velocity);
            this.camera.position.add(this.tmp);
        }
        this.camera.update(true);
    }
}

