/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.values;

import com.badlogic.gdx.graphics.g3d.particles.values.ParticleValue;
import com.badlogic.gdx.graphics.g3d.particles.values.PrimitiveSpawnShapeValue;
import com.badlogic.gdx.graphics.g3d.particles.values.SpawnShapeValue;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public final class EllipseSpawnShapeValue
extends PrimitiveSpawnShapeValue {
    PrimitiveSpawnShapeValue.SpawnSide side = PrimitiveSpawnShapeValue.SpawnSide.both;

    public EllipseSpawnShapeValue() {
    }

    public EllipseSpawnShapeValue(EllipseSpawnShapeValue ellipseSpawnShapeValue) {
        super(ellipseSpawnShapeValue);
        this.load(ellipseSpawnShapeValue);
    }

    @Override
    public SpawnShapeValue copy() {
        return new EllipseSpawnShapeValue(this);
    }

    public PrimitiveSpawnShapeValue.SpawnSide getSide() {
        return this.side;
    }

    @Override
    public void load(ParticleValue particleValue) {
        super.load(particleValue);
        this.side = ((EllipseSpawnShapeValue)particleValue).side;
    }

    @Override
    public void read(Json json, JsonValue jsonValue) {
        super.read(json, jsonValue);
        this.side = json.readValue("side", PrimitiveSpawnShapeValue.SpawnSide.class, jsonValue);
    }

    public void setSide(PrimitiveSpawnShapeValue.SpawnSide spawnSide) {
        this.side = spawnSide;
    }

    @Override
    public void spawnAux(Vector3 vector3, float f) {
        float f2 = this.spawnWidth + this.spawnWidthDiff * this.spawnWidthValue.getScale(f);
        float f3 = this.spawnHeight + this.spawnHeightDiff * this.spawnHeightValue.getScale(f);
        float f4 = this.spawnDepth + this.spawnDepthDiff * this.spawnDepthValue.getScale(f);
        f = this.side == PrimitiveSpawnShapeValue.SpawnSide.top ? (float)Math.PI : (this.side == PrimitiveSpawnShapeValue.SpawnSide.bottom ? (float)(-Math.PI) : (float)Math.PI * 2);
        float f5 = MathUtils.random(0.0f, f);
        if (this.edges) {
            if (f2 == 0.0f) {
                vector3.set(0.0f, f3 / 2.0f * MathUtils.sin(f5), f4 / 2.0f * MathUtils.cos(f5));
                return;
            }
            if (f3 == 0.0f) {
                vector3.set(f2 / 2.0f * MathUtils.cos(f5), 0.0f, f4 / 2.0f * MathUtils.sin(f5));
                return;
            }
            if (f4 == 0.0f) {
                vector3.set(f2 / 2.0f * MathUtils.cos(f5), f3 / 2.0f * MathUtils.sin(f5), 0.0f);
                return;
            }
            f2 /= 2.0f;
            f = f3 / 2.0f;
            f4 /= 2.0f;
        } else {
            f2 = MathUtils.random(f2 / 2.0f);
            f = MathUtils.random(f3 / 2.0f);
            f4 = MathUtils.random(f4 / 2.0f);
        }
        f3 = MathUtils.random(-1.0f, 1.0f);
        float f6 = (float)Math.sqrt(1.0f - f3 * f3);
        vector3.set(f2 * f6 * MathUtils.cos(f5), f * f6 * MathUtils.sin(f5), f4 * f3);
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("side", (Object)this.side);
    }
}

