/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.graphics.g3d.particles.ParallelArray;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ParticleControllerComponent;
import com.badlogic.gdx.graphics.g3d.particles.influencers.Influencer;
import com.badlogic.gdx.graphics.g3d.particles.values.ScaledNumericValue;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public abstract class DynamicsModifier
extends Influencer {
    protected static final Quaternion TMP_Q;
    protected static final Vector3 TMP_V1;
    protected static final Vector3 TMP_V2;
    protected static final Vector3 TMP_V3;
    public boolean isGlobal = false;
    protected ParallelArray.FloatChannel lifeChannel;

    static {
        TMP_V1 = new Vector3();
        TMP_V2 = new Vector3();
        TMP_V3 = new Vector3();
        TMP_Q = new Quaternion();
    }

    public DynamicsModifier() {
    }

    public DynamicsModifier(DynamicsModifier dynamicsModifier) {
        this.isGlobal = dynamicsModifier.isGlobal;
    }

    @Override
    public void allocateChannels() {
        this.lifeChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Life);
    }

    @Override
    public void read(Json json, JsonValue jsonValue) {
        super.read(json, jsonValue);
        this.isGlobal = json.readValue("isGlobal", Boolean.TYPE, jsonValue);
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("isGlobal", this.isGlobal);
    }

    public static abstract class Angular
    extends Strength {
        protected ParallelArray.FloatChannel angularChannel;
        public ScaledNumericValue phiValue;
        public ScaledNumericValue thetaValue = new ScaledNumericValue();

        public Angular() {
            this.phiValue = new ScaledNumericValue();
        }

        public Angular(Angular angular) {
            super(angular);
            this.phiValue = new ScaledNumericValue();
            this.thetaValue.load(angular.thetaValue);
            this.phiValue.load(angular.phiValue);
        }

        @Override
        public void activateParticles(int n, int n2) {
            super.activateParticles(n, n2);
            int n3 = n * this.angularChannel.strideSize;
            int n4 = this.angularChannel.strideSize;
            for (n = n3; n < n2 * n4 + n3; n += this.angularChannel.strideSize) {
                float f;
                float f2 = this.thetaValue.newLowValue();
                float f3 = f = this.thetaValue.newHighValue();
                if (!this.thetaValue.isRelative()) {
                    f3 = f - f2;
                }
                this.angularChannel.data[n + 0] = f2;
                this.angularChannel.data[n + 1] = f3;
                f2 = this.phiValue.newLowValue();
                f3 = f = this.phiValue.newHighValue();
                if (!this.phiValue.isRelative()) {
                    f3 = f - f2;
                }
                this.angularChannel.data[n + 2] = f2;
                this.angularChannel.data[n + 3] = f3;
            }
        }

        @Override
        public void allocateChannels() {
            super.allocateChannels();
            ParticleChannels.Interpolation4.id = this.controller.particleChannels.newId();
            this.angularChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Interpolation4);
        }

        @Override
        public void read(Json json, JsonValue jsonValue) {
            super.read(json, jsonValue);
            this.thetaValue = json.readValue("thetaValue", ScaledNumericValue.class, jsonValue);
            this.phiValue = json.readValue("phiValue", ScaledNumericValue.class, jsonValue);
        }

        @Override
        public void write(Json json) {
            super.write(json);
            json.writeValue("thetaValue", this.thetaValue);
            json.writeValue("phiValue", this.phiValue);
        }
    }

    public static class BrownianAcceleration
    extends Strength {
        ParallelArray.FloatChannel accelerationChannel;

        public BrownianAcceleration() {
        }

        public BrownianAcceleration(BrownianAcceleration brownianAcceleration) {
            super(brownianAcceleration);
        }

        @Override
        public void allocateChannels() {
            super.allocateChannels();
            this.accelerationChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Acceleration);
        }

        @Override
        public BrownianAcceleration copy() {
            return new BrownianAcceleration(this);
        }

        @Override
        public void update() {
            int n = this.controller.particles.size;
            int n2 = 0;
            int n3 = 0;
            int n4 = 2;
            int n5 = 0;
            while (n2 < n) {
                float f = this.strengthChannel.data[n3 + 0];
                float f2 = this.strengthChannel.data[n3 + 1];
                float f3 = this.strengthValue.getScale(this.lifeChannel.data[n4]);
                TMP_V3.set(MathUtils.random(-1.0f, 1.0f), MathUtils.random(-1.0f, 1.0f), MathUtils.random(-1.0f, 1.0f)).nor().scl(f + f2 * f3);
                float[] fArray = this.accelerationChannel.data;
                int n6 = n5 + 0;
                fArray[n6] = fArray[n6] + BrownianAcceleration.TMP_V3.x;
                fArray = this.accelerationChannel.data;
                n6 = n5 + 1;
                fArray[n6] = fArray[n6] + BrownianAcceleration.TMP_V3.y;
                fArray = this.accelerationChannel.data;
                n6 = n5 + 2;
                fArray[n6] = fArray[n6] + BrownianAcceleration.TMP_V3.z;
                ++n2;
                n3 += this.strengthChannel.strideSize;
                n5 += this.accelerationChannel.strideSize;
                n4 += this.lifeChannel.strideSize;
            }
        }
    }

    public static class CentripetalAcceleration
    extends Strength {
        ParallelArray.FloatChannel accelerationChannel;
        ParallelArray.FloatChannel positionChannel;

        public CentripetalAcceleration() {
        }

        public CentripetalAcceleration(CentripetalAcceleration centripetalAcceleration) {
            super(centripetalAcceleration);
        }

        @Override
        public void allocateChannels() {
            super.allocateChannels();
            this.accelerationChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Acceleration);
            this.positionChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Position);
        }

        @Override
        public CentripetalAcceleration copy() {
            return new CentripetalAcceleration(this);
        }

        @Override
        public void update() {
            float f;
            float f2;
            float[] fArray;
            boolean bl = this.isGlobal;
            float f3 = 0.0f;
            if (!bl) {
                fArray = this.controller.transform.val;
                f3 = fArray[12];
                f2 = fArray[13];
                f = fArray[14];
            } else {
                f = 0.0f;
                f2 = 0.0f;
            }
            int n = this.controller.particles.size;
            int n2 = 0;
            int n3 = 0;
            int n4 = 2;
            int n5 = 0;
            int n6 = 0;
            while (n2 < n) {
                float f4 = this.strengthChannel.data[n3 + 0];
                float f5 = this.strengthChannel.data[n3 + 1];
                float f6 = this.strengthValue.getScale(this.lifeChannel.data[n4]);
                TMP_V3.set(this.positionChannel.data[n5 + 0] - f3, this.positionChannel.data[n5 + 1] - f2, this.positionChannel.data[n5 + 2] - f).nor().scl(f4 + f5 * f6);
                fArray = this.accelerationChannel.data;
                int n7 = n6 + 0;
                fArray[n7] = fArray[n7] + CentripetalAcceleration.TMP_V3.x;
                fArray = this.accelerationChannel.data;
                n7 = n6 + 1;
                fArray[n7] = fArray[n7] + CentripetalAcceleration.TMP_V3.y;
                fArray = this.accelerationChannel.data;
                n7 = n6 + 2;
                fArray[n7] = fArray[n7] + CentripetalAcceleration.TMP_V3.z;
                ++n2;
                n5 += this.positionChannel.strideSize;
                n3 += this.strengthChannel.strideSize;
                n6 += this.accelerationChannel.strideSize;
                n4 += this.lifeChannel.strideSize;
            }
        }
    }

    public static class FaceDirection
    extends DynamicsModifier {
        ParallelArray.FloatChannel accellerationChannel;
        ParallelArray.FloatChannel rotationChannel;

        public FaceDirection() {
        }

        public FaceDirection(FaceDirection faceDirection) {
            super(faceDirection);
        }

        @Override
        public void allocateChannels() {
            this.rotationChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Rotation3D);
            this.accellerationChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Acceleration);
        }

        @Override
        public ParticleControllerComponent copy() {
            return new FaceDirection(this);
        }

        @Override
        public void update() {
            int n = this.controller.particles.size;
            int n2 = this.rotationChannel.strideSize;
            int n3 = 0;
            int n4 = 0;
            while (n3 < n * n2 + 0) {
                Vector3 vector3 = TMP_V1.set(this.accellerationChannel.data[n4 + 0], this.accellerationChannel.data[n4 + 1], this.accellerationChannel.data[n4 + 2]).nor();
                Vector3 vector32 = TMP_V2.set(TMP_V1).crs(Vector3.Y).nor().crs(TMP_V1).nor();
                Vector3 vector33 = TMP_V3.set(vector32).crs(vector3).nor();
                TMP_Q.setFromAxes(false, vector33.x, vector32.x, vector3.x, vector33.y, vector32.y, vector3.y, vector33.z, vector32.z, vector3.z);
                this.rotationChannel.data[n3 + 0] = FaceDirection.TMP_Q.x;
                this.rotationChannel.data[n3 + 1] = FaceDirection.TMP_Q.y;
                this.rotationChannel.data[n3 + 2] = FaceDirection.TMP_Q.z;
                this.rotationChannel.data[n3 + 3] = FaceDirection.TMP_Q.w;
                n3 += this.rotationChannel.strideSize;
                n4 += this.accellerationChannel.strideSize;
            }
        }
    }

    public static class PolarAcceleration
    extends Angular {
        ParallelArray.FloatChannel directionalVelocityChannel;

        public PolarAcceleration() {
        }

        public PolarAcceleration(PolarAcceleration polarAcceleration) {
            super(polarAcceleration);
        }

        @Override
        public void allocateChannels() {
            super.allocateChannels();
            this.directionalVelocityChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Acceleration);
        }

        @Override
        public PolarAcceleration copy() {
            return new PolarAcceleration(this);
        }

        @Override
        public void update() {
            int n = this.controller.particles.size;
            int n2 = this.directionalVelocityChannel.strideSize;
            int n3 = 0;
            int n4 = 2;
            int n5 = 0;
            int n6 = 0;
            while (n3 < n * n2 + 0) {
                float f = this.lifeChannel.data[n4];
                float f2 = this.strengthChannel.data[n5 + 0];
                float f3 = this.strengthChannel.data[n5 + 1];
                float f4 = this.strengthValue.getScale(f);
                float f5 = this.angularChannel.data[n6 + 2] + this.angularChannel.data[n6 + 3] * this.phiValue.getScale(f);
                float f6 = this.angularChannel.data[n6 + 0] + this.angularChannel.data[n6 + 1] * this.thetaValue.getScale(f);
                f = MathUtils.cosDeg(f6);
                float f7 = MathUtils.sinDeg(f6);
                f6 = MathUtils.cosDeg(f5);
                f5 = MathUtils.sinDeg(f5);
                TMP_V3.set(f * f5, f6, f7 * f5).nor().scl(f2 + f3 * f4);
                float[] fArray = this.directionalVelocityChannel.data;
                int n7 = n3 + 0;
                fArray[n7] = fArray[n7] + PolarAcceleration.TMP_V3.x;
                fArray = this.directionalVelocityChannel.data;
                n7 = n3 + 1;
                fArray[n7] = fArray[n7] + PolarAcceleration.TMP_V3.y;
                fArray = this.directionalVelocityChannel.data;
                n7 = n3 + 2;
                fArray[n7] = fArray[n7] + PolarAcceleration.TMP_V3.z;
                n5 += this.strengthChannel.strideSize;
                n3 += this.directionalVelocityChannel.strideSize;
                n6 += this.angularChannel.strideSize;
                n4 += this.lifeChannel.strideSize;
            }
        }
    }

    public static class Rotational2D
    extends Strength {
        ParallelArray.FloatChannel rotationalVelocity2dChannel;

        public Rotational2D() {
        }

        public Rotational2D(Rotational2D rotational2D) {
            super(rotational2D);
        }

        @Override
        public void allocateChannels() {
            super.allocateChannels();
            this.rotationalVelocity2dChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.AngularVelocity2D);
        }

        @Override
        public Rotational2D copy() {
            return new Rotational2D(this);
        }

        @Override
        public void update() {
            int n = this.controller.particles.size;
            int n2 = this.rotationalVelocity2dChannel.strideSize;
            int n3 = 0;
            int n4 = 0;
            int n5 = 2;
            while (n3 < n * n2 + 0) {
                float[] fArray = this.rotationalVelocity2dChannel.data;
                fArray[n3] = fArray[n3] + (this.strengthChannel.data[n4 + 0] + this.strengthChannel.data[n4 + 1] * this.strengthValue.getScale(this.lifeChannel.data[n5]));
                n4 += this.strengthChannel.strideSize;
                n3 += this.rotationalVelocity2dChannel.strideSize;
                n5 += this.lifeChannel.strideSize;
            }
        }
    }

    public static class Rotational3D
    extends Angular {
        ParallelArray.FloatChannel rotationChannel;
        ParallelArray.FloatChannel rotationalForceChannel;

        public Rotational3D() {
        }

        public Rotational3D(Rotational3D rotational3D) {
            super(rotational3D);
        }

        @Override
        public void allocateChannels() {
            super.allocateChannels();
            this.rotationChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Rotation3D);
            this.rotationalForceChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.AngularVelocity3D);
        }

        @Override
        public Rotational3D copy() {
            return new Rotational3D(this);
        }

        @Override
        public void update() {
            int n = this.controller.particles.size;
            int n2 = this.rotationalForceChannel.strideSize;
            int n3 = 2;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n4 < n * n2) {
                float f = this.lifeChannel.data[n3];
                float f2 = this.strengthChannel.data[n5 + 0];
                float f3 = this.strengthChannel.data[n5 + 1];
                float f4 = this.strengthValue.getScale(f);
                float f5 = this.angularChannel.data[n6 + 2] + this.angularChannel.data[n6 + 3] * this.phiValue.getScale(f);
                float f6 = this.angularChannel.data[n6 + 0] + this.angularChannel.data[n6 + 1] * this.thetaValue.getScale(f);
                f = MathUtils.cosDeg(f6);
                float f7 = MathUtils.sinDeg(f6);
                f6 = MathUtils.cosDeg(f5);
                f5 = MathUtils.sinDeg(f5);
                TMP_V3.set(f * f5, f6, f7 * f5);
                TMP_V3.scl((f2 + f3 * f4) * ((float)Math.PI / 180));
                float[] fArray = this.rotationalForceChannel.data;
                int n7 = n4 + 0;
                fArray[n7] = fArray[n7] + Rotational3D.TMP_V3.x;
                fArray = this.rotationalForceChannel.data;
                n7 = n4 + 1;
                fArray[n7] = fArray[n7] + Rotational3D.TMP_V3.y;
                fArray = this.rotationalForceChannel.data;
                n7 = n4 + 2;
                fArray[n7] = fArray[n7] + Rotational3D.TMP_V3.z;
                n5 += this.strengthChannel.strideSize;
                n4 += this.rotationalForceChannel.strideSize;
                n6 += this.angularChannel.strideSize;
                n3 += this.lifeChannel.strideSize;
            }
        }
    }

    public static abstract class Strength
    extends DynamicsModifier {
        protected ParallelArray.FloatChannel strengthChannel;
        public ScaledNumericValue strengthValue = new ScaledNumericValue();

        public Strength() {
        }

        public Strength(Strength strength) {
            super(strength);
            this.strengthValue.load(strength.strengthValue);
        }

        @Override
        public void activateParticles(int n, int n2) {
            int n3 = n * this.strengthChannel.strideSize;
            int n4 = this.strengthChannel.strideSize;
            for (n = n3; n < n2 * n4 + n3; n += this.strengthChannel.strideSize) {
                float f;
                float f2 = this.strengthValue.newLowValue();
                float f3 = f = this.strengthValue.newHighValue();
                if (!this.strengthValue.isRelative()) {
                    f3 = f - f2;
                }
                this.strengthChannel.data[n + 0] = f2;
                this.strengthChannel.data[n + 1] = f3;
            }
        }

        @Override
        public void allocateChannels() {
            super.allocateChannels();
            ParticleChannels.Interpolation.id = this.controller.particleChannels.newId();
            this.strengthChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Interpolation);
        }

        @Override
        public void read(Json json, JsonValue jsonValue) {
            super.read(json, jsonValue);
            this.strengthValue = json.readValue("strengthValue", ScaledNumericValue.class, jsonValue);
        }

        @Override
        public void write(Json json) {
            super.write(json);
            json.writeValue("strengthValue", this.strengthValue);
        }
    }

    public static class TangentialAcceleration
    extends Angular {
        ParallelArray.FloatChannel directionalVelocityChannel;
        ParallelArray.FloatChannel positionChannel;

        public TangentialAcceleration() {
        }

        public TangentialAcceleration(TangentialAcceleration tangentialAcceleration) {
            super(tangentialAcceleration);
        }

        @Override
        public void allocateChannels() {
            super.allocateChannels();
            this.directionalVelocityChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Acceleration);
            this.positionChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Position);
        }

        @Override
        public TangentialAcceleration copy() {
            return new TangentialAcceleration(this);
        }

        @Override
        public void update() {
            int n = this.controller.particles.size;
            int n2 = this.directionalVelocityChannel.strideSize;
            int n3 = 0;
            int n4 = 2;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n3 < n * n2 + 0) {
                float f = this.lifeChannel.data[n4];
                float f2 = this.strengthChannel.data[n5 + 0];
                float f3 = this.strengthChannel.data[n5 + 1];
                float f4 = this.strengthValue.getScale(f);
                float f5 = this.angularChannel.data[n6 + 2] + this.angularChannel.data[n6 + 3] * this.phiValue.getScale(f);
                float f6 = this.angularChannel.data[n6 + 0] + this.angularChannel.data[n6 + 1] * this.thetaValue.getScale(f);
                f = MathUtils.cosDeg(f6);
                f6 = MathUtils.sinDeg(f6);
                float f7 = MathUtils.cosDeg(f5);
                f5 = MathUtils.sinDeg(f5);
                TMP_V3.set(f * f5, f7, f6 * f5).crs(this.positionChannel.data[n7 + 0], this.positionChannel.data[n7 + 1], this.positionChannel.data[n7 + 2]).nor().scl(f2 + f3 * f4);
                float[] fArray = this.directionalVelocityChannel.data;
                int n8 = n3 + 0;
                fArray[n8] = fArray[n8] + TangentialAcceleration.TMP_V3.x;
                fArray = this.directionalVelocityChannel.data;
                n8 = n3 + 1;
                fArray[n8] = fArray[n8] + TangentialAcceleration.TMP_V3.y;
                fArray = this.directionalVelocityChannel.data;
                n8 = n3 + 2;
                fArray[n8] = fArray[n8] + TangentialAcceleration.TMP_V3.z;
                n5 += this.strengthChannel.strideSize;
                n3 += this.directionalVelocityChannel.strideSize;
                n6 += this.angularChannel.strideSize;
                n4 += this.lifeChannel.strideSize;
                n7 += this.positionChannel.strideSize;
            }
        }
    }
}

