/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.batches;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.particles.ParticleSorter;
import com.badlogic.gdx.graphics.g3d.particles.batches.ParticleBatch;
import com.badlogic.gdx.graphics.g3d.particles.renderers.ParticleControllerRenderData;
import com.badlogic.gdx.utils.Array;

public abstract class BufferedParticleBatch<T extends ParticleControllerRenderData>
implements ParticleBatch<T> {
    protected int bufferedParticlesCount;
    protected Camera camera;
    protected int currentCapacity = 0;
    protected Array<T> renderData;
    protected ParticleSorter sorter = new ParticleSorter.Distance();

    protected BufferedParticleBatch(Class<T> clazz) {
        this.renderData = new Array(false, 10, clazz);
    }

    protected abstract void allocParticlesData(int var1);

    @Override
    public void begin() {
        this.renderData.clear();
        this.bufferedParticlesCount = 0;
    }

    @Override
    public void draw(T t) {
        if (((ParticleControllerRenderData)t).controller.particles.size > 0) {
            this.renderData.add(t);
            this.bufferedParticlesCount += ((ParticleControllerRenderData)t).controller.particles.size;
        }
    }

    @Override
    public void end() {
        int n = this.bufferedParticlesCount;
        if (n > 0) {
            this.ensureCapacity(n);
            this.flush(this.sorter.sort(this.renderData));
        }
    }

    public void ensureCapacity(int n) {
        if (this.currentCapacity >= n) {
            return;
        }
        this.sorter.ensureCapacity(n);
        this.allocParticlesData(n);
        this.currentCapacity = n;
    }

    protected abstract void flush(int[] var1);

    public int getBufferedCount() {
        return this.bufferedParticlesCount;
    }

    public ParticleSorter getSorter() {
        return this.sorter;
    }

    public void resetCapacity() {
        this.bufferedParticlesCount = 0;
        this.currentCapacity = 0;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
        this.sorter.setCamera(camera);
    }

    public void setSorter(ParticleSorter particleSorter) {
        this.sorter = particleSorter;
        particleSorter.setCamera(this.camera);
        particleSorter.ensureCapacity(this.currentCapacity);
    }
}

