/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.attributes;

import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.NumberUtils;

public class FloatAttribute
extends Attribute {
    public static final long AlphaTest;
    public static final String AlphaTestAlias = "alphaTest";
    public static final long Shininess;
    public static final String ShininessAlias = "shininess";
    public float value;

    static {
        Shininess = FloatAttribute.register(ShininessAlias);
        AlphaTest = FloatAttribute.register(AlphaTestAlias);
    }

    public FloatAttribute(long l) {
        super(l);
    }

    public FloatAttribute(long l, float f) {
        super(l);
        this.value = f;
    }

    public static FloatAttribute createAlphaTest(float f) {
        return new FloatAttribute(AlphaTest, f);
    }

    public static FloatAttribute createShininess(float f) {
        return new FloatAttribute(Shininess, f);
    }

    @Override
    public int compareTo(Attribute attribute) {
        if (this.type != attribute.type) {
            return (int)(this.type - attribute.type);
        }
        float f = ((FloatAttribute)attribute).value;
        int n = MathUtils.isEqual(this.value, f) ? 0 : (this.value < f ? -1 : 1);
        return n;
    }

    @Override
    public Attribute copy() {
        return new FloatAttribute(this.type, this.value);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 977 + NumberUtils.floatToRawIntBits(this.value);
    }
}

