/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import java.nio.FloatBuffer;

public class SpriteCache
implements Disposable {
    private static final float[] tempVertices = new float[30];
    private Array<Cache> caches;
    private final Color color;
    private float colorPacked;
    private final Matrix4 combinedMatrix;
    private final IntArray counts;
    private Cache currentCache;
    private ShaderProgram customShader = null;
    private boolean drawing;
    private final Mesh mesh;
    private final Matrix4 projectionMatrix;
    public int renderCalls;
    private final ShaderProgram shader;
    private final Array<Texture> textures;
    public int totalRenderCalls;
    private final Matrix4 transformMatrix = new Matrix4();

    public SpriteCache() {
        this(1000, false);
    }

    public SpriteCache(int n, ShaderProgram object, boolean bl) {
        this.projectionMatrix = new Matrix4();
        this.caches = new Array();
        this.combinedMatrix = new Matrix4();
        this.textures = new Array(8);
        this.counts = new IntArray(8);
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.colorPacked = Color.WHITE_FLOAT_BITS;
        int n2 = 0;
        this.renderCalls = 0;
        this.totalRenderCalls = 0;
        this.shader = object;
        if (bl && n > 8191) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Can't have more than 8191 sprites per batch: ");
            ((StringBuilder)object).append(n);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        int n3 = bl ? 4 : 6;
        int n4 = bl ? n * 6 : 0;
        this.mesh = new Mesh(true, n3 * n, n4, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0"));
        this.mesh.setAutoBind(false);
        if (bl) {
            n4 = n * 6;
            object = new short[n4];
            n = 0;
            n3 = n2;
            while (n3 < n4) {
                object[n3 + 0] = (short)n;
                object[n3 + 1] = (short)(n + 1);
                n2 = (short)(n + 2);
                object[n3 + 2] = (short)n2;
                object[n3 + 3] = (short)n2;
                object[n3 + 4] = (short)(n + 3);
                object[n3 + 5] = (short)n;
                n3 += 6;
                n = (short)(n + 4);
            }
            this.mesh.setIndices((short[])object);
        }
        this.projectionMatrix.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    public SpriteCache(int n, boolean bl) {
        this(n, SpriteCache.createDefaultShader(), bl);
    }

    static ShaderProgram createDefaultShader() {
        ShaderProgram shaderProgram = new ShaderProgram("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projectionViewMatrix;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main()\n{\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projectionViewMatrix * a_position;\n}\n", "#ifdef GL_ES\nprecision mediump float;\n#endif\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nvoid main()\n{\n  gl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n}");
        if (shaderProgram.isCompiled()) {
            return shaderProgram;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Error compiling shader: ");
        stringBuilder.append(shaderProgram.getLog());
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void add(Texture texture, float f, float f2) {
        float f3;
        float f4 = (float)texture.getWidth() + f;
        float f5 = (float)texture.getHeight() + f2;
        float[] fArray = tempVertices;
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3 = this.colorPacked;
        fArray[3] = 0.0f;
        fArray[4] = 1.0f;
        fArray[5] = f;
        fArray[6] = f5;
        fArray[7] = f3;
        fArray[8] = 0.0f;
        fArray[9] = 0.0f;
        fArray[10] = f4;
        fArray[11] = f5;
        fArray[12] = f3;
        fArray[13] = 1.0f;
        fArray[14] = 0.0f;
        if (this.mesh.getNumIndices() > 0) {
            fArray = tempVertices;
            fArray[15] = f4;
            fArray[16] = f2;
            fArray[17] = this.colorPacked;
            fArray[18] = 1.0f;
            fArray[19] = 1.0f;
            this.add(texture, fArray, 0, 20);
        } else {
            fArray = tempVertices;
            fArray[15] = f4;
            fArray[16] = f5;
            fArray[17] = f5 = this.colorPacked;
            fArray[18] = 1.0f;
            fArray[19] = 0.0f;
            fArray[20] = f4;
            fArray[21] = f2;
            fArray[22] = f5;
            fArray[23] = 1.0f;
            fArray[24] = 1.0f;
            fArray[25] = f;
            fArray[26] = f2;
            fArray[27] = f5;
            fArray[28] = 0.0f;
            fArray[29] = 1.0f;
            this.add(texture, fArray, 0, 30);
        }
    }

    public void add(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        float f10;
        float f11;
        float f12;
        float f13;
        block10: {
            block9: {
                f13 = f + f3;
                f12 = f2 + f4;
                f11 = -f3;
                f10 = -f4;
                f5 -= f3;
                f6 -= f4;
                if (f7 != 1.0f) break block9;
                f = f5;
                f2 = f6;
                f4 = f11;
                f3 = f10;
                if (f8 == 1.0f) break block10;
            }
            f4 = f11 * f7;
            f3 = f10 * f8;
            f = f5 * f7;
            f2 = f6 * f8;
        }
        if (f9 != 0.0f) {
            f7 = MathUtils.cosDeg(f9);
            f8 = MathUtils.sinDeg(f9);
            f5 = f7 * f4;
            f6 = f5 - f8 * f3;
            f3 = f3 * f7 + (f4 *= f8);
            f10 = f8 * f2;
            f5 -= f10;
            f11 = f2 * f7;
            f9 = f4 + f11;
            f2 = f7 * f - f10;
            f10 = f11 + f8 * f;
            f7 = f2 - f5 + f6;
            f = f2;
            f8 = f10;
            f2 = f9;
            f4 = f6;
            f6 = f10 - (f9 - f3);
        } else {
            f7 = f;
            f8 = f2;
            f5 = f4;
            f6 = f3;
        }
        f9 = f4 + f13;
        f10 = f3 + f12;
        f11 = f + f13;
        float f14 = f8 + f12;
        float f15 = f7 + f13;
        float f16 = f6 + f12;
        f3 = 1.0f / (float)texture.getWidth();
        f6 = 1.0f / (float)texture.getHeight();
        f4 = (float)n * f3;
        f = (float)(n2 + n4) * f6;
        f3 = (float)(n + n3) * f3;
        f6 = (float)n2 * f6;
        if (!bl) {
            f7 = f3;
            f3 = f4;
            f4 = f7;
        }
        f8 = f6;
        f7 = f;
        if (bl2) {
            f7 = f6;
            f8 = f;
        }
        float[] fArray = tempVertices;
        fArray[0] = f9;
        fArray[1] = f10;
        fArray[2] = f = this.colorPacked;
        fArray[3] = f3;
        fArray[4] = f7;
        fArray[5] = f5 + f13;
        fArray[6] = f2 + f12;
        fArray[7] = f;
        fArray[8] = f3;
        fArray[9] = f8;
        fArray[10] = f11;
        fArray[11] = f14;
        fArray[12] = f;
        fArray[13] = f4;
        fArray[14] = f8;
        if (this.mesh.getNumIndices() > 0) {
            fArray = tempVertices;
            fArray[15] = f15;
            fArray[16] = f16;
            fArray[17] = this.colorPacked;
            fArray[18] = f4;
            fArray[19] = f7;
            this.add(texture, fArray, 0, 20);
        } else {
            fArray = tempVertices;
            fArray[15] = f11;
            fArray[16] = f14;
            fArray[17] = f = this.colorPacked;
            fArray[18] = f4;
            fArray[19] = f8;
            fArray[20] = f15;
            fArray[21] = f16;
            fArray[22] = f;
            fArray[23] = f4;
            fArray[24] = f7;
            fArray[25] = f9;
            fArray[26] = f10;
            fArray[27] = f;
            fArray[28] = f3;
            fArray[29] = f7;
            this.add(texture, fArray, 0, 30);
        }
    }

    public void add(Texture texture, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        float f5 = 1.0f / (float)texture.getWidth();
        float f6 = 1.0f / (float)texture.getHeight();
        float f7 = (float)n * f5;
        float f8 = (float)(n2 + n4) * f6;
        f5 = (float)(n + n3) * f5;
        f6 = (float)n2 * f6;
        float f9 = f + f3;
        float f10 = f2 + f4;
        f4 = f5;
        f3 = f7;
        if (bl) {
            f3 = f5;
            f4 = f7;
        }
        f5 = f6;
        f7 = f8;
        if (bl2) {
            f7 = f6;
            f5 = f8;
        }
        float[] fArray = tempVertices;
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f8 = this.colorPacked;
        fArray[3] = f3;
        fArray[4] = f7;
        fArray[5] = f;
        fArray[6] = f10;
        fArray[7] = f8;
        fArray[8] = f3;
        fArray[9] = f5;
        fArray[10] = f9;
        fArray[11] = f10;
        fArray[12] = f8;
        fArray[13] = f4;
        fArray[14] = f5;
        if (this.mesh.getNumIndices() > 0) {
            fArray = tempVertices;
            fArray[15] = f9;
            fArray[16] = f2;
            fArray[17] = this.colorPacked;
            fArray[18] = f4;
            fArray[19] = f7;
            this.add(texture, fArray, 0, 20);
        } else {
            fArray = tempVertices;
            fArray[15] = f9;
            fArray[16] = f10;
            fArray[17] = f8 = this.colorPacked;
            fArray[18] = f4;
            fArray[19] = f5;
            fArray[20] = f9;
            fArray[21] = f2;
            fArray[22] = f8;
            fArray[23] = f4;
            fArray[24] = f7;
            fArray[25] = f;
            fArray[26] = f2;
            fArray[27] = f8;
            fArray[28] = f3;
            fArray[29] = f7;
            this.add(texture, fArray, 0, 30);
        }
    }

    public void add(Texture texture, float f, float f2, int n, int n2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = (float)n + f;
        float f9 = (float)n2 + f2;
        float[] fArray = tempVertices;
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f7;
        fArray[3] = f3;
        fArray[4] = f4;
        fArray[5] = f;
        fArray[6] = f9;
        fArray[7] = f7;
        fArray[8] = f3;
        fArray[9] = f6;
        fArray[10] = f8;
        fArray[11] = f9;
        fArray[12] = f7;
        fArray[13] = f5;
        fArray[14] = f6;
        if (this.mesh.getNumIndices() > 0) {
            fArray = tempVertices;
            fArray[15] = f8;
            fArray[16] = f2;
            fArray[17] = f7;
            fArray[18] = f5;
            fArray[19] = f4;
            this.add(texture, fArray, 0, 20);
        } else {
            fArray = tempVertices;
            fArray[15] = f8;
            fArray[16] = f9;
            fArray[17] = f7;
            fArray[18] = f5;
            fArray[19] = f6;
            fArray[20] = f8;
            fArray[21] = f2;
            fArray[22] = f7;
            fArray[23] = f5;
            fArray[24] = f4;
            fArray[25] = f;
            fArray[26] = f2;
            fArray[27] = f7;
            fArray[28] = f3;
            fArray[29] = f4;
            this.add(texture, fArray, 0, 30);
        }
    }

    public void add(Texture texture, float f, float f2, int n, int n2, int n3, int n4) {
        float f3;
        float f4 = 1.0f / (float)texture.getWidth();
        float f5 = 1.0f / (float)texture.getHeight();
        float f6 = (float)n * f4;
        float f7 = (float)(n2 + n4) * f5;
        f4 = (float)(n + n3) * f4;
        float f8 = (float)n2 * f5;
        f5 = f + (float)n3;
        float f9 = f2 + (float)n4;
        float[] fArray = tempVertices;
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3 = this.colorPacked;
        fArray[3] = f6;
        fArray[4] = f7;
        fArray[5] = f;
        fArray[6] = f9;
        fArray[7] = f3;
        fArray[8] = f6;
        fArray[9] = f8;
        fArray[10] = f5;
        fArray[11] = f9;
        fArray[12] = f3;
        fArray[13] = f4;
        fArray[14] = f8;
        if (this.mesh.getNumIndices() > 0) {
            fArray = tempVertices;
            fArray[15] = f5;
            fArray[16] = f2;
            fArray[17] = this.colorPacked;
            fArray[18] = f4;
            fArray[19] = f7;
            this.add(texture, fArray, 0, 20);
        } else {
            fArray = tempVertices;
            fArray[15] = f5;
            fArray[16] = f9;
            fArray[17] = f3 = this.colorPacked;
            fArray[18] = f4;
            fArray[19] = f8;
            fArray[20] = f5;
            fArray[21] = f2;
            fArray[22] = f3;
            fArray[23] = f4;
            fArray[24] = f7;
            fArray[25] = f;
            fArray[26] = f2;
            fArray[27] = f3;
            fArray[28] = f6;
            fArray[29] = f7;
            this.add(texture, fArray, 0, 30);
        }
    }

    public void add(Texture texture, float[] fArray, int n, int n2) {
        if (this.currentCache != null) {
            int n3 = this.mesh.getNumIndices() > 0 ? 4 : 6;
            n3 = n2 / (n3 * 5) * 6;
            int n4 = this.textures.size - 1;
            if (n4 >= 0 && this.textures.get(n4) == texture) {
                this.counts.incr(n4, n3);
            } else {
                this.textures.add(texture);
                this.counts.add(n3);
            }
            this.mesh.getVerticesBuffer().put(fArray, n, n2);
            return;
        }
        throw new IllegalStateException("beginCache must be called before add.");
    }

    public void add(Sprite sprite) {
        if (this.mesh.getNumIndices() > 0) {
            this.add(sprite.getTexture(), sprite.getVertices(), 0, 20);
            return;
        }
        float[] fArray = sprite.getVertices();
        System.arraycopy(fArray, 0, tempVertices, 0, 15);
        System.arraycopy(fArray, 10, tempVertices, 15, 5);
        System.arraycopy(fArray, 15, tempVertices, 20, 5);
        System.arraycopy(fArray, 0, tempVertices, 25, 5);
        this.add(sprite.getTexture(), tempVertices, 0, 30);
    }

    public void add(TextureRegion textureRegion, float f, float f2) {
        this.add(textureRegion, f, f2, textureRegion.getRegionWidth(), textureRegion.getRegionHeight());
    }

    public void add(TextureRegion textureRegion, float f, float f2, float f3, float f4) {
        float f5;
        f3 = f + f3;
        float f6 = f2 + f4;
        f4 = textureRegion.u;
        float f7 = textureRegion.v2;
        float f8 = textureRegion.u2;
        float f9 = textureRegion.v;
        float[] fArray = tempVertices;
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f5 = this.colorPacked;
        fArray[3] = f4;
        fArray[4] = f7;
        fArray[5] = f;
        fArray[6] = f6;
        fArray[7] = f5;
        fArray[8] = f4;
        fArray[9] = f9;
        fArray[10] = f3;
        fArray[11] = f6;
        fArray[12] = f5;
        fArray[13] = f8;
        fArray[14] = f9;
        if (this.mesh.getNumIndices() > 0) {
            fArray = tempVertices;
            fArray[15] = f3;
            fArray[16] = f2;
            fArray[17] = this.colorPacked;
            fArray[18] = f8;
            fArray[19] = f7;
            this.add(textureRegion.texture, tempVertices, 0, 20);
        } else {
            fArray = tempVertices;
            fArray[15] = f3;
            fArray[16] = f6;
            fArray[17] = f6 = this.colorPacked;
            fArray[18] = f8;
            fArray[19] = f9;
            fArray[20] = f3;
            fArray[21] = f2;
            fArray[22] = f6;
            fArray[23] = f8;
            fArray[24] = f7;
            fArray[25] = f;
            fArray[26] = f2;
            fArray[27] = f6;
            fArray[28] = f4;
            fArray[29] = f7;
            this.add(textureRegion.texture, tempVertices, 0, 30);
        }
    }

    public void add(TextureRegion textureRegion, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        block8: {
            block7: {
                f14 = f + f3;
                f13 = f2 + f4;
                f12 = -f3;
                f11 = -f4;
                f5 -= f3;
                f6 -= f4;
                if (f7 != 1.0f) break block7;
                f4 = f5;
                f = f6;
                f3 = f12;
                f2 = f11;
                if (f8 == 1.0f) break block8;
            }
            f3 = f12 * f7;
            f2 = f11 * f8;
            f4 = f5 * f7;
            f = f6 * f8;
        }
        if (f9 != 0.0f) {
            f7 = MathUtils.cosDeg(f9);
            f9 = MathUtils.sinDeg(f9);
            f5 = f7 * f3;
            f6 = f5 - f9 * f2;
            f8 = f2 * f7 + (f3 *= f9);
            f2 = f9 * f;
            f11 = f3 + (f *= f7);
            f7 = f7 * f4 - f2;
            f4 = f + f9 * f4;
            f9 = f7 - (f5 -= f2) + f6;
            f2 = f4;
            f = f11;
            f3 = f6;
            f6 = f4 - (f11 - f8);
            f4 = f7;
            f7 = f9;
        } else {
            f7 = f4;
            f9 = f;
            f5 = f3;
            f6 = f2;
            f8 = f2;
            f2 = f9;
        }
        f3 += f14;
        f8 += f13;
        f4 += f14;
        f9 = f2 + f13;
        f2 = f7 + f14;
        float f15 = f6 + f13;
        f7 = textureRegion.u;
        f6 = textureRegion.v2;
        f12 = textureRegion.u2;
        f11 = textureRegion.v;
        float[] fArray = tempVertices;
        fArray[0] = f3;
        fArray[1] = f8;
        fArray[2] = f10 = this.colorPacked;
        fArray[3] = f7;
        fArray[4] = f6;
        fArray[5] = f5 + f14;
        fArray[6] = f + f13;
        fArray[7] = f10;
        fArray[8] = f7;
        fArray[9] = f11;
        fArray[10] = f4;
        fArray[11] = f9;
        fArray[12] = f10;
        fArray[13] = f12;
        fArray[14] = f11;
        if (this.mesh.getNumIndices() > 0) {
            fArray = tempVertices;
            fArray[15] = f2;
            fArray[16] = f15;
            fArray[17] = this.colorPacked;
            fArray[18] = f12;
            fArray[19] = f6;
            this.add(textureRegion.texture, tempVertices, 0, 20);
        } else {
            fArray = tempVertices;
            fArray[15] = f4;
            fArray[16] = f9;
            fArray[17] = f = this.colorPacked;
            fArray[18] = f12;
            fArray[19] = f11;
            fArray[20] = f2;
            fArray[21] = f15;
            fArray[22] = f;
            fArray[23] = f12;
            fArray[24] = f6;
            fArray[25] = f3;
            fArray[26] = f8;
            fArray[27] = f;
            fArray[28] = f7;
            fArray[29] = f6;
            this.add(textureRegion.texture, tempVertices, 0, 30);
        }
    }

    public void begin() {
        if (!this.drawing) {
            if (this.currentCache == null) {
                this.renderCalls = 0;
                this.combinedMatrix.set(this.projectionMatrix).mul(this.transformMatrix);
                Gdx.gl20.glDepthMask(false);
                ShaderProgram shaderProgram = this.customShader;
                if (shaderProgram != null) {
                    shaderProgram.begin();
                    this.customShader.setUniformMatrix("u_proj", this.projectionMatrix);
                    this.customShader.setUniformMatrix("u_trans", this.transformMatrix);
                    this.customShader.setUniformMatrix("u_projTrans", this.combinedMatrix);
                    this.customShader.setUniformi("u_texture", 0);
                    this.mesh.bind(this.customShader);
                } else {
                    this.shader.begin();
                    this.shader.setUniformMatrix("u_projectionViewMatrix", this.combinedMatrix);
                    this.shader.setUniformi("u_texture", 0);
                    this.mesh.bind(this.shader);
                }
                this.drawing = true;
                return;
            }
            throw new IllegalStateException("endCache must be called before begin");
        }
        throw new IllegalStateException("end must be called before begin.");
    }

    public void beginCache() {
        if (!this.drawing) {
            if (this.currentCache == null) {
                this.mesh.getNumIndices();
                this.currentCache = new Cache(this.caches.size, this.mesh.getVerticesBuffer().limit());
                this.caches.add(this.currentCache);
                this.mesh.getVerticesBuffer().compact();
                return;
            }
            throw new IllegalStateException("endCache must be called before begin.");
        }
        throw new IllegalStateException("end must be called before beginCache");
    }

    public void beginCache(int n) {
        if (!this.drawing) {
            if (this.currentCache == null) {
                if (n == this.caches.size - 1) {
                    Cache cache = this.caches.removeIndex(n);
                    this.mesh.getVerticesBuffer().limit(cache.offset);
                    this.beginCache();
                    return;
                }
                this.currentCache = this.caches.get(n);
                this.mesh.getVerticesBuffer().position(this.currentCache.offset);
                return;
            }
            throw new IllegalStateException("endCache must be called before begin.");
        }
        throw new IllegalStateException("end must be called before beginCache");
    }

    public void clear() {
        this.caches.clear();
        this.mesh.getVerticesBuffer().clear().flip();
    }

    @Override
    public void dispose() {
        this.mesh.dispose();
        ShaderProgram shaderProgram = this.shader;
        if (shaderProgram != null) {
            shaderProgram.dispose();
        }
    }

    public void draw(int n) {
        if (this.drawing) {
            Object object = this.caches.get(n);
            n = this.mesh.getNumIndices() > 0 ? 4 : 6;
            int n2 = ((Cache)object).offset / (n * 5) * 6;
            Texture[] textureArray = ((Cache)object).textures;
            int[] nArray = ((Cache)object).counts;
            int n3 = ((Cache)object).textureCount;
            for (n = 0; n < n3; ++n) {
                int n4 = nArray[n];
                textureArray[n].bind();
                object = this.customShader;
                if (object != null) {
                    this.mesh.render((ShaderProgram)object, 4, n2, n4);
                } else {
                    this.mesh.render(this.shader, 4, n2, n4);
                }
                n2 += n4;
            }
            this.renderCalls += n3;
            this.totalRenderCalls += n3;
            return;
        }
        IllegalStateException illegalStateException = new IllegalStateException("SpriteCache.begin must be called before draw.");
        throw illegalStateException;
    }

    public void draw(int n, int n2, int n3) {
        if (this.drawing) {
            Cache cache = this.caches.get(n);
            int n4 = n2 * 6 + cache.offset;
            n = n3 * 6;
            Texture[] textureArray = cache.textures;
            int[] nArray = cache.counts;
            int n5 = cache.textureCount;
            for (n2 = 0; n2 < n5; ++n2) {
                textureArray[n2].bind();
                int n6 = nArray[n2];
                if (n6 > n) {
                    n3 = n;
                    n2 = n5;
                } else {
                    n3 = n - n6;
                    n = n6;
                }
                ShaderProgram shaderProgram = this.customShader;
                if (shaderProgram != null) {
                    this.mesh.render(shaderProgram, 4, n4, n);
                } else {
                    this.mesh.render(this.shader, 4, n4, n);
                }
                n4 += n;
                n = n3;
            }
            this.renderCalls += cache.textureCount;
            this.totalRenderCalls += n5;
            return;
        }
        IllegalStateException illegalStateException = new IllegalStateException("SpriteCache.begin must be called before draw.");
        throw illegalStateException;
    }

    public void end() {
        if (this.drawing) {
            this.drawing = false;
            this.shader.end();
            Gdx.gl20.glDepthMask(true);
            ShaderProgram shaderProgram = this.customShader;
            if (shaderProgram != null) {
                this.mesh.unbind(shaderProgram);
            } else {
                this.mesh.unbind(this.shader);
            }
            return;
        }
        throw new IllegalStateException("begin must be called before end.");
    }

    public int endCache() {
        Object object;
        block8: {
            Object object2;
            int n;
            block11: {
                block10: {
                    int n2;
                    block9: {
                        object = this.currentCache;
                        if (object == null) break block8;
                        n = this.mesh.getVerticesBuffer().position() - ((Cache)object).offset;
                        object2 = ((Cache)object).textures;
                        if (object2 != null) break block9;
                        ((Cache)object).maxCount = n;
                        ((Cache)object).textureCount = this.textures.size;
                        ((Cache)object).textures = this.textures.toArray(Texture.class);
                        ((Cache)object).counts = new int[((Cache)object).textureCount];
                        n = this.counts.size;
                        for (n2 = 0; n2 < n; ++n2) {
                            ((Cache)object).counts[n2] = this.counts.get(n2);
                        }
                        this.mesh.getVerticesBuffer().flip();
                        break block10;
                    }
                    if (n > ((Cache)object).maxCount) break block11;
                    ((Cache)object).textureCount = this.textures.size;
                    if (((Cache)object).textures.length < ((Cache)object).textureCount) {
                        ((Cache)object).textures = new Texture[((Cache)object).textureCount];
                    }
                    n = ((Cache)object).textureCount;
                    for (n2 = 0; n2 < n; ++n2) {
                        ((Cache)object).textures[n2] = this.textures.get(n2);
                    }
                    if (((Cache)object).counts.length < ((Cache)object).textureCount) {
                        ((Cache)object).counts = new int[((Cache)object).textureCount];
                    }
                    n = ((Cache)object).textureCount;
                    for (n2 = 0; n2 < n; ++n2) {
                        ((Cache)object).counts[n2] = this.counts.get(n2);
                    }
                    object2 = this.mesh.getVerticesBuffer();
                    ((FloatBuffer)object2).position(0);
                    Object object3 = this.caches;
                    object3 = ((Array)object3).get(((Array)object3).size - 1);
                    ((FloatBuffer)object2).limit(((Cache)object3).offset + ((Cache)object3).maxCount);
                }
                this.currentCache = null;
                this.textures.clear();
                this.counts.clear();
                return ((Cache)object).id;
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("If a cache is not the last created, it cannot be redefined with more entries than when it was first created: ");
            ((StringBuilder)object2).append(n);
            ((StringBuilder)object2).append(" (");
            ((StringBuilder)object2).append(((Cache)object).maxCount);
            ((StringBuilder)object2).append(" max)");
            throw new GdxRuntimeException(((StringBuilder)object2).toString());
        }
        object = new IllegalStateException("beginCache must be called before endCache.");
        throw object;
    }

    public Color getColor() {
        return this.color;
    }

    public ShaderProgram getCustomShader() {
        return this.customShader;
    }

    public float getPackedColor() {
        return this.colorPacked;
    }

    public Matrix4 getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public Matrix4 getTransformMatrix() {
        return this.transformMatrix;
    }

    public boolean isDrawing() {
        return this.drawing;
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color.set(f, f2, f3, f4);
        this.colorPacked = this.color.toFloatBits();
    }

    public void setColor(Color color2) {
        this.color.set(color2);
        this.colorPacked = color2.toFloatBits();
    }

    public void setPackedColor(float f) {
        Color.abgr8888ToColor(this.color, f);
        this.colorPacked = f;
    }

    public void setProjectionMatrix(Matrix4 matrix4) {
        if (!this.drawing) {
            this.projectionMatrix.set(matrix4);
            return;
        }
        throw new IllegalStateException("Can't set the matrix within begin/end.");
    }

    public void setShader(ShaderProgram shaderProgram) {
        this.customShader = shaderProgram;
    }

    public void setTransformMatrix(Matrix4 matrix4) {
        if (!this.drawing) {
            this.transformMatrix.set(matrix4);
            return;
        }
        throw new IllegalStateException("Can't set the matrix within begin/end.");
    }

    private static class Cache {
        int[] counts;
        final int id;
        int maxCount;
        final int offset;
        int textureCount;
        Texture[] textures;

        public Cache(int n, int n2) {
            this.id = n;
            this.offset = n2;
        }
    }
}

